/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateProvider;
import com.intellij.util.net.ssl.CertificateWarningDialogProvider;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/tasks/actions/ShowCertificateInfoAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getRootCertificate", "Ljava/security/cert/X509Certificate;", "endEntityCertificate", "manager", "Lcom/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager;", "certificates", "", "isRoot", "", "certificate", "findIssuerCertificate", "Companion", "intellij.tasks.core"})
@SourceDebugExtension(value={"SMAP\nShowCertificateInfoAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowCertificateInfoAction.kt\ncom/intellij/tasks/actions/ShowCertificateInfoAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1869#2,2:93\n*S KotlinDebug\n*F\n+ 1 ShowCertificateInfoAction.kt\ncom/intellij/tasks/actions/ShowCertificateInfoAction\n*L\n75#1:93,2\n*E\n"})
public final class ShowCertificateInfoAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        try {
            CertificateManager manager = CertificateManager.Companion.getInstance();
            manager.getCacertsPath();
            List certificates = manager.getCustomTrustManager().getCertificates();
            if (certificates.isEmpty()) {
                String string = "Key store '%s' is empty";
                Object[] objectArray = new Object[]{manager.getCacertsPath()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                Messages.showInfoMessage((String)string2, (String)"No Certificates Available");
            } else {
                DialogWrapper dialog;
                X509Certificate certificate = (X509Certificate)certificates.get(0);
                Object[] objectArray = new X509Certificate[1];
                Intrinsics.checkNotNull((Object)certificate);
                objectArray[0] = certificate;
                List certHierarchy = CollectionsKt.mutableListOf((Object[])objectArray);
                this.getRootCertificate(certificate, manager.getCustomTrustManager(), certHierarchy);
                CertificateWarningDialogProvider certificateWarningDialogProvider = CertificateWarningDialogProvider.Companion.getInstance();
                DialogWrapper dialogWrapper = dialog = certificateWarningDialogProvider != null ? certificateWarningDialogProvider.createCertificateWarningDialog(certHierarchy, manager.getCustomTrustManager(), "test.com", "RSA", new CertificateProvider()) : null;
                if (dialog == null) {
                    LOG.error("Dialog cannot be shown now, dialog provider returns null");
                    return;
                }
                LOG.debug("Accepted: " + dialog.showAndGet());
            }
        }
        catch (Exception logged) {
            LOG.error((Throwable)logged);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final X509Certificate getRootCertificate(X509Certificate endEntityCertificate, ConfirmingTrustManager.MutableTrustManager manager, List<X509Certificate> certificates) throws KeyStoreException {
        X509Certificate issuerCertificate = this.findIssuerCertificate(endEntityCertificate, manager);
        if (issuerCertificate != null) {
            certificates.add(issuerCertificate);
            if (this.isRoot(issuerCertificate)) {
                return issuerCertificate;
            }
            return this.getRootCertificate(issuerCertificate, manager, certificates);
        }
        return null;
    }

    private final boolean isRoot(X509Certificate certificate) {
        try {
            certificate.verify(certificate.getPublicKey());
            return certificate.getKeyUsage() != null && certificate.getKeyUsage()[5];
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final X509Certificate findIssuerCertificate(X509Certificate certificate, ConfirmingTrustManager.MutableTrustManager manager) throws KeyStoreException {
        List aliases = manager.getAliases();
        Function1 resolveCertificate = arg_0 -> ShowCertificateInfoAction.findIssuerCertificate$lambda$0(manager, arg_0);
        Intrinsics.checkNotNull((Object)aliases);
        Iterable $this$forEach$iv = aliases;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            X509Certificate x509Cert;
            String alias = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)alias);
            X509Certificate cert = (X509Certificate)resolveCertificate.invoke((Object)alias);
            if (cert == null || !Intrinsics.areEqual((Object)(x509Cert = cert).getSubjectX500Principal(), (Object)certificate.getIssuerX500Principal())) continue;
            return x509Cert;
        }
        return null;
    }

    private static final X509Certificate findIssuerCertificate$lambda$0(ConfirmingTrustManager.MutableTrustManager $manager, String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return $manager.getCertificate(alias);
    }

    static {
        Logger logger = Logger.getInstance(ShowCertificateInfoAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/tasks/actions/ShowCertificateInfoAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.tasks.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

