// Code generated by ifacemaker; DO NOT EDIT.

package hcloud

import (
	"context"
)

// IFloatingIPClient ...
type IFloatingIPClient interface {
	// GetByID retrieves a Floating IP by its ID. If the Floating IP does not exist,
	// nil is returned.
	GetByID(ctx context.Context, id int64) (*FloatingIP, *Response, error)
	// GetByName retrieves a Floating IP by its name. If the Floating IP does not exist, nil is returned.
	GetByName(ctx context.Context, name string) (*FloatingIP, *Response, error)
	// Get retrieves a Floating IP by its ID if the input can be parsed as an integer, otherwise it
	// retrieves a Floating IP by its name. If the Floating IP does not exist, nil is returned.
	Get(ctx context.Context, idOrName string) (*FloatingIP, *Response, error)
	// List returns a list of Floating IPs for a specific page.
	//
	// Please note that filters specified in opts are not taken into account
	// when their value corresponds to their zero value or when they are empty.
	List(ctx context.Context, opts FloatingIPListOpts) ([]*FloatingIP, *Response, error)
	// All returns all Floating IPs.
	All(ctx context.Context) ([]*FloatingIP, error)
	// AllWithOpts returns all Floating IPs for the given options.
	AllWithOpts(ctx context.Context, opts FloatingIPListOpts) ([]*FloatingIP, error)
	// Create creates a Floating IP.
	Create(ctx context.Context, opts FloatingIPCreateOpts) (FloatingIPCreateResult, *Response, error)
	// Delete deletes a Floating IP.
	Delete(ctx context.Context, floatingIP *FloatingIP) (*Response, error)
	// Update updates a Floating IP.
	Update(ctx context.Context, floatingIP *FloatingIP, opts FloatingIPUpdateOpts) (*FloatingIP, *Response, error)
	// Assign assigns a Floating IP to a server.
	Assign(ctx context.Context, floatingIP *FloatingIP, server *Server) (*Action, *Response, error)
	// Unassign unassigns a Floating IP from the currently assigned server.
	Unassign(ctx context.Context, floatingIP *FloatingIP) (*Action, *Response, error)
	// ChangeDNSPtr changes or resets the reverse DNS pointer for a Floating IP address.
	// Pass a nil ptr to reset the reverse DNS pointer to its default value.
	ChangeDNSPtr(ctx context.Context, floatingIP *FloatingIP, ip string, ptr *string) (*Action, *Response, error)
	// ChangeProtection changes the resource protection level of a Floating IP.
	ChangeProtection(ctx context.Context, floatingIP *FloatingIP, opts FloatingIPChangeProtectionOpts) (*Action, *Response, error)
}
