//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// Specifies a list appearance that encompasses both UICollectionView
/// &
/// UITableView lists.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uilistenvironment?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIListEnvironment(pub NSInteger);
impl UIListEnvironment {
    /// Indicates the absence of any information about whether or not the trait collection is from a view in a list environment.
    #[doc(alias = "UIListEnvironmentUnspecified")]
    pub const Unspecified: Self = Self(0);
    /// There is no containing list.
    #[doc(alias = "UIListEnvironmentNone")]
    pub const None: Self = Self(1);
    /// Contained within a plain-style list.
    #[doc(alias = "UIListEnvironmentPlain")]
    pub const Plain: Self = Self(2);
    /// Contained within a grouped-style list.
    #[doc(alias = "UIListEnvironmentGrouped")]
    pub const Grouped: Self = Self(3);
    /// Contained within a inset-grouped-style list.
    #[doc(alias = "UIListEnvironmentInsetGrouped")]
    pub const InsetGrouped: Self = Self(4);
    /// Contained within a sidebar-style list.
    #[doc(alias = "UIListEnvironmentSidebar")]
    pub const Sidebar: Self = Self(5);
    /// Contained within a sidebar-plain-style list.
    #[doc(alias = "UIListEnvironmentSidebarPlain")]
    pub const SidebarPlain: Self = Self(6);
}

unsafe impl Encode for UIListEnvironment {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIListEnvironment {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A trait that specifies the UIListEnvironment, if any, that a view is in. It is set on views inside UITableViews and list sections in UICollectionViews.
    /// Defaults to UIListEnvironmentUnspecified.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uitraitlistenvironment?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITraitListEnvironment;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITraitListEnvironment {}
);

#[cfg(feature = "UITrait")]
extern_conformance!(
    unsafe impl UINSIntegerTraitDefinition for UITraitListEnvironment {}
);

#[cfg(feature = "UITrait")]
extern_conformance!(
    unsafe impl UITraitDefinition for UITraitListEnvironment {}
);

impl UITraitListEnvironment {
    extern_methods!();
}

/// Methods declared on superclass `NSObject`.
impl UITraitListEnvironment {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
