//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

extern_class!(
    /// UISearchTextField is the subclass of UITextField used in UISearchBar, and can also be used elsewhere (e.g. as the titleView of a UINavigationItem).
    ///
    /// In addition to its text, a UISearchField can contain tokens. Tokens are discrete representations of non-textual content. Your app might use tokens to represent filters that are being applied in conjunction with the search field’s text. Tokens are always created by the application, and always occur contiguously before the search field’s text.
    ///
    ///
    /// Note: Because the system drives selection and keyboard behaviors through the UITextInput protocol, and UISearchTextField supports selecting tokens, UISearchTextField assigns UITextPositions to tokens as well as text. If the current selection includes any tokens, their positions are part of the range returned by `UISearchTextField.selectedTextRange`. Use the `textualRange` property to obtain the range of the text field that excludes any tokens.
    ///
    /// Tokens can be programmatically selected by including their position in a range assigned to the `selectedTextRange` property. UISearchTextField does not support placing an insertion point before a token; attempting to do so will select the token instead.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchtextfield?language=objc)
    #[unsafe(super(UITextField, UIControl, UIView, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(
        feature = "UIControl",
        feature = "UIResponder",
        feature = "UITextField",
        feature = "UIView"
    ))]
    pub struct UISearchTextField;
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView",
    feature = "objc2-quartz-core"
))]
#[cfg(not(target_os = "watchos"))]
extern_conformance!(
    unsafe impl CALayerDelegate for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl NSCoding for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UISearchTextField {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearance for UISearchTextField {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UISearchTextField {}
);

#[cfg(all(
    feature = "UIContentSizeCategoryAdjusting",
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIContentSizeCategoryAdjusting for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UICoordinateSpace for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIDynamicBehavior",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIDynamicItem for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItem for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItemContainer for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UITextInput",
    feature = "UITextInputTraits",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIKeyInput for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UILetterformAwareAdjusting",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UILetterformAwareAdjusting for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UITextInput",
    feature = "UITextInputTraits",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITextInput for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UITextInputTraits",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITextInputTraits for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UITraitCollection",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UISearchTextField {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
impl UISearchTextField {
    extern_methods!(
        /// Simple access to the collection of tokens.
        #[unsafe(method(tokens))]
        #[unsafe(method_family = none)]
        pub unsafe fn tokens(&self) -> Retained<NSArray<UISearchToken>>;

        /// Setter for [`tokens`][Self::tokens].
        #[unsafe(method(setTokens:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTokens(&self, tokens: &NSArray<UISearchToken>);

        #[unsafe(method(insertToken:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertToken_atIndex(&self, token: &UISearchToken, token_index: NSInteger);

        #[unsafe(method(removeTokenAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeTokenAtIndex(&self, token_index: NSInteger);

        #[cfg(feature = "UITextInput")]
        /// Returns the position of the provided token. To select a token, assign a UITextRange containing its position to the selectedTextRange property.
        #[unsafe(method(positionOfTokenAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn positionOfTokenAtIndex(
            &self,
            token_index: NSInteger,
        ) -> Retained<UITextPosition>;

        #[cfg(feature = "UITextInput")]
        /// Returns the tokens which are contained within the provided range.
        ///
        /// You can use this method to determine which tokens are included in the user’s current selection. The range may span more than one token or a mixture of tokens and text.
        #[unsafe(method(tokensInRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn tokensInRange(
            &self,
            text_range: &UITextRange,
        ) -> Retained<NSArray<UISearchToken>>;

        #[cfg(feature = "UITextInput")]
        /// The range that corresponds to the field’s text, exclusive of any tokens.
        ///
        ///
        /// See: -[
        /// <UITextInput
        /// > positionWithinRange:atCharacterOffset:]
        #[unsafe(method(textualRange))]
        #[unsafe(method_family = none)]
        pub unsafe fn textualRange(&self) -> Retained<UITextRange>;

        #[cfg(feature = "UITextInput")]
        /// Removes any text contained in the specified range, inserts the provided token at the specified index, and selects the newly-inserted token. Does not replace any tokens within the provided range. If the range intersects the marked text range, the marked text is committed.
        ///
        /// This method is essentially a convenience wrapper around the more fundamental `text`, `tokens`, and `selectedTextRange` properties, providing the selection behavior the user will expect.
        ///
        ///
        /// Note: Because this method does not remove any tokens in the provided range, the caller can pass the field’s selectedTextRange to convert the selected portion of the text into a token without first having to trim the range.
        #[unsafe(method(replaceTextualPortionOfRange:withToken:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceTextualPortionOfRange_withToken_atIndex(
            &self,
            text_range: &UITextRange,
            token: &UISearchToken,
            token_index: NSUInteger,
        );

        #[cfg(feature = "UIColor")]
        /// Set this to nil for tokens to use their default color.
        #[unsafe(method(tokenBackgroundColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn tokenBackgroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`tokenBackgroundColor`][Self::tokenBackgroundColor].
        #[unsafe(method(setTokenBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTokenBackgroundColor(&self, token_background_color: Option<&UIColor>);

        /// Whether the user can remove tokens through standard actions such as Delete and Cut.
        ///
        /// The application can always remove tokens programmatically. If this property is true, the application must be prepared not only for tokens to be removed, but also to be re-added through Undo. Defaults to true.
        #[unsafe(method(allowsDeletingTokens))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsDeletingTokens(&self) -> bool;

        /// Setter for [`allowsDeletingTokens`][Self::allowsDeletingTokens].
        #[unsafe(method(setAllowsDeletingTokens:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsDeletingTokens(&self, allows_deleting_tokens: bool);

        /// Whether the user can copy tokens to the pasteboard or drag them out of the text field.
        ///
        /// To support copying tokens, this property must be true and the delegate must provide an item provider for the tokens to be copied. UISearchTextField always enables the Copy command if any plain text is selected, even if the selection also includes tokens and this property is false. Defaults to true.
        #[unsafe(method(allowsCopyingTokens))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsCopyingTokens(&self) -> bool;

        /// Setter for [`allowsCopyingTokens`][Self::allowsCopyingTokens].
        #[unsafe(method(setAllowsCopyingTokens:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsCopyingTokens(&self, allows_copying_tokens: bool);

        #[cfg(feature = "UISearchSuggestion")]
        /// An array of suggestions that will be presented as a menu beneath the search field when nonempty.
        /// Set to nil or
        /// @
        /// [] to dismiss the menu.
        /// The menu will also dismiss and the property will be set to nil when a suggestion is selected.
        /// The delegate is expected to execute any necessary updating when a suggestion is selected.
        #[unsafe(method(searchSuggestions))]
        #[unsafe(method_family = none)]
        pub unsafe fn searchSuggestions(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn UISearchSuggestion>>>>;

        #[cfg(feature = "UISearchSuggestion")]
        /// Setter for [`searchSuggestions`][Self::searchSuggestions].
        #[unsafe(method(setSearchSuggestions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSearchSuggestions(
            &self,
            search_suggestions: Option<&NSArray<ProtocolObject<dyn UISearchSuggestion>>>,
        );
    );
}

/// Methods declared on superclass `UIControl`.
#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
impl UISearchTextField {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame: CGRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(all(
            feature = "UIAction",
            feature = "UIMenuElement",
            feature = "objc2-core-foundation"
        ))]
        /// Initializes the control and adds primaryAction for the UIControlEventPrimaryActionTriggered control event. Subclasses of UIControl may alter or add behaviors around the usage of primaryAction, see subclass documentation of this initializer for additional information.
        #[unsafe(method(initWithFrame:primaryAction:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame_primaryAction(
            this: Allocated<Self>,
            frame: CGRect,
            primary_action: Option<&UIAction>,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITextField",
    feature = "UIView"
))]
impl UISearchTextField {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// An individual token in a UISearchTextField.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchtoken?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UISearchToken;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UISearchToken {}
);

impl UISearchToken {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        #[unsafe(method(tokenWithIcon:text:))]
        #[unsafe(method_family = none)]
        pub unsafe fn tokenWithIcon_text(
            icon: Option<&UIImage>,
            text: &NSString,
            mtm: MainThreadMarker,
        ) -> Retained<UISearchToken>;

        /// The object which this token represents.
        ///
        /// The application can assign any object it wants to this property. UISearchTextField does not attempt to interpret this object.
        ///
        ///
        /// Note: Because UISearchToken strongly references its representedObject, consider assigning a lightweight representation (such as NSManagedObjectID) instead of a complete model object to this property. The lifetime of a UISearchToken may be considerably longer than expected, especially if the token has been copied to a pasteboard.
        #[unsafe(method(representedObject))]
        #[unsafe(method_family = none)]
        pub unsafe fn representedObject(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`representedObject`][Self::representedObject].
        #[unsafe(method(setRepresentedObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRepresentedObject(&self, represented_object: Option<&AnyObject>);
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchtextfielddelegate?language=objc)
    #[cfg(feature = "UITextField")]
    pub unsafe trait UISearchTextFieldDelegate:
        UITextFieldDelegate + MainThreadOnly
    {
        #[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
        /// Implements cut and copy of tokens.
        ///
        /// To support drag and drop and the Cut and Copy commands, your delegate must implement this method and return an NSItemProvider for the requested token. The field’s textPasteDelegate is responsible for implementing pasting of tokens. Your delegate can provide a plain text representation for pasting in other contexts, but should register a custom type identifier so it can recognize and reconstruct the token when pasted into the same field.
        ///
        /// This method will only be called if either of the field’s allowsCopyingTokens or allowsDeletingTokens properties is true.
        #[optional]
        #[unsafe(method(searchTextField:itemProviderForCopyingToken:))]
        #[unsafe(method_family = none)]
        unsafe fn searchTextField_itemProviderForCopyingToken(
            &self,
            search_text_field: &UISearchTextField,
            token: &UISearchToken,
        ) -> Retained<NSItemProvider>;

        #[cfg(all(
            feature = "UIControl",
            feature = "UIResponder",
            feature = "UISearchSuggestion",
            feature = "UIView"
        ))]
        /// searchSuggestions property will be set to nil after sending this message
        #[optional]
        #[unsafe(method(searchTextField:didSelectSuggestion:))]
        #[unsafe(method_family = none)]
        unsafe fn searchTextField_didSelectSuggestion(
            &self,
            search_text_field: &UISearchTextField,
            suggestion: &ProtocolObject<dyn UISearchSuggestion>,
        );
    }
);

extern_protocol!(
    /// A protocol that refines UITextPasteItem to support pasting of tokens.
    ///
    /// Paste items vended by UISearchTextField conform to this protocol.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchtextfieldpasteitem?language=objc)
    #[cfg(feature = "UITextPasteDelegate")]
    pub unsafe trait UISearchTextFieldPasteItem: UITextPasteItem + MainThreadOnly {
        /// Transforms this paste item into a token at the end of the search text field’s token array.
        #[unsafe(method(setSearchTokenResult:))]
        #[unsafe(method_family = none)]
        unsafe fn setSearchTokenResult(&self, token: &UISearchToken);
    }
);
