/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fenceInjection;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.fenceInjection.FenceSurroundingsProvider;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u00060\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0007H\u0014J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/fenceInjection/CodeFenceInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "<init>", "()V", "toInject", "", "Ljava/lang/Class;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "elementsToInjectIn", "Lcom/intellij/psi/PsiElement;", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "host", "canBeInjected", "", "language", "Lcom/intellij/lang/Language;", "findLangForInjection", "element", "injectAsOnePlace", "intellij.markdown.fenceInjection"})
@SourceDebugExtension(value={"SMAP\nCodeFenceInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFenceInjector.kt\norg/intellij/plugins/markdown/fenceInjection/CodeFenceInjector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n12434#2,2:79\n1#3:81\n*S KotlinDebug\n*F\n+ 1 CodeFenceInjector.kt\norg/intellij/plugins/markdown/fenceInjection/CodeFenceInjector\n*L\n37#1:79,2\n*E\n"})
public class CodeFenceInjector
implements MultiHostInjector {
    @NotNull
    private final List<Class<MarkdownCodeFence>> toInject = CollectionsKt.listOf(MarkdownCodeFence.class);

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        return this.toInject;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            if (!(host instanceof MarkdownCodeFence) || !((MarkdownCodeFence)host).isValidHost()) {
                return;
            }
            PsiElement[] psiElementArray = ((MarkdownCodeFence)host).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$all$iv = psiElementArray;
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        if (bl) {
            return;
        }
        Language language = this.findLangForInjection((MarkdownCodeFence)host);
        if (language == null) {
            return;
        }
        Language language2 = language;
        if (!this.canBeInjected(language2)) {
            return;
        }
        registrar.startInjecting(language2);
        this.injectAsOnePlace((MarkdownCodeFence)host, registrar, language2);
        registrar.makeInspectionsLenient(true);
        registrar.doneInjecting();
    }

    private final boolean canBeInjected(Language language) {
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    @Nullable
    protected Language findLangForInjection(@NotNull MarkdownCodeFence element2) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        String string = element2.getFenceLanguage();
        if (string == null) {
            return null;
        }
        String name = string;
        Language it = language = CodeFenceLanguageGuesser.guessLanguageForInjection(name);
        boolean bl = false;
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return MarkdownSettings.Companion.getInstance(project).getAreInjectionsEnabled() ? language : null;
    }

    private final void injectAsOnePlace(MarkdownCodeFence host, MultiHostRegistrar registrar, Language language) {
        Object v1;
        PsiElement last;
        PsiElement first;
        block2: {
            List<PsiElement> list2 = MarkdownCodeFence.Companion.obtainFenceContent(host, true);
            if (list2 == null) {
                return;
            }
            List<PsiElement> elements2 = list2;
            first = (PsiElement)CollectionsKt.first(elements2);
            last = (PsiElement)CollectionsKt.last(elements2);
            Iterable iterable = FenceSurroundingsProvider.Companion.getEP_NAME().getExtensionList();
            for (Object t : iterable) {
                FenceSurroundingsProvider it = (FenceSurroundingsProvider)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLanguage(), (Object)language)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        FenceSurroundingsProvider fenceSurroundingsProvider = v1;
        FenceSurroundingsProvider.Surroundings surroundings = fenceSurroundingsProvider != null ? fenceSurroundingsProvider.getCodeFenceSurroundings() : null;
        TextRange textRange = TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength()));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange range = textRange;
        FenceSurroundingsProvider.Surroundings surroundings2 = surroundings;
        FenceSurroundingsProvider.Surroundings surroundings3 = surroundings;
        registrar.addPlace(surroundings2 != null ? surroundings2.getPrefix() : null, surroundings3 != null ? surroundings3.getSuffix() : null, (PsiLanguageInjectionHost)host, range);
    }
}

