/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.extensions;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.AssumptionViolatedException;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class TooManyFailedTestsExecutionCondition
implements ExecutionCondition,
TestWatcher,
BeforeEachCallback,
BeforeAllCallback {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"Not too many failed tests (yet)");
    private static final String MAX_FAILURE_TEST_COUNT_FLAG = "idea.max.failure.test.count";
    private static final int MAX_FAILURE_TEST_COUNT = Integer.parseInt(Objects.requireNonNullElse(System.getProperty("idea.max.failure.test.count"), "150"));
    private static final AtomicInteger ourFailedTestsCount = new AtomicInteger();
    private static final AtomicInteger ourExecutedTestsCount = new AtomicInteger();
    private ConditionEvaluationResult myDisabledReason = null;

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context2) {
        if (MAX_FAILURE_TEST_COUNT >= 0 && ourFailedTestsCount.get() > MAX_FAILURE_TEST_COUNT) {
            if (this.myDisabledReason == null) {
                String msg = "Too many errors (" + ourFailedTestsCount.get() + ", MAX_FAILURE_TEST_COUNT = " + MAX_FAILURE_TEST_COUNT + "). Executed: " + ourExecutedTestsCount.get() + " tests";
                this.myDisabledReason = ConditionEvaluationResult.disabled((String)msg);
            }
            return this.myDisabledReason;
        }
        return ENABLED;
    }

    public void testFailed(ExtensionContext context2, Throwable cause) {
        ourFailedTestsCount.incrementAndGet();
        ourExecutedTestsCount.incrementAndGet();
    }

    public void testSuccessful(ExtensionContext context2) {
        ourExecutedTestsCount.incrementAndGet();
    }

    public void testAborted(ExtensionContext context2, Throwable cause) {
        ourExecutedTestsCount.incrementAndGet();
    }

    public void beforeEach(ExtensionContext context2) {
        this.failIfDisabled(context2);
    }

    public void beforeAll(ExtensionContext context2) {
        this.failIfDisabled(context2);
    }

    private void failIfDisabled(ExtensionContext context2) {
        ConditionEvaluationResult evaluated = this.evaluateExecutionCondition(context2);
        if (evaluated.isDisabled()) {
            String reason = (String)evaluated.getReason().get();
            throw new AssumptionViolatedException(reason);
        }
    }
}

