SYD-PAUSE(1)

# NAME

*syd-pause* - Block forever (until signaled), optionally ignoring selected signals

# SYNOPSIS

*syd-pause* _[ -t ]_ _[ -h ]_ _[ -a ]_ _[ -q ]_ _[ -b ]_ _[ -i ]_ _[ -p signals ]_

# DESCRIPTION

*syd-pause* is a tiny, long-lived process that simply waits until it is
terminated by a signal. By default, it honors all standard termination
signals; options allow you to ignore specific signals so the process
continues running when they are delivered. This is useful as a minimal
placeholder, supervisor target, or synchronization sentinel in service
pipelines and sandboxes.

# OPTIONS

|[ *--help*
:< Display help.
|[ *-t*
:< Ignore SIGTERM.
|[ *-h*
:< Ignore SIGHUP.
|[ *-a*
:< Ignore SIGALRM.
|[ *-q*
:< Ignore SIGQUIT.
|[ *-b*
:< Ignore SIGABRT.
|[ *-i*
:< Ignore SIGINT.
|[ *-p signals*
:< Ignore the comma-separated list of signal numbers given in signals (e.g. -p 1,2,3,15).
|[
:< Numbers must be valid per _signal_(7). This flag can be combined with the short flags above.

# EXIT STATUS

On normal termination by a signal, *syd-pause* exits 0. On errors
*syd-pause* exits with the corresponding _errno_(3) value.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd-ofd_(1), _s6-pause_(1), _pause_(2)

- *syd* homepage: https://sydbox.exherbo.org/
- *s6-pause* manpage: https://skarnet.org/software/s6/s6-pause.html

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
