/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolPriority;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolConsumerGroup
extends ExasolPriority
implements DBPRefreshableObject,
DBPNamedObject2,
DBPSaveableObject {
    private ExasolDataSource dataSource;
    private String groupName;
    private Integer cpuWeight;
    private Integer precedence;
    private BigDecimal groupRamLimit;
    private BigDecimal userRamLimit;
    private BigDecimal sessionRamLimit;
    private Date created;
    private String comment = "";
    private Boolean persisted;
    private BigDecimal groupId = new BigDecimal(-1);

    public ExasolConsumerGroup(@NotNull ExasolDataSource dataSource, @NotNull String name, @Nullable Integer precedence, @NotNull Integer cpuWeight, @Nullable BigDecimal groupRamLimit, @Nullable BigDecimal userRamLimit, @Nullable BigDecimal sessionRamLimit, @Nullable String comment) {
        super(dataSource, name, comment);
        this.cpuWeight = cpuWeight;
        this.groupRamLimit = groupRamLimit;
        this.sessionRamLimit = sessionRamLimit;
        this.userRamLimit = userRamLimit;
        this.precedence = precedence;
        this.groupName = name;
        this.comment = comment;
        this.persisted = false;
        this.dataSource = dataSource;
    }

    public ExasolConsumerGroup(@NotNull ExasolDataSource dataSource, @Nullable ResultSet dbResult) {
        super(dataSource, "", "");
        this.dataSource = dataSource;
        if (dbResult != null) {
            this.persisted = true;
            this.cpuWeight = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"CPU_WEIGHT");
            this.precedence = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PRECEDENCE");
            this.groupRamLimit = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"GROUP_TEMP_DB_RAM_LIMIT");
            this.userRamLimit = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"USER_TEMP_DB_RAM_LIMIT");
            this.sessionRamLimit = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"SESSION_TEMP_DB_RAM_LIMIT");
            this.groupName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSUMER_GROUP_NAME");
            this.created = JDBCUtils.safeGetDate((ResultSet)dbResult, (String)"CREATED");
            this.comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSUMER_GROUP_COMMENT");
            this.cpuWeight = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"CPU_WEIGHT");
            this.groupId = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"CONSUMER_GROUP_ID");
            super.setName(this.groupName);
            super.setDescription(this.comment);
        }
    }

    @Override
    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @Override
    @NotNull
    public ExasolDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.getDataSource().refreshObject(monitor);
        return this;
    }

    @Override
    @Property(viewable=true, editable=true, updatable=true, order=10)
    @NotNull
    public String getName() {
        return this.groupName;
    }

    @Override
    public void setName(String groupName) {
        this.groupName = groupName;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20)
    public Integer getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(Integer precedence) {
        this.precedence = precedence;
    }

    @Override
    @Property(viewable=true, editable=false, updatable=false, order=25)
    public BigDecimal getGroupId() {
        return this.groupId;
    }

    @Property(viewable=true, editable=true, updatable=true, order=30)
    public int getCpuWeight() {
        return this.cpuWeight;
    }

    public void setCpuWeight(int weight) {
        this.cpuWeight = weight;
    }

    @Property(viewable=true, editable=true, updatable=true, order=40)
    public BigDecimal getGroupRamLimit() {
        return this.groupRamLimit;
    }

    public void setGroupRamLimit(BigDecimal groupRamLimit) {
        this.groupRamLimit = groupRamLimit;
    }

    @Property(viewable=true, editable=true, updatable=true, order=50)
    public BigDecimal getUserRamLimit() {
        return this.userRamLimit;
    }

    public void setUserRamLimit(BigDecimal userRamLimit) {
        this.userRamLimit = userRamLimit;
    }

    @Property(viewable=true, editable=true, updatable=true, order=55)
    public BigDecimal getSessionRamLimit() {
        return this.sessionRamLimit;
    }

    public void setSessionRamLimit(BigDecimal sessionRamLimit) {
        this.sessionRamLimit = sessionRamLimit;
    }

    @Override
    @Property(viewable=true, editable=false, updatable=false, order=60)
    public Date getCreated() {
        return this.created;
    }

    @Override
    @Property(viewable=true, editable=true, updatable=true, order=70)
    public String getDescription() {
        return this.comment;
    }

    @Override
    public void setDescription(String comment) {
        this.comment = comment;
    }
}

