from typing import Any

from django.db.backends.oracle.schema import DatabaseSchemaEditor
from django.db.models.base import Model
from django.db.models.fields import Field

class OracleGISSchemaEditor(DatabaseSchemaEditor):
    sql_add_geometry_metadata: str
    sql_add_spatial_index: str
    sql_drop_spatial_index: str
    sql_clear_geometry_table_metadata: str
    sql_clear_geometry_field_metadata: str
    geometry_sql: Any
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def geo_quote_name(self, name: Any) -> Any: ...
    def column_sql(
        self, model: type[Model], field: Field, include_default: bool = ...
    ) -> tuple[None, None] | tuple[str, list[Any]]: ...
    def create_model(self, model: type[Model]) -> None: ...
    def delete_model(self, model: type[Model]) -> None: ...
    def add_field(self, model: type[Model], field: Field) -> None: ...
    def remove_field(self, model: type[Model], field: Field) -> None: ...
    def run_geometry_sql(self) -> None: ...
