/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.targets;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.targets.TestTarget;
import org.jetbrains.qodana.staticAnalysis.scopes.QodanaAnalysisScope;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/MultiScopeTestTarget;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/TestTarget;", "name", "", "tools", "", "Lorg/jetbrains/qodana/staticAnalysis/scopes/QodanaAnalysisScope;", "threshold", "", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "<init>", "(Ljava/lang/String;Ljava/util/Map;ILcom/intellij/openapi/components/PathMacroManager;)V", "getName", "()Ljava/lang/String;", "getThreshold", "()I", "inspections", "", "getInspections", "()Ljava/util/List;", "contains", "", "inspection", "url", "intellij.qodana"})
public final class MultiScopeTestTarget
implements TestTarget {
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, QodanaAnalysisScope> tools;
    private final int threshold;
    @NotNull
    private final PathMacroManager macroManager;
    @NotNull
    private final List<String> inspections;

    public MultiScopeTestTarget(@NotNull String name, @NotNull Map<String, QodanaAnalysisScope> tools, int threshold, @NotNull PathMacroManager macroManager) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Intrinsics.checkNotNullParameter((Object)macroManager, (String)"macroManager");
        this.name = name;
        this.tools = tools;
        this.threshold = threshold;
        this.macroManager = macroManager;
        this.inspections = CollectionsKt.toList((Iterable)this.tools.keySet());
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    @NotNull
    public List<String> getInspections() {
        return this.inspections;
    }

    @Override
    public boolean contains(@NotNull String inspection, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)inspection, (String)"inspection");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.macroManager.expandPath(url));
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        QodanaAnalysisScope qodanaAnalysisScope = this.tools.get(inspection);
        if (qodanaAnalysisScope == null) {
            return false;
        }
        QodanaAnalysisScope scope2 = qodanaAnalysisScope;
        return scope2.contains(virtualFile2);
    }
}

