/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public abstract class LocalVariableCommonEntry
extends AbstractStructure {
    public static final int LENGTH = 10;
    protected int startPc;
    protected int length;
    protected int nameIndex;
    protected int descriptorOrSignatureIndex;
    protected int index;

    public final int getStartPc() {
        return this.startPc;
    }

    public final void setStartPc(int n) {
        this.startPc = n;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public final int getNameIndex() {
        return this.nameIndex;
    }

    public final void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public final int getDescriptorOrSignatureIndex() {
        return this.descriptorOrSignatureIndex;
    }

    public final void setDescriptorOrSignatureIndex(int n) {
        this.descriptorOrSignatureIndex = n;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        this.startPc = dataInput.readUnsignedShort();
        this.length = dataInput.readUnsignedShort();
        this.nameIndex = dataInput.readUnsignedShort();
        this.descriptorOrSignatureIndex = dataInput.readUnsignedShort();
        this.index = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public final void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.startPc);
        dataOutput.writeShort(this.length);
        dataOutput.writeShort(this.nameIndex);
        dataOutput.writeShort(this.descriptorOrSignatureIndex);
        dataOutput.writeShort(this.index);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected String printAccessFlagsVerbose(int n) {
        if (n != 0) {
            throw new RuntimeException("Access flags should be zero: " + Integer.toHexString(n));
        }
        return "";
    }
}

