/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.ConstantPool;
import java.io.DataOutput;
import java.io.IOException;

public abstract class CpEntry
implements Cloneable {
    public static final byte TAG_CLASS = 7;
    public static final byte TAG_FIELDREF = 9;
    public static final byte TAG_METHODREF = 10;
    public static final byte TAG_INTERFACE_METHODREF = 11;
    public static final byte TAG_STRING = 8;
    public static final byte TAG_INTEGER = 3;
    public static final byte TAG_FLOAT = 4;
    public static final byte TAG_LONG = 5;
    public static final byte TAG_DOUBLE = 6;
    public static final byte TAG_NAME_AND_TYPE = 12;
    public static final byte TAG_UTF8 = 1;
    ConstantPool pool;
    int hash;
    byte tag;
    int index;
    CpEntry next;

    public CpEntry(ConstantPool pool, byte tag, int hash) {
        this.pool = pool;
        this.tag = tag;
        this.hash = hash;
    }

    public final int hashCode() {
        return this.hash;
    }

    public void computeHash() {
    }

    public final int getIndex() {
        return this.index;
    }

    public final byte getTag() {
        return this.tag;
    }

    abstract void write(DataOutput var1) throws IOException;

    public String toJavaString() {
        return this.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    void postClone() {
        if (this.next != null && this.next.pool != this.pool) {
            CpEntry ourNext = this.pool.getPoolEntry(this.next.index);
            if (ourNext.next == null) {
                ourNext.next = this.next.next;
            }
            this.next = ourNext;
        }
    }
}

