/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb2/vdkb_timebar.h>
#include <string.h>
DEFINE_SIGNAL_LIST(VDKBTimebar,VDKProgressBar);
/*
 */
VDKBTimebar::VDKBTimebar(VDKForm* owner, double min, double max,double tick):
    VDKProgressBar(owner,min,max)
{
    timer = new VDKTimer(owner,tick,false);
    timeElapsed = 0;
}
VDKBTimebar::~VDKBTimebar()
{
    timer->Stop();
    timer->Destroy();
}
/*
 */
void
VDKBTimebar::Setup(void)
{
    SetSize(120,20);
    NormalBackground = VDKRgb(255,255,255);
    PrelightBackground = VDKRgb(70,130,180);
    timer->Parent(this);
    SignalConnect(timer,"timer_tick_signal",&VDKBTimebar::OnTimer,false);
    timer->Start();
}
bool
VDKBTimebar::OnTimer(VDKObject*)
{
    timeElapsed++;
    Value = double(timeElapsed%60);
    return true;
}

