/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2010 Gary Ching-Pang Lin <glin@suse.com>
 *
 * Licensed under the GNU Lesser General Public License Version 2.1
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __URF_VERSION_H
#define __URF_VERSION_H

/*
 * URF_CHECK_VERSION
 *
 * The compile-time major version
 */
#define URF_MAJOR_VERSION				(0)

/*
 * URF_CHECK_MINOR
 *
 * The compile-time minor version
 */
#define URF_MINOR_VERSION				(3)

/*
 * URF_MICRO_VERSION
 *
 * The compile-time micro version
 */
#define URF_MICRO_VERSION				(0)

/* check whether a urfkill version equal to or greater than
 * major.minor.micro.
 */
#define URF_CHECK_VERSION(major,minor,micro)    \
    (URF_MAJOR_VERSION > (major) || \
     (URF_MAJOR_VERSION == (major) && URF_MINOR_VERSION > (minor)) || \
     (URF_MAJOR_VERSION == (major) && URF_MINOR_VERSION == (minor) && \
      URF_MICRO_VERSION >= (micro)))

#endif /* __URF_VERSION_H */
