/*! \file utf8tables.cpp
 * \brief Static tables with UTF-8 state machines.
 *
 * $Id: utf8tables.cpp 5712 2014-01-30 02:17:35Z brazilofmux@gmail.com $
 *
 */

#include "copyright.h"
#include "autoconf.h"
#include "config.h"
#include "externs.h"

// utf/cl_Printable.txt
//
// 106866 included, 1007246 excluded, 0 errors.
// 215 states, 95 columns, 3949 bytes
//
const unsigned char cl_print_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   0,

       2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  37,  38,  39,  40,  41,   42,  43,  44,  45,  46,  47,  48,  49,
      50,  51,  52,  53,  54,  55,  56,  57,   58,  59,  60,  61,  62,  63,  64,  65,
       0,   0,  66,  67,  67,  67,  67,  67,   67,  67,  67,  67,   0,  68,  69,  67,
      67,  67,  70,  67,  71,  72,  73,  74,   75,  76,  67,  77,  78,  79,  80,  81,
      82,  83,  84,  85,  86,  87,  87,  87,   87,  88,  89,  87,  87,  90,  91,  92,
      93,   0,   0,  94,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short cl_print_sot[215] =
{
        0,   35,   45,   51,   65,   81,   91,  101,   115,  129,  151,  169,  183,  205,  218,  224,
      230,  240,  277,  299,  309,  332,  365,  398,   436,  465,  499,  528,  562,  592,  636,  662,
      692,  722,  752,  785,  811,  841,  862,  882,   892,  902,  951,  972,  990, 1011, 1037, 1051,
     1110, 1123, 1133, 1143, 1167, 1189, 1206, 1220,  1230, 1240, 1246, 1256, 1262, 1280, 1298, 1308,
     1326, 1340, 1346, 1359, 1365, 1379, 1393, 1403,  1417, 1431, 1441, 1455, 1465, 1483, 1493, 1503,
     1513, 1531, 1545, 1569, 1579, 1605, 1655, 1669,  1683, 1697, 1707, 1717, 1723, 1729, 1739, 1756,
     1774, 1794, 1808, 1821, 1831, 1841, 1851, 1861,  1871, 1881, 1903, 1921, 1931, 1937, 1947, 1967,
     1977, 1983, 1993, 2003, 2013, 2023, 2029, 2039,  2045, 2053, 2059, 2098, 2108, 2118, 2124, 2142,
     2152, 2162, 2168, 2174, 2188, 2202, 2212, 2222,  2232, 2246, 2252, 2266, 2283, 2295, 2305, 2314,
     2324, 2330, 2361, 2367, 2377, 2383, 2407, 2421,  2427, 2437, 2447, 2457, 2479, 2485, 2515, 2539,
     2593, 2614, 2624, 2630, 2644, 2654, 2660, 2666,  2680, 2686, 2696, 2706, 2716, 2741, 2751, 2765,
     2792, 2806, 2816, 2830, 2836, 2842, 2849, 2863,  2869, 2882, 2888, 2898, 2906, 2942, 2952, 2962,
     2976, 2982, 2992, 3002, 3012, 3044, 3054, 3080,  3097, 3107, 3117, 3132, 3138, 3158, 3191, 3201,
     3211, 3221, 3227, 3235, 3243, 3249, 3257
};

const unsigned char cl_print_sbt[3263] =
{
     254, 215, 216,  64, 215, 227,   1,   2,    3,   4,   5,   6,   7,   8,   9,  10,
      11,  12,  13,  14,  15,  16,  17,  47,   85, 110, 118, 119, 120, 122, 142, 144,
     145, 158, 212,  34, 215,  13, 216, 255,  215,  18, 216,  29, 215,   2, 215,  64,
     216,  29, 215,  17, 215, 255, 216,  32,  215,   8, 216,   2, 215,   5, 216,  30,
     215,   6, 215,   7, 216, 253, 215, 216,  215,  20, 216, 255, 215,  29, 216,  29,
     215,   2, 215,   3, 216,   5, 215,  56,  216,  29, 215,   2, 215,  38, 216,  11,
     215,  15, 216,  29, 215,   2, 215,  23,  216,   2, 215,   7, 216, 255, 215,  31,
     216,  29, 215,   2, 215,   8, 216, 255,  215,   2, 216,  51, 215, 255, 216,  30,
     215,   2, 215, 255, 216,   2, 215, 255,  216,   2, 215, 255, 216,   9, 215,  27,
     216,   5, 215,   5, 216,  40, 215,   8,  215,  10, 216,  11, 215, 255, 216,   2,
     215,   2, 216, 255, 215,  31, 216,  29,  215,   2, 215,  11, 216,  21, 215,  16,
     216, 255, 215,  15, 216,  29, 215,   2,  215,  22, 216,   8, 215, 255, 216,   6,
     215,   2, 216,   2, 215, 255, 216,   4,  215,  18, 216,  29, 215,   2, 215,  14,
     216,   2, 215, 254, 216, 215,  30, 216,   45, 215,  15, 215,  51, 216,  29, 215,
       2, 215,  50, 216,  43, 215,   2, 215,   43, 216,   9, 215,   7, 216,  34, 215,
      34, 215, 255,  18,   3, 215, 228,  19,   20,  21,  22,  23,  24,  25,  26,  27,
      28,  29,  30,  31,  32,  33,  34,  35,   36,  37,  38,  39,  40,  41,  42,  43,
      44,  45,  46,  29, 215,   2, 215,  22,  216,   4, 215, 255, 216,   9, 215, 255,
     216,   3, 215, 255, 216,   7, 215,  15,  216,  30, 215,   2, 215,  58, 216,   3,
     215,   3, 216,  29, 215,   2, 215,  13,  216, 252, 215, 216, 215, 216,   4, 215,
     255, 216,   2, 215,  27, 216,   6, 215,    7, 216,  29, 215,   3, 215,   3, 216,
     255, 215,   8, 216,   2, 215,   2, 216,    2, 215,  22, 216, 255, 215,   7, 216,
     254, 215, 216,   3, 215,   4, 216,   3,  215,   3, 216,  29, 215,   2, 215,   5,
     216,   2, 215,   2, 216,   2, 215,   2,  216, 254, 215, 216,   8, 215, 255, 216,
       4, 215,   2, 216, 255, 215,   5, 216,    2, 215,  22, 216,  33, 215,   3, 215,
       3, 216, 255, 215,   6, 216,   4, 215,    2, 216,   2, 215,  22, 216, 255, 215,
       7, 216, 255, 215,   2, 216, 255, 215,    2, 216, 255, 215,   2, 216,   4, 215,
       2, 216,  29, 215,   2, 215,   3, 216,    4, 215,   2, 216,   2, 215,   2, 216,
       4, 215, 255, 216,   7, 215,   4, 216,  254, 215, 216,   7, 215,  16, 216,  39,
     215,   3, 215,   3, 216, 255, 215,   9,  216, 255, 215,   3, 216, 255, 215,  22,
     216, 255, 215,   7, 216, 255, 215,   2,  216, 255, 215,   5, 216,   3, 215,   3,
     216,  29, 215,   2, 215,   6, 216, 255,  215,   3, 216, 255, 215,   2, 216,   3,
     215, 255, 216,  15, 215,   4, 216,   2,  215,  10, 216, 254, 215, 216,  43, 215,
       3, 215,   3, 216, 255, 215,   8, 216,    2, 215,   2, 216,   2, 215,  22, 216,
     255, 215,   7, 216, 255, 215,   2, 216,  255, 215,   5, 216,   3, 215,   3, 216,
      29, 215,   2, 215,   5, 216,   2, 215,    2, 216,   2, 215,   2, 216,   9, 215,
       2, 216,   4, 215,   2, 216, 255, 215,    5, 216,   2, 215,  12, 216,  43, 215,
       4, 215,   2, 216, 255, 215,   6, 216,    3, 215,   3, 216, 255, 215,   4, 216,
       3, 215,   2, 216, 253, 215, 216, 215,    2, 216,   3, 215,   2, 216,   3, 215,
       3, 216,   3, 215,  12, 216,   4, 215,    2, 216,  29, 215,   2, 215,   3, 216,
       3, 215,   3, 216, 255, 215,   3, 216,    3, 215, 255, 216,   6, 215, 255, 216,
      14, 215,  21, 216,  34, 215,   3, 215,    3, 216, 255, 215,   8, 216, 255, 215,
       3, 216, 255, 215,  23, 216, 255, 215,   10, 216, 255, 215,   5, 216,   3, 215,
       3, 216,  29, 215,   2, 215,   5, 216,  255, 215,   3, 216, 255, 215,   3, 216,
      11, 215,   2, 216,   6, 215,   4, 216,    2, 215,  10, 216,   8, 215,   8, 216,
      29, 215,   4, 215,   2, 216, 255, 215,    8, 216, 255, 215,   3, 216, 255, 215,
      23, 216, 255, 215,  10, 216, 255, 215,    5, 216,   3, 215,   3, 216,  29, 215,
       2, 215,   5, 216, 255, 215,   3, 216,  255, 215,   3, 216,   8, 215,   2, 216,
       7, 215, 254, 216, 215,   4, 216,   2,  215,  10, 216, 255, 215,   2, 216,  42,
     215,   4, 215,   2, 216, 255, 215,   8,  216, 255, 215,   3, 216, 255, 215,  23,
     216, 255, 215,  16, 216,   3, 215,   3,  216,  29, 215,   2, 215,   5, 216, 255,
     215,   3, 216, 255, 215,   3, 216,  10,  215, 255, 216,   8, 215,   4, 216,   2,
     215,  16, 216,   3, 215,   7, 216,  29,  215,   4, 215,   2, 216, 255, 215,  18,
     216,   3, 215,  24, 216, 255, 215,   9,  216, 254, 215, 216,  31, 215,   2, 215,
       7, 216,   8, 215,   6, 216, 253, 215,  216, 215,   8, 216,  18, 215,   3, 216,
      40, 215,   3, 215,  55, 216,   7, 215,  255, 216,  29, 215,   2, 215,   8, 216,
       4, 215,  16, 216,  65, 215,   3, 215,    2, 216, 254, 215, 216,   2, 215,   2,
     216, 254, 215, 216,   2, 215, 255, 216,    6, 215,   4, 216, 255, 215,   7, 216,
     255, 215,   3, 216, 252, 215, 216, 215,  216,   2, 215,   2, 216, 255, 215,  11,
     216,   3, 215,   3, 216,  31, 215,   2,  215,   5, 216, 254, 215, 216,   5, 215,
       2, 216,   2, 215,  10, 216,   2, 215,    2, 216,  63, 215,   2, 215,  24, 216,
       2, 215,  27, 216, 251, 215, 216, 215,  216, 215,   6, 216,  29, 215,   2, 215,
       8, 216, 255, 215,  36, 216,   6, 215,  254, 216, 215,   5, 216,   4, 215,   2,
     216,  29, 215,   3, 215, 255, 216,   3,  215, 255, 216,   2, 215,   4, 216,   4,
     215,   8, 216, 255, 215,  36, 216, 255,  215,   2, 216,  29, 215,   2, 215,   6,
     216, 255, 215,   6, 216, 255, 215,  11,  216,  68, 215,   2, 215, 252,  48,   2,
      49,  50,   5,   2, 249,  51,  52,  53,   54,  55,  56,  57,  10,   2, 230,  58,
      59,  60,  61,  62,  63,  64,  65,  66,   67,  68,  69,  70,  71,  72,  73,  74,
     215,  75,  76,  77, 215,  78,  79, 215,   80,   3,   2, 255, 215,   4,   2, 252,
      81,  82,  83,  84,  29, 215,   2, 215,   55, 216, 254, 215, 216,   2, 215,   5,
     216,  29, 215,   2, 215,  13, 216, 255,  215,  50, 216,  29, 215,   2, 215,   6,
     216,  10, 215,  45, 216,  32, 215,   2,  215,   9, 216, 255, 215,   4, 216,   2,
     215,   7, 216, 253, 215, 216, 215,   4,  216,   2, 215,  32, 216,  29, 215,   2,
     215,   9, 216, 255, 215,   4, 216,   2,  215,  33, 216, 255, 215,   4, 216,   2,
     215,   7, 216,  30, 215,   2, 215, 254,  216, 215,   4, 216,   2, 215,  15, 216,
     255, 215,  40, 216,  29, 215,   2, 215,   17, 216, 255, 215,   4, 216,   2, 215,
      40, 216,  29, 215,   2, 215,  27, 216,    5, 215,  29, 216,  32, 215,   2, 215,
      26, 216,   6, 215,  32, 216,  29, 215,    2, 215,  53, 216,  40, 215,   2, 215,
      29, 216,   3, 215,  32, 216,  29, 215,    2, 215,  49, 216,  44, 215,   2, 215,
      13, 216, 255, 215,   6, 216,  12, 215,   20, 216, 255, 215,   2, 216,  38, 215,
       2, 215,  20, 216,  12, 215,  13, 216,  255, 215,   3, 216, 255, 215,   2, 216,
      41, 215,   2, 215,  52, 216,   2, 215,   10, 216,  29, 215,   2, 215,  18, 216,
     255, 215,  10, 216,   3, 215,  10, 216,    6, 215,  10, 216,  35, 215,   2, 215,
      15, 216, 255, 215,  10, 216,   6, 215,   32, 216,  29, 215,   2, 215,  56, 216,
      37, 215,   2, 215,  41, 216, 254, 215,  216,   5, 215,  16, 216,  29, 215,   2,
     215,  54, 216,  39, 215,   2, 215,  29,  216,   3, 215,  12, 216,   4, 215,   9,
     216,  36, 215,   2, 215, 255, 216,   3,  215,  42, 216,   2, 215,   5, 216,  40,
     215,   2, 215,  44, 216,   4, 215,  16,  216,  29, 215,   2, 215,  10, 216,   6,
     215,  11, 216,   3, 215,  34, 216,  29,  215,   2, 215,  23, 216,   2, 215,   3,
     216,   2, 215,  34, 216,  29, 215,   2,  215,  31, 216,   2, 215,  20, 216,  40,
     215,   2, 215,  10, 216,   6, 215,  10,  216,   6, 215,  14, 216,  47, 215,   2,
     215,  52, 216, 255, 215,  11, 216,  29,  215,   2, 215,   4, 216, 255, 215,   7,
     216,   4, 215,  27, 216,   9, 215,   9,  216,  32, 215,   2, 215,  42, 216,   4,
     215,  12, 216,  35, 215,   2, 215,  55,  216,   4, 215,   5, 216,  29, 215,   2,
     215,  10, 216,   3, 215,  51, 216,  29,  215,  21, 215, 255, 216,  13, 215, 255,
     216,   7, 215,   4, 216, 255, 215,   5,  216,  42, 215,   2, 215,  22, 216,   2,
     215,   6, 216,   2, 215,  32, 216,  29,  215,   2, 215,   6, 216,   2, 215,   6,
     216,   2, 215,   8, 216, 249, 215, 216,  215, 216, 215, 216, 215,  31, 216,  31,
     215,   2, 215,  53, 216, 255, 215,  10,  216,  29, 215,   2, 215,   5, 216, 255,
     215,  14, 216,   2, 215,   6, 216, 255,  215,  19, 216,   2, 215,   3, 216, 255,
     215,   9, 216,  30, 215,   2, 215, 252,   86,  87,  88,  89,   2,   2, 255,  90,
       8,   2, 253,  91,  92,  93,   9,   2,  251,  94,  95,  96,  97,  98,  13,   2,
     255,  99,   2, 215, 244, 100, 101,   2,  102, 103, 104, 105, 106,  15, 215, 107,
     108,   3,   2, 255, 109,  29, 215,   2,  215,  11, 216,   5, 215,  26, 216,   5,
     215,  17, 216,  29, 215,   2, 215,  32,  216,  16, 215,   2, 216,   2, 215,  12,
     216,  29, 215,   2, 215,  15, 216, 255,  215,   5, 216,  11, 215,  25, 216,  36,
     215,  31, 215,   4, 216, 255, 215,   3,  216,  56, 215,   2, 215,  10, 216,   6,
     215,  48, 216,  29, 215,   2, 215,  41,  216,  52, 215,   2, 215,  39, 216,  54,
     215,   2, 215,  11, 216,  21, 215,  32,  216,  29, 215,   2, 215,  14, 216, 255,
     215,  19, 216, 254, 215, 216,   4, 215,   24, 216,  29, 215,   3, 215,   4, 216,
     255, 215,   4, 216,   2, 215,  28, 216,  255, 215,  23, 216,  29, 215,   2, 215,
      12, 216, 253, 215, 216, 215,   4, 216,    3, 215,   9, 216,   2, 215,  31, 216,
      29, 215,   2, 215,  21, 216,   3, 215,   24, 216, 255, 215,  14, 216,  30, 215,
       2, 215,  11, 216, 254, 215, 216,   3,  215,  48, 216,  29, 215,   2, 215,  13,
     216,   3, 215,  10, 216,  67, 215,   2,  215,  47, 216, 255, 215,  16, 216,  29,
     215,   2, 215,  31, 216, 255, 215,  32,  216,  29, 215,   2, 215,  47, 216,  10,
     215,   7, 216,  29, 215,   2, 215,  38,  216,  10, 215,  16, 216,  29, 215,   2,
     215,  38, 216,   9, 215, 255, 216,  45,  215,   2, 215,  23, 216,   9, 215,   7,
     216, 255, 215,   7, 216, 255, 215,   7,  216, 255, 215,   7, 216,  30, 215,   2,
     215,   7, 216, 255, 215,   7, 216, 255,  215,   7, 216, 255, 215,   7, 216,  62,
     215,   2, 215,  26, 216, 255, 215,  37,  216,  29, 215,   2, 215,  52, 216,  41,
     215,   2, 215,  22, 216,  26, 215,  12,  216,  33, 215,   2, 215, 247, 111, 112,
     113,   2, 114,   2, 115, 116, 101,   2,    2, 255, 117,  52,   2,  29, 215,   2,
     215,  42, 216,   6, 215,  16, 216,  29,  215,   3, 215,  63, 216,  29, 215,   2,
     215,  23, 216,   4, 215,  37, 216,  29,  215,   7, 215,  41, 216,   3, 215,  15,
     216,  29, 215,   2, 215,  15, 216, 255,  215,  40, 216,  37, 215,   2, 215,  36,
     216,  12, 215,  16, 216,  29, 215,   2,  215,  63, 216,  30, 215,   2, 215,  54,
       2, 255,  67,   9,   2,  29, 215,   2,  215,  64,   2,  29, 215,   2, 215,  63,
       2, 255, 121,  29, 215,   2, 215,  12,  216,  81, 215,   2, 215,  18,   2, 254,
     123, 124,   4,   2, 252, 125, 126, 127,  128,   2,   2, 242, 129, 130, 131,  65,
       2, 132, 133, 134, 135, 136, 137, 138,  139, 140,   3, 215, 255, 141,  16,   2,
      29, 215,   2, 215,  13, 216,   3, 215,   48, 216,  29, 215,   2, 215,   7, 216,
       9, 215,  48, 216,  29, 215,   2, 215,   44, 216,  49, 215,   2, 215,  32, 216,
       2, 215,  13, 216, 255, 215,   4, 216,   10, 215,   2, 216,  29, 215,   2, 215,
      24, 216,   8, 215,  32, 216,  29, 215,    2, 215,  48, 216,   2, 215,   6, 216,
      37, 215,   2, 215,  13, 216,  80, 215,   61, 215,   5, 216,  29, 215,   2, 215,
       6, 216, 255, 215,  37, 216,   4, 215,   10, 216,  35, 215,   2, 215,   4, 216,
      10, 215,  12, 216,  24, 215,  10, 216,   33, 215,   2, 215,  43, 216,   3, 215,
      18, 216,  29, 215,   2, 215,  19, 216,   12, 215,  30, 216,  32, 215,   2, 215,
      51, 216, 255, 215,  12, 216,  29, 215,    3, 215,  13, 216, 255, 215,  11, 216,
       4, 215,   2, 216,  61, 215,   2, 215,   55, 216,  38, 215,   2, 215,  14, 216,
       2, 215,  10, 216,   2, 215,  32, 216,   33, 215,   2, 215,  48, 216, 254, 215,
     216,   3, 215,   2, 216,   2, 215,   5,  216,  31, 215,   2, 215, 253, 216, 215,
     216,  24, 215,   5, 216,  61, 215,   2,  215,  45, 216,   3, 215,  10, 216,  35,
     215,   2, 215,  30,   2, 254, 116, 143,   61, 215,   2, 215,   7, 216,   4, 215,
      49, 216,  33, 215,   2, 215,   4,   2,   89, 215,  37, 215, 255, 146,   4,   2,
       2, 147, 250,   2, 148, 149, 150,  15,  151,   5,   2, 245, 146, 152, 153, 154,
     155,   2, 156, 112,   2, 117, 157,  29,  215,  18, 215,  48, 216,  29, 215,   2,
     215,  46, 216,   2, 215,  16, 216,  29,  215,   2, 215,  26, 216,  67, 215,   2,
     215,   7, 216,  12, 215,   5, 216,   5,  215, 254, 216, 215,  24, 216, 255, 215,
       5, 216, 254, 215, 216,  30, 215,   2,  215,   2, 216, 255, 215,   2, 216, 255,
     215,  58, 216,  29, 215,  21, 215,  45,  216,  29, 215,   2, 215,  16, 216,   2,
     215,  46, 216,  29, 215,   2, 215,   8,  216,  40, 215,  14, 216,  31, 215,   2,
     215,  26, 216,  22, 215,  16, 216,  29,  215,   2, 215,  19, 216, 255, 215,  19,
     216, 255, 215,   4, 216,   4, 215,   5,  216, 255, 215,  10, 216,  29, 215,   2,
     215,  61, 216,  32, 215,   4, 215,   6,  216,   2, 215,   6, 216,   2, 215,   6,
     216,   2, 215,   3, 216,   3, 215,   7,  216, 255, 215,   7, 216,  13, 215,   2,
     216,  31, 215,  18, 215, 252, 159, 181,  184, 187,   9, 215, 253, 188, 215, 202,
      10, 119, 254, 208, 210,   3, 215, 255,  211,  45, 215,   2, 215, 248, 160, 161,
       2, 162, 163,   2, 164, 165,   2, 215,  250,  58, 166, 167, 168, 169, 170,   2,
       2, 255, 171,  13, 215, 254, 172, 173,    2, 215, 255, 174,   3, 215, 254, 175,
     176,   2, 215, 254, 177, 178,   2, 215,  254,   2, 179,   7, 215, 255, 180,  35,
     215,   2, 215,  12, 216, 255, 215,  26,  216, 255, 215,  19, 216, 255, 215,   2,
     216, 254, 215, 216,  29, 215,   2, 215,   14, 216,   2, 215,  14, 216,  63, 215,
       2, 215,  59, 216,  34, 215,   2, 215,    3, 216,   4, 215,  45, 216,   3, 215,
       9, 216,  29, 215,   2, 215,  11, 216,    5, 215,  12, 216,  65, 215,  18, 215,
      45, 216,  32, 215,   2, 215,  17, 216,   76, 215,   2, 215,  31, 216, 255, 215,
       4, 216,  12, 215,  16, 216,  29, 215,    2, 215,  11, 216,  82, 215,   2, 215,
      30, 216, 255, 215,  33, 216,  29, 215,    2, 215,   4, 216,   4, 215,  14, 216,
      71, 215,   2, 215,  30, 216,   2, 215,   10, 216,  51, 215,   2, 215,   6, 216,
       2, 215, 254, 216, 215,  44, 216, 255,  215,   2, 216,   3, 215, 255, 216,   2,
     215, 255, 216,  29, 215,   2, 215,  22,  216, 255, 215,   9, 216,  61, 215,   2,
     215,  28, 216,   3, 215,  27, 216,   5,  215, 255, 216,  29, 215,   2, 215,   4,
     216, 255, 215,   2, 216,   5, 215, 252,  216, 215, 216, 215,   4, 216, 255, 215,
       3, 216, 255, 215,  27, 216,  41, 215,    2, 215,   8, 216,   8, 215,   9, 216,
       7, 215,  32, 216,  29, 215,   2, 215,   54, 216,   3, 215,   7, 216,  29, 215,
       2, 215,  22, 216,   2, 215,  27, 216,    5, 215,   8, 216,  29, 215,   2, 215,
       9, 216,  84, 215,  34, 215,  31, 216,   30, 215,   4, 215, 254, 182, 183,  89,
     215,   2, 215,  57, 216,   2, 215,   2,  216, 255, 215,   2, 216,  29, 215,   2,
     215,   2, 216,  91, 215,   2, 215,  13,    2, 255, 185,   2, 215, 254,   2, 186,
      75, 215,   2, 215,  47, 216,  46, 215,    2, 215,  35, 216,  13, 215,   4, 216,
      41, 215,   2, 215,  16,   2, 255, 185,   76, 215,   2, 215,   3,   2, 249,  67,
     189, 190, 191, 192,   2, 193,   2, 215,  254,   2, 194,   2, 215, 250,   2, 195,
     196, 197, 198, 199,   4,   2, 255, 200,    4,   2, 255, 201,  61, 215,   2, 215,
      39, 216,   2, 215,  23, 216,  29, 215,    2, 215,  37, 216,   5, 215,   3, 216,
      48, 215,   5, 215,   2, 216,   7, 215,   30, 216,   4, 215,  18, 216,  29, 215,
       2, 215,  30, 216,  63, 215,   2, 215,    2, 216,   3, 215, 255, 216,  87, 215,
       2, 215,  23, 216,   9, 215,  18, 216,   43, 215,   2, 215,  21, 216, 255, 215,
      42, 216,  29, 215,   2, 215,  29, 216,  255, 215,   2, 216,   2, 215, 255, 216,
       2, 215,   2, 216,   2, 215,   4, 216,  255, 215,  12, 216, 253, 215, 216, 215,
       3, 216,  29, 215,   2, 215,   4, 216,  255, 215,  59, 216,  29, 215,   2, 215,
       6, 216, 255, 215,   4, 216,   2, 215,    8, 216, 255, 215,   7, 216, 255, 215,
      28, 216, 255, 215,   4, 216,  30, 215,    2, 215,   5, 216, 254, 215, 216,   3,
     215,   7, 216, 255, 215,  46, 216,  29,  215,   2, 215,  38, 216,   2, 215,  24,
     216,  29, 215,   2, 215,  12, 216,   2,  215,  50, 216,  29, 215,   2, 215, 246,
      70,   2, 203, 215, 204, 205, 206, 215,  207, 179,  83, 215,   2, 215,  20, 216,
      73, 215,   2, 215,  11, 216,   5, 215,   31, 216,   2, 215, 255, 216,  11, 215,
     253, 216, 215, 216,  29, 215,   4, 215,  255, 216,   3, 215, 255, 216,   3, 215,
       5, 216,   8, 215, 255, 216,   7, 215,  255, 216,  25, 215, 254, 216, 215,   2,
     216,   2, 215, 255, 216,  29, 215,  12,  215,   4, 216,   2, 215, 255, 216,  76,
     215,   2, 215, 255, 216,  15, 215,  34,  216,  43, 215,   2, 215,  27,   2, 255,
     209,  36,   2,  29, 215,   2, 215,  23,  216,  70, 215,   2, 215,  28,   2, 255,
      57,  64, 215,  34, 215,   8,   2, 255,  192,  52, 215,  34, 215, 255, 213,  60,
     215,   6, 215,   3,   2, 255, 214,  85,  215,   2, 215,  48, 216,  45, 215
};

// utf/cl_AttrNameInitial.txt
//
// 177 included, 1113935 excluded, 0 errors.
// 6 states, 14 columns, 312 bytes
//
const unsigned char cl_attrnameinitial_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   1,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   1,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   1,   0,

       2,   3,   4,   4,   4,   5,   5,   4,    3,   2,   2,   2,   5,   5,   5,   5,
       4,   4,   6,   3,   3,   3,   2,   0,    4,   4,   4,   4,   2,   2,   3,   3,
       3,   3,   3,   3,   3,   3,   2,   2,    2,   2,   7,   2,   2,   2,   3,   3,
       3,   3,   2,   2,   2,   7,   2,   0,    3,   4,   8,   3,   3,   4,   4,   2,
       0,   0,   9,  10,  11,  12,  13,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_attrnameinitial_sot[6] =
{
        0,   11,   17,   23,   33,   44
};

const unsigned char cl_attrnameinitial_sbt[50] =
{
     254,   6,   7,   7,   6, 251,   1,   2,    3,   4,   5,   7,   6,   2,   7,   5,
       6,   2,   6,   7,   7,   5,   6,   4,    6,   2,   7,   2,   6, 255,   7,   5,
       6,   3,   6,   2,   7, 252,   6,   7,    6,   7,   5,   6,   6,   6, 255,   7,
       7,   6
};

// utf/cl_AttrName.txt
//
// 203 included, 1113909 excluded, 0 errors.
// 6 states, 14 columns, 312 bytes
//
const unsigned char cl_attrname_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   1,   1,   0,   1,   1,    1,   1,   0,   1,   0,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   0,   0,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   1,   0,

       2,   3,   4,   4,   4,   5,   5,   4,    3,   2,   2,   2,   5,   5,   5,   5,
       4,   4,   6,   3,   3,   3,   2,   0,    4,   4,   4,   4,   2,   2,   3,   3,
       3,   3,   3,   3,   3,   3,   2,   2,    2,   2,   7,   2,   2,   2,   3,   3,
       3,   3,   2,   2,   2,   7,   2,   0,    3,   4,   8,   3,   3,   4,   4,   2,
       0,   0,   9,  10,  11,  12,  13,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_attrname_sot[6] =
{
        0,   11,   17,   23,   33,   44
};

const unsigned char cl_attrname_sbt[50] =
{
     254,   6,   7,   7,   6, 251,   1,   2,    3,   4,   5,   7,   6,   2,   7,   5,
       6,   2,   6,   7,   7,   5,   6,   4,    6,   2,   7,   2,   6, 255,   7,   5,
       6,   3,   6,   2,   7, 252,   6,   7,    6,   7,   5,   6,   6,   6, 255,   7,
       7,   6
};

// utf/cl_ObjectName.txt
//
// 257 included, 1113855 excluded, 0 errors.
// 8 states, 23 columns, 343 bytes
//
const unsigned char cl_objectname_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       1,   1,   1,   1,   1,   1,   0,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   0,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   0,   1,   1,   0,

       2,   3,   4,   4,   4,   5,   5,   4,    3,   6,   6,   6,   5,   5,   5,   5,
       4,   4,   7,   8,   8,   3,   6,   6,    9,   9,   9,   4,  10,  10,   8,   3,
       8,  11,  11,  12,  12,  12,  13,  14,   14,  14,  14,  14,  14,  14,  12,  12,
      11,  12,  14,  14,  14,  14,  14,  14,   12,  15,  16,  12,  12,  16,  16,  14,
       0,   0,  17,  18,  19,  20,  21,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,  22,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_objectname_sot[8] =
{
        0,   12,   18,   24,   38,   56,   62,   68
};

const unsigned char cl_objectname_sbt[79] =
{
     254,   8,   9,  15,   8, 250,   1,   2,    3,   4,   5,   6,  11,   8,   6,   9,
       6,   8,   2,   8,  15,   9,   6,   8,    4,   8,   2,   9,   3,   8, 255,   9,
       5,   8,   2,   9,   6,   8,   3,   8,    2,   9,   2,   8,   3,   9, 255,   8,
       2,   9,   2,   8,   2,   9,   6,   8,    7,   8, 255,   9,  15,   8,   2,   8,
     255,   7,  20,   8,   8,   8,   4,   9,  252,   8,   9,   8,   9,   7,   8
};

// utf/cl_PlayerName.txt
//
// 190 included, 1113922 excluded, 0 errors.
// 6 states, 14 columns, 312 bytes
//
const unsigned char cl_playername_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   1,   0,   0,   1,    0,   0,   0,   0,   1,   1,   1,   0,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   0,

       2,   3,   4,   4,   4,   5,   5,   4,    3,   2,   2,   2,   5,   5,   5,   5,
       4,   4,   6,   3,   3,   3,   2,   0,    4,   4,   4,   4,   2,   2,   3,   3,
       3,   3,   3,   3,   3,   3,   2,   2,    2,   2,   7,   2,   2,   2,   3,   3,
       3,   3,   2,   2,   2,   7,   2,   0,    3,   4,   8,   3,   3,   4,   4,   2,
       0,   0,   9,  10,  11,  12,  13,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_playername_sot[6] =
{
        0,   11,   17,   23,   33,   44
};

const unsigned char cl_playername_sbt[50] =
{
     254,   6,   7,   7,   6, 251,   1,   2,    3,   4,   5,   7,   6,   2,   7,   5,
       6,   2,   6,   7,   7,   5,   6,   4,    6,   2,   7,   2,   6, 255,   7,   5,
       6,   3,   6,   2,   7, 252,   6,   7,    6,   7,   5,   6,   6,   6, 255,   7,
       7,   6
};

// utf/cl_8859_1.txt
//
// 191 included, 1113921 excluded, 0 errors.
// 3 states, 6 columns, 279 bytes
//
const unsigned char cl_8859_1_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   0,

       2,   2,   2,   2,   2,   2,   2,   2,    2,   2,   2,   2,   2,   2,   2,   2,
       2,   2,   2,   2,   2,   2,   2,   2,    2,   2,   2,   2,   2,   2,   2,   2,
       3,   3,   3,   3,   3,   3,   3,   3,    3,   3,   3,   3,   3,   3,   3,   3,
       3,   3,   3,   3,   3,   3,   3,   3,    3,   3,   3,   3,   3,   3,   3,   3,
       0,   0,   4,   5,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_8859_1_sot[3] =
{
        0,    8,   14
};

const unsigned char cl_8859_1_sbt[20] =
{
     254,   3,   4,   2,   3, 254,   1,   2,    3,   3, 255,   4,   2,   3,   2,   3,
       2,   4,   2,   3
};

// utf/cl_8859_2.txt
//
// 191 included, 1113921 excluded, 0 errors.
// 6 states, 21 columns, 335 bytes
//
const unsigned char cl_8859_2_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   0,

       0,   2,   3,   4,   3,   5,   5,   6,    7,   8,   0,   8,   5,   9,   9,   5,
       4,   4,   0,   8,   2,   7,   8,   8,   10,  10,   3,  10,   8,  11,   7,   2,
      12,   2,   2,   7,  13,   7,   0,  14,   15,   8,   0,   8,   0,  14,   2,   7,
      12,   7,   0,   8,  14,   0,   8,   8,   15,   4,   3,   7,   2,   3,   4,   0,
       0,   0,  16,  17,  18,  19,   0,   0,    0,   0,   0,  20,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char cl_8859_2_sot[6] =
{
        0,   11,   17,   36,   46,   63
};

const unsigned char cl_8859_2_sbt[73] =
{
     254,   6,   7,  14,   6, 251,   1,   2,    3,   4,   5,  12,   6,   4,   7,   5,
       6,   2,   6,   2,   7,   2,   6, 254,    7,   6,   2,   7, 253,   6,   7,   6,
       2,   7,   6,   6,   3,   6,   4,   7,    2,   6,   2,   7,  10,   6,   2,   6,
       3,   7, 255,   6,   2,   7,   2,   6,  254,   7,   6,   2,   7,   7,   6,   6,
       6, 255,   7,   3,   6,   2,   7,   9,    6
};

// utf/tr_utf8_ascii.txt
//
// 2367 code points.
// 94 states, 192 columns, 3739 bytes
//
const unsigned char tr_ascii_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   1,    2,   3,   4,   0,   0,   5,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   6,   0,   0,   0,   0,
       7,   8,   9,  10,  11,  12,  13,  14,   15,  16,  17,  18,  19,  20,  21,  22,
      23,  24,  25,  26,  27,  28,  29,  30,   31,  32,  33,  34,  35,  36,  37,   0,
      38,  39,  40,  41,  42,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100,   0,

     101, 102, 103, 104, 105, 106, 107, 108,  109, 110, 111, 112, 113, 114, 115, 116,
     117, 118, 119, 120, 121, 122, 123, 124,  125, 126, 127, 128, 129, 130, 131, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
       0,   0, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174,   0, 175, 176,   0,
     177, 178, 179, 180,   0, 181, 182,   0,    0, 183,   0, 184,   0,   0,   0, 185,
     186, 187, 188, 189,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0, 190,
     191,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_ascii_sot[94] =
{
        0,  132,  165,  215,  284,  355,  417,  481,   552,  606,  643,  658,  670,  676,  720,  740,
      754,  783,  791,  797,  814,  831,  850,  881,   898,  913,  954,  969,  985, 1004, 1021, 1085,
     1148, 1216, 1285, 1354, 1422, 1485, 1495, 1519,  1562, 1600, 1638, 1663, 1716, 1762, 1772, 1785,
     1801, 1829, 1882, 1944, 1950, 1970, 1994, 2012,  2018, 2028, 2057, 2066, 2082, 2090, 2098, 2112,
     2127, 2146, 2170, 2178, 2186, 2207, 2266, 2334,  2370, 2378, 2390, 2402, 2412, 2421, 2445, 2470,
     2539, 2608, 2680, 2749, 2818, 2887, 2956, 3025,  3094, 3163, 3204, 3259, 3266, 3285
};

const unsigned char tr_ascii_sbt[3295] =
{
     155, 157, 101, 102, 103, 104, 107, 121,  126, 127, 128, 129, 130, 131, 132, 133,
     134, 135, 136, 137, 138, 139, 140, 141,  142, 143, 144, 145, 146, 147, 148, 149,
     150, 151, 152, 153, 154, 155, 156, 158,  159, 160, 161, 162, 163, 164, 165, 166,
     167, 168, 169, 170, 171, 172, 173, 174,  175, 176, 177, 178, 179, 180, 181, 182,
     183, 184, 185, 186, 187, 188, 189, 190,  191, 192, 193, 194, 195, 196, 197, 198,
     199, 200, 201, 202, 203, 204, 205, 206,  207, 208, 209, 210, 211, 212, 213, 214,
     215, 216, 217, 218, 219, 220,  64, 157,  229,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,   16,  17,  18,  19,  20,  21,  22,  25,
      39,  59,  65,  73, 127, 157,   6, 157,  254, 126, 127,   6, 157, 253, 126, 157,
     191,   2, 157, 253, 139, 157, 126,   2,  157, 253, 144, 145, 126,   3, 157, 253,
     126, 143, 205,  32, 157, 101, 157,   6,  159, 254, 157, 161,   4, 163,   4, 167,
     254, 162, 172,   5, 173, 254, 136, 173,    4, 179, 255, 183,   2, 157,   6, 191,
     254, 157, 193,   4, 195,   4, 199, 254,  194, 204,   5, 205, 254, 141, 205,   4,
     211, 253, 215, 157, 215,  27, 157, 101,  157, 207, 159, 191, 159, 191, 159, 191,
     161, 193, 161, 193, 161, 193, 161, 193,  162, 194, 162, 194, 163, 195, 163, 195,
     163, 195, 163, 195, 163, 195, 165, 197,  165, 197, 165, 197, 165, 197, 166, 198,
     166, 198, 167, 199, 167, 199, 167, 199,  167, 199, 167,   3, 157, 244, 168, 200,
     169, 201, 157, 170, 202, 170, 202, 170,  202, 170,  27, 157, 101, 157, 248, 202,
     170, 202, 172, 204, 172, 204, 172,   2,  204,   2, 157, 250, 173, 205, 173, 205,
     173, 205,   2, 157, 212, 176, 208, 176,  208, 176, 208, 177, 209, 177, 209, 177,
     209, 177, 209, 178, 210, 178, 210, 178,  210, 179, 211, 179, 211, 179, 211, 179,
     211, 179, 211, 179, 211, 181, 213, 183,  215, 183, 184, 216, 184, 216, 184, 216,
     209,  27, 157, 101, 157, 255, 192,   2,  160, 255, 192,   3, 157, 253, 161, 193,
     157,   2, 162, 255, 194,   4, 157, 253,  164, 196, 165,   3, 157, 252, 167, 169,
     201, 202,   2, 157, 254, 172, 204,   2,  173, 255, 205,   2, 157, 254, 174, 206,
       5, 157, 244, 210, 178, 210, 178, 179,  211, 157, 180, 183, 215, 184, 216,  36,
     157, 104, 157, 255, 127,   9, 157, 235,  159, 191, 167, 199, 173, 205, 179, 211,
     179, 211, 179, 211, 179, 211, 179, 211,  157, 159, 191, 159, 191,   2, 157, 246,
     165, 197, 165, 197, 169, 201, 173, 205,  173, 205,   2, 157, 255, 200,   3, 157,
     254, 165, 197,   2, 157, 252, 172, 204,  159, 191,   2, 157, 254, 173, 205,  27,
     157, 101, 157, 228, 159, 191, 159, 191,  163, 195, 163, 195, 167, 199, 167, 199,
     173, 205, 173, 205, 176, 208, 176, 208,  179, 211, 179, 211, 177, 209, 178, 210,
       2, 157, 252, 166, 198, 172, 194,   2,  157, 237, 184, 216, 159, 191, 163, 195,
     173, 205, 173, 205, 173, 205, 173, 205,  183, 215, 202, 204, 210,   3, 157, 250,
     159, 161, 193, 170, 178, 209,  27, 157,  101, 157, 255, 216,   2, 157, 243, 160,
     179, 157, 163, 195, 168, 200, 157, 207,  176, 208, 183, 215,   3, 157, 253, 192,
     157, 193,   2, 194,   8, 157, 255, 197,    5, 157, 253, 198, 157, 199,   2, 157,
       4, 202,   2, 157, 255, 203,   2, 204,    8, 157,   3, 208,  28, 157, 103, 157,
     255, 209,   5, 157, 252, 210, 211, 157,  212,   4, 157,   2, 216,  11, 157, 255,
     200,   2, 157, 255, 207,  15, 157, 252,  198, 157, 200, 208,   3, 157, 254, 213,
     215,  34, 157, 125, 157,   4, 126, 254,  220, 126,   3, 157, 253, 202, 209, 214,
      55, 157, 127, 157,  32, 157, 255, 126,    3, 157, 255, 153,  28, 157, 105, 157,
       2, 126,  85, 157, 105, 157, 253, 163,  157, 167,   6, 157, 255, 167,   2, 157,
     255, 159,   7, 157, 255, 167,   5, 157,  255, 173,   4, 157, 255, 179,   9, 157,
     255, 163,   2, 157, 255, 191,   7, 157,  255, 199,   5, 157, 255, 205,  28, 157,
     104, 157, 255, 211,   9, 157, 255, 195,    6, 157, 253, 195, 157, 199,   6, 157,
     255, 199,  61, 157, 127, 157,  14, 157,  254, 173, 205,  16, 157, 254, 166, 198,
      31, 157, 117, 157, 252, 159, 191, 159,  191,  14, 157, 250, 167, 199, 167, 199,
     173, 205,   4, 157, 248, 163, 195, 179,  211, 179, 211, 179, 211,  39, 157, 127,
     157,   2, 157, 255, 127,  62, 157, 111,  157, 255, 139,  80, 157, 127, 157,   6,
     157, 246, 142, 143, 144, 145, 146, 147,  148, 149, 150, 151,  49, 157, 127, 157,
      22, 157, 246, 142, 143, 144, 145, 146,  147, 148, 149, 150, 151,  33, 157, 101,
     157, 246, 142, 143, 144, 145, 146, 147,  148, 149, 150, 151,  47, 157, 255, 127,
      33, 157, 127, 157,  11, 157, 239,  23,  157,  23, 157,  23, 157,  23, 157,  23,
     157,  23, 157,  23, 157,  23, 157,  23,    3, 157, 252,  24, 157,  24,  19,  30,
     157, 127, 157,  12, 157, 246, 142, 143,  144, 145, 146, 147, 148, 149, 150, 151,
      43, 157, 117, 157, 246, 142, 143, 144,  145, 146, 147, 148, 149, 150, 151,  65,
     157, 102, 157, 255,  26,  11, 157, 255,   27,  17, 157, 254,  19,  28,   4, 157,
     253,  29, 157,  24,   5, 157, 255,  24,    6, 157, 248,  30,  31,  32, 157,  33,
      34,  35,  36,   2, 157, 254,  37,  38,   27, 157, 101, 157, 246, 142, 143, 144,
     145, 146, 147, 148, 149, 150, 151,  81,  157, 127, 157,  15, 157, 247, 143, 144,
     145, 146, 147, 148, 149, 150, 151,  41,  157, 107, 157, 255, 139,   9, 157, 246,
     142, 143, 144, 145, 146, 147, 148, 149,  150, 151,  65, 157, 105, 157, 244, 127,
     157, 142, 143, 144, 145, 146, 147, 148,  149, 150, 151,  75, 157, 101, 157, 255,
     159,   2, 157, 252, 160, 161, 162, 194,    2, 163, 250, 167, 168, 169, 170, 171,
     172,   5, 173,   2, 157,   2, 173, 255,  174,   2, 176, 255, 178,   3, 179, 252,
     171, 180, 181, 184,   9, 157, 236, 159,  157, 160, 157, 162, 163, 157, 165, 166,
     167, 168, 169, 170, 171, 172, 157, 173,  157, 174, 176,  27, 157, 101, 157, 252,
     178, 179, 181, 191,   3, 157, 253, 192,  194, 195,   3, 157, 250, 197, 157, 201,
     203, 157, 205,   3, 157, 253, 206, 210,  211,   2, 157, 255, 212,   6, 157, 252,
     199, 208, 211, 212,   6, 157, 250, 192,  194, 196, 203, 204, 206,   2, 208, 253,
     209, 210, 216,   4, 157, 252, 167, 157,  206, 179,  28, 157, 101, 157, 237, 192,
     194, 196, 197, 201, 202, 203, 204, 206,  208, 209, 157, 212, 214, 216, 191, 157,
     194, 195,   3, 157, 255, 199,   2, 157,  255, 211,   2, 157,   2, 193, 248, 194,
     195, 196, 200, 197, 198, 199, 157,   2,  199, 255, 200,   3, 202,   2, 203,   3,
     204, 248, 205, 157, 209, 157, 210, 211,  157, 211,   2, 212,   3, 216,  29, 157,
     101, 157, 192, 159, 191, 160, 192, 160,  192, 160, 192, 161, 193, 162, 194, 162,
     194, 162, 194, 162, 194, 162, 194, 163,  195, 163, 195, 163, 195, 163, 195, 163,
     195, 164, 196, 165, 197, 166, 198, 166,  198, 166, 198, 166, 198, 166, 198, 167,
     199, 167, 199, 169, 201, 169, 201, 169,  201, 170, 202, 170, 202, 170, 202, 170,
     202, 171, 203,  27, 157, 101, 157, 192,  171, 203, 171, 203, 172, 204, 172, 204,
     172, 204, 172, 204, 173, 205, 173, 205,  173, 205, 173, 205, 174, 206, 174, 206,
     176, 208, 176, 208, 176, 208, 176, 208,  177, 209, 177, 209, 177, 209, 177, 209,
     177, 209, 178, 210, 178, 210, 178, 210,  178, 210, 179, 211, 179, 211, 179, 211,
     179, 211, 179, 211, 180, 212, 180, 212,   27, 157, 101, 157, 228, 181, 213, 181,
     213, 181, 213, 181, 213, 181, 213, 182,  214, 182, 214, 183, 215, 184, 216, 184,
     216, 184, 216, 198, 210, 213, 215, 191,  209,   4, 157, 224, 159, 191, 159, 191,
     159, 191, 159, 191, 159, 191, 159, 191,  159, 191, 159, 191, 159, 191, 159, 191,
     159, 191, 159, 191, 163, 195, 163, 195,  163, 195, 163, 195,  27, 157, 101, 157,
     198, 163, 195, 163, 195, 163, 195, 163,  195, 167, 199, 167, 199, 173, 205, 173,
     205, 173, 205, 173, 205, 173, 205, 173,  205, 173, 205, 173, 205, 173, 205, 173,
     205, 173, 205, 173, 205, 179, 211, 179,  211, 179, 211, 179, 211, 179, 211, 179,
     211, 179, 211, 183, 215, 183, 215, 183,  215, 183, 215,  33, 157, 127, 157,  35,
     157, 253, 126, 157, 126,  27, 157, 101,  157,   2, 126,  11, 157,   3, 126,  13,
     157,   3, 126,  13, 157,   2, 126, 255,  190,  13, 157,   2, 126,  28, 157, 101,
     157, 250,  40,  41,  42, 157,  43,  44,    2, 157, 253,  45,  46,  47,   6, 157,
     253,  48,  49,  50,   8, 157, 253,  51,   52,  53,   9, 157, 255,  54,   2, 157,
     255,  55,   4, 157, 253,  56,  57,  58,   40, 157, 101, 157,  11, 126,   5, 157,
       2, 139, 255, 157,   2, 139,   2, 157,  255, 126,   4, 133,   4, 128,   2, 157,
     253, 136, 157, 140,  10, 157, 255, 126,   12, 157, 253, 127, 157, 126,  28, 157,
     104, 157, 255, 139,   4, 157, 255, 127,    9, 157, 255, 139,  12, 157, 255, 126,
      16, 157, 254, 142, 199,   2, 157, 244,  146, 147, 148, 149, 150, 151, 137, 139,
     155, 134, 135, 204,  27, 157, 101, 157,  236, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 137, 139, 155, 134, 135,  157, 191, 195, 205, 214,  71, 157, 103,
     157, 255, 161,   7, 157, 255, 197,   3,  166, 254, 198, 157,   2, 167, 252, 170,
     202, 157, 172,   3, 157, 254, 174, 175,    3, 176,   6, 157, 255, 184,   3, 157,
     243, 184, 157, 169, 159, 160, 161, 157,  195, 163, 164, 157, 171, 205,   4, 157,
     255, 199,  33, 157, 106, 157, 251, 162,  194, 195, 199, 200,  21, 157, 254, 143,
     167,   3, 157, 255, 180,   4, 157, 255,  182,   2, 157, 251, 170, 161, 162, 171,
     199,   3, 157, 255, 212,   4, 157, 255,  214,   2, 157, 252, 202, 193, 194, 203,
      27, 157, 119, 157, 255, 139,   2, 157,  255, 141,  69, 157, 127, 157,   6, 157,
     255, 155,  13, 157, 254, 154, 156,  43,  157, 114, 157, 255, 136,   8, 157, 253,
     139, 157, 141,   6, 157, 255, 139,  59,  157, 127, 157,   6, 157, 247, 143, 144,
     145, 146, 147, 148, 149, 150, 151,  11,  157, 247, 143, 144, 145, 146, 147, 148,
     149, 150, 151,  30, 157, 109, 157, 247,  143, 144, 145, 146, 147, 148, 149, 150,
     151,  11, 157, 220, 191, 192, 193, 194,  195, 196, 197, 198, 199, 200, 201, 202,
     203, 204, 205, 206, 207, 208, 209, 210,  211, 212, 213, 214, 215, 216, 159, 160,
     161, 162, 163, 164, 165, 166, 167, 168,   27, 157, 101, 157, 213, 169, 170, 171,
     172, 173, 174, 175, 176, 177, 178, 179,  180, 181, 182, 183, 184, 191, 192, 193,
     194, 195, 196, 197, 198, 199, 200, 201,  202, 203, 204, 205, 206, 207, 208, 209,
     210, 211, 212, 213, 214, 215, 216, 142,   10, 157, 245, 143, 144, 145, 146, 147,
     148, 149, 150, 151, 157, 142,  27, 157,  122, 157,   2, 136,  68, 157, 127, 157,
       8, 157,   2, 127,  18, 157, 247, 143,  144, 145, 146, 147, 148, 149, 150, 151,
      28, 157, 101, 157, 237, 143, 144, 145,  146, 147, 148, 149, 150, 151, 157, 143,
     144, 145, 146, 147, 148, 149, 150, 151,   72, 157, 127, 157,  22, 157,   2, 136,
       2, 157,   4, 136, 255, 141,   2, 157,  255, 136,  31, 157, 102, 157,   2, 136,
      88, 157, 112, 157, 255, 167,  47, 157,  255, 199,  31, 157, 127, 157,   6, 157,
     243, 170, 202, 170, 174, 176, 191, 210,  166, 198, 169, 201, 184, 216,   7, 157,
     255, 212,   7, 157, 254, 200, 180,  29,  157, 127, 157,   4, 157, 254, 173, 205,
      59, 157, 101, 157, 253,  60, 157,  61,    8, 157, 251,  62, 157,  63, 157,  64,
      75, 157, 101, 157, 253, 126, 138, 140,   88, 157, 127, 157, 255, 157,   2, 126,
      62, 157, 101, 157, 247, 143, 144, 145,  146, 147, 148, 149, 150, 151,  82, 157,
     125, 157, 246, 142, 143, 144, 145, 146,  147, 148, 149, 150, 151,  57, 157, 101,
     157, 254, 201, 171,  30, 157, 247, 143,  144, 145, 146, 147, 148, 149, 150, 151,
      50, 157, 127, 157,  18, 157, 255,  66,    4, 157, 255,  67,   6, 157, 254,  68,
      69,   2, 157, 252,  70,  71, 157,  72,   27, 157, 127, 157,  15, 157, 255, 137,
      49, 157, 127, 157,   4, 157,   6, 126,   55, 157, 117, 157, 255, 138,   2, 157,
     253, 152, 153, 127,  29, 157,   2, 189,  252, 134, 135, 217, 219,  34, 157, 108,
     157, 254, 185, 187,   4, 126,   3, 189,  243, 138, 157, 140, 157, 153, 152, 157,
     127, 157, 134, 135, 217, 219,   2, 157,  243, 129, 132, 136, 137, 139, 154, 156,
     155, 157, 186, 130, 131, 158,   4, 157,  241, 126, 157, 126, 157, 126, 157, 126,
     157, 126, 157, 126, 157, 126, 157, 126,   28, 157, 102, 157, 193, 127, 128, 129,
     130, 131, 132, 133, 134, 135, 136, 137,  138, 139, 140, 141, 142, 143, 144, 145,
     146, 147, 148, 149, 150, 151, 152, 153,  154, 155, 156, 157, 158, 159, 160, 161,
     162, 163, 164, 165, 166, 167, 168, 169,  170, 171, 172, 173, 174, 175, 176, 177,
     178, 179, 180, 181, 182, 183, 184, 185,  186, 187, 188, 189,  27, 157, 101, 157,
     225, 190, 191, 192, 193, 194, 195, 196,  197, 198, 199, 200, 201, 202, 203, 204,
     205, 206, 207, 208, 209, 210, 211, 212,  213, 214, 215, 216, 217, 218, 219, 220,
      60, 157, 127, 157,   9, 157, 255, 126,   55, 157, 117, 157, 255,  74,  12, 157,
     253,  77, 157,  91,  59, 157, 117, 157,  253,  75, 157,  19,  22, 157, 255,  76,
      49, 157, 117, 157, 255, 166,  39, 157,  255, 198,  34, 157, 101, 157, 252, 143,
     144, 145, 146,  87, 157, 114, 157, 255,   78,   2, 157, 245,  79,  80,  81,  82,
      83,  84,  85,  86,  87,  88,  89,   4,  157, 255,  90,  59, 157, 127, 157,   6,
     157, 238, 143, 144, 145, 146, 147, 148,  149, 150, 151, 143, 144, 145, 146, 147,
     148, 149, 150, 151,  41, 157, 101, 157,  192, 159, 160, 161, 162, 163, 164, 165,
     166, 167, 168, 169, 170, 171, 172, 173,  174, 175, 176, 177, 178, 179, 180, 181,
     182, 183, 184, 191, 192, 193, 194, 195,  196, 197, 198, 199, 200, 201, 202, 203,
     204, 205, 206, 207, 208, 209, 210, 211,  212, 213, 214, 215, 216, 159, 160, 161,
     162, 163, 164, 165, 166, 167, 168, 169,  170,  27, 157, 101, 157, 192, 171, 172,
     173, 174, 175, 176, 177, 178, 179, 180,  181, 182, 183, 184, 191, 192, 193, 194,
     195, 196, 197, 157, 199, 200, 201, 202,  203, 204, 205, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 159, 160,  161, 162, 163, 164, 165, 166, 167, 168,
     169, 170, 171, 172, 173, 174, 175, 176,  177, 178, 179, 180, 181, 182,  27, 157,
     101, 157, 224, 183, 184, 191, 192, 193,  194, 195, 196, 197, 198, 199, 200, 201,
     202, 203, 204, 205, 206, 207, 208, 209,  210, 211, 212, 213, 214, 215, 216, 159,
     157, 161, 162,   2, 157, 255, 165,   2,  157, 254, 168, 169,   2, 157, 233, 172,
     173, 174, 175, 157, 177, 178, 179, 180,  181, 182, 183, 184, 191, 192, 193, 194,
     157, 196, 157, 198, 199, 200,  27, 157,  101, 157, 192, 201, 202, 203, 204, 157,
     206, 207, 208, 209, 210, 211, 212, 213,  214, 215, 216, 159, 160, 161, 162, 163,
     164, 165, 166, 167, 168, 169, 170, 171,  172, 173, 174, 175, 176, 177, 178, 179,
     180, 181, 182, 183, 184, 191, 192, 193,  194, 195, 196, 197, 198, 199, 200, 201,
     202, 203, 204, 205, 206, 207, 208, 209,  210, 211, 212,  27, 157, 101, 157, 245,
     213, 214, 215, 216, 159, 160, 157, 162,  163, 164, 165,   2, 157, 206, 168, 169,
     170, 171, 172, 173, 174, 175, 157, 177,  178, 179, 180, 181, 182, 183, 157, 191,
     192, 193, 194, 195, 196, 197, 198, 199,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 159, 160, 157, 162, 163, 164, 165,
      28, 157, 101, 157, 249, 167, 168, 169,  170, 171, 157, 173,   3, 157, 202, 177,
     178, 179, 180, 181, 182, 183, 157, 191,  192, 193, 194, 195, 196, 197, 198, 199,
     200, 201, 202, 203, 204, 205, 206, 207,  208, 209, 210, 211, 212, 213, 214, 215,
     216, 159, 160, 161, 162, 163, 164, 165,  166, 167, 168, 169, 170, 171, 172, 173,
     174, 175, 176, 177, 178,  27, 157, 101,  157, 192, 179, 180, 181, 182, 183, 184,
     191, 192, 193, 194, 195, 196, 197, 198,  199, 200, 201, 202, 203, 204, 205, 206,
     207, 208, 209, 210, 211, 212, 213, 214,  215, 216, 159, 160, 161, 162, 163, 164,
     165, 166, 167, 168, 169, 170, 171, 172,  173, 174, 175, 176, 177, 178, 179, 180,
     181, 182, 183, 184, 191, 192, 193, 194,  195, 196,  27, 157, 101, 157, 192, 197,
     198, 199, 200, 201, 202, 203, 204, 205,  206, 207, 208, 209, 210, 211, 212, 213,
     214, 215, 216, 159, 160, 161, 162, 163,  164, 165, 166, 167, 168, 169, 170, 171,
     172, 173, 174, 175, 176, 177, 178, 179,  180, 181, 182, 183, 184, 191, 192, 193,
     194, 195, 196, 197, 198, 199, 200, 201,  202, 203, 204, 205, 206, 207, 208,  27,
     157, 101, 157, 192, 209, 210, 211, 212,  213, 214, 215, 216, 159, 160, 161, 162,
     163, 164, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174, 175, 176, 177, 178,
     179, 180, 181, 182, 183, 184, 191, 192,  193, 194, 195, 196, 197, 198, 199, 200,
     201, 202, 203, 204, 205, 206, 207, 208,  209, 210, 211, 212, 213, 214, 215, 216,
     159, 160, 161, 162,  27, 157, 101, 157,  192, 163, 164, 165, 166, 167, 168, 169,
     170, 171, 172, 173, 174, 175, 176, 177,  178, 179, 180, 181, 182, 183, 184, 191,
     192, 193, 194, 195, 196, 197, 198, 199,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 159, 160, 161, 162, 163, 164, 165,
     166, 167, 168, 169, 170, 171, 172, 173,  174,  27, 157, 101, 157, 220, 175, 176,
     177, 178, 179, 180, 181, 182, 183, 184,  191, 192, 193, 194, 195, 196, 197, 198,
     199, 200, 201, 202, 203, 204, 205, 206,  207, 208, 209, 210, 211, 212, 213, 214,
     215, 216,  55, 157, 115, 157, 206, 142,  143, 144, 145, 146, 147, 148, 149, 150,
     151, 142, 143, 144, 145, 146, 147, 148,  149, 150, 151, 142, 143, 144, 145, 146,
     147, 148, 149, 150, 151, 142, 143, 144,  145, 146, 147, 148, 149, 150, 151, 142,
     143, 144, 145, 146, 147, 148, 149, 150,  151,  27, 157, 105, 157, 254,  92,  93,
      85, 157, 127, 157,  17, 157, 254, 161,  176,   4, 157, 255, 160,  11, 157, 253,
     172, 157, 174,  27, 157, 103, 157, 255,  177,   3, 157, 255, 181,  84, 157
};

// utf/tr_utf8_cp437.txt
//
// 2480 code points.
// 103 states, 193 columns, 7632 bytes
//
const unsigned char tr_cp437_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   1,    2,   3,   4,   0,   0,   5,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   6,   0,   0,   0,   0,
       7,   8,   9,  10,  11,  12,  13,  14,   15,  16,  17,  18,  19,  20,  21,  22,
      23,  24,  25,  26,  27,  28,  29,  30,   31,  32,  33,  34,  35,  36,  37,   0,
      38,  39,  40,  41,  42,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100,   0,

     101, 102, 103, 104, 105, 106, 107, 108,  109, 110, 111, 112, 113, 114, 115, 116,
     117, 118, 119, 120, 121, 122, 123, 124,  125, 126, 127, 128, 129, 130, 131, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
       0,   0, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174,   0, 175, 176, 177,
     178, 179, 180, 181,   0, 182, 183,   0,    0, 184,   0, 185,   0,   0,   0, 186,
     187, 188, 189, 190,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0, 191,
     192,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_cp437_sot[103] =
{
        0,  133,  172,  237,  306,  377,  439,  503,   574,  628,  665,  680,  692,  727,  740,  784,
      804,  818,  847,  855,  861,  878,  895,  914,   945,  962,  977, 1018, 1033, 1049, 1068, 1085,
     1149, 1212, 1280, 1349, 1418, 1486, 1549, 1559,  1583, 1633, 1675, 1713, 1742, 1795, 1841, 1855,
     1879, 1900, 1916, 1927, 1955, 2008, 2070, 2114,  2148, 2191, 2201, 2211, 2234, 2240, 2260, 2284,
     2302, 2308, 2318, 2347, 2356, 2372, 2380, 2388,  2402, 2417, 2436, 2460, 2468, 2476, 2497, 2556,
     2624, 2660, 2668, 2680, 2692, 2702, 2711, 2735,  2760, 2829, 2898, 2970, 3039, 3108, 3177, 3246,
     3315, 3384, 3453, 3494, 3549, 3556, 3575
};

const unsigned short tr_cp437_sbt[3585] =
{
     155, 166, 110, 111, 112, 113, 116, 130,  135, 136, 137, 138, 139, 140, 141, 142,
     143, 144, 145, 146, 147, 148, 149, 150,  151, 152, 153, 154, 155, 156, 157, 158,
     159, 160, 161, 162, 163, 164, 165, 167,  168, 169, 170, 171, 172, 173, 174, 175,
     176, 177, 178, 179, 180, 181, 182, 183,  184, 185, 186, 187, 188, 189, 190, 191,
     192, 193, 194, 195, 196, 197, 198, 199,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220, 221, 222, 223,
     224, 225, 226, 227, 228, 229,  64, 166,  228,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,   16,  17,  18,  19,  20,  21,  22,  23,
      26,  40,  68,  74,  82, 127, 166,   6,  166, 224, 358, 276, 258, 259, 166, 260,
     166, 124, 135, 166, 269, 277, 273, 148,  166, 135, 351, 344, 356, 154, 135, 333,
     123, 353, 135, 152, 270, 278, 275, 274,  166, 271,  28, 166, 101, 166,   4, 168,
     250, 245, 246, 249, 231, 172, 247,   2,  172,   4, 176, 254, 171, 268,   4, 182,
     253, 256, 145, 182,   3, 188, 220, 257,  192, 166, 328, 236, 263, 234, 200, 235,
     237, 248, 238, 241, 233, 239, 240, 244,  264, 243, 242, 203, 267, 252, 265, 250,
     214, 251, 349, 214, 254, 266, 253, 232,  224, 166, 255,  28, 166, 101, 166, 207,
     168, 200, 168, 200, 168, 200, 170, 202,  170, 202, 170, 202, 170, 202, 171, 203,
     171, 203, 172, 204, 172, 204, 172, 204,  172, 204, 172, 204, 174, 206, 174, 206,
     174, 206, 174, 206, 175, 207, 175, 207,  176, 208, 176, 208, 176, 208, 176, 208,
     176,   3, 166, 244, 177, 209, 178, 210,  166, 179, 211, 179, 211, 179, 211, 179,
      28, 166, 101, 166, 248, 211, 179, 211,  181, 213, 181, 213, 181,   2, 213,   2,
     166, 250, 182, 214, 182, 214, 182, 214,    2, 166, 212, 185, 217, 185, 217, 185,
     217, 186, 218, 186, 218, 186, 218, 186,  218, 187, 219, 187, 219, 187, 219, 188,
     220, 188, 220, 188, 220, 188, 220, 188,  220, 188, 220, 190, 222, 192, 224, 192,
     193, 225, 193, 225, 193, 225, 218,  28,  166, 101, 166, 255, 201,   2, 169, 255,
     201,   3, 166, 253, 170, 202, 166,   2,  171, 255, 203,   4, 166, 253, 173, 262,
     174,   3, 166, 252, 176, 178, 210, 211,    2, 166, 254, 181, 213,   2, 182, 255,
     214,   2, 166, 254, 183, 215,   5, 166,  244, 219, 187, 219, 187, 188, 220, 166,
     189, 192, 224, 193, 225,  37, 166, 104,  166, 255, 136,   9, 166, 235, 168, 200,
     176, 208, 182, 214, 188, 220, 188, 220,  188, 220, 188, 220, 188, 220, 166, 168,
     200, 168, 200,   2, 166, 246, 174, 206,  174, 206, 178, 210, 182, 214, 182, 214,
       2, 166, 255, 209,   3, 166, 254, 174,  206,   2, 166, 252, 181, 213, 168, 200,
       2, 166, 254, 182, 214,  28, 166, 101,  166, 228, 168, 200, 168, 200, 172, 204,
     172, 204, 176, 208, 176, 208, 182, 214,  182, 214, 185, 217, 185, 217, 188, 220,
     188, 220, 186, 218, 187, 219,   2, 166,  252, 175, 207, 181, 203,   2, 166, 237,
     193, 225, 168, 200, 172, 204, 182, 214,  182, 214, 182, 214, 182, 214, 192, 224,
     211, 213, 219,   3, 166, 250, 168, 170,  202, 179, 187, 218,  28, 166, 101, 166,
     255, 225,   2, 166, 243, 169, 188, 166,  172, 204, 177, 209, 166, 216, 185, 217,
     192, 224,   3, 166, 253, 201, 166, 202,    2, 203,   8, 166, 255, 206,   5, 166,
     253, 207, 166, 208,   2, 166,   4, 211,    2, 166, 255, 212,   2, 213,   8, 166,
       3, 217,  29, 166, 103, 166, 255, 218,    5, 166, 252, 219, 220, 166, 221,   4,
     166,   2, 225,  11, 166, 255, 209,   2,  166, 255, 216,  15, 166, 252, 207, 166,
     209, 217,   3, 166, 254, 222, 224,  35,  166, 125, 166,   4, 135, 254, 229, 135,
       3, 166, 253, 211, 218, 223,  56, 166,  127, 166,  32, 166, 255, 135,   3, 166,
     255, 162,  29, 166, 105, 166,   2, 135,   13, 166, 255, 329,   4, 166, 255, 336,
      10, 166, 255, 331,   2, 166, 255, 335,    2, 166, 255, 337,   7, 166, 255, 327,
       2, 166, 254, 338, 341,  38, 166, 101,  166, 255, 330,   2, 166, 252, 332, 334,
     166, 340,  85, 166, 105, 166, 253, 172,  166, 176,   6, 166, 255, 176,   2, 166,
     255, 168,   7, 166, 255, 176,   5, 166,  255, 182,   4, 166, 255, 188,   9, 166,
     255, 172,   2, 166, 255, 200,   7, 166,  255, 208,   5, 166, 255, 214,  29, 166,
     104, 166, 255, 220,   9, 166, 255, 204,    6, 166, 253, 204, 166, 208,   6, 166,
     255, 208,  62, 166, 127, 166,  14, 166,  254, 182, 214,  16, 166, 254, 175, 207,
      32, 166, 117, 166, 252, 168, 200, 168,  200,  14, 166, 250, 176, 208, 176, 208,
     182, 214,   4, 166, 248, 172, 204, 188,  220, 188, 220, 188, 220,  40, 166, 127,
     166,   2, 166, 255, 136,  63, 166, 111,  166, 255, 148,  81, 166, 127, 166,   6,
     166, 246, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160,  50, 166, 127, 166,
      22, 166, 246, 151, 152, 153, 154, 155,  156, 157, 158, 159, 160,  34, 166, 101,
     166, 246, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160,  47, 166, 255, 136,
      34, 166, 127, 166,  11, 166, 239,  24,  166,  24, 166,  24, 166,  24, 166,  24,
     166,  24, 166,  24, 166,  24, 166,  24,    3, 166, 252,  25, 166,  25,  20,  31,
     166, 127, 166,  12, 166, 246, 151, 152,  153, 154, 155, 156, 157, 158, 159, 160,
      44, 166, 117, 166, 246, 151, 152, 153,  154, 155, 156, 157, 158, 159, 160,  66,
     166, 102, 166, 255,  27,  11, 166, 255,   28,  17, 166, 254,  20,  29,   4, 166,
     253,  30, 166,  25,   5, 166, 255,  25,    6, 166, 248,  31,  32,  33, 166,  34,
      35,  36,  37,   2, 166, 254,  38,  39,   28, 166, 101, 166, 246, 151, 152, 153,
     154, 155, 156, 157, 158, 159, 160,  82,  166, 127, 166,  15, 166, 247, 152, 153,
     154, 155, 156, 157, 158, 159, 160,  42,  166, 107, 166, 255, 148,   9, 166, 246,
     151, 152, 153, 154, 155, 156, 157, 158,  159, 160,  66, 166, 105, 166, 244, 136,
     166, 151, 152, 153, 154, 155, 156, 157,  158, 159, 160,  76, 166, 101, 166, 255,
     168,   2, 166, 252, 169, 170, 171, 203,    2, 172, 250, 176, 177, 178, 179, 180,
     181,   5, 182,   2, 166,   2, 182, 255,  183,   2, 185, 255, 187,   3, 188, 252,
     180, 189, 190, 193,   9, 166, 236, 168,  166, 169, 166, 171, 172, 166, 174, 175,
     176, 177, 178, 179, 180, 181, 166, 182,  166, 183, 185,  28, 166, 101, 166, 252,
     187, 188, 190, 200,   3, 166, 253, 201,  203, 204,   3, 166, 250, 206, 166, 210,
     212, 166, 214,   3, 166, 253, 215, 219,  220,   2, 166, 255, 221,   6, 166, 252,
     208, 217, 220, 221,   6, 166, 250, 201,  203, 205, 212, 213, 215,   2, 217, 253,
     218, 219, 225,   4, 166, 252, 176, 166,  215, 188,  29, 166, 101, 166, 237, 201,
     203, 205, 206, 210, 211, 212, 213, 215,  217, 218, 166, 221, 223, 225, 200, 166,
     203, 204,   3, 166, 255, 208,   2, 166,  255, 220,   2, 166,   2, 202, 248, 203,
     204, 205, 209, 206, 207, 208, 166,   2,  208, 255, 209,   3, 211,   2, 212,   3,
     213, 248, 214, 166, 218, 166, 219, 220,  166, 220,   2, 221,   3, 225,  30, 166,
     101, 166, 192, 168, 200, 169, 201, 169,  201, 169, 201, 170, 202, 171, 203, 171,
     203, 171, 203, 171, 203, 171, 203, 172,  204, 172, 204, 172, 204, 172, 204, 172,
     204, 173, 205, 174, 206, 175, 207, 175,  207, 175, 207, 175, 207, 175, 207, 176,
     208, 176, 208, 178, 210, 178, 210, 178,  210, 179, 211, 179, 211, 179, 211, 179,
     211, 180, 212,  28, 166, 101, 166, 192,  180, 212, 180, 212, 181, 213, 181, 213,
     181, 213, 181, 213, 182, 214, 182, 214,  182, 214, 182, 214, 183, 215, 183, 215,
     185, 217, 185, 217, 185, 217, 185, 217,  186, 218, 186, 218, 186, 218, 186, 218,
     186, 218, 187, 219, 187, 219, 187, 219,  187, 219, 188, 220, 188, 220, 188, 220,
     188, 220, 188, 220, 189, 221, 189, 221,   28, 166, 101, 166, 228, 190, 222, 190,
     222, 190, 222, 190, 222, 190, 222, 191,  223, 191, 223, 192, 224, 193, 225, 193,
     225, 193, 225, 207, 219, 222, 224, 200,  218,   4, 166, 224, 168, 200, 168, 200,
     168, 200, 168, 200, 168, 200, 168, 200,  168, 200, 168, 200, 168, 200, 168, 200,
     168, 200, 168, 200, 172, 204, 172, 204,  172, 204, 172, 204,  28, 166, 101, 166,
     198, 172, 204, 172, 204, 172, 204, 172,  204, 176, 208, 176, 208, 182, 214, 182,
     214, 182, 214, 182, 214, 182, 214, 182,  214, 182, 214, 182, 214, 182, 214, 182,
     214, 182, 214, 182, 214, 188, 220, 188,  220, 188, 220, 188, 220, 188, 220, 188,
     220, 188, 220, 192, 224, 192, 224, 192,  224, 192, 224,  34, 166, 127, 166,  35,
     166, 253, 135, 166, 135,  28, 166, 101,  166,   2, 135,  11, 166,   3, 135,  13,
     166,   3, 135,  13, 166,   2, 135, 255,  199,  13, 166,   2, 135,  29, 166, 101,
     166, 243,  41,  42,  43, 166,  44,  45,   46, 166,  47,  48,  49, 166,  50,   4,
     166, 247,  51,  52,  53,  54,  55,  56,   57,  58,  59,   2, 166, 253,  60,  61,
      62,   9, 166, 255,  63,   2, 166, 255,   64,   4, 166, 253,  65,  66,  67,  41,
     166, 101, 166,   7, 135, 255, 103,   3,  135,   5, 166,   2, 148, 255, 166,   2,
     148,   2, 166, 255, 135,   4, 142,   4,  137,   2, 166, 253, 110, 166, 149,  10,
     166, 255, 135,  12, 166, 253, 122, 166,  135,  29, 166, 104, 166, 255, 148,   4,
     166, 255, 136,   9, 166, 255, 148,  12,  166, 255, 135,  16, 166, 254, 151, 208,
       2, 166, 244, 155, 156, 157, 158, 159,  160, 146, 148, 164, 143, 144, 355,  28,
     166, 101, 166, 236, 151, 152, 153, 154,  155, 156, 157, 158, 159, 160, 146, 148,
     164, 143, 144, 166, 200, 204, 214, 223,   19, 166, 255, 261,  52, 166, 103, 166,
     255, 170,   7, 166, 255, 206,   3, 175,  254, 207, 166,   2, 176, 252, 179, 211,
     166, 181,   3, 166, 254, 183, 184,   3,  185,   6, 166, 255, 193,   3, 166, 243,
     193, 166, 178, 168, 169, 170, 166, 204,  172, 173, 166, 180, 214,   4, 166, 255,
     208,  34, 166, 106, 166, 251, 171, 203,  204, 208, 209,  21, 166, 254, 152, 176,
       3, 166, 255, 189,   4, 166, 255, 191,    2, 166, 251, 179, 170, 171, 180, 208,
       3, 166, 255, 221,   4, 166, 255, 223,    2, 166, 252, 211, 202, 203, 212,  28,
     166, 118, 166, 251, 127, 129, 128, 132,  121,  18, 166, 255, 126,  51, 166, 119,
     166, 255, 148,   2, 166, 255, 150,   3,  166, 254, 352, 354,   3, 166, 254, 339,
     131,   9, 166, 255, 342,  50, 166, 109,  166, 255, 350,  23, 166, 254, 164, 343,
       2, 166, 254, 346, 345,   8, 166, 254,  163, 165,  44, 166, 114, 166, 255, 145,
       8, 166, 253, 148, 166, 150,   6, 166,  255, 148,  60, 166, 117, 166, 255, 272,
      15, 166, 254, 347, 348,  58, 166, 127,  166,   6, 166, 247, 152, 153, 154, 155,
     156, 157, 158, 159, 160,  11, 166, 247,  152, 153, 154, 155, 156, 157, 158, 159,
     160,  31, 166, 109, 166, 247, 152, 153,  154, 155, 156, 157, 158, 159, 160,  11,
     166, 220, 200, 201, 202, 203, 204, 205,  206, 207, 208, 209, 210, 211, 212, 213,
     214, 215, 216, 217, 218, 219, 220, 221,  222, 223, 224, 225, 168, 169, 170, 171,
     172, 173, 174, 175, 176, 177,  28, 166,  101, 166, 213, 178, 179, 180, 181, 182,
     183, 184, 185, 186, 187, 188, 189, 190,  191, 192, 193, 200, 201, 202, 203, 204,
     205, 206, 207, 208, 209, 210, 211, 212,  213, 214, 215, 216, 217, 218, 219, 220,
     221, 222, 223, 224, 225, 151,  10, 166,  245, 152, 153, 154, 155, 156, 157, 158,
     159, 160, 166, 151,  28, 166, 101, 166,  253, 299, 166, 282,   9, 166, 255, 321,
       3, 166, 255, 294,   3, 166, 255, 295,    3, 166, 255, 320,   3, 166, 255, 298,
       7, 166, 255, 283,   7, 166, 255, 297,    7, 166, 255, 296,   7, 166, 255, 300,
      31, 166, 117, 166, 227, 308, 289, 316,  317, 304, 287, 286, 290, 315, 314, 303,
     293, 292, 291, 301, 302, 307, 284, 285,  288, 312, 313, 306, 310, 311, 305, 319,
     318, 309,  47, 166, 101, 166, 255, 326,    3, 166, 255, 323,   3, 166, 255, 322,
       3, 166, 255, 324,   3, 166, 252, 325,  279, 280, 281,  12, 166, 255, 357,  11,
     166, 255, 125,   5, 166, 255, 133,   7,  166, 253, 119, 166, 134,  31, 166, 105,
     166, 255, 120,   6, 166, 255, 112,  80,  166, 127, 166,  32, 166, 253, 104, 105,
     118,  31, 166, 101, 166, 253, 115, 166,  114,  29, 166, 255, 109,   2, 166, 252,
     108, 166, 106, 107,   4, 166, 255, 117,   48, 166, 122, 166,   2, 145,  69, 166,
     127, 166,   8, 166,   2, 136,  18, 166,  247, 152, 153, 154, 155, 156, 157, 158,
     159, 160,  29, 166, 101, 166, 237, 152,  153, 154, 155, 156, 157, 158, 159, 160,
     166, 152, 153, 154, 155, 156, 157, 158,  159, 160,  73, 166, 127, 166,  22, 166,
       2, 145,   2, 166,   4, 145, 255, 150,    2, 166, 255, 145,  32, 166, 102, 166,
       2, 145,  89, 166, 112, 166, 255, 176,   47, 166, 255, 208,  32, 166, 127, 166,
       6, 166, 243, 179, 211, 179, 183, 185,  200, 219, 175, 207, 178, 210, 193, 225,
       7, 166, 255, 221,   7, 166, 254, 209,  189,  30, 166, 127, 166,   4, 166, 254,
     182, 214,  60, 166, 101, 166, 253,  69,  166,  70,   8, 166, 251,  71, 166,  72,
     166,  73,  76, 166, 101, 166, 253, 135,  147, 149,  89, 166, 127, 166, 255, 166,
       2, 135,  63, 166, 101, 166, 247, 152,  153, 154, 155, 156, 157, 158, 159, 160,
      83, 166, 125, 166, 246, 151, 152, 153,  154, 155, 156, 157, 158, 159, 160,  58,
     166, 101, 166, 254, 210, 180,  30, 166,  247, 152, 153, 154, 155, 156, 157, 158,
     159, 160,  51, 166, 127, 166,  18, 166,  255,  75,   4, 166, 255,  76,   6, 166,
     254,  77,  78,   2, 166, 252,  79,  80,  166,  81,  28, 166, 127, 166,  15, 166,
     255, 146,  50, 166, 127, 166,   4, 166,    6, 135,  56, 166, 117, 166, 255, 147,
       2, 166, 253, 161, 162, 136,  29, 166,    2, 198, 252, 143, 144, 226, 228,  35,
     166, 108, 166, 254, 194, 196,   4, 135,    3, 198, 243, 147, 166, 149, 166, 162,
     161, 166, 136, 166, 143, 144, 226, 228,    2, 166, 243, 138, 141, 145, 146, 148,
     163, 165, 164, 166, 195, 139, 140, 167,    4, 166, 241, 135, 166, 135, 166, 135,
     166, 135, 166, 135, 166, 135, 166, 135,  166, 135,  29, 166, 102, 166, 193, 136,
     137, 138, 139, 140, 141, 142, 143, 144,  145, 146, 147, 148, 149, 150, 151, 152,
     153, 154, 155, 156, 157, 158, 159, 160,  161, 162, 163, 164, 165, 166, 167, 168,
     169, 170, 171, 172, 173, 174, 175, 176,  177, 178, 179, 180, 181, 182, 183, 184,
     185, 186, 187, 188, 189, 190, 191, 192,  193, 194, 195, 196, 197, 198,  28, 166,
     101, 166, 225, 199, 200, 201, 202, 203,  204, 205, 206, 207, 208, 209, 210, 211,
     212, 213, 214, 215, 216, 217, 218, 219,  220, 221, 222, 223, 224, 225, 226, 227,
     228, 229,  61, 166, 127, 166,   9, 166,  255, 135,  56, 166, 117, 166, 255,  83,
      12, 166, 253,  86, 166, 100,  60, 166,  117, 166, 253,  84, 166,  20,  22, 166,
     255,  85,  50, 166, 117, 166, 255, 175,   39, 166, 255, 207,  35, 166, 101, 166,
     252, 152, 153, 154, 155,  88, 166, 114,  166, 255,  87,   2, 166, 245,  88,  89,
      90,  91,  92,  93,  94,  95,  96,  97,   98,   4, 166, 255,  99,  60, 166, 127,
     166,   6, 166, 238, 152, 153, 154, 155,  156, 157, 158, 159, 160, 152, 153, 154,
     155, 156, 157, 158, 159, 160,  42, 166,  101, 166, 192, 168, 169, 170, 171, 172,
     173, 174, 175, 176, 177, 178, 179, 180,  181, 182, 183, 184, 185, 186, 187, 188,
     189, 190, 191, 192, 193, 200, 201, 202,  203, 204, 205, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 217, 218,  219, 220, 221, 222, 223, 224, 225, 168,
     169, 170, 171, 172, 173, 174, 175, 176,  177, 178, 179,  28, 166, 101, 166, 192,
     180, 181, 182, 183, 184, 185, 186, 187,  188, 189, 190, 191, 192, 193, 200, 201,
     202, 203, 204, 205, 206, 166, 208, 209,  210, 211, 212, 213, 214, 215, 216, 217,
     218, 219, 220, 221, 222, 223, 224, 225,  168, 169, 170, 171, 172, 173, 174, 175,
     176, 177, 178, 179, 180, 181, 182, 183,  184, 185, 186, 187, 188, 189, 190, 191,
      28, 166, 101, 166, 224, 192, 193, 200,  201, 202, 203, 204, 205, 206, 207, 208,
     209, 210, 211, 212, 213, 214, 215, 216,  217, 218, 219, 220, 221, 222, 223, 224,
     225, 168, 166, 170, 171,   2, 166, 255,  174,   2, 166, 254, 177, 178,   2, 166,
     233, 181, 182, 183, 184, 166, 186, 187,  188, 189, 190, 191, 192, 193, 200, 201,
     202, 203, 166, 205, 166, 207, 208, 209,   28, 166, 101, 166, 192, 210, 211, 212,
     213, 166, 215, 216, 217, 218, 219, 220,  221, 222, 223, 224, 225, 168, 169, 170,
     171, 172, 173, 174, 175, 176, 177, 178,  179, 180, 181, 182, 183, 184, 185, 186,
     187, 188, 189, 190, 191, 192, 193, 200,  201, 202, 203, 204, 205, 206, 207, 208,
     209, 210, 211, 212, 213, 214, 215, 216,  217, 218, 219, 220, 221,  28, 166, 101,
     166, 245, 222, 223, 224, 225, 168, 169,  166, 171, 172, 173, 174,   2, 166, 206,
     177, 178, 179, 180, 181, 182, 183, 184,  166, 186, 187, 188, 189, 190, 191, 192,
     166, 200, 201, 202, 203, 204, 205, 206,  207, 208, 209, 210, 211, 212, 213, 214,
     215, 216, 217, 218, 219, 220, 221, 222,  223, 224, 225, 168, 169, 166, 171, 172,
     173, 174,  29, 166, 101, 166, 249, 176,  177, 178, 179, 180, 166, 182,   3, 166,
     202, 186, 187, 188, 189, 190, 191, 192,  166, 200, 201, 202, 203, 204, 205, 206,
     207, 208, 209, 210, 211, 212, 213, 214,  215, 216, 217, 218, 219, 220, 221, 222,
     223, 224, 225, 168, 169, 170, 171, 172,  173, 174, 175, 176, 177, 178, 179, 180,
     181, 182, 183, 184, 185, 186, 187,  28,  166, 101, 166, 192, 188, 189, 190, 191,
     192, 193, 200, 201, 202, 203, 204, 205,  206, 207, 208, 209, 210, 211, 212, 213,
     214, 215, 216, 217, 218, 219, 220, 221,  222, 223, 224, 225, 168, 169, 170, 171,
     172, 173, 174, 175, 176, 177, 178, 179,  180, 181, 182, 183, 184, 185, 186, 187,
     188, 189, 190, 191, 192, 193, 200, 201,  202, 203, 204, 205,  28, 166, 101, 166,
     192, 206, 207, 208, 209, 210, 211, 212,  213, 214, 215, 216, 217, 218, 219, 220,
     221, 222, 223, 224, 225, 168, 169, 170,  171, 172, 173, 174, 175, 176, 177, 178,
     179, 180, 181, 182, 183, 184, 185, 186,  187, 188, 189, 190, 191, 192, 193, 200,
     201, 202, 203, 204, 205, 206, 207, 208,  209, 210, 211, 212, 213, 214, 215, 216,
     217,  28, 166, 101, 166, 192, 218, 219,  220, 221, 222, 223, 224, 225, 168, 169,
     170, 171, 172, 173, 174, 175, 176, 177,  178, 179, 180, 181, 182, 183, 184, 185,
     186, 187, 188, 189, 190, 191, 192, 193,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220, 221, 222, 223,
     224, 225, 168, 169, 170, 171,  28, 166,  101, 166, 192, 172, 173, 174, 175, 176,
     177, 178, 179, 180, 181, 182, 183, 184,  185, 186, 187, 188, 189, 190, 191, 192,
     193, 200, 201, 202, 203, 204, 205, 206,  207, 208, 209, 210, 211, 212, 213, 214,
     215, 216, 217, 218, 219, 220, 221, 222,  223, 224, 225, 168, 169, 170, 171, 172,
     173, 174, 175, 176, 177, 178, 179, 180,  181, 182, 183,  28, 166, 101, 166, 220,
     184, 185, 186, 187, 188, 189, 190, 191,  192, 193, 200, 201, 202, 203, 204, 205,
     206, 207, 208, 209, 210, 211, 212, 213,  214, 215, 216, 217, 218, 219, 220, 221,
     222, 223, 224, 225,  56, 166, 115, 166,  206, 151, 152, 153, 154, 155, 156, 157,
     158, 159, 160, 151, 152, 153, 154, 155,  156, 157, 158, 159, 160, 151, 152, 153,
     154, 155, 156, 157, 158, 159, 160, 151,  152, 153, 154, 155, 156, 157, 158, 159,
     160, 151, 152, 153, 154, 155, 156, 157,  158, 159, 160,  28, 166, 105, 166, 254,
     101, 102,  86, 166, 127, 166,  17, 166,  254, 170, 185,   4, 166, 255, 169,  11,
     166, 253, 181, 166, 183,  28, 166, 103,  166, 255, 186,   3, 166, 255, 190,  85,
     166
};

// utf/tr_utf8_latin1.txt
//
// 2404 code points.
// 96 states, 192 columns, 7146 bytes
//
const unsigned char tr_latin1_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   1,    2,   3,   4,   0,   0,   5,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   6,   0,   0,   0,   0,
       7,   8,   9,  10,  11,  12,  13,  14,   15,  16,  17,  18,  19,  20,  21,  22,
      23,  24,  25,  26,  27,  28,  29,  30,   31,  32,  33,  34,  35,  36,  37,   0,
      38,  39,  40,  41,  42,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100,   0,

     101, 102, 103, 104, 105, 106, 107, 108,  109, 110, 111, 112, 113, 114, 115, 116,
     117, 118, 119, 120, 121, 122, 123, 124,  125, 126, 127, 128, 129, 130, 131, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
       0,   0, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174,   0, 175, 176,   0,
     177, 178, 179, 180,   0, 181, 182,   0,    0, 183,   0, 184,   0,   0,   0, 185,
     186, 187, 188, 189,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0, 190,
     191,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_latin1_sot[96] =
{
        0,  132,  171,  240,  309,  380,  442,  504,   575,  629,  666,  681,  693,  699,  743,  763,
      777,  806,  814,  820,  837,  854,  873,  904,   921,  936,  977,  992, 1008, 1027, 1044, 1108,
     1171, 1239, 1308, 1377, 1445, 1508, 1518, 1542,  1587, 1625, 1663, 1688, 1741, 1787, 1797, 1810,
     1826, 1836, 1864, 1917, 1979, 1985, 2005, 2029,  2047, 2057, 2067, 2096, 2105, 2121, 2129, 2137,
     2151, 2166, 2185, 2209, 2217, 2225, 2246, 2305,  2373, 2409, 2422, 2434, 2446, 2460, 2466, 2475,
     2499, 2524, 2593, 2662, 2734, 2803, 2872, 2941,  3010, 3079, 3148, 3217, 3258, 3313, 3320, 3339

};

const unsigned short tr_latin1_sbt[3349] =
{
     155, 159, 103, 104, 105, 106, 109, 123,  128, 129, 130, 131, 132, 133, 134, 135,
     136, 137, 138, 139, 140, 141, 142, 143,  144, 145, 146, 147, 148, 149, 150, 151,
     152, 153, 154, 155, 156, 157, 158, 160,  161, 162, 163, 164, 165, 166, 167, 168,
     169, 170, 171, 172, 173, 174, 175, 176,  177, 178, 179, 180, 181, 182, 183, 184,
     185, 186, 187, 188, 189, 190, 191, 192,  193, 194, 195, 196, 197, 198, 199, 200,
     201, 202, 203, 204, 205, 206, 207, 208,  209, 210, 211, 212, 213, 214, 215, 216,
     217, 218, 219, 220, 221, 222,  64, 159,  229,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,   16,  17,  18,  19,  20,  21,  22,  25,
      39,  60,  66,  74, 127, 159,   6, 159,  224, 256, 257, 258, 259, 260, 261, 262,
     263, 264, 265, 266, 267, 268, 269, 270,  271, 272, 273, 274, 275, 276, 277, 278,
     279, 280, 281, 282, 283, 284, 285, 286,  287,  27, 159, 101, 159, 192, 288, 289,
     290, 291, 292, 293, 294, 295, 296, 297,  298, 299, 300, 301, 302, 303, 304, 305,
     306, 307, 308, 309, 310, 311, 312, 313,  314, 315, 316, 317, 318, 319, 320, 321,
     322, 323, 324, 325, 326, 327, 328, 329,  330, 331, 332, 333, 334, 335, 336, 337,
     338, 339, 340, 341, 342, 343, 344, 345,  346, 347, 348, 349, 350, 351,  27, 159,
     101, 159, 207, 161, 193, 161, 193, 161,  193, 163, 195, 163, 195, 163, 195, 163,
     195, 164, 196, 164, 196, 165, 197, 165,  197, 165, 197, 165, 197, 165, 197, 167,
     199, 167, 199, 167, 199, 167, 199, 168,  200, 168, 200, 169, 201, 169, 201, 169,
     201, 169, 201, 169,   3, 159, 244, 170,  202, 171, 203, 159, 172, 204, 172, 204,
     172, 204, 172,  27, 159, 101, 159, 248,  204, 172, 204, 174, 206, 174, 206, 174,
       2, 206,   2, 159, 250, 175, 207, 175,  207, 175, 207,   2, 159, 212, 178, 210,
     178, 210, 178, 210, 179, 211, 179, 211,  179, 211, 179, 211, 180, 212, 180, 212,
     180, 212, 181, 213, 181, 213, 181, 213,  181, 213, 181, 213, 181, 213, 183, 215,
     185, 217, 351, 186, 218, 186, 218, 186,  218, 211,  27, 159, 101, 159, 255, 194,
       2, 162, 255, 194,   3, 159, 253, 163,  195, 159,   2, 164, 255, 196,   4, 159,
     253, 166, 198, 167,   3, 159, 252, 169,  171, 203, 204,   2, 159, 254, 174, 206,
       2, 175, 255, 207,   2, 159, 254, 176,  208,   5, 159, 244, 212, 180, 212, 180,
     181, 213, 159, 182, 185, 217, 186, 218,   36, 159, 104, 159, 255, 129,   9, 159,
     223, 161, 193, 169, 201, 175, 207, 181,  213, 181, 213, 181, 213, 181, 213, 181,
     213, 159, 161, 193, 161, 193, 159, 326,  167, 199, 167, 199, 171, 203, 175, 207,
     175, 207,   2, 159, 255, 202,   3, 159,  254, 167, 199,   2, 159, 248, 174, 206,
     161, 193, 159, 326, 312, 344,  27, 159,  101, 159, 228, 161, 193, 161, 193, 165,
     197, 165, 197, 169, 201, 169, 201, 175,  207, 175, 207, 178, 210, 178, 210, 181,
     213, 181, 213, 179, 211, 180, 212,   2,  159, 252, 168, 200, 174, 196,   2, 159,
     237, 186, 218, 161, 193, 165, 197, 175,  207, 175, 207, 175, 207, 175, 207, 185,
     217, 204, 206, 212,   3, 159, 250, 161,  163, 195, 172, 180, 211,  27, 159, 101,
     159, 255, 218,   2, 159, 243, 162, 181,  159, 165, 197, 170, 202, 159, 209, 178,
     210, 185, 217,   3, 159, 253, 194, 159,  195,   2, 196,   8, 159, 255, 199,   5,
     159, 253, 200, 159, 201,   2, 159,   4,  204,   2, 159, 255, 205,   2, 206,   8,
     159,   3, 210,  28, 159, 103, 159, 255,  211,   5, 159, 252, 212, 213, 159, 214,
       4, 159,   2, 218,  11, 159, 255, 202,    2, 159, 255, 209,  15, 159, 252, 200,
     159, 202, 210,   3, 159, 254, 215, 217,   34, 159, 125, 159,   4, 128, 254, 222,
     128,   3, 159, 253, 204, 211, 216,  55,  159, 127, 159,  32, 159, 255, 128,   3,
     159, 255, 155,  28, 159, 105, 159,   2,  128,  85, 159, 105, 159, 253, 165, 159,
     169,   6, 159, 255, 169,   2, 159, 255,  161,   7, 159, 255, 169,   5, 159, 255,
     175,   4, 159, 255, 181,   9, 159, 255,  165,   2, 159, 255, 193,   7, 159, 255,
     201,   5, 159, 255, 207,  28, 159, 104,  159, 255, 213,   9, 159, 255, 197,   6,
     159, 253, 197, 159, 201,   6, 159, 255,  201,  61, 159, 127, 159,  14, 159, 254,
     175, 207,  16, 159, 254, 168, 200,  31,  159, 117, 159, 252, 161, 193, 161, 193,
      14, 159, 250, 169, 201, 169, 201, 175,  207,   4, 159, 248, 165, 197, 181, 213,
     181, 213, 181, 213,  39, 159, 127, 159,    2, 159, 255, 129,  62, 159, 111, 159,
     255, 141,  80, 159, 127, 159,   6, 159,  246, 144, 145, 146, 147, 148, 149, 150,
     151, 152, 153,  49, 159, 127, 159,  22,  159, 246, 144, 145, 146, 147, 148, 149,
     150, 151, 152, 153,  33, 159, 101, 159,  246, 144, 145, 146, 147, 148, 149, 150,
     151, 152, 153,  47, 159, 255, 129,  33,  159, 127, 159,  11, 159, 239,  23, 159,
      23, 159,  23, 159,  23, 159,  23, 159,   23, 159,  23, 159,  23, 159,  23,   3,
     159, 252,  24, 159,  24,  19,  30, 159,  127, 159,  12, 159, 246, 144, 145, 146,
     147, 148, 149, 150, 151, 152, 153,  43,  159, 117, 159, 246, 144, 145, 146, 147,
     148, 149, 150, 151, 152, 153,  65, 159,  102, 159, 255,  26,  11, 159, 255,  27,
      17, 159, 254,  19,  28,   4, 159, 253,   29, 159,  24,   5, 159, 255,  24,   6,
     159, 248,  30,  31,  32, 159,  33,  34,   35,  36,   2, 159, 254,  37,  38,  27,
     159, 101, 159, 246, 144, 145, 146, 147,  148, 149, 150, 151, 152, 153,  81, 159,
     127, 159,  15, 159, 247, 145, 146, 147,  148, 149, 150, 151, 152, 153,  41, 159,
     107, 159, 255, 269,   9, 159, 246, 144,  145, 146, 147, 148, 149, 150, 151, 152,
     153,  65, 159, 105, 159, 244, 129, 159,  144, 145, 146, 147, 148, 149, 150, 151,
     152, 153,  75, 159, 101, 159, 255, 161,    2, 159, 252, 162, 163, 164, 196,   2,
     165, 250, 169, 170, 171, 172, 173, 174,    5, 175,   2, 159,   2, 175, 255, 176,
       2, 178, 255, 180,   3, 181, 252, 173,  182, 183, 186,   9, 159, 236, 161, 159,
     162, 159, 164, 165, 159, 167, 168, 169,  170, 171, 172, 173, 174, 159, 175, 159,
     176, 178,  27, 159, 101, 159, 252, 180,  181, 183, 193,   3, 159, 253, 194, 196,
     197,   3, 159, 250, 199, 159, 203, 205,  159, 207,   3, 159, 253, 208, 212, 213,
       2, 159, 255, 214,   6, 159, 252, 201,  210, 213, 214,   6, 159, 250, 194, 196,
     198, 205, 206, 208,   2, 210, 253, 211,  212, 218,   4, 159, 252, 169, 159, 208,
     181,  28, 159, 101, 159, 237, 194, 196,  198, 199, 203, 204, 205, 206, 208, 210,
     211, 159, 214, 216, 218, 193, 159, 196,  197,   3, 159, 255, 201,   2, 159, 255,
     213,   2, 159,   2, 195, 248, 336, 197,  198, 202, 199, 200, 201, 159,   2, 201,
     255, 202,   3, 204,   2, 205,   3, 206,  248, 207, 159, 211, 159, 212, 213, 159,
     213,   2, 214,   3, 218,  29, 159, 101,  159, 192, 161, 193, 162, 194, 162, 194,
     162, 194, 163, 195, 164, 196, 164, 196,  164, 196, 164, 196, 164, 196, 165, 197,
     165, 197, 165, 197, 165, 197, 165, 197,  166, 198, 167, 199, 168, 200, 168, 200,
     168, 200, 168, 200, 168, 200, 169, 201,  169, 201, 171, 203, 171, 203, 171, 203,
     172, 204, 172, 204, 172, 204, 172, 204,  173, 205,  27, 159, 101, 159, 192, 173,
     205, 173, 205, 174, 206, 174, 206, 174,  206, 174, 206, 175, 207, 175, 207, 175,
     207, 175, 207, 176, 208, 176, 208, 178,  210, 178, 210, 178, 210, 178, 210, 179,
     211, 179, 211, 179, 211, 179, 211, 179,  211, 180, 212, 180, 212, 180, 212, 180,
     212, 181, 213, 181, 213, 181, 213, 181,  213, 181, 213, 182, 214, 182, 214,  27,
     159, 101, 159, 228, 183, 215, 183, 215,  183, 215, 183, 215, 183, 215, 184, 216,
     184, 216, 185, 217, 186, 218, 186, 218,  186, 218, 200, 212, 215, 217, 193, 211,
       4, 159, 224, 161, 193, 161, 193, 161,  193, 161, 193, 161, 193, 161, 193, 161,
     193, 161, 193, 161, 193, 161, 193, 161,  193, 161, 193, 165, 197, 165, 197, 165,
     197, 165, 197,  27, 159, 101, 159, 198,  165, 197, 165, 197, 165, 197, 165, 197,
     169, 201, 169, 201, 175, 207, 175, 207,  175, 207, 175, 207, 175, 207, 175, 207,
     175, 207, 175, 207, 175, 207, 175, 207,  175, 207, 175, 207, 181, 213, 181, 213,
     181, 213, 181, 213, 181, 213, 181, 213,  181, 213, 185, 217, 185, 217, 185, 217,
     185, 217,  33, 159, 127, 159,  35, 159,  253, 128, 159, 128,  27, 159, 101, 159,
       2, 128,  11, 159,   3, 128,  13, 159,    3, 128,  13, 159,   2, 128, 255, 192,
      13, 159,   2, 128,  28, 159, 101, 159,  250,  40,  41,  42, 159,  43,  44,   2,
     159, 251,  45,  46,  47, 159,  48,   4,  159, 253,  49,  50,  51,   8, 159, 253,
      52,  53,  54,   9, 159, 255,  55,   2,  159, 255,  56,   4, 159, 253,  57,  58,
      59,  40, 159, 101, 159,  11, 128,   5,  159,   2, 141, 255, 159,   2, 141,   2,
     159, 255, 128,   4, 135,   4, 130,   2,  159, 253, 138, 159, 142,  10, 159, 255,
     128,  12, 159, 253, 129, 159, 128,  28,  159, 104, 159, 255, 141,   4, 159, 255,
     129,   9, 159, 255, 141,  12, 159, 255,  128,  16, 159, 254, 144, 201,   2, 159,
     244, 148, 149, 150, 151, 152, 153, 139,  269, 157, 136, 137, 206,  27, 159, 101,
     159, 236, 144, 145, 146, 147, 148, 149,  150, 151, 152, 153, 139, 269, 157, 136,
     137, 159, 193, 197, 207, 216,  71, 159,  103, 159, 255, 163,   7, 159, 255, 199,
       3, 168, 254, 200, 159,   2, 169, 252,  172, 204, 159, 174,   3, 159, 254, 176,
     177,   3, 178,   6, 159, 255, 186,   3,  159, 243, 186, 159, 171, 161, 162, 163,
     159, 197, 165, 166, 159, 173, 207,   4,  159, 255, 201,  33, 159, 106, 159, 251,
     164, 196, 197, 201, 202,  21, 159, 254,  145, 169,   3, 159, 255, 182,   4, 159,
     255, 184,   2, 159, 251, 172, 163, 164,  173, 201,   3, 159, 255, 214,   4, 159,
     255, 216,   2, 159, 252, 204, 195, 196,  205,  27, 159, 119, 159, 255, 141,   2,
     159, 255, 143,  69, 159, 127, 159,   6,  159, 255, 157,  13, 159, 254, 156, 158,
      43, 159, 114, 159, 255, 138,   8, 159,  253, 141, 159, 143,   6, 159, 255, 141,
      59, 159, 117, 159, 255, 268,   8, 159,  255, 268,  65, 159, 127, 159,   6, 159,
     247, 145, 146, 147, 148, 149, 150, 151,  152, 153,  11, 159, 247, 145, 146, 147,
     148, 149, 150, 151, 152, 153,  30, 159,  109, 159, 247, 145, 146, 147, 148, 149,
     150, 151, 152, 153,  11, 159, 220, 193,  194, 195, 196, 197, 198, 199, 200, 201,
     202, 203, 204, 205, 206, 207, 208, 209,  210, 211, 212, 213, 214, 215, 216, 217,
     218, 161, 162, 163, 164, 165, 166, 167,  168, 169, 170,  27, 159, 101, 159, 213,
     171, 172, 173, 174, 175, 176, 177, 178,  179, 180, 181, 182, 183, 184, 185, 186,
     193, 194, 195, 196, 197, 198, 199, 200,  201, 202, 203, 204, 205, 206, 207, 208,
     209, 210, 211, 212, 213, 214, 215, 216,  217, 218, 144,  10, 159, 245, 145, 146,
     147, 148, 149, 150, 151, 152, 153, 159,  144,  27, 159, 122, 159,   2, 138,  68,
     159, 127, 159,   8, 159,   2, 129,  18,  159, 247, 145, 146, 147, 148, 149, 150,
     151, 152, 153,  28, 159, 101, 159, 237,  145, 146, 147, 148, 149, 150, 151, 152,
     153, 159, 145, 146, 147, 148, 149, 150,  151, 152, 153,  72, 159, 127, 159,  22,
     159,   2, 138,   2, 159,   4, 138, 255,  143,   2, 159, 255, 138,  31, 159, 102,
     159,   2, 138,  41, 159,   2, 268,  45,  159, 112, 159, 255, 169,  47, 159, 255,
     201,  31, 159, 127, 159,   6, 159, 243,  172, 204, 172, 176, 178, 193, 212, 168,
     200, 171, 203, 186, 218,   7, 159, 255,  214,   7, 159, 254, 202, 182,  29, 159,
     127, 159,   4, 159, 254, 175, 207,  59,  159, 101, 159, 253,  61, 159,  62,   8,
     159, 251,  63, 159,  64, 159,  65,  75,  159, 101, 159, 253, 128, 140, 142,  88,
     159, 127, 159, 255, 159,   2, 128,  62,  159, 101, 159, 247, 145, 146, 147, 148,
     149, 150, 151, 152, 153,  82, 159, 125,  159, 246, 144, 145, 146, 147, 148, 149,
     150, 151, 152, 153,  57, 159, 101, 159,  254, 203, 173,  30, 159, 247, 145, 146,
     147, 148, 149, 150, 151, 152, 153,  50,  159, 127, 159,  18, 159, 255,  67,   4,
     159, 255,  68,   6, 159, 254,  69,  70,    2, 159, 252,  71,  72, 159,  73,  27,
     159, 127, 159,  15, 159, 255, 139,  49,  159, 127, 159,   4, 159,   6, 128,  55,
     159, 117, 159, 255, 140,   2, 159, 253,  154, 155, 129,  29, 159,   2, 191, 252,
     136, 137, 219, 221,  34, 159, 108, 159,  254, 187, 189,   4, 128,   3, 191, 243,
     140, 159, 142, 159, 155, 154, 159, 129,  159, 136, 137, 219, 221,   2, 159, 243,
     131, 134, 138, 139, 141, 156, 158, 157,  159, 188, 132, 133, 160,   4, 159, 241,
     128, 159, 128, 159, 128, 159, 128, 159,  128, 159, 128, 159, 128, 159, 128,  28,
     159, 102, 159, 193, 129, 130, 131, 132,  133, 134, 135, 136, 137, 138, 139, 140,
     141, 142, 143, 144, 145, 146, 147, 148,  149, 150, 151, 152, 153, 154, 155, 156,
     157, 158, 159, 160, 161, 162, 163, 164,  165, 166, 167, 168, 169, 170, 171, 172,
     173, 174, 175, 176, 177, 178, 179, 180,  181, 182, 183, 184, 185, 186, 187, 188,
     189, 190, 191,  27, 159, 101, 159, 225,  192, 193, 194, 195, 196, 197, 198, 199,
     200, 201, 202, 203, 204, 205, 206, 207,  208, 209, 210, 211, 212, 213, 214, 215,
     216, 217, 218, 219, 220, 221, 222,  60,  159, 127, 159,   6, 159, 250, 258, 259,
     268, 128, 262, 261,  53, 159, 117, 159,  255,  75,  12, 159, 253,  79, 159,  93,
      59, 159, 117, 159, 253,  76,  77,  19,   22, 159, 255,  78,  49, 159, 117, 159,
     255, 168,  10, 159, 255, 304,  28, 159,  255, 200,  34, 159, 104, 159, 255, 336,
      87, 159, 101, 159, 252, 145, 146, 147,  148,  87, 159, 114, 159, 255,  80,   2,
     159, 245,  81,  82,  83,  84,  85,  86,   87,  88,  89,  90,  91,   4, 159, 255,
      92,  59, 159, 127, 159,   6, 159, 238,  145, 146, 147, 148, 149, 150, 151, 152,
     153, 145, 146, 147, 148, 149, 150, 151,  152, 153,  41, 159, 101, 159, 192, 161,
     162, 163, 164, 165, 166, 167, 168, 169,  170, 171, 172, 173, 174, 175, 176, 177,
     178, 179, 180, 181, 182, 183, 184, 185,  186, 193, 194, 195, 196, 197, 198, 199,
     200, 201, 202, 203, 204, 205, 206, 207,  208, 209, 210, 211, 212, 213, 214, 215,
     216, 217, 218, 161, 162, 163, 164, 165,  166, 167, 168, 169, 170, 171, 172,  27,
     159, 101, 159, 192, 173, 174, 175, 176,  177, 178, 179, 180, 181, 182, 183, 184,
     185, 186, 193, 194, 195, 196, 197, 198,  199, 159, 201, 202, 203, 204, 205, 206,
     207, 208, 209, 210, 211, 212, 213, 214,  215, 216, 217, 218, 161, 162, 163, 164,
     165, 166, 167, 168, 169, 170, 171, 172,  173, 174, 175, 176, 177, 178, 179, 180,
     181, 182, 183, 184,  27, 159, 101, 159,  224, 185, 186, 193, 194, 195, 196, 197,
     198, 199, 200, 201, 202, 203, 204, 205,  206, 207, 208, 209, 210, 211, 212, 213,
     214, 215, 216, 217, 218, 161, 159, 163,  164,   2, 159, 255, 167,   2, 159, 254,
     170, 171,   2, 159, 233, 174, 175, 176,  177, 159, 179, 180, 181, 182, 183, 184,
     185, 186, 193, 194, 195, 196, 159, 198,  159, 200, 201, 202,  27, 159, 101, 159,
     192, 203, 204, 205, 206, 159, 208, 209,  210, 211, 212, 213, 214, 215, 216, 217,
     218, 161, 162, 163, 164, 165, 166, 167,  168, 169, 170, 171, 172, 173, 174, 175,
     176, 177, 178, 179, 180, 181, 182, 183,  184, 185, 186, 193, 194, 195, 196, 197,
     198, 199, 200, 201, 202, 203, 204, 205,  206, 207, 208, 209, 210, 211, 212, 213,
     214,  27, 159, 101, 159, 245, 215, 216,  217, 218, 161, 162, 159, 164, 165, 166,
     167,   2, 159, 206, 170, 171, 172, 173,  174, 175, 176, 177, 159, 179, 180, 181,
     182, 183, 184, 185, 159, 193, 194, 195,  196, 197, 198, 199, 200, 201, 202, 203,
     204, 205, 206, 207, 208, 209, 210, 211,  212, 213, 214, 215, 216, 217, 218, 161,
     162, 159, 164, 165, 166, 167,  28, 159,  101, 159, 249, 169, 170, 171, 172, 173,
     159, 175,   3, 159, 202, 179, 180, 181,  182, 183, 184, 185, 159, 193, 194, 195,
     196, 197, 198, 199, 200, 201, 202, 203,  204, 205, 206, 207, 208, 209, 210, 211,
     212, 213, 214, 215, 216, 217, 218, 161,  162, 163, 164, 165, 166, 167, 168, 169,
     170, 171, 172, 173, 174, 175, 176, 177,  178, 179, 180,  27, 159, 101, 159, 192,
     181, 182, 183, 184, 185, 186, 193, 194,  195, 196, 197, 198, 199, 200, 201, 202,
     203, 204, 205, 206, 207, 208, 209, 210,  211, 212, 213, 214, 215, 216, 217, 218,
     161, 162, 163, 164, 165, 166, 167, 168,  169, 170, 171, 172, 173, 174, 175, 176,
     177, 178, 179, 180, 181, 182, 183, 184,  185, 186, 193, 194, 195, 196, 197, 198,
      27, 159, 101, 159, 192, 199, 200, 201,  202, 203, 204, 205, 206, 207, 208, 209,
     210, 211, 212, 213, 214, 215, 216, 217,  218, 161, 162, 163, 164, 165, 166, 167,
     168, 169, 170, 171, 172, 173, 174, 175,  176, 177, 178, 179, 180, 181, 182, 183,
     184, 185, 186, 193, 194, 195, 196, 197,  198, 199, 200, 201, 202, 203, 204, 205,
     206, 207, 208, 209, 210,  27, 159, 101,  159, 192, 211, 212, 213, 214, 215, 216,
     217, 218, 161, 162, 163, 164, 165, 166,  167, 168, 169, 170, 171, 172, 173, 174,
     175, 176, 177, 178, 179, 180, 181, 182,  183, 184, 185, 186, 193, 194, 195, 196,
     197, 198, 199, 200, 201, 202, 203, 204,  205, 206, 207, 208, 209, 210, 211, 212,
     213, 214, 215, 216, 217, 218, 161, 162,  163, 164,  27, 159, 101, 159, 192, 165,
     166, 167, 168, 169, 170, 171, 172, 173,  174, 175, 176, 177, 178, 179, 180, 181,
     182, 183, 184, 185, 186, 193, 194, 195,  196, 197, 198, 199, 200, 201, 202, 203,
     204, 205, 206, 207, 208, 209, 210, 211,  212, 213, 214, 215, 216, 217, 218, 161,
     162, 163, 164, 165, 166, 167, 168, 169,  170, 171, 172, 173, 174, 175, 176,  27,
     159, 101, 159, 220, 177, 178, 179, 180,  181, 182, 183, 184, 185, 186, 193, 194,
     195, 196, 197, 198, 199, 200, 201, 202,  203, 204, 205, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 217, 218,   55, 159, 115, 159, 206, 144, 145, 146,
     147, 148, 149, 150, 151, 152, 153, 144,  145, 146, 147, 148, 149, 150, 151, 152,
     153, 144, 145, 146, 147, 148, 149, 150,  151, 152, 153, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 144, 145, 146,  147, 148, 149, 150, 151, 152, 153,  27,
     159, 105, 159, 254,  94,  95,  85, 159,  127, 159,  17, 159, 254, 163, 178,   4,
     159, 255, 162,  11, 159, 253, 174, 159,  176,  27, 159, 103, 159, 255, 179,   3,
     159, 255, 183,  84, 159
};

// utf/tr_utf8_latin2.txt
//
// 2372 code points.
// 94 states, 192 columns, 7092 bytes
//
const unsigned char tr_latin2_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   1,    2,   3,   4,   0,   0,   5,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   6,   0,   0,   0,   0,
       7,   8,   9,  10,  11,  12,  13,  14,   15,  16,  17,  18,  19,  20,  21,  22,
      23,  24,  25,  26,  27,  28,  29,  30,   31,  32,  33,  34,  35,  36,  37,   0,
      38,  39,  40,  41,  42,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100,   0,

     101, 102, 103, 104, 105, 106, 107, 108,  109, 110, 111, 112, 113, 114, 115, 116,
     117, 118, 119, 120, 121, 122, 123, 124,  125, 126, 127, 128, 129, 130, 131, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
       0,   0, 165, 166, 167, 168, 169, 170,  171, 172, 173, 174,   0, 175, 176,   0,
     177, 178, 179, 180,   0, 181, 182,   0,    0, 183,   0, 184,   0,   0,   0, 185,
     186, 187, 188, 189,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0, 190,
     191,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_latin2_sot[94] =
{
        0,  132,  169,  238,  307,  378,  440,  504,   575,  629,  666,  687,  699,  705,  749,  769,
      783,  812,  820,  826,  843,  860,  879,  910,   927,  942,  983,  998, 1014, 1033, 1050, 1114,
     1177, 1245, 1314, 1383, 1451, 1514, 1524, 1548,  1591, 1629, 1667, 1692, 1745, 1791, 1801, 1814,
     1830, 1858, 1911, 1973, 1979, 1999, 2023, 2041,  2047, 2057, 2086, 2095, 2111, 2119, 2127, 2141,
     2156, 2175, 2199, 2207, 2215, 2236, 2295, 2363,  2399, 2407, 2419, 2431, 2441, 2450, 2474, 2499,
     2568, 2637, 2709, 2778, 2847, 2916, 2985, 3054,  3123, 3192, 3233, 3288, 3295, 3314
};

const unsigned short tr_latin2_sbt[3324] =
{
     155, 157, 101, 102, 103, 104, 107, 121,  126, 127, 128, 129, 130, 131, 132, 133,
     134, 135, 136, 137, 138, 139, 140, 141,  142, 143, 144, 145, 146, 147, 148, 149,
     150, 151, 152, 153, 154, 155, 156, 158,  159, 160, 161, 162, 163, 164, 165, 166,
     167, 168, 169, 170, 171, 172, 173, 174,  175, 176, 177, 178, 179, 180, 181, 182,
     183, 184, 185, 186, 187, 188, 189, 190,  191, 192, 193, 194, 195, 196, 197, 198,
     199, 200, 201, 202, 203, 204, 205, 206,  207, 208, 209, 210, 211, 212, 213, 214,
     215, 216, 217, 218, 219, 220,  64, 157,  229,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,   16,  17,  18,  19,  20,  21,  22,  25,
      39,  59,  65,  73, 127, 157,   6, 157,  254, 254, 127,   2, 157, 255, 258,   2,
     157, 252, 261, 262, 157, 191,   2, 157,  248, 267, 157, 126, 270, 157, 144, 145,
     274,   3, 157, 253, 278, 143, 205,  32,  157, 101, 157, 192, 159, 287, 288, 159,
     290, 159, 157, 293, 163, 295, 163, 297,  167, 299, 300, 167, 162, 172, 173, 305,
     306, 173, 308, 309, 173, 179, 312, 179,  314, 315, 157, 317, 191, 319, 320, 191,
     322, 191, 157, 325, 195, 327, 195, 329,  199, 331, 332, 199, 194, 204, 205, 337,
     338, 205, 340, 341, 205, 211, 344, 211,  346, 347, 157, 215,  27, 157, 101, 157,
     207, 159, 191, 289, 321, 255, 271, 292,  324, 161, 193, 161, 193, 294, 326, 301,
     333, 302, 334, 163, 195, 163, 195, 163,  195, 296, 328, 298, 330, 165, 197, 165,
     197, 165, 197, 165, 197, 166, 198, 166,  198, 167, 199, 167, 199, 167, 199, 167,
     199, 167,   3, 157, 244, 168, 200, 169,  201, 157, 291, 323, 170, 202, 259, 275,
     170,  27, 157, 101, 157, 246, 202, 257,  273, 303, 335, 172, 204, 304, 336, 204,
       2, 157, 250, 173, 205, 173, 205, 307,  339,   2, 157, 212, 286, 318, 176, 208,
     310, 342, 260, 276, 177, 209, 264, 280,  263, 279, 316, 348, 265, 281, 178, 210,
     179, 211, 179, 211, 179, 211, 311, 343,  313, 345, 179, 211, 181, 213, 183, 215,
     183, 266, 282, 269, 285, 268, 284, 209,   27, 157, 101, 157, 255, 192,   2, 160,
     255, 192,   3, 157, 253, 161, 193, 157,    2, 162, 255, 194,   4, 157, 253, 164,
     196, 165,   3, 157, 252, 167, 169, 201,  202,   2, 157, 254, 172, 204,   2, 173,
     255, 205,   2, 157, 254, 174, 206,   5,  157, 244, 210, 178, 210, 178, 179, 211,
     157, 180, 183, 215, 184, 216,  36, 157,  104, 157, 255, 127,   9, 157, 235, 159,
     191, 167, 199, 173, 205, 179, 211, 179,  211, 179, 211, 179, 211, 179, 211, 157,
     159, 191, 159, 191,   2, 157, 246, 165,  197, 165, 197, 169, 201, 173, 205, 173,
     205,   2, 157, 255, 200,   3, 157, 254,  165, 197,   2, 157, 252, 172, 204, 159,
     191,   2, 157, 254, 173, 205,  27, 157,  101, 157, 228, 159, 191, 159, 191, 163,
     195, 163, 195, 167, 199, 167, 199, 173,  205, 173, 205, 176, 208, 176, 208, 179,
     211, 179, 211, 177, 209, 178, 210,   2,  157, 252, 166, 198, 172, 194,   2, 157,
     237, 184, 216, 159, 191, 163, 195, 173,  205, 173, 205, 173, 205, 173, 205, 183,
     215, 202, 204, 210,   3, 157, 250, 159,  161, 193, 170, 178, 209,  27, 157, 101,
     157, 255, 216,   2, 157, 243, 160, 179,  157, 163, 195, 168, 200, 157, 207, 176,
     208, 183, 215,   3, 157, 253, 192, 157,  193,   2, 194,   8, 157, 255, 197,   5,
     157, 253, 198, 157, 199,   2, 157,   4,  202,   2, 157, 255, 203,   2, 204,   8,
     157,   3, 208,  28, 157, 103, 157, 255,  209,   5, 157, 252, 210, 211, 157, 212,
       4, 157,   2, 216,  11, 157, 255, 200,    2, 157, 255, 207,  15, 157, 252, 198,
     157, 200, 208,   3, 157, 254, 213, 215,   34, 157, 108, 157, 255, 277,  16, 157,
     250, 256, 349, 126, 272, 220, 283,   3,  157, 253, 202, 209, 214,  55, 157, 127,
     157,  32, 157, 255, 126,   3, 157, 255,  153,  28, 157, 105, 157,   2, 126,  85,
     157, 105, 157, 253, 163, 157, 167,   6,  157, 255, 167,   2, 157, 255, 159,   7,
     157, 255, 167,   5, 157, 255, 173,   4,  157, 255, 179,   9, 157, 255, 163,   2,
     157, 255, 191,   7, 157, 255, 199,   5,  157, 255, 205,  28, 157, 104, 157, 255,
     211,   9, 157, 255, 195,   6, 157, 253,  195, 157, 199,   6, 157, 255, 199,  61,
     157, 127, 157,  14, 157, 254, 173, 205,   16, 157, 254, 166, 198,  31, 157, 117,
     157, 252, 159, 191, 159, 191,  14, 157,  250, 167, 199, 167, 199, 173, 205,   4,
     157, 248, 163, 195, 179, 211, 179, 211,  179, 211,  39, 157, 127, 157,   2, 157,
     255, 127,  62, 157, 111, 157, 255, 139,   80, 157, 127, 157,   6, 157, 246, 142,
     143, 144, 145, 146, 147, 148, 149, 150,  151,  49, 157, 127, 157,  22, 157, 246,
     142, 143, 144, 145, 146, 147, 148, 149,  150, 151,  33, 157, 101, 157, 246, 142,
     143, 144, 145, 146, 147, 148, 149, 150,  151,  47, 157, 255, 127,  33, 157, 127,
     157,  11, 157, 239,  23, 157,  23, 157,   23, 157,  23, 157,  23, 157,  23, 157,
      23, 157,  23, 157,  23,   3, 157, 252,   24, 157,  24,  19,  30, 157, 127, 157,
      12, 157, 246, 142, 143, 144, 145, 146,  147, 148, 149, 150, 151,  43, 157, 117,
     157, 246, 142, 143, 144, 145, 146, 147,  148, 149, 150, 151,  65, 157, 102, 157,
     255,  26,  11, 157, 255,  27,  17, 157,  254,  19,  28,   4, 157, 253,  29, 157,
      24,   5, 157, 255,  24,   6, 157, 248,   30,  31,  32, 157,  33,  34,  35,  36,
       2, 157, 254,  37,  38,  27, 157, 101,  157, 246, 142, 143, 144, 145, 146, 147,
     148, 149, 150, 151,  81, 157, 127, 157,   15, 157, 247, 143, 144, 145, 146, 147,
     148, 149, 150, 151,  41, 157, 107, 157,  255, 139,   9, 157, 246, 142, 143, 144,
     145, 146, 147, 148, 149, 150, 151,  65,  157, 105, 157, 244, 127, 157, 142, 143,
     144, 145, 146, 147, 148, 149, 150, 151,   75, 157, 101, 157, 255, 159,   2, 157,
     252, 160, 161, 162, 194,   2, 163, 250,  167, 168, 169, 170, 171, 172,   5, 173,
       2, 157,   2, 173, 255, 174,   2, 176,  255, 178,   3, 179, 252, 171, 180, 181,
     184,   9, 157, 236, 159, 157, 160, 157,  162, 163, 157, 165, 166, 167, 168, 169,
     170, 171, 172, 157, 173, 157, 174, 176,   27, 157, 101, 157, 252, 178, 179, 181,
     191,   3, 157, 253, 192, 194, 195,   3,  157, 250, 197, 157, 201, 203, 157, 205,
       3, 157, 253, 206, 210, 211,   2, 157,  255, 212,   6, 157, 252, 199, 208, 211,
     212,   6, 157, 250, 192, 194, 196, 203,  204, 206,   2, 208, 253, 209, 210, 216,
       4, 157, 252, 167, 157, 206, 179,  28,  157, 101, 157, 237, 192, 194, 196, 197,
     201, 202, 203, 204, 206, 208, 209, 157,  212, 214, 216, 191, 157, 194, 195,   3,
     157, 255, 199,   2, 157, 255, 211,   2,  157,   2, 193, 248, 194, 195, 196, 200,
     197, 198, 199, 157,   2, 199, 255, 200,    3, 202,   2, 203,   3, 204, 248, 205,
     157, 209, 157, 210, 211, 157, 211,   2,  212,   3, 216,  29, 157, 101, 157, 192,
     159, 191, 160, 192, 160, 192, 160, 192,  161, 193, 162, 194, 162, 194, 162, 194,
     162, 194, 162, 194, 163, 195, 163, 195,  163, 195, 163, 195, 163, 195, 164, 196,
     165, 197, 166, 198, 166, 198, 166, 198,  166, 198, 166, 198, 167, 199, 167, 199,
     169, 201, 169, 201, 169, 201, 170, 202,  170, 202, 170, 202, 170, 202, 171, 203,
      27, 157, 101, 157, 192, 171, 203, 171,  203, 172, 204, 172, 204, 172, 204, 172,
     204, 173, 205, 173, 205, 173, 205, 173,  205, 174, 206, 174, 206, 176, 208, 176,
     208, 176, 208, 176, 208, 177, 209, 177,  209, 177, 209, 177, 209, 177, 209, 178,
     210, 178, 210, 178, 210, 178, 210, 179,  211, 179, 211, 179, 211, 179, 211, 179,
     211, 180, 212, 180, 212,  27, 157, 101,  157, 228, 181, 213, 181, 213, 181, 213,
     181, 213, 181, 213, 182, 214, 182, 214,  183, 215, 184, 216, 184, 216, 184, 216,
     198, 210, 213, 215, 191, 209,   4, 157,  224, 159, 191, 159, 191, 159, 191, 159,
     191, 159, 191, 159, 191, 159, 191, 159,  191, 159, 191, 159, 191, 159, 191, 159,
     191, 163, 195, 163, 195, 163, 195, 163,  195,  27, 157, 101, 157, 198, 163, 195,
     163, 195, 163, 195, 163, 195, 167, 199,  167, 199, 173, 205, 173, 205, 173, 205,
     173, 205, 173, 205, 173, 205, 173, 205,  173, 205, 173, 205, 173, 205, 173, 205,
     173, 205, 179, 211, 179, 211, 179, 211,  179, 211, 179, 211, 179, 211, 179, 211,
     183, 215, 183, 215, 183, 215, 183, 215,   33, 157, 127, 157,  35, 157, 253, 126,
     157, 126,  27, 157, 101, 157,   2, 126,   11, 157,   3, 126,  13, 157,   3, 126,
      13, 157,   2, 126, 255, 190,  13, 157,    2, 126,  28, 157, 101, 157, 250,  40,
      41,  42, 157,  43,  44,   2, 157, 253,   45,  46,  47,   6, 157, 253,  48,  49,
      50,   8, 157, 253,  51,  52,  53,   9,  157, 255,  54,   2, 157, 255,  55,   4,
     157, 253,  56,  57,  58,  40, 157, 101,  157,  11, 126,   5, 157,   2, 139, 255,
     157,   2, 139,   2, 157, 255, 126,   4,  133,   4, 128,   2, 157, 253, 136, 157,
     140,  10, 157, 255, 126,  12, 157, 253,  127, 157, 126,  28, 157, 104, 157, 255,
     139,   4, 157, 255, 127,   9, 157, 255,  139,  12, 157, 255, 126,  16, 157, 254,
     142, 199,   2, 157, 244, 146, 147, 148,  149, 150, 151, 137, 139, 155, 134, 135,
     204,  27, 157, 101, 157, 236, 142, 143,  144, 145, 146, 147, 148, 149, 150, 151,
     137, 139, 155, 134, 135, 157, 191, 195,  205, 214,  71, 157, 103, 157, 255, 161,
       7, 157, 255, 197,   3, 166, 254, 198,  157,   2, 167, 252, 170, 202, 157, 172,
       3, 157, 254, 174, 175,   3, 176,   6,  157, 255, 184,   3, 157, 243, 184, 157,
     169, 159, 160, 161, 157, 195, 163, 164,  157, 171, 205,   4, 157, 255, 199,  33,
     157, 106, 157, 251, 162, 194, 195, 199,  200,  21, 157, 254, 143, 167,   3, 157,
     255, 180,   4, 157, 255, 182,   2, 157,  251, 170, 161, 162, 171, 199,   3, 157,
     255, 212,   4, 157, 255, 214,   2, 157,  252, 202, 193, 194, 203,  27, 157, 119,
     157, 255, 139,   2, 157, 255, 141,  69,  157, 127, 157,   6, 157, 255, 155,  13,
     157, 254, 154, 156,  43, 157, 114, 157,  255, 136,   8, 157, 253, 139, 157, 141,
       6, 157, 255, 139,  59, 157, 127, 157,    6, 157, 247, 143, 144, 145, 146, 147,
     148, 149, 150, 151,  11, 157, 247, 143,  144, 145, 146, 147, 148, 149, 150, 151,
      30, 157, 109, 157, 247, 143, 144, 145,  146, 147, 148, 149, 150, 151,  11, 157,
     220, 191, 192, 193, 194, 195, 196, 197,  198, 199, 200, 201, 202, 203, 204, 205,
     206, 207, 208, 209, 210, 211, 212, 213,  214, 215, 216, 159, 160, 161, 162, 163,
     164, 165, 166, 167, 168,  27, 157, 101,  157, 213, 169, 170, 171, 172, 173, 174,
     175, 176, 177, 178, 179, 180, 181, 182,  183, 184, 191, 192, 193, 194, 195, 196,
     197, 198, 199, 200, 201, 202, 203, 204,  205, 206, 207, 208, 209, 210, 211, 212,
     213, 214, 215, 216, 142,  10, 157, 245,  143, 144, 145, 146, 147, 148, 149, 150,
     151, 157, 142,  27, 157, 122, 157,   2,  136,  68, 157, 127, 157,   8, 157,   2,
     127,  18, 157, 247, 143, 144, 145, 146,  147, 148, 149, 150, 151,  28, 157, 101,
     157, 237, 143, 144, 145, 146, 147, 148,  149, 150, 151, 157, 143, 144, 145, 146,
     147, 148, 149, 150, 151,  72, 157, 127,  157,  22, 157,   2, 136,   2, 157,   4,
     136, 255, 141,   2, 157, 255, 136,  31,  157, 102, 157,   2, 136,  88, 157, 112,
     157, 255, 167,  47, 157, 255, 199,  31,  157, 127, 157,   6, 157, 243, 170, 202,
     170, 174, 176, 191, 210, 166, 198, 169,  201, 184, 216,   7, 157, 255, 212,   7,
     157, 254, 200, 180,  29, 157, 127, 157,    4, 157, 254, 173, 205,  59, 157, 101,
     157, 253,  60, 157,  61,   8, 157, 251,   62, 157,  63, 157,  64,  75, 157, 101,
     157, 253, 126, 138, 140,  88, 157, 127,  157, 255, 157,   2, 126,  62, 157, 101,
     157, 247, 143, 144, 145, 146, 147, 148,  149, 150, 151,  82, 157, 125, 157, 246,
     142, 143, 144, 145, 146, 147, 148, 149,  150, 151,  57, 157, 101, 157, 254, 201,
     171,  30, 157, 247, 143, 144, 145, 146,  147, 148, 149, 150, 151,  50, 157, 127,
     157,  18, 157, 255,  66,   4, 157, 255,   67,   6, 157, 254,  68,  69,   2, 157,
     252,  70,  71, 157,  72,  27, 157, 127,  157,  15, 157, 255, 137,  49, 157, 127,
     157,   4, 157,   6, 126,  55, 157, 117,  157, 255, 138,   2, 157, 253, 152, 153,
     127,  29, 157,   2, 189, 252, 134, 135,  217, 219,  34, 157, 108, 157, 254, 185,
     187,   4, 126,   3, 189, 243, 138, 157,  140, 157, 153, 152, 157, 127, 157, 134,
     135, 217, 219,   2, 157, 243, 129, 132,  136, 137, 139, 154, 156, 155, 157, 186,
     130, 131, 158,   4, 157, 241, 126, 157,  126, 157, 126, 157, 126, 157, 126, 157,
     126, 157, 126, 157, 126,  28, 157, 102,  157, 193, 127, 128, 129, 130, 131, 132,
     133, 134, 135, 136, 137, 138, 139, 140,  141, 142, 143, 144, 145, 146, 147, 148,
     149, 150, 151, 152, 153, 154, 155, 156,  157, 158, 159, 160, 161, 162, 163, 164,
     165, 166, 167, 168, 169, 170, 171, 172,  173, 174, 175, 176, 177, 178, 179, 180,
     181, 182, 183, 184, 185, 186, 187, 188,  189,  27, 157, 101, 157, 225, 190, 191,
     192, 193, 194, 195, 196, 197, 198, 199,  200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,  216, 217, 218, 219, 220,  60, 157, 127,
     157,   9, 157, 255, 126,  55, 157, 117,  157, 255,  74,  12, 157, 253,  77, 157,
      91,  59, 157, 117, 157, 253,  75, 157,   19,  22, 157, 255,  76,  49, 157, 117,
     157, 255, 166,  39, 157, 255, 198,  34,  157, 101, 157, 252, 143, 144, 145, 146,
      87, 157, 114, 157, 255,  78,   2, 157,  245,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,   4, 157, 255,  90,   59, 157, 127, 157,   6, 157, 238, 143,
     144, 145, 146, 147, 148, 149, 150, 151,  143, 144, 145, 146, 147, 148, 149, 150,
     151,  41, 157, 101, 157, 192, 159, 160,  161, 162, 163, 164, 165, 166, 167, 168,
     169, 170, 171, 172, 173, 174, 175, 176,  177, 178, 179, 180, 181, 182, 183, 184,
     191, 192, 193, 194, 195, 196, 197, 198,  199, 200, 201, 202, 203, 204, 205, 206,
     207, 208, 209, 210, 211, 212, 213, 214,  215, 216, 159, 160, 161, 162, 163, 164,
     165, 166, 167, 168, 169, 170,  27, 157,  101, 157, 192, 171, 172, 173, 174, 175,
     176, 177, 178, 179, 180, 181, 182, 183,  184, 191, 192, 193, 194, 195, 196, 197,
     157, 199, 200, 201, 202, 203, 204, 205,  206, 207, 208, 209, 210, 211, 212, 213,
     214, 215, 216, 159, 160, 161, 162, 163,  164, 165, 166, 167, 168, 169, 170, 171,
     172, 173, 174, 175, 176, 177, 178, 179,  180, 181, 182,  27, 157, 101, 157, 224,
     183, 184, 191, 192, 193, 194, 195, 196,  197, 198, 199, 200, 201, 202, 203, 204,
     205, 206, 207, 208, 209, 210, 211, 212,  213, 214, 215, 216, 159, 157, 161, 162,
       2, 157, 255, 165,   2, 157, 254, 168,  169,   2, 157, 233, 172, 173, 174, 175,
     157, 177, 178, 179, 180, 181, 182, 183,  184, 191, 192, 193, 194, 157, 196, 157,
     198, 199, 200,  27, 157, 101, 157, 192,  201, 202, 203, 204, 157, 206, 207, 208,
     209, 210, 211, 212, 213, 214, 215, 216,  159, 160, 161, 162, 163, 164, 165, 166,
     167, 168, 169, 170, 171, 172, 173, 174,  175, 176, 177, 178, 179, 180, 181, 182,
     183, 184, 191, 192, 193, 194, 195, 196,  197, 198, 199, 200, 201, 202, 203, 204,
     205, 206, 207, 208, 209, 210, 211, 212,   27, 157, 101, 157, 245, 213, 214, 215,
     216, 159, 160, 157, 162, 163, 164, 165,    2, 157, 206, 168, 169, 170, 171, 172,
     173, 174, 175, 157, 177, 178, 179, 180,  181, 182, 183, 157, 191, 192, 193, 194,
     195, 196, 197, 198, 199, 200, 201, 202,  203, 204, 205, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 159, 160,  157, 162, 163, 164, 165,  28, 157, 101,
     157, 249, 167, 168, 169, 170, 171, 157,  173,   3, 157, 202, 177, 178, 179, 180,
     181, 182, 183, 157, 191, 192, 193, 194,  195, 196, 197, 198, 199, 200, 201, 202,
     203, 204, 205, 206, 207, 208, 209, 210,  211, 212, 213, 214, 215, 216, 159, 160,
     161, 162, 163, 164, 165, 166, 167, 168,  169, 170, 171, 172, 173, 174, 175, 176,
     177, 178,  27, 157, 101, 157, 192, 179,  180, 181, 182, 183, 184, 191, 192, 193,
     194, 195, 196, 197, 198, 199, 200, 201,  202, 203, 204, 205, 206, 207, 208, 209,
     210, 211, 212, 213, 214, 215, 216, 159,  160, 161, 162, 163, 164, 165, 166, 167,
     168, 169, 170, 171, 172, 173, 174, 175,  176, 177, 178, 179, 180, 181, 182, 183,
     184, 191, 192, 193, 194, 195, 196,  27,  157, 101, 157, 192, 197, 198, 199, 200,
     201, 202, 203, 204, 205, 206, 207, 208,  209, 210, 211, 212, 213, 214, 215, 216,
     159, 160, 161, 162, 163, 164, 165, 166,  167, 168, 169, 170, 171, 172, 173, 174,
     175, 176, 177, 178, 179, 180, 181, 182,  183, 184, 191, 192, 193, 194, 195, 196,
     197, 198, 199, 200, 201, 202, 203, 204,  205, 206, 207, 208,  27, 157, 101, 157,
     192, 209, 210, 211, 212, 213, 214, 215,  216, 159, 160, 161, 162, 163, 164, 165,
     166, 167, 168, 169, 170, 171, 172, 173,  174, 175, 176, 177, 178, 179, 180, 181,
     182, 183, 184, 191, 192, 193, 194, 195,  196, 197, 198, 199, 200, 201, 202, 203,
     204, 205, 206, 207, 208, 209, 210, 211,  212, 213, 214, 215, 216, 159, 160, 161,
     162,  27, 157, 101, 157, 192, 163, 164,  165, 166, 167, 168, 169, 170, 171, 172,
     173, 174, 175, 176, 177, 178, 179, 180,  181, 182, 183, 184, 191, 192, 193, 194,
     195, 196, 197, 198, 199, 200, 201, 202,  203, 204, 205, 206, 207, 208, 209, 210,
     211, 212, 213, 214, 215, 216, 159, 160,  161, 162, 163, 164, 165, 166, 167, 168,
     169, 170, 171, 172, 173, 174,  27, 157,  101, 157, 220, 175, 176, 177, 178, 179,
     180, 181, 182, 183, 184, 191, 192, 193,  194, 195, 196, 197, 198, 199, 200, 201,
     202, 203, 204, 205, 206, 207, 208, 209,  210, 211, 212, 213, 214, 215, 216,  55,
     157, 115, 157, 206, 142, 143, 144, 145,  146, 147, 148, 149, 150, 151, 142, 143,
     144, 145, 146, 147, 148, 149, 150, 151,  142, 143, 144, 145, 146, 147, 148, 149,
     150, 151, 142, 143, 144, 145, 146, 147,  148, 149, 150, 151, 142, 143, 144, 145,
     146, 147, 148, 149, 150, 151,  27, 157,  105, 157, 254,  92,  93,  85, 157, 127,
     157,  17, 157, 254, 161, 176,   4, 157,  255, 160,  11, 157, 253, 172, 157, 174,
      27, 157, 103, 157, 255, 177,   3, 157,  255, 181,  84, 157
};

// utf/tr_tolower.txt
//
// 1029 code points.
// 46 states, 86 columns, 1713 bytes
//
const unsigned char tr_tolower_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  37,  38,  35,  39,  40,   41,  42,  43,  44,  45,  46,  47,  48,
      49,  50,  51,  52,  53,  54,  55,  56,   57,  58,  59,  60,  61,  62,  63,  64,
       0,   0,   0,  65,  66,  67,  68,  69,   70,  71,   0,   0,   0,  72,  73,  74,
      75,  76,  77,  78,  79,  80,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,  81,  82,   0,   0,   0,   0,   0,    0,   0,  83,   0,   0,   0,   0,  84,
      85,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_tolower_sot[46] =
{
        0,   27,   37,  107,  174,  241,  307,  371,   390,  402,  426,  475,  485,  521,  583,  652,
      698,  706,  724,  730,  736,  804,  866,  884,   904,  926,  958,  978,  993,  999, 1005, 1019,
     1039, 1049, 1081, 1127, 1138, 1188, 1216, 1250,  1311, 1327, 1333, 1339, 1345, 1351
};

const unsigned char tr_tolower_sbt[1365] =
{
     254,  46,  62,  63,  46, 235,   1,   2,    3,   4,   5,   6,   7,   8,   9,  10,
      11,  12,  13,  14,  15,  16,  17,  26,   35,  41,  43,   2,  46,  23,  63, 255,
      46,   7,  63,  53,  46,   2,  46, 220,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  64,  46,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  64,  46,   64,  46,  64,  46,   2,  64, 240,  46,
      64,  46,  64,  46,  64,  46,  64,  46,   47,  46,  64,  46,  64,  46,  64,   2,
      46, 249,  65,  46,  66,  46,  65,  46,   67,  21,  46,   3,  46, 249,  65,  46,
      66,  46,  65,  46,  68,   2,  46, 230,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  64,  46,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,   2,  64, 233,  46,  64,  46,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  69,  65,   46,  66,  46,  65,  23,  46,   3,  46,
     245,  70,  64,  46,  64,  46,  70,  68,   46,  71,  72,  66,   2,  46, 248,  73,
      74,  75,  65,  46,  76,  77,  46,   2,   78, 255,  64,   3,  46, 243,  76,  79,
      46,  80,  64,  46,  64,  46,  64,  81,   68,  46,  82,   2,  46, 243,  64,  46,
      81,  83,  46,  84,  85,  66,  46,  65,   46,  86,  64,   3,  46, 255,  64,  24,
      46,   6,  46, 232,  87,  65,  46,  88,   64,  46,  89,  66,  46,  65,  46,  83,
      46,  65,  46,  66,  46,  65,  46,  68,   46,  65,  46,  66,   2,  46, 250,  64,
      46,  64,  46,  64,  46,   2,  64, 248,   46,  64,  46,  64,  46,  64,  46,  64,
       2,  46, 242,  87,  64,  46,  64,  46,   90,  91,  64,  46,  64,  46,  64,  46,
      64,  22,  46,   2,  46, 220,  64,  46,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  64,  46,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  92,  46,   64,  46,   2,  64, 244,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  64,  46,   64,   7,  46, 251,  48,  66,  46,  93,
      49,  22,  46,   3,  46, 242,  65,  46,   94,  95,  96,  64,  46,  64,  46,  64,
      46,  64,  46,  64,  69,  46,  49,  46,  253,  64,  46,  64,   3,  46, 255,  64,
      30,  46,   8,  46, 245,  97,  46,  98,   99,  98,  46, 100,  46, 101, 102,  46,
      15,  63,   2, 103, 255,  46,   8, 103,   41,  46,  17,  46, 255, 104,   8,  46,
     244,  64,  46,  64,  46,  64,  46,  64,   46,  64,  46,  64,  46,   2,  64, 248,
      46,  64,  46,  64,  46,  64,  46,  64,    5,  46, 255, 105,   2,  46, 252,  68,
      46, 106,  64,   2,  46, 255, 107,   2,  108,  21,  46,   2,  46,  16, 109,  16,
      63,  15, 103,  37,  46,  34,  46, 252,   64,  46,  64,  46,   2,  64, 232,  46,
      64,  46,  64,  46,  64,  46,  64,  46,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  64,  22,   46,   2,  46, 255,  64,   9,  46, 230,
      64,  46,  64,  46,  64,  46,  64,  46,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  64,  46,   64,  46,   2,  64, 232,  46,  64,  46,
      64,  46,  64,  46,  64,  46,  64,  46,   64,  46,  64,  46,  64,  46,  64,  46,
      64,  46,  64,  46,  64,  22,  46,   2,   46, 242,  68,  65,  46,  66,  46,  65,
      46,  68,  46,  65,  46,  66,  46,  65,    2,  46, 236,  64,  46,  64,  46,  64,
      46,  64,  46,  64,  46,  64,  46,  64,   46,  64,  46,  64,  46,  64,  46,   2,
      64, 232,  46,  64,  46,  64,  46,  64,   46,  64,  46,  64,  46,  64,  46,  64,
      46,  64,  46,  64,  46,  64,  46,  64,   46,  64,  22,  46,   2,  46, 219,  64,
      46,  64,  46,  64,  46,  64,  46,  64,   46,  64,  46,  64,  46,  64,  46,  64,
      46,  64,  46,  64,  46,  64,  46,  64,   46,  64,  46,  64,  46,  64,  46,  64,
      46,  64,  46,  64,  11,  46,  15, 109,   21,  46,   2,  46,  16, 110,   7, 111,
      61,  46,   4,  46, 254,  18,  19,  51,   46,   2,  20, 250,  21,  20,  22,  23,
      24,  25,  21,  46,  34,  46,  31, 112,   21,  46,   2,  46,   6, 113,  78,  46,
       2,  46, 220, 114,  46, 114,  46, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,  46, 114,  46, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,  46, 114,  46,   2,  114, 232,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,  46, 114,  46, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  22,  46,   2,  46, 235, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,  46, 114,  46, 114,   46, 114,  46, 114,   9,  46, 250,  50,
      46, 114,  46, 114,  46,   2, 114, 232,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,  46, 114,  46, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      22,  46,  10,  46,   8, 115,   8,  46,    6, 115,   9,  46,   8, 115,   8,  46,
       8, 115,  21,  46,  10,  46,   6, 115,   11,  46, 249, 115,  46, 115,  46, 115,
      46, 115,   7,  46,   8, 115,  37,  46,   10,  46,   8, 115,   8,  46,   8, 115,
       7,  46,   8, 115,   8,  46,   2, 115,    2, 116, 255, 117,  24,  46,  10,  46,
       2, 118,   2, 119, 255, 117,  11,  46,    2, 115,   2, 120,  11,  46,   2, 115,
       2, 121, 255, 122,  11,  46,   2, 123,    2, 124, 255, 117,  24,  46,   6,  46,
     253,  27,  28,  29,  11,  46, 254,  30,   31,  27,  46, 252,  32,  33,  20,  34,
      33,  46,  39,  46, 255,  51,   3,  46,  254,  52,  53,   6,  46, 255, 125,  34,
      46,  34,  46,  15, 126,  37,  46,   5,   46, 255, 127,  80,  46,  55,  46,   2,
     128,   2, 129,   2, 130,   2, 129,   2,  128,  21,  46,   2,  46,   2, 131,   2,
     132,   2, 131,   2, 133,   2, 134,   2,  135,   2, 134,   2, 133,  68,  46,   2,
      46,  16, 136,  16, 137,  14, 138,  38,   46,  34,  46, 238, 114,  46,  54, 139,
      55,  46, 117,  46, 140,  46, 127,  46,   56,  57,  58,  59,  46, 114,   2,  46,
     255, 140,   8,  46, 254,  60,  61,  21,   46,   2,  46, 221, 114,  46, 114,  46,
     114,  46, 114,  46, 114,  46, 114,  46,  114,  46, 114,  46, 114,  46, 114,  46,
     114,  46, 114,  46, 114,  46, 114,  46,  114,  46, 114,  46, 114,  46, 114,   7,
      46, 253, 127,  46, 140,  39,  46,  27,   46, 250,  36,  37,  46,  38,  39,  40,
      53,  46,   2,  46, 225, 114,  46, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,  46, 114,  46, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,   3,  46, 254, 114,   46,   2, 114, 250,  46, 114,  46, 114,
      46, 114,  40,  46,   2,  46, 233, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,  46, 114,  46, 114,   46, 114,  46, 114,  46, 114,  61,  46,
      36,  46, 254, 114,  46,   2, 114, 248,   46, 114,  46, 114,  46, 114,  46, 114,
       3,  46, 243, 114,  46, 114,  46, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      22,  46,   2,  46, 220, 114,  46, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,  46, 114,  46, 114,   46, 114,  46, 114,  46, 114,  46, 114,
      46, 114,  46, 114,  46, 114,  46, 114,   46,   2, 114, 248,  46, 114,  46, 114,
      46, 114,  46, 114,  10,  46, 250, 140,   46, 127,  46, 141, 114,  22,  46,   2,
      46, 249, 114,  46, 114,  46, 114,  46,  114,   4,  46, 255, 127,  72,  46,  61,
      46, 255,  42,  24,  46,  35,  46,  25,  142,  26,  46,  18,  46, 255,  44,  67,
      46,  18,  46, 255,  45,  67,  46,   2,   46,   8, 143,   8, 144,   8, 143,   8,
     145,   7, 146,  45,  46
};

const string_desc tr_tolower_ott[100] =
{
    {  1,  1, T("\x69") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA5") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA6") }, // 1 references
    {  2,  1, T("\xC3\x9F") }, // 1 references
    {  2,  1, T("\xCF\x89") }, // 1 references
    {  1,  1, T("\x6B") }, // 1 references
    {  2,  1, T("\xC3\xA5") }, // 1 references
    {  2,  1, T("\xC9\xAB") }, // 1 references
    {  2,  1, T("\xC9\xBD") }, // 1 references
    {  2,  1, T("\xC9\x91") }, // 1 references
    {  2,  1, T("\xC9\xB1") }, // 1 references
    {  2,  1, T("\xC9\x90") }, // 1 references
    {  2,  1, T("\xC9\x92") }, // 1 references
    {  2,  1, T("\xC8\xBF") }, // 1 references
    {  2,  1, T("\xC9\x80") }, // 1 references
    {  1,  1, T("\x20") }, // 26 references
    {  2,  1, T("\x00\x20") }, // 61 references
    {  2,  1, T("\x00\x01") }, // 208 references
    {  2,  1, T("\x00\x03") }, // 18 references
    {  2,  1, T("\x00\x07") }, // 11 references
    {  2,  1, T("\x01\x3F") }, // 1 references
    {  2,  1, T("\x00\x0F") }, // 7 references
    {  2,  1, T("\x06\x07") }, // 1 references
    {  2,  1, T("\x0F\x12") }, // 2 references
    {  2,  1, T("\x0F\x1F") }, // 1 references
    {  2,  1, T("\x0F\x1D") }, // 1 references
    {  2,  1, T("\x01\x13") }, // 1 references
    {  2,  1, T("\x0F\x16") }, // 1 references
    {  2,  1, T("\x0F\x0B") }, // 1 references
    {  2,  1, T("\x0F\x33") }, // 2 references
    {  2,  1, T("\x0F\x37") }, // 1 references
    {  2,  1, T("\x0F\x3F") }, // 2 references
    {  2,  1, T("\x0F\x2F") }, // 1 references
    {  2,  1, T("\x0F\x2A") }, // 1 references
    {  2,  1, T("\x0C\x26") }, // 2 references
    {  2,  1, T("\x0C\x2A") }, // 1 references
    {  2,  1, T("\x00\x1F") }, // 2 references
    {  2,  1, T("\x0C\x3B") }, // 1 references
    {  2,  1, T("\x0C\x39") }, // 1 references
    {  2,  1, T("\x0C\x25") }, // 1 references
    {  2,  1, T("\x00\x02") }, // 2 references
    {  2,  1, T("\x00\x0E") }, // 1 references
    {  2,  1, T("\x00\x06") }, // 1 references
    {  2,  1, T("\x01\x23") }, // 1 references
    {  2,  1, T("\x01\x08") }, // 1 references
    {  2,  1, T("\x0E\x3E") }, // 1 references
    {  2,  1, T("\x0E\x27") }, // 1 references
    {  2,  1, T("\x0F\x03") }, // 1 references
    {  2,  1, T("\x03\x0D") }, // 1 references
    {  2,  1, T("\x03\x09") }, // 1 references
    {  2,  1, T("\x00\x2A") }, // 1 references
    {  2,  1, T("\x00\x25") }, // 2 references
    {  2,  1, T("\x00\x27") }, // 1 references
    {  2,  1, T("\x01\x00") }, // 1 references
    {  2,  1, T("\x01\x03") }, // 1 references
    {  2,  1, T("\x01\x01") }, // 1 references
    {  2,  1, T("\x01\x20") }, // 27 references
    {  2,  1, T("\x00\x18") }, // 1 references
    {  2,  1, T("\x01\x0C") }, // 1 references
    {  2,  1, T("\x00\x0B") }, // 1 references
    {  2,  1, T("\x02\x06") }, // 1 references
    {  2,  1, T("\x02\x02") }, // 2 references
    {  2,  1, T("\x01\x10") }, // 31 references
    {  2,  1, T("\x00\x30") }, // 16 references
    {  2,  1, T("\x03\x10") }, // 7 references
    {  3,  1, T("\x03\x36\x20") }, // 32 references
    {  3,  1, T("\x03\x37\x20") }, // 6 references
    {  3,  1, T("\x00\x00\x01") }, // 252 references
    {  3,  1, T("\x00\x00\x08") }, // 78 references
    {  3,  1, T("\x00\x03\x0A") }, // 2 references
    {  3,  1, T("\x00\x00\x0F") }, // 4 references
    {  3,  1, T("\x00\x02\x3A") }, // 2 references
    {  3,  1, T("\x00\x02\x3E") }, // 2 references
    {  3,  1, T("\x00\x02\x2C") }, // 2 references
    {  3,  1, T("\x00\x02\x10") }, // 2 references
    {  3,  1, T("\x00\x00\x09") }, // 1 references
    {  3,  1, T("\x00\x02\x00") }, // 2 references
    {  3,  1, T("\x00\x02\x06") }, // 2 references
    {  3,  1, T("\x00\x01\x3C") }, // 1 references
    {  3,  1, T("\x00\x00\x10") }, // 16 references
    {  3,  1, T("\x00\x00\x07") }, // 5 references
    {  3,  1, T("\x00\x01\x26") }, // 4 references
    {  3,  1, T("\x00\x01\x2A") }, // 4 references
    {  3,  1, T("\x00\x01\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x1A") }, // 4 references
    {  3,  1, T("\x00\x00\x1E") }, // 2 references
    {  3,  1, T("\x00\x00\x26") }, // 4 references
    {  3,  1, T("\x00\x00\x2A") }, // 4 references
    {  3,  1, T("\x00\x00\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x30") }, // 16 references
    {  3,  1, T("\x00\x01\x10") }, // 16 references
    {  3,  1, T("\x00\x01\x30") }, // 15 references
    {  3,  1, T("\x03\x04\x1E") }, // 1 references
    {  3,  1, T("\x00\x00\x03") }, // 4 references
    {  3,  1, T("\x0B\x28\x04") }, // 1 references
    {  3,  1, T("\x00\x01\x20") }, // 26 references
    {  4,  1, T("\x00\x00\x00\x28") }, // 16 references
    {  4,  1, T("\x00\x00\x00\x38") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x18") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x28") } // 8 references
};

// utf/tr_toupper.txt
//
// 1036 code points.
// 48 states, 90 columns, 1810 bytes
//
const unsigned char tr_toupper_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   0,

       2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  37,  38,  39,  40,  41,   42,  43,  44,  45,  46,  47,  48,  49,
      50,  51,  52,  53,  54,  55,  56,  57,   58,  59,  60,  61,  62,  63,  64,  65,
       0,   0,  66,  67,  68,  69,  70,  71,   72,  73,  74,   0,   0,  75,  76,  77,
      78,  79,  80,  81,  82,  83,  84,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,  85,  86,   0,   0,   0,   0,   0,    0,   0,  87,   0,   0,   0,   0,  88,
      89,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_toupper_sot[48] =
{
        0,   30,   36,   48,  116,  187,  260,  325,   389,  452,  474,  492,  504,  566,  572,  613,
      675,  742,  784,  792,  798,  815,  825,  893,   957,  975, 1011, 1036, 1058, 1077, 1087, 1093,
     1123, 1129, 1160, 1206, 1214, 1225, 1275, 1303,  1337, 1399, 1415, 1421, 1427, 1433, 1440, 1450

};

const unsigned char tr_toupper_sbt[1458] =
{
     254,  48,  62,  64,  48, 232,   1,   2,    3,   4,   5,   6,   7,   8,   9,  10,
      11,  12,  13,  14,  15,  16,  17,  18,   19,  20,  28,  36,  42,  44,  55,  48,
     255,  63,  34,  48,  34,  48,  23,  64,  255,  48,   7,  64, 255,  65,  24,  48,
       3,  48, 201,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  49,  48,  66,  48,  66,   48,  66,   2,  48, 251,  67,  48,  68,
      48,  67,  25,  48,   2,  48, 247,  69,   48,  67,  48,  68,  48,  67,  48,  70,
       2,  48, 211,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
       2,  48, 250,  67,  48,  68,  48,  67,   50,  24,  48,   2,  48, 255,  71,   2,
      48, 253,  66,  48,  66,   2,  48, 255,   70,   3,  48, 255,  68,   5,  48, 255,
      67,   2,  48, 255,  72,   3,  48, 254,   66,  73,   3,  48, 255,  74,   2,  48,
     251,  66,  48,  66,  48,  66,   2,  48,  255,  70,   4,  48, 255,  66,   2,  48,
     255,  75,   3,  48, 253,  68,  48,  67,    2,  48, 255,  66,   3,  48, 253,  66,
      48,  76,  24,  48,   7,  48, 213,  66,   77,  48,  70,  78,  48,  66,  79,  48,
      67,  48,  75,  48,  67,  48,  68,  48,   67,  48,  70,  48,  67,  48,  68,  80,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,   2,  48, 252,  67,  77,  48,   66,   3,  48, 249,  66,  48,  66,  48,
      66,  48,  66,  24,  48,   3,  48, 225,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,   3,   48, 239,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,   8,  48, 255,  68,   2,
      48, 255,  51,  24,  48,   2,  48, 253,   52,  48,  67,   4,  48, 244,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  53,   54,  55,   2,  81, 249,  48,  82,  83,
      48,  84,  48,  85,   4,  48, 255,  86,    2,  48, 255,  87,   4,  48,   2,  88,
     254,  48,  56,   3,  48, 252,  86,  48,   57,  89,   2,  48, 255,  90,   7,  48,
     255,  58,  26,  48,   2,  48, 255,  91,    2,  48, 255,  92,   4,  48, 251,  91,
      93,  94,  95,  96,   5,  48, 255,  97,   69,  48,  51,  48, 253,  66,  48,  66,
       3,  48, 255,  66,   3,  48, 255,  98,    2,  99,  26,  48,  46,  48, 251, 100,
     101, 102, 101,  48,  15,  64,  24,  48,    2,  48,   2, 103, 255, 104,   9, 103,
     250, 105, 106, 107,  48, 108, 109,   3,   48, 226, 110, 111, 112,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66, 113, 114, 115,    2,  48, 255, 103,   2,  48, 255,  70,
       2,  48, 255,  66,  28,  48,  50,  48,   16,  64,  24,  48,   2,  48,  16, 103,
      16, 114, 224,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  24,  48,   3,  48, 255,   66,   9,  48, 203,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  24,  48,   4,  48, 194,  67,  48,   68,  48,  67,  48,  70,  48,  67,  48,
      68,  48,  67,  70,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  24,  48,   3,  48,  219,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  50,  48,
      35,  48,  15, 114,  16, 116,  24,  48,    2,  48,   7, 117,  81,  48,  55,  48,
     255,  21,   2,  48,   2,  22, 250,  23,   22,  24,  25,  26,  27,  24,  48,  59,
      48, 255, 118,   3,  48, 255, 119,  26,   48,   3,  48, 193, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  24,  48,   3,  48, 235,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,   5,  48, 255,  121,   5,  48, 225, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  24,  48,   2,  48,   8,
     122,   8,  48,   6, 122,  10,  48,   8,  122,   8,  48,   8, 122,  32,  48,   2,
      48,   6, 122,  11,  48, 249, 122,  48,  122,  48, 122,  48, 122,   8,  48,   8,
     122,   8,  48,   2, 123,   2, 124,   2,  125,   2, 126,   2, 127,   2, 128,   2,
     129,  26,  48,   2,  48,   8, 122,   8,   48,   8, 122,   8,  48,   8, 122,   8,
      48,   2, 122, 254,  48, 130,  10,  48,  255,  59,  25,  48,   5,  48, 255, 130,
      12,  48,   2, 122,  14,  48,   2, 122,    3,  48, 255, 131,  13,  48, 255, 130,
      36,  48,   7,  48, 254,  29,  30,  12,   48, 255,  31,  28,  48, 251,  32,  33,
      22,  34,  35,  35,  48,  16,  48, 255,  132,  33,  48,  16, 133,  24,  48,   6,
      48, 255, 134,  83,  48,  18,  48,   2,  135,   2, 136,   2, 137,   2, 136,   2,
     135,   2, 138,   2, 139,   2, 138,   2,  140,   2, 141,   2, 142,   2, 141,   2,
     140,  46,  48,  50,  48,  16, 143,  24,   48,   2,  48,  16, 144,  15, 145,   2,
      48, 255, 120,   3,  48, 248,  60,  61,   48, 130,  48, 146,  48, 134,   6,  48,
     255, 120,   2,  48, 255, 146,  33,  48,    3,  48, 221, 120,  48, 120,  48, 120,
      48, 120,  48, 120,  48, 120,  48, 120,   48, 120,  48, 120,  48, 120,  48, 120,
      48, 120,  48, 120,  48, 120,  48, 120,   48, 120,  48, 120,  48, 120,   8,  48,
     253, 134,  48, 146,  41,  48,   2,  48,   32, 147,   6, 148,  50,  48,  27,  48,
     250,  37,  38,  48,  39,  40,  41,  57,   48,   3,  48, 225, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,   3,  48, 245, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  42,  48,   3,  48, 233, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  64,  48,  37,   48, 243, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,   3,   48, 243, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  24,   48,   3,  48, 209, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  48, 120,  48, 120,  48,
     120,  48, 120,  48, 120,  48, 120,  48,  120,  48, 120,  10,  48, 253, 146,  48,
     134,   2,  48, 255, 120,  24,  48,   3,   48, 249, 120,  48, 120,  48, 120,  48,
     120,   4,  48, 255, 134,  75,  48,  63,   48, 255,  43,  26,  48,   3,  48,  26,
     149,  61,  48,  18,  48, 255,  45,  71,   48,  18,  48, 254,  46,  47,  70,  48,
      42,  48,   8, 150,   8, 151,   8, 150,   24,  48,   2,  48,   8, 152,   8, 153,
      72,  48
};

const string_desc tr_toupper_ott[105] =
{
    {  1,  1, T("\x49") }, // 1 references
    {  1,  1, T("\x53") }, // 1 references
    {  3,  1, T("\xE2\xB1\xBE") }, // 1 references
    {  3,  1, T("\xE2\xB1\xBF") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAF") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAD") }, // 1 references
    {  3,  1, T("\xE2\xB1\xB0") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA2") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAE") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA4") }, // 1 references
    {  2,  1, T("\xCE\x99") }, // 1 references
    {  2,  1, T("\xC8\xBA") }, // 1 references
    {  2,  1, T("\xC8\xBE") }, // 1 references
    {  1,  1, T("\x20") }, // 26 references
    {  2,  1, T("\x0C\x29") }, // 1 references
    {  2,  1, T("\x00\x20") }, // 61 references
    {  2,  1, T("\x06\x07") }, // 1 references
    {  2,  1, T("\x00\x01") }, // 208 references
    {  2,  1, T("\x00\x03") }, // 18 references
    {  2,  1, T("\x00\x07") }, // 10 references
    {  2,  1, T("\x01\x3F") }, // 1 references
    {  2,  1, T("\x00\x0F") }, // 8 references
    {  2,  1, T("\x0F\x03") }, // 1 references
    {  2,  1, T("\x01\x23") }, // 1 references
    {  2,  1, T("\x0E\x27") }, // 1 references
    {  2,  1, T("\x0E\x3E") }, // 1 references
    {  2,  1, T("\x00\x1F") }, // 2 references
    {  2,  1, T("\x01\x08") }, // 1 references
    {  2,  1, T("\x00\x02") }, // 2 references
    {  2,  1, T("\x00\x0E") }, // 1 references
    {  2,  1, T("\x00\x06") }, // 1 references
    {  2,  1, T("\x01\x13") }, // 1 references
    {  2,  1, T("\x0F\x12") }, // 2 references
    {  2,  1, T("\x0F\x1F") }, // 1 references
    {  2,  1, T("\x0F\x1D") }, // 1 references
    {  2,  1, T("\x0F\x16") }, // 1 references
    {  2,  1, T("\x0F\x0B") }, // 1 references
    {  2,  1, T("\x0F\x33") }, // 2 references
    {  2,  1, T("\x0F\x37") }, // 1 references
    {  2,  1, T("\x0F\x3F") }, // 2 references
    {  2,  1, T("\x0F\x2F") }, // 1 references
    {  2,  1, T("\x0F\x2A") }, // 1 references
    {  2,  1, T("\x0C\x26") }, // 2 references
    {  2,  1, T("\x0C\x2A") }, // 1 references
    {  2,  1, T("\x03\x0D") }, // 1 references
    {  2,  1, T("\x0C\x3B") }, // 1 references
    {  2,  1, T("\x0C\x39") }, // 1 references
    {  2,  1, T("\x03\x09") }, // 1 references
    {  2,  1, T("\x0C\x25") }, // 1 references
    {  2,  1, T("\x02\x06") }, // 1 references
    {  2,  1, T("\x02\x02") }, // 2 references
    {  2,  1, T("\x00\x2A") }, // 1 references
    {  2,  1, T("\x00\x25") }, // 2 references
    {  2,  1, T("\x00\x27") }, // 1 references
    {  2,  1, T("\x01\x20") }, // 28 references
    {  2,  1, T("\x01\x21") }, // 1 references
    {  2,  1, T("\x01\x00") }, // 1 references
    {  2,  1, T("\x01\x03") }, // 1 references
    {  2,  1, T("\x01\x01") }, // 1 references
    {  2,  1, T("\x01\x02") }, // 1 references
    {  2,  1, T("\x01\x09") }, // 1 references
    {  2,  1, T("\x01\x33") }, // 1 references
    {  2,  1, T("\x01\x36") }, // 1 references
    {  2,  1, T("\x00\x18") }, // 1 references
    {  2,  1, T("\x01\x2A") }, // 1 references
    {  2,  1, T("\x01\x10") }, // 32 references
    {  2,  1, T("\x00\x0B") }, // 1 references
    {  2,  1, T("\x00\x30") }, // 16 references
    {  2,  1, T("\x03\x10") }, // 7 references
    {  3,  1, T("\x0B\x28\x04") }, // 1 references
    {  3,  1, T("\x03\x04\x1E") }, // 1 references
    {  3,  1, T("\x00\x00\x01") }, // 252 references
    {  3,  1, T("\x00\x03\x3B") }, // 1 references
    {  3,  1, T("\x00\x00\x08") }, // 78 references
    {  3,  1, T("\x00\x03\x0A") }, // 2 references
    {  3,  1, T("\x00\x02\x3A") }, // 2 references
    {  3,  1, T("\x00\x02\x3E") }, // 2 references
    {  3,  1, T("\x00\x02\x2C") }, // 2 references
    {  3,  1, T("\x00\x02\x00") }, // 2 references
    {  3,  1, T("\x00\x02\x10") }, // 2 references
    {  3,  1, T("\x00\x02\x06") }, // 2 references
    {  3,  1, T("\x00\x00\x0F") }, // 4 references
    {  3,  1, T("\x00\x00\x09") }, // 1 references
    {  3,  1, T("\x00\x01\x3C") }, // 1 references
    {  3,  1, T("\x00\x00\x10") }, // 16 references
    {  3,  1, T("\x00\x00\x07") }, // 5 references
    {  3,  1, T("\x00\x01\x26") }, // 4 references
    {  3,  1, T("\x00\x01\x2A") }, // 4 references
    {  3,  1, T("\x00\x01\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x1A") }, // 4 references
    {  3,  1, T("\x00\x00\x1E") }, // 2 references
    {  3,  1, T("\x00\x00\x26") }, // 4 references
    {  3,  1, T("\x00\x00\x2A") }, // 4 references
    {  3,  1, T("\x00\x00\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x30") }, // 16 references
    {  3,  1, T("\x00\x01\x10") }, // 16 references
    {  3,  1, T("\x00\x01\x30") }, // 15 references
    {  3,  1, T("\x00\x00\x03") }, // 4 references
    {  3,  1, T("\x03\x36\x20") }, // 32 references
    {  3,  1, T("\x03\x37\x20") }, // 6 references
    {  3,  1, T("\x00\x01\x20") }, // 26 references
    {  4,  1, T("\x00\x00\x00\x28") }, // 16 references
    {  4,  1, T("\x00\x00\x00\x38") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x18") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x28") } // 8 references
};

// utf/tr_totitle.txt
//
// 1040 code points.
// 48 states, 90 columns, 1811 bytes
//
const unsigned char tr_totitle_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   1,   1,   1,   1,   1,
       1,   1,   1,   1,   1,   1,   1,   1,    1,   1,   1,   0,   0,   0,   0,   0,

       2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  37,  38,  39,  40,  41,   42,  43,  44,  45,  46,  47,  48,  49,
      50,  51,  52,  53,  54,  55,  56,  57,   58,  59,  60,  61,  62,  63,  64,  65,
       0,   0,  66,  67,  68,  69,  70,  71,   72,  73,  74,   0,   0,  75,  76,  77,
      78,  79,  80,  81,  82,  83,  84,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,  85,  86,   0,   0,   0,   0,   0,    0,   0,  87,   0,   0,   0,   0,  88,
      89,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_totitle_sot[48] =
{
        0,   30,   36,   48,  116,  187,  260,  326,   390,  453,  475,  493,  505,  567,  573,  614,
      676,  743,  785,  793,  799,  816,  826,  894,   958,  976, 1012, 1037, 1059, 1078, 1088, 1094,
     1124, 1130, 1161, 1207, 1215, 1226, 1276, 1304,  1338, 1400, 1416, 1422, 1428, 1434, 1441, 1451

};

const unsigned char tr_totitle_sbt[1459] =
{
     254,  48,  62,  64,  48, 232,   1,   2,    3,   4,   5,   6,   7,   8,   9,  10,
      11,  12,  13,  14,  15,  16,  17,  18,   19,  20,  28,  36,  42,  44,  55,  48,
     255,  63,  34,  48,  34,  48,  23,  64,  255,  48,   7,  64, 255,  65,  24,  48,
       3,  48, 201,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  49,  48,  66,  48,  66,   48,  66,   2,  48, 251,  67,  48,  68,
      48,  67,  25,  48,   2,  48, 247,  69,   48,  67,  48,  68,  48,  67,  48,  70,
       2,  48, 211,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
       2,  48, 250,  67,  48,  68,  48,  67,   50,  24,  48,   2,  48, 255,  71,   2,
      48, 253,  66,  48,  66,   2,  48, 255,   70,   3,  48, 255,  68,   5,  48, 255,
      67,   2,  48, 255,  72,   3,  48, 254,   66,  73,   3,  48, 255,  74,   2,  48,
     251,  66,  48,  66,  48,  66,   2,  48,  255,  70,   4,  48, 255,  66,   2,  48,
     255,  75,   3,  48, 253,  68,  48,  67,    2,  48, 255,  66,   3,  48, 253,  66,
      48,  76,  24,  48,   6,  48, 251,  66,   77,  67,  70,  77,   2,  66, 213,  77,
      68,  48,  67,  48,  75,  48,  67,  48,   68,  48,  67,  48,  70,  48,  67,  48,
      68,  78,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  67,  77,  66,   48,  66,   3,  48, 249,  66,  48,  66,
      48,  66,  48,  66,  24,  48,   3,  48,  225,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,    3,  48, 239,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,   8,  48, 255,  68,
       2,  48, 255,  51,  24,  48,   2,  48,  253,  52,  48,  67,   4,  48, 244,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   53,  54,  55,   2,  79, 249,  48,  80,
      81,  48,  82,  48,  83,   4,  48, 255,   84,   2,  48, 255,  85,   4,  48,   2,
      86, 254,  48,  56,   3,  48, 252,  84,   48,  57,  87,   2,  48, 255,  88,   7,
      48, 255,  58,  26,  48,   2,  48, 255,   89,   2,  48, 255,  90,   4,  48, 251,
      89,  91,  92,  93,  94,   5,  48, 255,   95,  69,  48,  51,  48, 253,  66,  48,
      66,   3,  48, 255,  66,   3,  48, 255,   96,   2,  97,  26,  48,  46,  48, 251,
      98,  99, 100,  99,  48,  15,  64,  24,   48,   2,  48,   2, 101, 255, 102,   9,
     101, 250, 103, 104, 105,  48, 106, 107,    3,  48, 226, 108, 109, 110,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66, 111, 112,  113,   2,  48, 255, 101,   2,  48, 255,
      70,   2,  48, 255,  66,  28,  48,  50,   48,  16,  64,  24,  48,   2,  48,  16,
     101,  16, 112, 224,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  24,  48,   3,  48,  255,  66,   9,  48, 203,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  48,  66,  48,  66,  48,  66,   48,  66,  48,  66,  48,  66,  48,  66,
      48,  66,  24,  48,   4,  48, 194,  67,   48,  68,  48,  67,  48,  70,  48,  67,
      48,  68,  48,  67,  70,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  24,  48,   3,   48, 219,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  48,
      66,  48,  66,  48,  66,  48,  66,  48,   66,  48,  66,  48,  66,  48,  66,  50,
      48,  35,  48,  15, 112,  16, 114,  24,   48,   2,  48,   7, 115,  81,  48,  55,
      48, 255,  21,   2,  48,   2,  22, 250,   23,  22,  24,  25,  26,  27,  24,  48,
      59,  48, 255, 116,   3,  48, 255, 117,   26,  48,   3,  48, 193, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  24,  48,   3,  48,
     235, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,   5,  48,  255, 119,   5,  48, 225, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  24,  48,   2,  48,
       8, 120,   8,  48,   6, 120,  10,  48,    8, 120,   8,  48,   8, 120,  32,  48,
       2,  48,   6, 120,  11,  48, 249, 120,   48, 120,  48, 120,  48, 120,   8,  48,
       8, 120,   8,  48,   2, 121,   2, 122,    2, 123,   2, 124,   2, 125,   2, 126,
       2, 127,  26,  48,   2,  48,   8, 120,    8,  48,   8, 120,   8,  48,   8, 120,
       8,  48,   2, 120, 254,  48, 128,  10,   48, 255,  59,  25,  48,   5,  48, 255,
     128,  12,  48,   2, 120,  14,  48,   2,  120,   3,  48, 255, 129,  13,  48, 255,
     128,  36,  48,   7,  48, 254,  29,  30,   12,  48, 255,  31,  28,  48, 251,  32,
      33,  22,  34,  35,  35,  48,  16,  48,  255, 130,  33,  48,  16, 131,  24,  48,
       6,  48, 255, 132,  83,  48,  18,  48,    2, 133,   2, 134,   2, 135,   2, 134,
       2, 133,   2, 136,   2, 137,   2, 136,    2, 138,   2, 139,   2, 140,   2, 139,
       2, 138,  46,  48,  50,  48,  16, 141,   24,  48,   2,  48,  16, 142,  15, 143,
       2,  48, 255, 118,   3,  48, 248,  60,   61,  48, 128,  48, 144,  48, 132,   6,
      48, 255, 118,   2,  48, 255, 144,  33,   48,   3,  48, 221, 118,  48, 118,  48,
     118,  48, 118,  48, 118,  48, 118,  48,  118,  48, 118,  48, 118,  48, 118,  48,
     118,  48, 118,  48, 118,  48, 118,  48,  118,  48, 118,  48, 118,  48, 118,   8,
      48, 253, 132,  48, 144,  41,  48,   2,   48,  32, 145,   6, 146,  50,  48,  27,
      48, 250,  37,  38,  48,  39,  40,  41,   57,  48,   3,  48, 225, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,   3,  48, 245, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  42,  48,   3,  48, 233, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  64,  48,   37,  48, 243, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,    3,  48, 243, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   24,  48,   3,  48, 209, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  48, 118,  48, 118,
      48, 118,  48, 118,  48, 118,  48, 118,   48, 118,  48, 118,  10,  48, 253, 144,
      48, 132,   2,  48, 255, 118,  24,  48,    3,  48, 249, 118,  48, 118,  48, 118,
      48, 118,   4,  48, 255, 132,  75,  48,   63,  48, 255,  43,  26,  48,   3,  48,
      26, 147,  61,  48,  18,  48, 255,  45,   71,  48,  18,  48, 254,  46,  47,  70,
      48,  42,  48,   8, 148,   8, 149,   8,  148,  24,  48,   2,  48,   8, 150,   8,
     151,  72,  48
};

const string_desc tr_totitle_ott[103] =
{
    {  1,  1, T("\x49") }, // 1 references
    {  1,  1, T("\x53") }, // 1 references
    {  3,  1, T("\xE2\xB1\xBE") }, // 1 references
    {  3,  1, T("\xE2\xB1\xBF") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAF") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAD") }, // 1 references
    {  3,  1, T("\xE2\xB1\xB0") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA2") }, // 1 references
    {  3,  1, T("\xE2\xB1\xAE") }, // 1 references
    {  3,  1, T("\xE2\xB1\xA4") }, // 1 references
    {  2,  1, T("\xCE\x99") }, // 1 references
    {  2,  1, T("\xC8\xBA") }, // 1 references
    {  2,  1, T("\xC8\xBE") }, // 1 references
    {  1,  1, T("\x20") }, // 26 references
    {  2,  1, T("\x0C\x29") }, // 1 references
    {  2,  1, T("\x00\x20") }, // 61 references
    {  2,  1, T("\x06\x07") }, // 1 references
    {  2,  1, T("\x00\x01") }, // 210 references
    {  2,  1, T("\x00\x03") }, // 19 references
    {  2,  1, T("\x00\x07") }, // 11 references
    {  2,  1, T("\x01\x3F") }, // 1 references
    {  2,  1, T("\x00\x0F") }, // 8 references
    {  2,  1, T("\x0F\x03") }, // 1 references
    {  2,  1, T("\x01\x23") }, // 1 references
    {  2,  1, T("\x0E\x27") }, // 1 references
    {  2,  1, T("\x0E\x3E") }, // 1 references
    {  2,  1, T("\x00\x1F") }, // 2 references
    {  2,  1, T("\x01\x08") }, // 1 references
    {  2,  1, T("\x00\x00") }, // 4 references
    {  2,  1, T("\x01\x13") }, // 1 references
    {  2,  1, T("\x0F\x12") }, // 2 references
    {  2,  1, T("\x0F\x1F") }, // 1 references
    {  2,  1, T("\x0F\x1D") }, // 1 references
    {  2,  1, T("\x0F\x16") }, // 1 references
    {  2,  1, T("\x0F\x0B") }, // 1 references
    {  2,  1, T("\x0F\x33") }, // 2 references
    {  2,  1, T("\x0F\x37") }, // 1 references
    {  2,  1, T("\x0F\x3F") }, // 2 references
    {  2,  1, T("\x0F\x2F") }, // 1 references
    {  2,  1, T("\x0F\x2A") }, // 1 references
    {  2,  1, T("\x0C\x26") }, // 2 references
    {  2,  1, T("\x0C\x2A") }, // 1 references
    {  2,  1, T("\x03\x0D") }, // 1 references
    {  2,  1, T("\x0C\x3B") }, // 1 references
    {  2,  1, T("\x0C\x39") }, // 1 references
    {  2,  1, T("\x03\x09") }, // 1 references
    {  2,  1, T("\x0C\x25") }, // 1 references
    {  2,  1, T("\x02\x06") }, // 1 references
    {  2,  1, T("\x02\x02") }, // 2 references
    {  2,  1, T("\x00\x2A") }, // 1 references
    {  2,  1, T("\x00\x25") }, // 2 references
    {  2,  1, T("\x00\x27") }, // 1 references
    {  2,  1, T("\x01\x20") }, // 28 references
    {  2,  1, T("\x01\x21") }, // 1 references
    {  2,  1, T("\x01\x00") }, // 1 references
    {  2,  1, T("\x01\x03") }, // 1 references
    {  2,  1, T("\x01\x01") }, // 1 references
    {  2,  1, T("\x01\x02") }, // 1 references
    {  2,  1, T("\x01\x09") }, // 1 references
    {  2,  1, T("\x01\x33") }, // 1 references
    {  2,  1, T("\x01\x36") }, // 1 references
    {  2,  1, T("\x00\x18") }, // 1 references
    {  2,  1, T("\x01\x2A") }, // 1 references
    {  2,  1, T("\x01\x10") }, // 32 references
    {  2,  1, T("\x00\x0B") }, // 1 references
    {  2,  1, T("\x00\x30") }, // 16 references
    {  2,  1, T("\x03\x10") }, // 7 references
    {  3,  1, T("\x0B\x28\x04") }, // 1 references
    {  3,  1, T("\x03\x04\x1E") }, // 1 references
    {  3,  1, T("\x00\x00\x01") }, // 252 references
    {  3,  1, T("\x00\x03\x3B") }, // 1 references
    {  3,  1, T("\x00\x00\x08") }, // 78 references
    {  3,  1, T("\x00\x03\x0A") }, // 2 references
    {  3,  1, T("\x00\x02\x3A") }, // 2 references
    {  3,  1, T("\x00\x02\x3E") }, // 2 references
    {  3,  1, T("\x00\x02\x2C") }, // 2 references
    {  3,  1, T("\x00\x02\x00") }, // 2 references
    {  3,  1, T("\x00\x02\x10") }, // 2 references
    {  3,  1, T("\x00\x02\x06") }, // 2 references
    {  3,  1, T("\x00\x00\x0F") }, // 4 references
    {  3,  1, T("\x00\x00\x09") }, // 1 references
    {  3,  1, T("\x00\x01\x3C") }, // 1 references
    {  3,  1, T("\x00\x00\x10") }, // 16 references
    {  3,  1, T("\x00\x00\x07") }, // 5 references
    {  3,  1, T("\x00\x01\x26") }, // 4 references
    {  3,  1, T("\x00\x01\x2A") }, // 4 references
    {  3,  1, T("\x00\x01\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x1A") }, // 4 references
    {  3,  1, T("\x00\x00\x1E") }, // 2 references
    {  3,  1, T("\x00\x00\x26") }, // 4 references
    {  3,  1, T("\x00\x00\x2A") }, // 4 references
    {  3,  1, T("\x00\x00\x2E") }, // 2 references
    {  3,  1, T("\x00\x00\x30") }, // 16 references
    {  3,  1, T("\x00\x01\x10") }, // 16 references
    {  3,  1, T("\x00\x01\x30") }, // 15 references
    {  3,  1, T("\x00\x00\x03") }, // 4 references
    {  3,  1, T("\x03\x36\x20") }, // 32 references
    {  3,  1, T("\x03\x37\x20") }, // 6 references
    {  3,  1, T("\x00\x01\x20") }, // 26 references
    {  4,  1, T("\x00\x00\x00\x28") }, // 16 references
    {  4,  1, T("\x00\x00\x00\x38") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x18") }, // 8 references
    {  4,  1, T("\x00\x00\x01\x28") } // 8 references
};

// utf/tr_foldmatch.txt
//
// 14 code points.
// 7 states, 11 columns, 310 bytes
//
const unsigned char tr_foldmatch_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   1,   0,   0,   0,   0,   1,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       2,   0,   3,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    4,   4,   4,   4,   5,   6,   6,   6,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   7,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   8,   9,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,  10,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned char tr_foldmatch_sot[7] =
{
        0,    9,   15,   23,   29,   35,   41
};

const unsigned char tr_foldmatch_sbt[47] =
{
     254,   7,  10,   6,   7, 253,   1,   3,    5,   2,   7, 255,   2,   8,   7,   4,
       7, 255,   8,   2,   9,   4,   7,   2,    7, 255,   4,   8,   7,   6,   7, 255,
       9,   4,   7,   7,   7, 255,   6,   3,    7,   3,   7, 255,   9,   7,   7
};

const string_desc tr_foldmatch_ott[3] =
{
    {  1,  1, T("\x27") }, // 4 references
    {  1,  1, T("\x22") }, // 8 references
    {  1,  1, T("\x00") } // 2 references
};

// utf/tr_Color.txt
//
// 2053 code points.
// 37 states, 67 columns, 4820 bytes
//
const unsigned char tr_color_itt[256] =
{
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,

       1,   2,   3,   4,   5,   6,   7,   8,    9,  10,  11,  12,  13,  14,  15,  16,
      17,  18,  19,  20,  21,  22,  23,  24,   25,  26,  27,  28,  29,  30,  31,  32,
      33,  34,  35,  36,  37,  38,  39,  40,   41,  42,  43,  44,  45,  46,  47,  48,
      49,  50,  51,  52,  53,  54,  55,  56,   57,  58,  59,  60,  61,  62,  63,  64,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,  65,
       0,   0,   0,  66,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0

};

const unsigned short tr_color_sot[37] =
{
        0,    5,   22,   35,  103,  171,  239,  307,   375,  443,  511,  579,  585,  613,  681,  749,
      817,  885,  953, 1021, 1089, 1157, 1225, 1293,  1361, 1429, 1497, 1565, 1633, 1701, 1769, 1837,
     1905, 1973, 2041, 2109, 2177
};

const unsigned short tr_color_sbt[2245] =
{
      65,  37, 254,   1,  11,  21,  37, 255,    2,   3,  37, 248,   3,   4,   5,   6,
       7,   8,   9,  10,  34,  37, 253,  37,   38,  39,   2,  37, 252,  40,  41,  37,
      42,  58,  37, 191,  37,  43,  44,  45,   46,  47,  48,  49,  50,  51,  52,  53,
      54,  55,  56,  57,  58,  59,  60,  61,   62,  63,  64,  65,  66,  67,  68,  69,
      70,  71,  72,  73,  74,  75,  76,  77,   78,  79,  80,  81,  82,  83,  84,  85,
      86,  87,  88,  89,  90,  91,  92,  93,   94,  95,  96,  97,  98,  99, 100, 101,
     102, 103, 104, 105, 106,   2,  37, 191,   37, 107, 108, 109, 110, 111, 112, 113,
     114, 115, 116, 117, 118, 119, 120, 121,  122, 123, 124, 125, 126, 127, 128, 129,
     130, 131, 132, 133, 134, 135, 136, 137,  138, 139, 140, 141, 142, 143, 144, 145,
     146, 147, 148, 149, 150, 151, 152, 153,  154, 155, 156, 157, 158, 159, 160, 161,
     162, 163, 164, 165, 166, 167, 168, 169,  170,   2,  37, 191,  37, 171, 172, 173,
     174, 175, 176, 177, 178, 179, 180, 181,  182, 183, 184, 185, 186, 187, 188, 189,
     190, 191, 192, 193, 194, 195, 196, 197,  198, 199, 200, 201, 202, 203, 204, 205,
     206, 207, 208, 209, 210, 211, 212, 213,  214, 215, 216, 217, 218, 219, 220, 221,
     222, 223, 224, 225, 226, 227, 228, 229,  230, 231, 232, 233, 234,   2,  37, 191,
      37, 235, 236, 237, 238, 239, 240, 241,  242, 243, 244, 245, 246, 247, 248, 249,
     250, 251, 252, 253, 254, 255, 256, 257,  258, 259, 260, 261, 262, 263, 264, 265,
     266, 267, 268, 269, 270, 271, 272, 273,  274, 275, 276, 277, 278, 279, 280, 281,
     282, 283, 284, 285, 286, 287, 288, 289,  290, 291, 292, 293, 294, 295, 296, 297,
     298,   2,  37, 191,  37, 299, 300, 301,  302, 303, 304, 305, 306, 307, 308, 309,
     310, 311, 312, 313, 314, 315, 316, 317,  318, 319, 320, 321, 322, 323, 324, 325,
     326, 327, 328, 329, 330, 331, 332, 333,  334, 335, 336, 337, 338, 339, 340, 341,
     342, 343, 344, 345, 346, 347, 348, 349,  350, 351, 352, 353, 354, 355, 356, 357,
     358, 359, 360, 361, 362,   2,  37, 191,   37, 363, 364, 365, 366, 367, 368, 369,
     370, 371, 372, 373, 374, 375, 376, 377,  378, 379, 380, 381, 382, 383, 384, 385,
     386, 387, 388, 389, 390, 391, 392, 393,  394, 395, 396, 397, 398, 399, 400, 401,
     402, 403, 404, 405, 406, 407, 408, 409,  410, 411, 412, 413, 414, 415, 416, 417,
     418, 419, 420, 421, 422, 423, 424, 425,  426,   2,  37, 191,  37, 427, 428, 429,
     430, 431, 432, 433, 434, 435, 436, 437,  438, 439, 440, 441, 442, 443, 444, 445,
     446, 447, 448, 449, 450, 451, 452, 453,  454, 455, 456, 457, 458, 459, 460, 461,
     462, 463, 464, 465, 466, 467, 468, 469,  470, 471, 472, 473, 474, 475, 476, 477,
     478, 479, 480, 481, 482, 483, 484, 485,  486, 487, 488, 489, 490,   2,  37, 191,
      37, 491, 492, 493, 494, 495, 496, 497,  498, 499, 500, 501, 502, 503, 504, 505,
     506, 507, 508, 509, 510, 511, 512, 513,  514, 515, 516, 517, 518, 519, 520, 521,
     522, 523, 524, 525, 526, 527, 528, 529,  530, 531, 532, 533, 534, 535, 536, 537,
     538, 539, 540, 541, 542, 543, 544, 545,  546, 547, 548, 549, 550, 551, 552, 553,
     554,   2,  37,  49,  37, 255,  12,  17,   37, 231,  37,  13,  14,  15,  16,  17,
      18,  19,  20,  21,  22,  23,  24,  25,   26,  27,  28,  29,  30,  31,  32,  33,
      34,  35,  36,  42,  37, 191,  37, 555,  556, 557, 558, 559, 560, 561, 562, 563,
     564, 565, 566, 567, 568, 569, 570, 571,  572, 573, 574, 575, 576, 577, 578, 579,
     580, 581, 582, 583, 584, 585, 586, 587,  588, 589, 590, 591, 592, 593, 594, 595,
     596, 597, 598, 599, 600, 601, 602, 603,  604, 605, 606, 607, 608, 609, 610, 611,
     612, 613, 614, 615, 616, 617, 618,   2,   37, 191,  37, 619, 620, 621, 622, 623,
     624, 625, 626, 627, 628, 629, 630, 631,  632, 633, 634, 635, 636, 637, 638, 639,
     640, 641, 642, 643, 644, 645, 646, 647,  648, 649, 650, 651, 652, 653, 654, 655,
     656, 657, 658, 659, 660, 661, 662, 663,  664, 665, 666, 667, 668, 669, 670, 671,
     672, 673, 674, 675, 676, 677, 678, 679,  680, 681, 682,   2,  37, 191,  37, 683,
     684, 685, 686, 687, 688, 689, 690, 691,  692, 693, 694, 695, 696, 697, 698, 699,
     700, 701, 702, 703, 704, 705, 706, 707,  708, 709, 710, 711, 712, 713, 714, 715,
     716, 717, 718, 719, 720, 721, 722, 723,  724, 725, 726, 727, 728, 729, 730, 731,
     732, 733, 734, 735, 736, 737, 738, 739,  740, 741, 742, 743, 744, 745, 746,   2,
      37, 191,  37, 747, 748, 749, 750, 751,  752, 753, 754, 755, 756, 757, 758, 759,
     760, 761, 762, 763, 764, 765, 766, 767,  768, 769, 770, 771, 772, 773, 774, 775,
     776, 777, 778, 779, 780, 781, 782, 783,  784, 785, 786, 787, 788, 789, 790, 791,
     792, 793, 794, 795, 796, 797, 798, 799,  800, 801, 802, 803, 804, 805, 806, 807,
     808, 809, 810,   2,  37, 191,  37, 811,  812, 813, 814, 815, 816, 817, 818, 819,
     820, 821, 822, 823, 824, 825, 826, 827,  828, 829, 830, 831, 832, 833, 834, 835,
     836, 837, 838, 839, 840, 841, 842, 843,  844, 845, 846, 847, 848, 849, 850, 851,
     852, 853, 854, 855, 856, 857, 858, 859,  860, 861, 862, 863, 864, 865, 866, 867,
     868, 869, 870, 871, 872, 873, 874,   2,   37, 191,  37, 875, 876, 877, 878, 879,
     880, 881, 882, 883, 884, 885, 886, 887,  888, 889, 890, 891, 892, 893, 894, 895,
     896, 897, 898, 899, 900, 901, 902, 903,  904, 905, 906, 907, 908, 909, 910, 911,
     912, 913, 914, 915, 916, 917, 918, 919,  920, 921, 922, 923, 924, 925, 926, 927,
     928, 929, 930, 931, 932, 933, 934, 935,  936, 937, 938,   2,  37, 191,  37, 939,
     940, 941, 942, 943, 944, 945, 946, 947,  948, 949, 950, 951, 952, 953, 954, 955,
     956, 957, 958, 959, 960, 961, 962, 963,  964, 965, 966, 967, 968, 969, 970, 971,
     972, 973, 974, 975, 976, 977, 978, 979,  980, 981, 982, 983, 984, 985, 986, 987,
     988, 989, 990, 991, 992, 993, 994, 995,  996, 997, 998, 999, 1000, 1001, 1002,   2,
      37, 191,  37, 1003, 1004, 1005, 1006, 1007,  1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015,
     1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023,  1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031,
     1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039,  1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047,
     1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,  1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063,
     1064, 1065, 1066,   2,  37, 191,  37, 1067,  1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075,
     1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083,  1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091,
     1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099,  1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107,
     1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115,  1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123,
     1124, 1125, 1126, 1127, 1128, 1129, 1130,   2,   37, 191,  37, 1131, 1132, 1133, 1134, 1135,
     1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143,  1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151,
     1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159,  1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167,
     1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175,  1176, 1177, 1178, 1179, 1180, 1181, 1182, 1183,
     1184, 1185, 1186, 1187, 1188, 1189, 1190, 1191,  1192, 1193, 1194,   2,  37, 191,  37, 1195,
     1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203,  1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211,
     1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219,  1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227,
     1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235,  1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243,
     1244, 1245, 1246, 1247, 1248, 1249, 1250, 1251,  1252, 1253, 1254, 1255, 1256, 1257, 1258,   2,
      37, 191,  37, 1259, 1260, 1261, 1262, 1263,  1264, 1265, 1266, 1267, 1268, 1269, 1270, 1271,
     1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279,  1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287,
     1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295,  1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303,
     1304, 1305, 1306, 1307, 1308, 1309, 1310, 1311,  1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319,
     1320, 1321, 1322,   2,  37, 191,  37, 1323,  1324, 1325, 1326, 1327, 1328, 1329, 1330, 1331,
     1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339,  1340, 1341, 1342, 1343, 1344, 1345, 1346, 1347,
     1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355,  1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363,
     1364, 1365, 1366, 1367, 1368, 1369, 1370, 1371,  1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379,
     1380, 1381, 1382, 1383, 1384, 1385, 1386,   2,   37, 191,  37, 1387, 1388, 1389, 1390, 1391,
     1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399,  1400, 1401, 1402, 1403, 1404, 1405, 1406, 1407,
     1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415,  1416, 1417, 1418, 1419, 1420, 1421, 1422, 1423,
     1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431,  1432, 1433, 1434, 1435, 1436, 1437, 1438, 1439,
     1440, 1441, 1442, 1443, 1444, 1445, 1446, 1447,  1448, 1449, 1450,   2,  37, 191,  37, 1451,
     1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459,  1460, 1461, 1462, 1463, 1464, 1465, 1466, 1467,
     1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475,  1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483,
     1484, 1485, 1486, 1487, 1488, 1489, 1490, 1491,  1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499,
     1500, 1501, 1502, 1503, 1504, 1505, 1506, 1507,  1508, 1509, 1510, 1511, 1512, 1513, 1514,   2,
      37, 191,  37, 1515, 1516, 1517, 1518, 1519,  1520, 1521, 1522, 1523, 1524, 1525, 1526, 1527,
     1528, 1529, 1530, 1531, 1532, 1533, 1534, 1535,  1536, 1537, 1538, 1539, 1540, 1541, 1542, 1543,
     1544, 1545, 1546, 1547, 1548, 1549, 1550, 1551,  1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559,
     1560, 1561, 1562, 1563, 1564, 1565, 1566, 1567,  1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575,
     1576, 1577, 1578,   2,  37, 191,  37, 1579,  1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587,
     1588, 1589, 1590, 1591, 1592, 1593, 1594, 1595,  1596, 1597, 1598, 1599, 1600, 1601, 1602, 1603,
     1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611,  1612, 1613, 1614, 1615, 1616, 1617, 1618, 1619,
     1620, 1621, 1622, 1623, 1624, 1625, 1626, 1627,  1628, 1629, 1630, 1631, 1632, 1633, 1634, 1635,
     1636, 1637, 1638, 1639, 1640, 1641, 1642,   2,   37, 191,  37, 1643, 1644, 1645, 1646, 1647,
     1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655,  1656, 1657, 1658, 1659, 1660, 1661, 1662, 1663,
     1664, 1665, 1666, 1667, 1668, 1669, 1670, 1671,  1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679,
     1680, 1681, 1682, 1683, 1684, 1685, 1686, 1687,  1688, 1689, 1690, 1691, 1692, 1693, 1694, 1695,
     1696, 1697, 1698, 1699, 1700, 1701, 1702, 1703,  1704, 1705, 1706,   2,  37, 191,  37, 1707,
     1708, 1709, 1710, 1711, 1712, 1713, 1714, 1715,  1716, 1717, 1718, 1719, 1720, 1721, 1722, 1723,
     1724, 1725, 1726, 1727, 1728, 1729, 1730, 1731,  1732, 1733, 1734, 1735, 1736, 1737, 1738, 1739,
     1740, 1741, 1742, 1743, 1744, 1745, 1746, 1747,  1748, 1749, 1750, 1751, 1752, 1753, 1754, 1755,
     1756, 1757, 1758, 1759, 1760, 1761, 1762, 1763,  1764, 1765, 1766, 1767, 1768, 1769, 1770,   2,
      37, 191,  37, 1771, 1772, 1773, 1774, 1775,  1776, 1777, 1778, 1779, 1780, 1781, 1782, 1783,
     1784, 1785, 1786, 1787, 1788, 1789, 1790, 1791,  1792, 1793, 1794, 1795, 1796, 1797, 1798, 1799,
     1800, 1801, 1802, 1803, 1804, 1805, 1806, 1807,  1808, 1809, 1810, 1811, 1812, 1813, 1814, 1815,
     1816, 1817, 1818, 1819, 1820, 1821, 1822, 1823,  1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831,
     1832, 1833, 1834,   2,  37, 191,  37, 1835,  1836, 1837, 1838, 1839, 1840, 1841, 1842, 1843,
     1844, 1845, 1846, 1847, 1848, 1849, 1850, 1851,  1852, 1853, 1854, 1855, 1856, 1857, 1858, 1859,
     1860, 1861, 1862, 1863, 1864, 1865, 1866, 1867,  1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875,
     1876, 1877, 1878, 1879, 1880, 1881, 1882, 1883,  1884, 1885, 1886, 1887, 1888, 1889, 1890, 1891,
     1892, 1893, 1894, 1895, 1896, 1897, 1898,   2,   37, 191,  37, 1899, 1900, 1901, 1902, 1903,
     1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911,  1912, 1913, 1914, 1915, 1916, 1917, 1918, 1919,
     1920, 1921, 1922, 1923, 1924, 1925, 1926, 1927,  1928, 1929, 1930, 1931, 1932, 1933, 1934, 1935,
     1936, 1937, 1938, 1939, 1940, 1941, 1942, 1943,  1944, 1945, 1946, 1947, 1948, 1949, 1950, 1951,
     1952, 1953, 1954, 1955, 1956, 1957, 1958, 1959,  1960, 1961, 1962,   2,  37, 191,  37, 1963,
     1964, 1965, 1966, 1967, 1968, 1969, 1970, 1971,  1972, 1973, 1974, 1975, 1976, 1977, 1978, 1979,
     1980, 1981, 1982, 1983, 1984, 1985, 1986, 1987,  1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995,
     1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003,  2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011,
     2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019,  2020, 2021, 2022, 2023, 2024, 2025, 2026,   2,
      37, 191,  37, 2027, 2028, 2029, 2030, 2031,  2032, 2033, 2034, 2035, 2036, 2037, 2038, 2039,
     2040, 2041, 2042, 2043, 2044, 2045, 2046, 2047,  2048, 2049, 2050, 2051, 2052, 2053, 2054, 2055,
     2056, 2057, 2058, 2059, 2060, 2061, 2062, 2063,  2064, 2065, 2066, 2067, 2068, 2069, 2070, 2071,
     2072, 2073, 2074, 2075, 2076, 2077, 2078, 2079,  2080, 2081, 2082, 2083, 2084, 2085, 2086, 2087,
     2088, 2089, 2090,   2,  37
};
