window.addEventListener("load", function(e) {timeline.setupCalendar(e)}, true);

var timeline = {

	setupCalendar: function setupCalendar() {
		//setting up listeners etc
		if (this.calendar == null) {
			this.calendar = getCompositeCalendar();
		}
		if (this.calendar) {
			this.calendar.removeObserver(this.calendarObserver);
		}
		this.calendar.addObserver(this.calendarObserver);
		if (this.mListener) {
			this.mListener.updatePeriod();
		}
	},
	
	calendarOpListener: {
		onOperationComplete: function timeline_onOC(calendarObserver, status, optype, id, detail) {
		},
		
		onGetResult: function timeline__onGR(calendarObserver, status, itemtype, detail, count, items) {
  			if (!Components.isSuccessCode(status)) {
				return;
			}
			items.forEach(this.timeline.addItem, this.timeline);
		}
	},
	
	calendarObserver: {
		QueryInterface: function timeline_QI(aIID) {
			if (!aIID.equals(Components.interfaces.calIObserver) &&
			!aIID.equals(Components.interfaces.calICompositeObserver) &&
			!aIID.equals(Components.interfaces.nsISupports)) {
				throw Components.results.NS_ERROR_NO_INTERFACE;
			}
			return this;
		},
		
		onAddItem: function timeline_onAddItem(item) {
    		refresh();
		},
		
		onDeleteItem: function timeline_onDeleteItem(item, rebuildFlag) {
    		refresh();
		},

		onModifyItem: function timeline_onModifyItem(newItem, oldItem) {
		    refresh();
		},

		onCalendarAdded: function timeline_calAdd(aCalendar) {
    		refresh();
		},
		
		onCalendarRemoved: function timeline_calRemove(aCalendar) {
    		refresh();
		},
		
		onError: function(cal, errno, msg) {
		},

		onStartBatch: function timeline_onStartBatch() {
			this.mBatchCount++;
		},

		onEndBatch: function() {
    		this.mBatchCount--;
			if (this.mBatchCount == 0) {
				this.timeline.refreshCalendarQuery();
			}
		},

		onPropertyChanged: function(aCalendar, aName, aValue, aOldValue) {
		},

		onPropertyDeleting: function(aCalendar, aName) {
		},

		onDefaultCalendarChanged: function(aCalendar) {
		},

		onLoad: function() {
    		refresh();
		}
	}
};

