/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can
 * be found in the LICENSE file.
 *
 */

#ifndef SKC_ONCE_SKC_STYLING
#define SKC_ONCE_SKC_STYLING

//
// STYLING COMMANDS
//
// FIXME -- THESE ARE PLATFORM "CAPABILITIES" AND PRESENCE OF ANY
// EXOTIC NON-CORE COMMANDS SHOULD BE DETERMINED AT RUNTIME
//

typedef enum skc_styling_opcode_e {

  SKC_STYLING_OPCODE_NOOP,

  SKC_STYLING_OPCODE_COVER_NONZERO,
  SKC_STYLING_OPCODE_COVER_EVENODD,
  SKC_STYLING_OPCODE_COVER_ACCUMULATE,
  SKC_STYLING_OPCODE_COVER_MASK,

  SKC_STYLING_OPCODE_COVER_WIP_ZERO,
  SKC_STYLING_OPCODE_COVER_ACC_ZERO,
  SKC_STYLING_OPCODE_COVER_MASK_ZERO,
  SKC_STYLING_OPCODE_COVER_MASK_ONE,
  SKC_STYLING_OPCODE_COVER_MASK_INVERT,

  SKC_STYLING_OPCODE_COLOR_FILL_SOLID,
  SKC_STYLING_OPCODE_COLOR_FILL_GRADIENT_LINEAR,

  SKC_STYLING_OPCODE_COLOR_WIP_ZERO,
  SKC_STYLING_OPCODE_COLOR_ACC_ZERO,

  SKC_STYLING_OPCODE_BLEND_OVER,
  SKC_STYLING_OPCODE_BLEND_PLUS,
  SKC_STYLING_OPCODE_BLEND_MULTIPLY,
  SKC_STYLING_OPCODE_BLEND_KNOCKOUT,

  SKC_STYLING_OPCODE_COVER_WIP_MOVE_TO_MASK,
  SKC_STYLING_OPCODE_COVER_ACC_MOVE_TO_MASK,

  SKC_STYLING_OPCODE_BACKGROUND_OVER,

  SKC_STYLING_OPCODE_SURFACE_COMPOSITE,

  SKC_STYLING_OPCODE_COLOR_ACC_TEST_OPACITY,

  //
  //
  //

  SKC_STYLING_OPCODE_COUNT,

  //
  //
  //

  SKC_STYLING_OPCODE_IS_FINAL = 0x80000000

} skc_styling_opcode_e;

//
//
//

typedef enum skc_styling_gradient_type_e {

  SKC_STYLING_GRADIENT_TYPE_LINEAR_NON_REPEATING,
  SKC_STYLING_GRADIENT_TYPE_LINEAR_REPEATING,
  SKC_STYLING_GRADIENT_TYPE_LINEAR_REFLECTING,

  SKC_STYLING_GRADIENT_TYPE_COUNT

} skc_styling_gradient_type_e;

//
// FIXME -- bury all of this once we stabilize styling
//

#define SKC_STYLING_CMDS(...) _countof(__VA_ARGS__),__VA_ARGS__
#define SKC_GROUP_IDS(...)    _countof(__VA_ARGS__),__VA_ARGS__

//
//
//

#endif

//
//
//
