/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REVERTPARAM_H
#define _SC_REVERTPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/ClientTypes.h"

/**
 * Parameter class for RevertCmd.
 */
class RevertParam : public ScParam
{
public:
  RevertParam( const svn::Paths& paths, bool recurse )
    : _paths(paths), _recurse(recurse)
  {
  }

  const svn::Paths& getPaths() const
  {
    return _paths;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  ScParamAccept(RevertParam);

private:
  // in
  svn::Paths _paths;
  bool       _recurse;
};

#endif // _SC_REVERTPARAM_H
