/*
 *  A basic analyser that kind of supports some of the
 *  features of Apertium input streams.
 */

#include <iostream>
#include <getopt.h>

#include "compact.h"

using namespace std;

void  end_program(char *name);
char* string_append(char *target, const char c);

int main(int argc, char **argv)
{
  FILE *input = stdin, *output = stdout;
  FILE *in = 0;

  if(optind == (argc - 3)) {
    in = fopen(argv[optind], "rb");
    if(in == NULL || ferror(in)) {
      end_program(argv[0]);
    }
    
    input = fopen(argv[optind+1], "r");
    if(input == NULL || ferror(input)) {
      end_program(argv[0]);
    }
    
    output= fopen(argv[optind+2], "w");
    if(output == NULL || ferror(output)) {
      end_program(argv[0]);
    }

  } else if(optind == (argc -2)) {
    in = fopen(argv[optind], "rb");
    if(in == NULL || ferror(in)) {
      end_program(argv[0]);
    }
    
    input = fopen(argv[optind+1], "r");
    if(input == NULL || ferror(input)) {
      end_program(argv[0]);
    }

  } else if(optind == (argc - 1)) {
    in = fopen(argv[optind], "rb");
    if(in == NULL || ferror(in)) {
      end_program(argv[0]);
    }

  } else {
    end_program(argv[0]);
  }

  CompactTransducer ca(in); // read the transducer

  try {
    char c;
    bool superblank = false;
    char *buffer = 0;
    std::vector<CAnalysis> analyses;

    while(!feof(input)) {
      c = fgetc(input);  // next input character

      if((c == ']') && (superblank == true)) {	// leaving a superblank
        superblank = false;  
        fputc(c, stdout);
        c = fgetc(input);
      }

      if(superblank == true) {			// in a superblank, so just output char
        fputc(c, output);
        continue;
      }

      if(!iswspace(c) && !ispunct(c)) {
        buffer = string_append(buffer, c);
        continue;
      }  

      if(buffer == 0) {
        fputc(c, output);
        continue;
      }

      if(c == '[') {				// entering a superblank
        superblank = true;
      }

      fprintf(output,"^%s/", buffer);  

      ca.analyze_string(buffer, analyses);  	// analyse the input

      if (analyses.size() > 0) {		// print out analyses

        for(size_t i = 0; i < analyses.size(); i++) {
          fputs(ca.print_analysis(analyses[i]), output);
          if(i < (analyses.size() - 1)) {
            fputc('/', output);
          }
        }
      } else { 					// print out unknown word
        fprintf(output, "*%s", buffer);
      }

      fprintf(output, "$", buffer);		// end of lexical unit

      fputc(c, output);

      delete[] buffer;
      buffer = 0;
    }

  } catch (const char *p) {   // deal with exceptions
    std::cerr << p << "\n";
    return 1;
  }

  return 0;
}

char* 
string_append(char *target, const char c)
{
  char *tmp = 0;
  char *ctmp = (char *)malloc(sizeof(char) * 2);
  ctmp[0] = c;
  ctmp[1] = '\0';

  if(!target) {
    size_t len = strlen(ctmp) + 1;
    tmp = (char *)malloc(sizeof(char) * len);
    tmp[0] = 0;
    strcat(tmp, ctmp);
    delete[] target;
    target = tmp;
  } else {
    size_t len = strlen(ctmp) + strlen(target) + 1;
    tmp = (char *)malloc(sizeof(char) * len);
    tmp[0] = 0;
    strcat(tmp, target);
    strcat(tmp, ctmp);
    delete[] target;
    target = tmp;
  }

  delete[] ctmp;
  return tmp;
}

void 
end_program(char *name)
{
  cout << basename(name) <<": process a stream with a finite-state transducer" << endl;
  cout << "USAGE: " << basename(name) << " fst_file [input_file [output_file]]" << endl;

  exit(EXIT_FAILURE);
}
