/*
  ids.cc, copyright (c) 2006 by Vincent Fourmond: 
  Code for the handling of IDs...
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

#include <string.h>
#include <stdlib.h>
#include <calc_internals.hh>

namespace SCalc {

  ID::ID(Session * s, const char * name) : 
    Expression(s), value(name)
  {
    id = -1; 		// not initialized yet
  }

  ID::~ID()
  {
  }

  const char * ID::name()
  {
    return value.c_str();
  }

  int ID::register_id()
  {
    return session()->register_varname(value);
  }

  void ID::dump(::std::ostream & stream)
  {
    stream << "ID: " << id << " (" << name() << ") ";
  }

  std::string ID::pretty_print()
  {
    std::string str;
    str+= "ID ";
    str+= name();
    return str;
  }

  /*******************************************************************/
  /** definitions for the Var class, now */

  Var::Var(Session * s, ID * newID) : Expression(s) 
  {
    id = newID->register_id();
    delete newID;		// destroy after use
  }
  
  double Var::evaluate(const double * vars, const double *)
  {
    return vars[id];
  }

  void Var::dump(::std::ostream & stream)
  {
    stream << "Var : " << name() << " (id : "
	   << id << ")";
  }

  std::set<int> Var::used_variables()
  { 
    std::set<int> a; 
    a.insert(id);
    return a;
  }

  Expression * Var::derive(int i)
  {
    if(i == id)
      return new Const(session(), 1.0);
    else
      return new Null(session());
  }

};
