
#line 1 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 242 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"


/** Data **/

#line 87 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 14, 1, 15, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 2, 1, 16, 2, 11, 0, 2, 
	12, 13, 2, 15, 0, 2, 15, 2, 
	2, 15, 14, 2, 15, 17, 2, 16, 
	4, 2, 16, 5, 2, 16, 6, 2, 
	16, 7, 2, 16, 8, 2, 16, 14, 
	2, 18, 19, 2, 20, 0, 2, 20, 
	2, 2, 20, 14, 2, 20, 17, 3, 
	3, 12, 13, 3, 9, 12, 13, 3, 
	10, 12, 13, 3, 11, 12, 13, 3, 
	12, 13, 16, 3, 15, 12, 13, 4, 
	1, 12, 13, 16, 4, 15, 0, 12, 
	13
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 21, 22, 23, 24, 25, 
	26, 27, 28, 29, 30, 31, 32, 33, 
	35, 46, 47, 48, 52, 57, 62, 67, 
	72, 76, 80, 82, 83, 84, 85, 86, 
	87, 88, 89, 90, 91, 92, 93, 94, 
	95, 96, 97, 102, 109, 114, 118, 124, 
	127, 129, 135, 146, 147, 148, 149, 150, 
	151, 152, 153, 154, 155, 156, 157, 159, 
	160, 161, 162, 163, 164, 165, 166, 167, 
	168, 169, 170, 171, 172, 173, 174, 175, 
	176, 177, 178, 187, 196, 198, 200, 202, 
	204, 206, 208, 210, 212, 214, 216, 218, 
	229, 231, 233, 235, 237, 239, 241, 243, 
	245, 247, 249, 251, 253, 255, 257, 259, 
	261, 263, 265, 267, 269, 271, 273, 275, 
	277, 279, 281, 283, 285, 287, 289, 291, 
	293, 295, 297, 299, 301, 303, 305, 307, 
	309, 311, 313, 315, 317, 319, 321, 323, 
	325, 327, 329, 331, 333, 335, 337, 339, 
	341, 343, 345, 347, 349, 351, 353, 355, 
	357, 359, 361, 363, 365, 367, 369, 371, 
	373, 375, 377, 379, 381, 383, 385, 387, 
	388, 389, 390, 391, 392, 393, 394, 395, 
	396, 397, 398, 405, 407, 409, 411, 413, 
	415, 417, 419, 421, 423, 425, 427, 429, 
	431, 433, 435, 437, 439, 441, 443, 445, 
	447, 449, 451, 453, 455, 457, 459, 461, 
	462, 463, 464, 465, 466, 467, 468, 469, 
	470, 471, 472, 473, 474, 475, 476, 477, 
	478, 479, 480, 481, 482, 483, 484, 485, 
	486, 487, 488, 489, 490, 491, 492, 493, 
	494, 503, 511, 513, 515, 517, 519, 521, 
	523, 525, 527, 529, 531, 533, 535, 537, 
	539, 541, 543, 545, 547, 549, 551, 553, 
	555, 557, 559, 561, 563, 565, 567, 569, 
	571, 573, 575, 577, 579, 581, 583, 585, 
	587, 589, 591, 593, 595, 597, 599, 601, 
	603, 605, 607, 609, 611, 613, 615, 617, 
	619, 621, 623, 625, 627, 629, 631, 633, 
	635, 637, 639, 641, 643, 645, 647, 649, 
	651, 653, 655, 657, 659, 660, 661, 662, 
	663, 664, 665, 666, 667, 668, 669, 670, 
	671, 672, 673, 674, 675, 676, 685, 695, 
	697, 699, 701, 703, 705, 707, 709, 711, 
	713, 715, 717, 719, 721, 723, 725, 727, 
	729, 731, 733, 735, 737, 739, 741, 743, 
	745, 747, 749, 751, 753, 755, 757, 759, 
	761, 763, 765, 767, 769, 771, 773, 775, 
	777, 779, 781, 783, 785, 787, 789, 791, 
	793, 795, 797, 799, 801, 803, 805, 807, 
	809, 811, 813, 815, 817, 819, 821, 823, 
	825, 827, 829, 831, 833, 835, 837, 839, 
	841, 843, 845, 847, 849, 851, 853, 855, 
	857, 859, 861, 863, 865, 867, 869, 871, 
	873, 875, 877, 879, 881, 883, 885, 887, 
	889, 891, 893, 895, 897, 899, 901, 903, 
	905, 907, 909, 911, 913, 915, 916, 917, 
	918, 919, 920, 921, 922, 923, 924, 925, 
	926, 927, 928, 929, 930, 931, 932, 933, 
	934, 935, 936, 937, 938, 939, 940, 941, 
	942, 943, 944, 952, 957, 959, 961, 963, 
	966, 968, 970, 972, 974, 976, 978, 980, 
	982, 984, 986, 988, 990, 992, 994, 996, 
	998, 1000, 1002, 1004, 1006, 1008, 1010, 1012, 
	1014, 1016, 1018, 1020, 1022, 1024, 1026, 1028, 
	1030, 1032, 1034, 1036, 1038, 1040, 1042, 1044, 
	1046, 1048, 1050, 1052, 1054, 1056, 1058, 1060, 
	1062, 1064, 1066, 1068, 1070, 1072, 1074, 1076, 
	1078, 1080, 1082, 1084, 1086, 1088, 1090, 1092, 
	1094, 1096, 1098, 1100, 1102, 1104, 1106, 1108, 
	1110, 1112, 1114, 1116, 1118, 1120, 1122, 1124, 
	1126, 1128, 1130, 1132, 1134, 1136, 1138, 1140, 
	1142, 1144, 1146, 1148, 1150, 1152, 1154, 1156, 
	1157, 1158
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -108, -104, -102, -99, 
	-97, -96, -95, -94, -92, -48, -80, -48, 
	-76, -48, -75, -48, -67, -48, -66, 32, 
	10, 10, 13, -48, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, 34, 34, 
	10, 32, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 9, 13, 10, 32, 9, 13, 
	10, 13, 10, 95, 70, 69, 65, 84, 
	85, 82, 69, 95, 69, 78, 68, 95, 
	37, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 32, 124, 9, 13, 10, 32, 
	92, 124, 9, 13, 10, 92, 124, 10, 
	92, 10, 32, 92, 124, 9, 13, -48, 
	10, 32, 34, 35, 37, 42, 64, 124, 
	9, 13, -48, -66, -48, -77, -48, -80, 
	-47, -126, -47, -128, -48, -75, -72, -48, 
	-76, -48, -72, -47, -127, -47, -126, -48, 
	-66, -47, -128, -48, -72, -47, -113, 58, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -108, -104, -102, -99, -96, 
	-95, -94, -92, 10, -48, 10, -80, 10, 
	-48, 10, -76, 10, -48, 10, -75, 10, 
	-48, 10, -67, 10, -48, 10, -66, 10, 
	10, 32, -48, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, -48, 10, -66, 
	10, -48, 10, -77, 10, -48, 10, -80, 
	10, -47, 10, -126, 10, -48, 10, -80, 
	10, -48, 10, -68, 10, -48, 10, -70, 
	10, -48, 10, -80, 10, 10, 32, -48, 
	10, -67, 10, -48, 10, -80, 10, 10, 
	32, -47, 10, -127, 10, -47, 10, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -48, 10, -72, 10, -48, 10, -71, 
	10, 10, 58, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	10, -66, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -69, 10, -48, 
	10, -67, 10, -48, 10, -66, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -48, -68, -48, -75, -47, 
	-128, -48, -72, 58, 10, 10, -48, 10, 
	32, 35, 124, 9, 13, -92, 10, -47, 
	10, -125, 10, -48, 10, -67, 10, -48, 
	10, -70, 10, -47, 10, -122, 10, -48, 
	10, -72, 10, -48, 10, -66, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -48, 
	10, -69, 10, -48, 10, -67, 10, -48, 
	10, -66, 10, -47, 10, -127, 10, -47, 
	10, -126, 10, 10, 58, -48, -80, -48, 
	-68, -48, -70, -48, -80, 32, -48, -67, 
	-48, -80, 32, -47, -127, -47, -122, -48, 
	-75, -48, -67, -48, -80, -47, -128, -48, 
	-72, -48, -71, 58, 10, 10, -48, 10, 
	32, 35, 37, 42, 64, 9, 13, -108, 
	-104, -102, -99, -95, -94, -92, 10, -48, 
	10, -80, 10, -48, 10, -76, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -66, 10, 10, 32, -48, 10, -66, 
	10, -48, 10, -77, 10, -48, 10, -80, 
	10, -47, 10, -126, 10, -47, 10, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -48, 10, -72, 10, -48, 10, -71, 
	10, 10, 58, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	10, -66, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -69, 10, -48, 
	10, -67, 10, -48, 10, -66, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -47, -122, -48, -75, -48, 
	-67, -48, -80, -47, -128, -48, -72, -48, 
	-71, 58, 10, 10, -48, 10, 32, 35, 
	37, 42, 64, 9, 13, -108, -104, -102, 
	-99, -97, -96, -95, -94, -92, 10, -48, 
	10, -80, 10, -48, 10, -76, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -66, 10, 10, 32, -48, 10, -66, 
	10, -48, 10, -77, 10, -48, 10, -80, 
	10, -47, 10, -126, 10, -47, 10, -128, 
	10, -48, 10, -75, 10, -48, 10, -76, 
	10, -48, 10, -72, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -48, 10, -66, 
	10, -47, 10, -128, 10, -48, 10, -72, 
	10, -47, 10, -113, 10, 10, 58, -48, 
	10, -80, 10, -48, 10, -68, 10, -48, 
	10, -70, 10, -48, 10, -80, 10, 10, 
	32, -48, 10, -67, 10, -48, 10, -80, 
	10, 10, 32, -47, 10, -127, 10, -47, 
	10, -122, 10, -48, 10, -75, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -47, 
	10, -128, 10, -48, 10, -72, 10, -48, 
	10, -71, 10, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	10, -66, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -69, 10, -48, 
	10, -67, 10, -48, 10, -66, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -47, -125, -48, -67, -48, 
	-70, -47, -122, -48, -72, -48, -66, -48, 
	-67, -48, -80, -48, -69, -48, -67, -48, 
	-66, -47, -127, -47, -126, 58, 10, 10, 
	-48, 10, 32, 35, 37, 64, 9, 13, 
	-97, -96, -95, -92, 10, -47, 10, -128, 
	10, -48, 10, -75, -72, 10, -48, 10, 
	-76, 10, -48, 10, -72, 10, -47, 10, 
	-127, 10, -47, 10, -126, 10, -48, 10, 
	-66, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -47, 10, -113, 10, 10, 58, 
	-48, 10, -68, 10, -48, 10, -75, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-48, 10, -80, 10, -48, 10, -68, 10, 
	-48, 10, -70, 10, -48, 10, -80, 10, 
	10, 32, -48, 10, -67, 10, -48, 10, 
	-80, 10, 10, 32, -47, 10, -127, 10, 
	-47, 10, -122, 10, -48, 10, -75, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-48, 10, -71, 10, -47, 10, -125, 10, 
	-48, 10, -67, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -72, 10, 
	-48, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	-48, 10, -67, 10, -48, 10, -66, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 9, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 2, 
	9, 1, 1, 2, 3, 3, 3, 3, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 3, 5, 3, 2, 4, 3, 
	2, 4, 9, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 7, 9, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 9, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 5, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	7, 8, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 7, 10, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 6, 5, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 1, 1, 1, 1, 1, 
	1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 1, 1, 0, 
	0, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 22, 24, 26, 28, 30, 
	32, 34, 36, 38, 40, 42, 44, 46, 
	49, 60, 62, 64, 68, 73, 78, 83, 
	88, 92, 96, 99, 101, 103, 105, 107, 
	109, 111, 113, 115, 117, 119, 121, 123, 
	125, 127, 129, 134, 141, 146, 150, 156, 
	160, 163, 169, 180, 182, 184, 186, 188, 
	190, 192, 194, 196, 198, 200, 202, 205, 
	207, 209, 211, 213, 215, 217, 219, 221, 
	223, 225, 227, 229, 231, 233, 235, 237, 
	239, 241, 243, 252, 262, 265, 268, 271, 
	274, 277, 280, 283, 286, 289, 292, 295, 
	306, 309, 312, 315, 318, 321, 324, 327, 
	330, 333, 336, 339, 342, 345, 348, 351, 
	354, 357, 360, 363, 366, 369, 372, 375, 
	378, 381, 384, 387, 390, 393, 396, 399, 
	402, 405, 408, 411, 414, 417, 420, 423, 
	426, 429, 432, 435, 438, 441, 444, 447, 
	450, 453, 456, 459, 462, 465, 468, 471, 
	474, 477, 480, 483, 486, 489, 492, 495, 
	498, 501, 504, 507, 510, 513, 516, 519, 
	522, 525, 528, 531, 534, 537, 540, 543, 
	545, 547, 549, 551, 553, 555, 557, 559, 
	561, 563, 565, 572, 575, 578, 581, 584, 
	587, 590, 593, 596, 599, 602, 605, 608, 
	611, 614, 617, 620, 623, 626, 629, 632, 
	635, 638, 641, 644, 647, 650, 653, 656, 
	658, 660, 662, 664, 666, 668, 670, 672, 
	674, 676, 678, 680, 682, 684, 686, 688, 
	690, 692, 694, 696, 698, 700, 702, 704, 
	706, 708, 710, 712, 714, 716, 718, 720, 
	722, 731, 740, 743, 746, 749, 752, 755, 
	758, 761, 764, 767, 770, 773, 776, 779, 
	782, 785, 788, 791, 794, 797, 800, 803, 
	806, 809, 812, 815, 818, 821, 824, 827, 
	830, 833, 836, 839, 842, 845, 848, 851, 
	854, 857, 860, 863, 866, 869, 872, 875, 
	878, 881, 884, 887, 890, 893, 896, 899, 
	902, 905, 908, 911, 914, 917, 920, 923, 
	926, 929, 932, 935, 938, 941, 944, 947, 
	950, 953, 956, 959, 962, 964, 966, 968, 
	970, 972, 974, 976, 978, 980, 982, 984, 
	986, 988, 990, 992, 994, 996, 1005, 1016, 
	1019, 1022, 1025, 1028, 1031, 1034, 1037, 1040, 
	1043, 1046, 1049, 1052, 1055, 1058, 1061, 1064, 
	1067, 1070, 1073, 1076, 1079, 1082, 1085, 1088, 
	1091, 1094, 1097, 1100, 1103, 1106, 1109, 1112, 
	1115, 1118, 1121, 1124, 1127, 1130, 1133, 1136, 
	1139, 1142, 1145, 1148, 1151, 1154, 1157, 1160, 
	1163, 1166, 1169, 1172, 1175, 1178, 1181, 1184, 
	1187, 1190, 1193, 1196, 1199, 1202, 1205, 1208, 
	1211, 1214, 1217, 1220, 1223, 1226, 1229, 1232, 
	1235, 1238, 1241, 1244, 1247, 1250, 1253, 1256, 
	1259, 1262, 1265, 1268, 1271, 1274, 1277, 1280, 
	1283, 1286, 1289, 1292, 1295, 1298, 1301, 1304, 
	1307, 1310, 1313, 1316, 1319, 1322, 1325, 1328, 
	1331, 1334, 1337, 1340, 1343, 1346, 1348, 1350, 
	1352, 1354, 1356, 1358, 1360, 1362, 1364, 1366, 
	1368, 1370, 1372, 1374, 1376, 1378, 1380, 1382, 
	1384, 1386, 1388, 1390, 1392, 1394, 1396, 1398, 
	1400, 1402, 1404, 1412, 1418, 1421, 1424, 1427, 
	1431, 1434, 1437, 1440, 1443, 1446, 1449, 1452, 
	1455, 1458, 1461, 1464, 1467, 1470, 1473, 1476, 
	1479, 1482, 1485, 1488, 1491, 1494, 1497, 1500, 
	1503, 1506, 1509, 1512, 1515, 1518, 1521, 1524, 
	1527, 1530, 1533, 1536, 1539, 1542, 1545, 1548, 
	1551, 1554, 1557, 1560, 1563, 1566, 1569, 1572, 
	1575, 1578, 1581, 1584, 1587, 1590, 1593, 1596, 
	1599, 1602, 1605, 1608, 1611, 1614, 1617, 1620, 
	1623, 1626, 1629, 1632, 1635, 1638, 1641, 1644, 
	1647, 1650, 1653, 1656, 1659, 1662, 1665, 1668, 
	1671, 1674, 1677, 1680, 1683, 1686, 1689, 1692, 
	1695, 1698, 1701, 1704, 1707, 1710, 1713, 1716, 
	1718, 1720
};

static const short _lexer_trans_targs[] = {
	2, 583, 16, 16, 17, 26, 28, 13, 
	42, 45, 16, 0, 3, 13, 51, 11, 
	59, 215, 324, 11, 453, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 11, 0, 12, 0, 
	13, 0, 14, 0, 0, 15, 16, 27, 
	15, 2, 16, 16, 17, 26, 28, 13, 
	42, 45, 16, 0, 18, 0, 19, 0, 
	20, 19, 19, 0, 21, 21, 22, 21, 
	21, 21, 21, 22, 21, 21, 21, 21, 
	23, 21, 21, 21, 21, 24, 21, 21, 
	16, 25, 25, 0, 16, 25, 25, 0, 
	16, 27, 26, 16, 0, 29, 0, 30, 
	0, 31, 0, 32, 0, 33, 0, 34, 
	0, 35, 0, 36, 0, 37, 0, 38, 
	0, 39, 0, 40, 0, 41, 0, 585, 
	0, 0, 0, 0, 0, 43, 44, 16, 
	44, 44, 42, 43, 43, 16, 44, 42, 
	44, 0, 45, 46, 45, 0, 50, 49, 
	48, 46, 49, 47, 0, 48, 46, 47, 
	0, 48, 47, 50, 49, 48, 46, 49, 
	47, 2, 50, 50, 17, 26, 28, 13, 
	42, 45, 50, 0, 52, 0, 53, 0, 
	54, 0, 55, 0, 56, 0, 57, 0, 
	58, 0, 11, 0, 60, 0, 61, 0, 
	62, 0, 63, 175, 0, 64, 0, 65, 
	0, 66, 0, 67, 0, 68, 0, 69, 
	0, 70, 0, 71, 0, 72, 0, 73, 
	0, 74, 0, 75, 0, 76, 0, 77, 
	0, 78, 0, 79, 0, 80, 0, 82, 
	81, 82, 81, 83, 82, 82, 16, 161, 
	94, 16, 82, 81, 84, 94, 96, 92, 
	104, 120, 92, 135, 82, 81, 85, 82, 
	81, 86, 82, 81, 87, 82, 81, 88, 
	82, 81, 89, 82, 81, 90, 82, 81, 
	91, 82, 81, 92, 82, 81, 93, 82, 
	81, 94, 82, 81, 82, 95, 81, 2, 
	16, 16, 17, 26, 28, 13, 42, 45, 
	16, 0, 97, 82, 81, 98, 82, 81, 
	99, 82, 81, 100, 82, 81, 101, 82, 
	81, 102, 82, 81, 103, 82, 81, 92, 
	82, 81, 105, 82, 81, 106, 82, 81, 
	107, 82, 81, 108, 82, 81, 109, 82, 
	81, 110, 82, 81, 111, 82, 81, 112, 
	82, 81, 82, 113, 81, 114, 82, 81, 
	115, 82, 81, 116, 82, 81, 117, 82, 
	81, 82, 118, 81, 119, 82, 81, 120, 
	82, 81, 121, 82, 81, 122, 82, 81, 
	123, 82, 81, 124, 82, 81, 125, 82, 
	81, 126, 82, 81, 127, 82, 81, 128, 
	82, 81, 129, 82, 81, 130, 82, 81, 
	131, 82, 81, 132, 82, 81, 133, 82, 
	81, 134, 82, 81, 82, 95, 81, 136, 
	82, 81, 137, 82, 81, 138, 82, 81, 
	139, 82, 81, 140, 82, 81, 141, 82, 
	81, 142, 82, 81, 143, 82, 81, 144, 
	82, 81, 145, 82, 81, 146, 82, 81, 
	147, 82, 81, 148, 82, 81, 149, 82, 
	81, 150, 82, 81, 151, 82, 81, 152, 
	82, 81, 153, 82, 81, 154, 82, 81, 
	155, 82, 81, 156, 82, 81, 157, 82, 
	81, 158, 82, 81, 159, 82, 81, 160, 
	82, 81, 134, 82, 81, 82, 162, 81, 
	82, 163, 81, 82, 164, 81, 82, 165, 
	81, 82, 166, 81, 82, 167, 81, 82, 
	168, 81, 82, 169, 81, 82, 170, 81, 
	82, 171, 81, 82, 172, 81, 82, 173, 
	81, 82, 174, 81, 82, 16, 81, 176, 
	0, 177, 0, 178, 0, 179, 0, 180, 
	0, 181, 0, 182, 0, 183, 0, 184, 
	0, 186, 185, 186, 185, 187, 186, 186, 
	16, 16, 186, 185, 188, 186, 185, 189, 
	186, 185, 190, 186, 185, 191, 186, 185, 
	192, 186, 185, 193, 186, 185, 194, 186, 
	185, 195, 186, 185, 196, 186, 185, 197, 
	186, 185, 198, 186, 185, 199, 186, 185, 
	200, 186, 185, 201, 186, 185, 202, 186, 
	185, 203, 186, 185, 204, 186, 185, 205, 
	186, 185, 206, 186, 185, 207, 186, 185, 
	208, 186, 185, 209, 186, 185, 210, 186, 
	185, 211, 186, 185, 212, 186, 185, 213, 
	186, 185, 214, 186, 185, 186, 95, 185, 
	216, 0, 217, 0, 218, 0, 219, 0, 
	220, 0, 221, 0, 222, 0, 223, 0, 
	224, 0, 225, 0, 226, 0, 227, 0, 
	228, 0, 229, 0, 230, 0, 231, 0, 
	232, 0, 233, 0, 234, 0, 235, 0, 
	236, 0, 237, 0, 238, 0, 239, 0, 
	240, 0, 241, 0, 242, 0, 243, 0, 
	244, 0, 245, 0, 246, 0, 248, 247, 
	248, 247, 249, 248, 248, 16, 310, 260, 
	16, 248, 247, 250, 260, 261, 258, 269, 
	258, 284, 248, 247, 251, 248, 247, 252, 
	248, 247, 253, 248, 247, 254, 248, 247, 
	255, 248, 247, 256, 248, 247, 257, 248, 
	247, 258, 248, 247, 259, 248, 247, 260, 
	248, 247, 248, 95, 247, 262, 248, 247, 
	263, 248, 247, 264, 248, 247, 265, 248, 
	247, 266, 248, 247, 267, 248, 247, 268, 
	248, 247, 258, 248, 247, 270, 248, 247, 
	271, 248, 247, 272, 248, 247, 273, 248, 
	247, 274, 248, 247, 275, 248, 247, 276, 
	248, 247, 277, 248, 247, 278, 248, 247, 
	279, 248, 247, 280, 248, 247, 281, 248, 
	247, 282, 248, 247, 283, 248, 247, 248, 
	95, 247, 285, 248, 247, 286, 248, 247, 
	287, 248, 247, 288, 248, 247, 289, 248, 
	247, 290, 248, 247, 291, 248, 247, 292, 
	248, 247, 293, 248, 247, 294, 248, 247, 
	295, 248, 247, 296, 248, 247, 297, 248, 
	247, 298, 248, 247, 299, 248, 247, 300, 
	248, 247, 301, 248, 247, 302, 248, 247, 
	303, 248, 247, 304, 248, 247, 305, 248, 
	247, 306, 248, 247, 307, 248, 247, 308, 
	248, 247, 309, 248, 247, 283, 248, 247, 
	248, 311, 247, 248, 312, 247, 248, 313, 
	247, 248, 314, 247, 248, 315, 247, 248, 
	316, 247, 248, 317, 247, 248, 318, 247, 
	248, 319, 247, 248, 320, 247, 248, 321, 
	247, 248, 322, 247, 248, 323, 247, 248, 
	16, 247, 325, 0, 326, 0, 327, 0, 
	328, 0, 329, 0, 330, 0, 331, 0, 
	332, 0, 333, 0, 334, 0, 335, 0, 
	336, 0, 337, 0, 338, 0, 339, 0, 
	341, 340, 341, 340, 342, 341, 341, 16, 
	439, 353, 16, 341, 340, 343, 353, 354, 
	351, 362, 383, 399, 351, 413, 341, 340, 
	344, 341, 340, 345, 341, 340, 346, 341, 
	340, 347, 341, 340, 348, 341, 340, 349, 
	341, 340, 350, 341, 340, 351, 341, 340, 
	352, 341, 340, 353, 341, 340, 341, 95, 
	340, 355, 341, 340, 356, 341, 340, 357, 
	341, 340, 358, 341, 340, 359, 341, 340, 
	360, 341, 340, 361, 341, 340, 351, 341, 
	340, 363, 341, 340, 364, 341, 340, 365, 
	341, 340, 366, 341, 340, 367, 341, 340, 
	368, 341, 340, 369, 341, 340, 370, 341, 
	340, 371, 341, 340, 372, 341, 340, 373, 
	341, 340, 374, 341, 340, 375, 341, 340, 
	376, 341, 340, 377, 341, 340, 378, 341, 
	340, 379, 341, 340, 380, 341, 340, 381, 
	341, 340, 382, 341, 340, 341, 95, 340, 
	384, 341, 340, 385, 341, 340, 386, 341, 
	340, 387, 341, 340, 388, 341, 340, 389, 
	341, 340, 390, 341, 340, 391, 341, 340, 
	341, 392, 340, 393, 341, 340, 394, 341, 
	340, 395, 341, 340, 396, 341, 340, 341, 
	397, 340, 398, 341, 340, 399, 341, 340, 
	400, 341, 340, 401, 341, 340, 402, 341, 
	340, 403, 341, 340, 404, 341, 340, 405, 
	341, 340, 406, 341, 340, 407, 341, 340, 
	408, 341, 340, 409, 341, 340, 410, 341, 
	340, 411, 341, 340, 412, 341, 340, 382, 
	341, 340, 414, 341, 340, 415, 341, 340, 
	416, 341, 340, 417, 341, 340, 418, 341, 
	340, 419, 341, 340, 420, 341, 340, 421, 
	341, 340, 422, 341, 340, 423, 341, 340, 
	424, 341, 340, 425, 341, 340, 426, 341, 
	340, 427, 341, 340, 428, 341, 340, 429, 
	341, 340, 430, 341, 340, 431, 341, 340, 
	432, 341, 340, 433, 341, 340, 434, 341, 
	340, 435, 341, 340, 436, 341, 340, 437, 
	341, 340, 438, 341, 340, 382, 341, 340, 
	341, 440, 340, 341, 441, 340, 341, 442, 
	340, 341, 443, 340, 341, 444, 340, 341, 
	445, 340, 341, 446, 340, 341, 447, 340, 
	341, 448, 340, 341, 449, 340, 341, 450, 
	340, 341, 451, 340, 341, 452, 340, 341, 
	16, 340, 454, 0, 455, 0, 456, 0, 
	457, 0, 458, 0, 459, 0, 460, 0, 
	461, 0, 462, 0, 463, 0, 464, 0, 
	465, 0, 466, 0, 467, 0, 468, 0, 
	469, 0, 470, 0, 471, 0, 472, 0, 
	473, 0, 474, 0, 475, 0, 476, 0, 
	477, 0, 478, 0, 479, 0, 480, 0, 
	482, 481, 482, 481, 483, 482, 482, 16, 
	569, 16, 482, 481, 484, 513, 529, 543, 
	482, 481, 485, 482, 481, 486, 482, 481, 
	487, 482, 481, 488, 505, 482, 481, 489, 
	482, 481, 490, 482, 481, 491, 482, 481, 
	492, 482, 481, 493, 482, 481, 494, 482, 
	481, 495, 482, 481, 496, 482, 481, 497, 
	482, 481, 498, 482, 481, 499, 482, 481, 
	500, 482, 481, 501, 482, 481, 502, 482, 
	481, 503, 482, 481, 504, 482, 481, 482, 
	95, 481, 506, 482, 481, 507, 482, 481, 
	508, 482, 481, 509, 482, 481, 510, 482, 
	481, 511, 482, 481, 512, 482, 481, 504, 
	482, 481, 514, 482, 481, 515, 482, 481, 
	516, 482, 481, 517, 482, 481, 518, 482, 
	481, 519, 482, 481, 520, 482, 481, 521, 
	482, 481, 482, 522, 481, 523, 482, 481, 
	524, 482, 481, 525, 482, 481, 526, 482, 
	481, 482, 527, 481, 528, 482, 481, 529, 
	482, 481, 530, 482, 481, 531, 482, 481, 
	532, 482, 481, 533, 482, 481, 534, 482, 
	481, 535, 482, 481, 536, 482, 481, 537, 
	482, 481, 538, 482, 481, 539, 482, 481, 
	540, 482, 481, 541, 482, 481, 542, 482, 
	481, 504, 482, 481, 544, 482, 481, 545, 
	482, 481, 546, 482, 481, 547, 482, 481, 
	548, 482, 481, 549, 482, 481, 550, 482, 
	481, 551, 482, 481, 552, 482, 481, 553, 
	482, 481, 554, 482, 481, 555, 482, 481, 
	556, 482, 481, 557, 482, 481, 558, 482, 
	481, 559, 482, 481, 560, 482, 481, 561, 
	482, 481, 562, 482, 481, 563, 482, 481, 
	564, 482, 481, 565, 482, 481, 566, 482, 
	481, 567, 482, 481, 568, 482, 481, 504, 
	482, 481, 482, 570, 481, 482, 571, 481, 
	482, 572, 481, 482, 573, 481, 482, 574, 
	481, 482, 575, 481, 482, 576, 481, 482, 
	577, 481, 482, 578, 481, 482, 579, 481, 
	482, 580, 481, 482, 581, 481, 482, 582, 
	481, 482, 16, 481, 584, 0, 16, 0, 
	0, 0
};

static const char _lexer_trans_actions[] = {
	25, 0, 47, 0, 5, 1, 0, 25, 
	1, 31, 0, 39, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 39, 50, 99, 19, 
	0, 25, 47, 0, 5, 1, 0, 25, 
	1, 31, 0, 39, 0, 39, 0, 39, 
	47, 0, 0, 39, 119, 41, 41, 41, 
	3, 111, 29, 29, 29, 0, 111, 29, 
	29, 29, 0, 111, 29, 0, 29, 0, 
	95, 7, 7, 39, 47, 0, 0, 39, 
	103, 21, 0, 47, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 39, 39, 39, 39, 0, 23, 107, 
	23, 23, 44, 23, 0, 47, 0, 1, 
	0, 39, 0, 0, 0, 39, 47, 33, 
	33, 80, 33, 33, 39, 0, 35, 0, 
	39, 0, 0, 47, 0, 0, 35, 0, 
	0, 89, 47, 0, 86, 83, 37, 89, 
	83, 92, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 124, 
	50, 47, 0, 77, 47, 0, 65, 29, 
	77, 65, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 11, 0, 56, 
	115, 27, 53, 50, 27, 56, 50, 59, 
	27, 39, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 11, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 11, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 124, 50, 47, 0, 77, 47, 0, 
	74, 74, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 47, 17, 0, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 124, 50, 
	47, 0, 77, 47, 0, 71, 29, 77, 
	71, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 15, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	15, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	15, 0, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	124, 50, 47, 0, 77, 47, 0, 68, 
	29, 77, 68, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 13, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 47, 13, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	13, 0, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	124, 50, 47, 0, 77, 47, 0, 62, 
	29, 62, 0, 0, 0, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	9, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 9, 0, 0, 39, 0, 39, 
	0, 0
};

static const char _lexer_eof_actions[] = {
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39
};

static const int lexer_start = 1;
static const int lexer_first_final = 585;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 246 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}

static void 
store_pystring_content(VALUE listener, 
          int start_col, 
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 2, con, INT2FIX(current_line));
}

static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1251 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
	{
	cs = lexer_start;
	}

#line 410 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
    
#line 1258 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 81 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 87 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 91 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 96 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));

    if (len < 0) len = 0;

    store_pystring_content(listener, lexer->start_col, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 104 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 5:
#line 108 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 6:
#line 112 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 7:
#line 116 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 8:
#line 120 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 9:
#line 124 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 10:
#line 131 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 12:
#line 141 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 13:
#line 146 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 14:
#line 150 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 15:
#line 156 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 16:
#line 163 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 17:
#line 167 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 18:
#line 173 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 19:
#line 177 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 20:
#line 191 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1534 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1597 "ext/gherkin_lexer_bg/gherkin_lexer_bg.c"
		}
	}
	}

	_out: {}
	}

#line 411 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/bg.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_bg()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Bg", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

