/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.Model;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.WeakHashMap;
import molikin.AtomClassifier;
import molikin.AtomGraph;
import molikin.PseudoBackbone;
import molikin.ResClassifier;
import molikin.Util;

public class DataCache {
    static WeakHashMap dataEntries = new WeakHashMap();
    Model model;
    ResClassifier resC = null;
    Collection atomStates = null;
    AtomClassifier atomC = null;
    AtomGraph atomGraph = null;
    PseudoBackbone pseudoBB = null;

    protected DataCache(Model model) {
        this.model = model;
    }

    public static DataCache getDataFor(Model model) {
        SoftReference softReference = (SoftReference)dataEntries.get(model);
        DataCache dataCache = null;
        if (softReference != null) {
            dataCache = (DataCache)softReference.get();
        }
        if (dataCache == null) {
            dataCache = new DataCache(model);
            dataEntries.put(model, new SoftReference<DataCache>(dataCache));
        }
        return dataCache;
    }

    public ResClassifier getResClassifier() {
        if (this.resC == null) {
            this.resC = new ResClassifier(this.model.getResidues());
        }
        return this.resC;
    }

    public Collection getUniqueAtomStates() {
        if (this.atomStates == null) {
            this.atomStates = Util.extractOrderedStatesByName(this.model);
        }
        return this.atomStates;
    }

    public AtomClassifier getAtomClassifier() {
        if (this.atomC == null) {
            this.atomC = new AtomClassifier(this.getUniqueAtomStates(), this.getResClassifier());
        }
        return this.atomC;
    }

    public AtomGraph getCovalentGraph() {
        if (this.atomGraph == null) {
            this.atomGraph = new AtomGraph(this.getUniqueAtomStates());
        }
        return this.atomGraph;
    }

    public PseudoBackbone getPseudoBackbone() {
        if (this.pseudoBB == null) {
            this.pseudoBB = new PseudoBackbone(this.model, this.model.getStates().values(), this.getResClassifier());
        }
        return this.pseudoBB;
    }

    public String getModelId() {
        return this.model.toString();
    }
}

