/*
 * Decompiled with CFR 0.152.
 */
package king.tool.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.util.SoftLog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import king.KinCanvas;
import king.Plugin;
import king.ToolBox;

public class PdfExport
extends Plugin
implements PropertyChangeListener,
Runnable {
    JFileChooser chooser;
    SuffixFileFilter pdfFilter;
    SuffixFileFilter pdftFilter;

    public PdfExport(ToolBox toolBox) {
        super(toolBox);
        this.buildChooser();
    }

    private void buildChooser() {
        this.pdfFilter = new SuffixFileFilter("Portable Document Format (PDF)");
        this.pdfFilter.addSuffix(".pdf");
        this.pdftFilter = new SuffixFileFilter("PDF with transparent background");
        this.pdftFilter.addSuffix(".pdf");
        String string = System.getProperty("user.dir");
        this.chooser = new JFileChooser();
        this.chooser.addChoosableFileFilter(this.pdfFilter);
        this.chooser.addChoosableFileFilter(this.pdftFilter);
        this.chooser.setFileFilter(this.pdfFilter);
        if (string != null) {
            this.chooser.setCurrentDirectory(new File(string));
        }
        this.chooser.addPropertyChangeListener(this);
    }

    public static void exportPDF(KinCanvas kinCanvas, File file) throws IOException, DocumentException {
        PdfExport.exportPDF(kinCanvas, false, file);
    }

    public static void exportPDF(KinCanvas kinCanvas, boolean bl, File file) throws IOException, DocumentException {
        Dimension dimension = kinCanvas.getCanvasSize();
        Document document = new Document(PageSize.LETTER, 72.0f, 72.0f, 72.0f, 72.0f);
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
        document.addCreator("KiNG by Ian W. Davis");
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)dimension.getWidth(), (float)dimension.getHeight());
        Graphics2D graphics2D = pdfTemplate.createGraphics((float)dimension.getWidth(), (float)dimension.getHeight());
        if (bl) {
            kinCanvas.getEngine().setTransparentBackground();
        }
        kinCanvas.paintCanvas(graphics2D, dimension, 2);
        graphics2D.dispose();
        double d = document.right() - document.left();
        double d2 = document.top() - document.bottom();
        float f = (float)Math.min(d / dimension.getWidth(), d2 / dimension.getHeight());
        pdfContentByte.addTemplate(pdfTemplate, f, 0.0f, 0.0f, f, document.left(), (float)((double)document.top() - (double)f * dimension.getHeight()));
        document.close();
    }

    public void askExport() {
        this.propertyChange(null);
        String string = System.getProperty("user.dir");
        if (string != null) {
            this.chooser.setCurrentDirectory(new File(string));
        }
        if (0 == this.chooser.showSaveDialog(this.kMain.getTopWindow())) {
            File file = this.chooser.getSelectedFile();
            if (!this.pdfFilter.accept(file) && 0 == JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "This file has the wrong extension. Append '.pdf' to the name?", "Fix extension?", 0)) {
                file = new File(file + ".pdf");
            }
            if (!file.exists() || 0 == JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "This file exists -- do you want to overwrite it?", "Overwrite file?", 0)) {
                try {
                    PdfExport.exportPDF(this.kMain.getCanvas(), this.pdftFilter.equals(this.chooser.getFileFilter()), file);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An error occurred while saving the file:\n" + exception.getMessage(), "Sorry!", 0);
                    exception.printStackTrace(SoftLog.err);
                }
                System.setProperty("user.dir", file.getAbsolutePath());
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null || "fileFilterChanged".equals(propertyChangeEvent.getPropertyName()) || "directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        String string = "pdf";
        for (int i = 1; i < 1000; ++i) {
            File file = new File(this.chooser.getCurrentDirectory(), "kingsnap" + i + "." + string);
            if (file.exists()) continue;
            this.chooser.setSelectedFile(file);
            break;
        }
    }

    public JMenuItem getToolsMenuItem() {
        return new JMenuItem(new ReflectiveAction(this.toString() + "...", null, this, "onExport"));
    }

    public JMenuItem getHelpMenuItem() {
        return null;
    }

    public String toString() {
        return "PDF document";
    }

    public void onExport(ActionEvent actionEvent) {
        this.askExport();
    }

    public static boolean isAppletSafe() {
        return false;
    }
}

