/*
 * Decompiled with CFR 0.152.
 */
package king.tool.edmap;

import driftwood.gui.FatJList;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.gui.TablePane2;
import driftwood.isosurface.Ccp4VertexSource;
import driftwood.isosurface.CrystalVertexSource;
import driftwood.isosurface.OMapVertexSource;
import driftwood.isosurface.XplorVertexSource;
import driftwood.util.SoftLog;
import driftwood.util.Strings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import king.FileDropHandler;
import king.KMessage;
import king.KinCanvas;
import king.Plugin;
import king.ToolBox;
import king.tool.edmap.EDMapWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDMapPlugin
extends Plugin
implements ListSelectionListener,
KMessage.Subscriber {
    static final String MAPTYPE_O = "O map (DSN6/Brix)";
    static final String MAPTYPE_XPLOR = "XPLOR map (ASCII format)";
    static final String MAPTYPE_CCP4 = "CCP4 map (type 2)";
    JFileChooser filechooser = null;
    JDialog urlchooser = null;
    JList urlList = null;
    JTextField urlField = null;
    boolean urlChooserOK = false;
    SuffixFileFilter omapFilter;
    SuffixFileFilter xmapFilter;
    SuffixFileFilter ccp4Filter;
    SuffixFileFilter mapFilter;

    public EDMapPlugin(ToolBox toolBox) {
        super(toolBox);
        this.makeFileFilters();
        this.kMain.subscribe(this);
        this.kMain.getFileDropHandler().addFileDropListener(new MapFileOpen());
    }

    @Override
    public void deliverMessage(KMessage kMessage) {
        if (kMessage.testProg(1L)) {
            this.kMain.unsubscribe(this);
            JApplet jApplet = this.kMain.getApplet();
            if (jApplet == null) {
                return;
            }
            KinCanvas kinCanvas = this.kMain.getCanvas();
            if (kinCanvas == null) {
                return;
            }
            ToolBox toolBox = kinCanvas.getToolBox();
            if (toolBox == null) {
                return;
            }
            boolean bl = false;
            String string = jApplet.getParameter("xmap");
            if (string == null) {
                string = jApplet.getParameter("omap");
                bl = true;
            }
            if (string == null) {
                return;
            }
            try {
                URL uRL = new URL(jApplet.getDocumentBase(), string);
                CrystalVertexSource crystalVertexSource = bl ? new OMapVertexSource(uRL.openStream()) : new XplorVertexSource(uRL.openStream());
                new EDMapWindow(toolBox, crystalVertexSource, uRL.getFile());
            }
            catch (MalformedURLException malformedURLException) {
                SoftLog.err.println("<PARAM> xmap/omap specified an unresolvable URL.");
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An I/O error occurred while loading the file:\n" + iOException.getMessage(), "Sorry!", 0);
                iOException.printStackTrace(SoftLog.err);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Wrong map format was chosen, or map is corrupt:\n" + illegalArgumentException.getMessage(), "Sorry!", 0);
                illegalArgumentException.printStackTrace(SoftLog.err);
            }
        }
    }

    void makeFileFilters() {
        this.omapFilter = new SuffixFileFilter("O maps (DSN6/Brix)");
        this.omapFilter.addSuffix(".brix");
        this.omapFilter.addSuffix(".brix.gz");
        this.omapFilter.addSuffix(".dsn6");
        this.omapFilter.addSuffix(".dsn6.gz");
        this.omapFilter.addSuffix(".dn6");
        this.omapFilter.addSuffix(".dn6.gz");
        this.omapFilter.addSuffix(".omap");
        this.omapFilter.addSuffix(".omap.gz");
        this.xmapFilter = new SuffixFileFilter("XPLOR maps (ASCII format)");
        this.xmapFilter.addSuffix(".xmap");
        this.xmapFilter.addSuffix(".xmap.gz");
        this.xmapFilter.addSuffix(".xplor");
        this.xmapFilter.addSuffix(".xplor.gz");
        this.ccp4Filter = new SuffixFileFilter("CCP4 maps (type 2)");
        this.ccp4Filter.addSuffix(".ccp4");
        this.ccp4Filter.addSuffix(".ccp4.gz");
        this.ccp4Filter.addSuffix(".mbk");
        this.ccp4Filter.addSuffix(".mbk.gz");
        this.ccp4Filter.addSuffix(".map");
        this.ccp4Filter.addSuffix(".map.gz");
        this.mapFilter = new SuffixFileFilter("All electron density maps");
        this.mapFilter.addSuffix(".ccp4");
        this.mapFilter.addSuffix(".ccp4.gz");
        this.mapFilter.addSuffix(".mbk");
        this.mapFilter.addSuffix(".mbk.gz");
        this.mapFilter.addSuffix(".xmap");
        this.mapFilter.addSuffix(".xmap.gz");
        this.mapFilter.addSuffix(".xplor");
        this.mapFilter.addSuffix(".xplor.gz");
        this.mapFilter.addSuffix(".brix");
        this.mapFilter.addSuffix(".brix.gz");
        this.mapFilter.addSuffix(".dsn6");
        this.mapFilter.addSuffix(".dsn6.gz");
        this.mapFilter.addSuffix(".dn6");
        this.mapFilter.addSuffix(".dn6.gz");
        this.mapFilter.addSuffix(".omap");
        this.mapFilter.addSuffix(".omap.gz");
        this.mapFilter.addSuffix(".map");
        this.mapFilter.addSuffix(".map.gz");
    }

    void makeFileChooser() {
        this.filechooser = new JFileChooser();
        String string = System.getProperty("user.dir");
        if (string != null) {
            this.filechooser.setCurrentDirectory(new File(string));
        }
        this.filechooser.addChoosableFileFilter(this.mapFilter);
        this.filechooser.addChoosableFileFilter(this.omapFilter);
        this.filechooser.addChoosableFileFilter(this.xmapFilter);
        this.filechooser.addChoosableFileFilter(this.ccp4Filter);
        this.filechooser.setFileFilter(this.mapFilter);
    }

    void makeURLChooser() {
        Object object;
        Object object2;
        this.urlList = new FatJList(150, 12);
        JApplet jApplet = this.kMain.getApplet();
        if (jApplet != null && (object2 = jApplet.getParameter("edmapList")) != null) {
            object = Strings.explode((String)object2, ' ');
            this.urlList.setListData((E[])object);
        }
        this.urlList.setSelectionMode(0);
        this.urlList.addListSelectionListener(this);
        object2 = new JScrollPane(this.urlList);
        this.urlField = new JTextField(20);
        object = new JButton(new ReflectiveAction("OK", null, this, "onUrlOk"));
        JButton jButton = new JButton(new ReflectiveAction("Cancel", null, this, "onUrlCancel"));
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.center().middle().insets(6).memorize();
        tablePane2.addCell((Component)object2, 2, 1);
        tablePane2.newRow();
        tablePane2.weights(0.0, 1.0).addCell(new JLabel("URL:")).hfill(true).addCell(this.urlField);
        tablePane2.newRow().startSubtable(2, 1).center().insets(1, 4, 1, 4).memorize();
        tablePane2.addCell((Component)object).addCell(jButton).endSubtable();
        this.urlchooser = new JDialog(this.kMain.getTopWindow(), "ED Map URLs", true);
        this.urlchooser.setDefaultCloseOperation(0);
        this.urlchooser.setContentPane(tablePane2);
        this.urlchooser.pack();
        this.urlchooser.setLocationRelativeTo(this.kMain.getTopWindow());
    }

    @Override
    public void loadFileFromCmdline(ArrayList<File> arrayList) {
        for (File file : arrayList) {
            try {
                if (!this.mapFilter.accept(file)) continue;
                if (this.kMain.getKinemage() != null) {
                    this.openMapFile(file);
                    continue;
                }
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "In order to run KiNG with a map from cmdline,\n you must also give a kin or PDB file!", "Sorry!", 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }

    @Override
    public JMenuItem getToolsMenuItem() {
        return new JMenuItem(new ReflectiveAction(this.toString(), null, this, "onOpenMap"));
    }

    public String toString() {
        return "Electron density maps";
    }

    @Override
    public JMenuItem getHelpMenuItem() {
        return new JMenuItem(new ReflectiveAction(this.toString(), null, this, "onHelp"));
    }

    @Override
    public String getHelpAnchor() {
        return "#edmap-plugin";
    }

    public void onOpenMap(ActionEvent actionEvent) {
        if (this.kMain.getKinemage() == null) {
            return;
        }
        try {
            if (this.kMain.getApplet() != null) {
                this.openMapURL();
            } else {
                this.openMapFile();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An I/O error occurred while loading the file:\n" + iOException.getMessage(), "Sorry!", 0);
            iOException.printStackTrace(SoftLog.err);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Wrong map format was chosen, or map is corrupt:\n" + illegalArgumentException.getMessage(), "Sorry!", 0);
            illegalArgumentException.printStackTrace(SoftLog.err);
        }
    }

    String askMapFormat(String string) {
        Object[] objectArray = new Object[]{MAPTYPE_O, MAPTYPE_XPLOR, MAPTYPE_CCP4};
        String string2 = MAPTYPE_O;
        if (this.omapFilter.accept(string)) {
            string2 = MAPTYPE_O;
        } else if (this.xmapFilter.accept(string)) {
            string2 = MAPTYPE_XPLOR;
        } else if (this.ccp4Filter.accept(string)) {
            string2 = MAPTYPE_CCP4;
        }
        String string3 = (String)JOptionPane.showInputDialog(this.kMain.getTopWindow(), "What format is this map in?", "Choose format", -1, null, objectArray, string2);
        return string3;
    }

    void openMapFile() throws IOException {
        String string;
        if (this.filechooser == null) {
            this.makeFileChooser();
        }
        if ((string = System.getProperty("user.dir")) != null) {
            this.filechooser.setCurrentDirectory(new File(string));
        }
        if (0 == this.filechooser.showOpenDialog(this.kMain.getTopWindow())) {
            File file = this.filechooser.getSelectedFile();
            this.openMapFile(file);
            System.setProperty("user.dir", file.getAbsolutePath());
        }
    }

    void openMapFile(File file) throws IOException {
        if (file != null && file.exists()) {
            CrystalVertexSource crystalVertexSource;
            String string = this.askMapFormat(file.getName());
            if (MAPTYPE_O.equals(string)) {
                crystalVertexSource = new OMapVertexSource(new FileInputStream(file));
            } else if (MAPTYPE_XPLOR.equals(string)) {
                crystalVertexSource = new XplorVertexSource(new FileInputStream(file));
            } else if (MAPTYPE_CCP4.equals(string)) {
                crystalVertexSource = new Ccp4VertexSource(new FileInputStream(file));
            } else {
                throw new IllegalArgumentException("Map type not specified");
            }
            EDMapWindow eDMapWindow = new EDMapWindow(this.parent, crystalVertexSource, file.getName());
            this.kMain.publish(new KMessage(this.kMain.getKinemage(), 1));
        }
    }

    void openMapURL() throws MalformedURLException, IOException {
        if (this.urlchooser == null) {
            this.makeURLChooser();
        }
        this.urlchooser.setVisible(true);
        if (this.urlChooserOK) {
            CrystalVertexSource crystalVertexSource;
            URL uRL = new URL(this.urlField.getText());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            String string = this.askMapFormat(this.urlField.getText());
            if (MAPTYPE_O.equals(string)) {
                crystalVertexSource = new OMapVertexSource(bufferedInputStream);
            } else if (MAPTYPE_XPLOR.equals(string)) {
                crystalVertexSource = new XplorVertexSource(bufferedInputStream);
            } else if (MAPTYPE_CCP4.equals(string)) {
                crystalVertexSource = new Ccp4VertexSource(bufferedInputStream);
            } else {
                throw new IllegalArgumentException("Map type not specified");
            }
            EDMapWindow eDMapWindow = new EDMapWindow(this.parent, crystalVertexSource, uRL.getFile());
            this.kMain.publish(new KMessage(this.kMain.getKinemage(), 1));
        }
    }

    public void onUrlCancel(ActionEvent actionEvent) {
        this.urlChooserOK = false;
        this.urlchooser.setVisible(false);
    }

    public void onUrlOk(ActionEvent actionEvent) {
        this.urlChooserOK = true;
        this.urlchooser.setVisible(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e = this.urlList.getSelectedValue();
        if (e != null) {
            String string = e.toString();
            this.urlField.setText("http://" + string);
            JApplet jApplet = this.kMain.getApplet();
            if (jApplet != null) {
                try {
                    URL uRL = new URL(jApplet.getDocumentBase(), jApplet.getParameter("edmapBase") + "/" + string);
                    this.urlField.setText(uRL.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    SoftLog.err.println(jApplet.getDocumentBase());
                    SoftLog.err.println(jApplet.getParameter("edmapBase"));
                    SoftLog.err.println(string);
                    malformedURLException.printStackTrace(SoftLog.err);
                }
            }
        }
    }

    private class MapFileOpen
    implements FileDropHandler.Listener {
        private MapFileOpen() {
        }

        public String toString() {
            return "Open as electron density map in KiNG";
        }

        public boolean canHandleDroppedFile(File file) {
            return EDMapPlugin.this.mapFilter.accept(file);
        }

        public void handleDroppedFile(File file) {
            try {
                EDMapPlugin.this.openMapFile(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }
}

