/*
 * Decompiled with CFR 0.152.
 */
package king.points;

import java.awt.Color;
import king.core.Engine2D;
import king.core.KPaint;
import king.core.KPoint;
import king.points.AbstractPoint;

public class MarkerPoint
extends AbstractPoint {
    public static final int CROSS_S = 1;
    public static final int CROSS_M = 2;
    public static final int CROSS_L = 4;
    public static final int CROSS_2 = 8;
    public static final int X_S = 16;
    public static final int X_M = 32;
    public static final int X_L = 64;
    public static final int X_2 = 128;
    public static final int SQUARE_S = 256;
    public static final int SQUARE_M = 512;
    public static final int SQUARE_L = 1024;
    public static final int BOX_S = 4096;
    public static final int BOX_M = 8192;
    public static final int BOX_L = 16384;
    public static final int RING_S = 65536;
    public static final int RING_M = 131072;
    public static final int RING_L = 262144;
    public static final int DISC_S = 0x100000;
    public static final int DISC_M = 0x200000;
    public static final int DISC_L = 0x400000;
    int style = 0;

    public MarkerPoint(String string) {
        super(string);
    }

    public MarkerPoint(KPoint kPoint, KPaint kPaint, int n) {
        super("marker");
        this.setColor(kPaint);
        this.setStyle(n);
        this.setUnpickable(true);
        this.x0 = (float)kPoint.getX();
        this.y0 = (float)kPoint.getY();
        this.z0 = (float)kPoint.getZ();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        this.style = n;
        this.fireKinChanged(512);
    }

    public void paint2D(Engine2D engine2D) {
        KPaint kPaint = this.getDrawingColor(engine2D);
        if (kPaint.isInvisible()) {
            return;
        }
        Color color = kPaint.getPaint(engine2D.backgroundMode, engine2D.colorCue);
        int n = engine2D.markerSize;
        int n2 = this.getStyle();
        if (n2 == 0 && this.parent != null) {
            n2 = this.parent.getStyle();
        }
        engine2D.painter.paintMarker(color, this.x, this.y, this.z, n, n2);
    }
}

