/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.FatJList;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.gui.TablePane2;
import driftwood.util.SoftLog;
import driftwood.util.Strings;
import driftwood.util.URLEncodedOutputStream;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import king.KMessage;
import king.KingMain;
import king.core.Kinemage;
import king.io.KinfileLoader;
import king.io.KinfileParser;
import king.io.KinfileWriter;

public class KinfileIO
implements KinfileLoader.Listener,
ListSelectionListener {
    KingMain kMain;
    JFileChooser fileOpenChooser = null;
    JFileChooser fileSaveChooser = null;
    File lastOpenedFile = null;
    File lastSavedFile = null;
    JDialog urlchooser = null;
    JList urlList = null;
    JTextField urlField = null;
    boolean urlChooserOK = false;
    JDialog progDialog = null;
    JProgressBar progBar = null;
    String fName = null;
    Kinemage mergeTarget = null;

    public KinfileIO(KingMain kingMain) {
        this.kMain = kingMain;
        this.initFileChooser();
        this.initURLChooser();
        this.initProgressDialog();
    }

    private void initFileChooser() {
        try {
            SuffixFileFilter suffixFileFilter = new SuffixFileFilter("Kinemage files (*.kin)");
            suffixFileFilter.addSuffix(".kin");
            suffixFileFilter.addSuffix(".kin.gz");
            suffixFileFilter.addSuffix(".kinz");
            suffixFileFilter.addSuffix(".kip");
            suffixFileFilter.addSuffix(".kip1");
            suffixFileFilter.addSuffix(".kip2");
            suffixFileFilter.addSuffix(".kip3");
            suffixFileFilter.addSuffix(".kip4");
            suffixFileFilter.addSuffix(".kip5");
            suffixFileFilter.addSuffix(".kip6");
            suffixFileFilter.addSuffix(".kip7");
            suffixFileFilter.addSuffix(".kip8");
            suffixFileFilter.addSuffix(".kip9");
            this.fileOpenChooser = new JFileChooser();
            this.fileOpenChooser.addChoosableFileFilter(suffixFileFilter);
            this.fileOpenChooser.setFileFilter(suffixFileFilter);
            this.fileSaveChooser = new JFileChooser();
            this.fileSaveChooser.addChoosableFileFilter(suffixFileFilter);
            this.fileSaveChooser.setFileFilter(suffixFileFilter);
            String string = System.getProperty("user.dir");
            if (string != null) {
                this.fileOpenChooser.setCurrentDirectory(new File(string));
                this.fileSaveChooser.setCurrentDirectory(new File(string));
            }
        }
        catch (SecurityException securityException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            if (!(exceptionInInitializerError.getCause() instanceof AccessControlException)) {
                throw exceptionInInitializerError;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    void initURLChooser() {
        Object object;
        Object object2;
        this.urlList = new FatJList(150, 12);
        JApplet jApplet = this.kMain.getApplet();
        if (jApplet != null && (object2 = jApplet.getParameter("kinfileList")) != null) {
            object = Strings.explode((String)object2, ' ');
            this.urlList.setListData((E[])object);
        }
        this.urlList.setSelectionMode(0);
        this.urlList.addListSelectionListener(this);
        object2 = new JScrollPane(this.urlList);
        this.urlField = new JTextField(20);
        object = new JButton(new ReflectiveAction("OK", null, this, "onUrlOk"));
        JButton jButton = new JButton(new ReflectiveAction("Cancel", null, this, "onUrlCancel"));
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.center().middle().insets(6).memorize();
        tablePane2.addCell((Component)object2, 2, 1);
        tablePane2.newRow();
        tablePane2.weights(0.0, 1.0).addCell(new JLabel("URL:")).hfill(true).addCell(this.urlField);
        tablePane2.newRow().startSubtable(2, 1).center().insets(1, 4, 1, 4).memorize();
        tablePane2.addCell((Component)object).addCell(jButton).endSubtable();
        this.urlchooser = new JDialog(this.kMain.getTopWindow(), "Kinemage URLs", true);
        this.urlchooser.setDefaultCloseOperation(0);
        this.urlchooser.setContentPane(tablePane2);
        this.urlchooser.pack();
        this.urlchooser.setLocationRelativeTo(this.kMain.getTopWindow());
    }

    private void initProgressDialog() {
        this.progBar = new JProgressBar();
        this.progBar.setStringPainted(true);
        this.progBar.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel jLabel = new JLabel("Loading kinemage(s)...");
        jLabel.setHorizontalAlignment(0);
        jLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.progDialog = new JDialog(this.kMain.getTopWindow(), "", true);
        this.progDialog.setDefaultCloseOperation(0);
        this.progDialog.getContentPane().add((Component)this.progBar, "South");
        this.progDialog.getContentPane().add((Component)jLabel, "North");
    }

    public boolean askLoadFile(Kinemage kinemage) {
        if (this.fileOpenChooser == null) {
            return false;
        }
        String string = System.getProperty("user.dir");
        if (string != null) {
            this.fileOpenChooser.setCurrentDirectory(new File(string));
        }
        if (0 == this.fileOpenChooser.showOpenDialog(this.kMain.getTopWindow())) {
            File file = this.fileOpenChooser.getSelectedFile();
            this.loadFile(file, kinemage);
            System.setProperty("user.dir", file.getAbsolutePath());
            return true;
        }
        return false;
    }

    public void loadFile(File file, Kinemage kinemage) {
        try {
            this.fName = file.getName();
            this.mergeTarget = kinemage;
            new KinfileLoader(new FileInputStream(file), this);
            if (kinemage == null) {
                this.lastOpenedFile = file;
                this.lastSavedFile = null;
            }
            this.progBar.setMaximum((int)file.length());
            this.progBar.setValue(0);
            this.progDialog.pack();
            this.progDialog.setLocationRelativeTo(this.kMain.getTopWindow());
            this.progDialog.setVisible(true);
        }
        catch (IOException iOException) {
            this.loadingException(iOException);
        }
    }

    public boolean askLoadURL(Kinemage kinemage) {
        URL uRL;
        if (this.urlchooser == null) {
            return false;
        }
        try {
            uRL = this.kMain.getAppletKinURL();
            if (uRL != null) {
                this.urlField.setText(uRL.toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.urlchooser.setVisible(true);
        if (this.urlChooserOK) {
            try {
                uRL = new URL(this.urlField.getText());
                this.loadURL(uRL, kinemage);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                this.loadingException(malformedURLException);
            }
        }
        return false;
    }

    public void onUrlCancel(ActionEvent actionEvent) {
        this.urlChooserOK = false;
        this.urlchooser.setVisible(false);
    }

    public void onUrlOk(ActionEvent actionEvent) {
        this.urlChooserOK = true;
        this.urlchooser.setVisible(false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e = this.urlList.getSelectedValue();
        if (e != null) {
            String string = e.toString();
            this.urlField.setText("http://" + string);
            JApplet jApplet = this.kMain.getApplet();
            if (jApplet != null) {
                try {
                    URL uRL = new URL(jApplet.getDocumentBase(), jApplet.getParameter("kinfileBase") + "/" + string);
                    this.urlField.setText(uRL.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    SoftLog.err.println(jApplet.getDocumentBase());
                    SoftLog.err.println(jApplet.getParameter("kinfileBase"));
                    SoftLog.err.println(string);
                    malformedURLException.printStackTrace(SoftLog.err);
                }
            }
        }
    }

    public void loadURL(URL uRL, Kinemage kinemage) {
        try {
            this.fName = uRL.getFile();
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setAllowUserInteraction(false);
            uRLConnection.connect();
            this.loadStream(uRLConnection.getInputStream(), uRLConnection.getContentLength(), kinemage);
        }
        catch (IOException iOException) {
            this.loadingException(iOException);
        }
    }

    public void loadStream(InputStream inputStream, int n, Kinemage kinemage) {
        this.mergeTarget = kinemage;
        new KinfileLoader(inputStream, this);
        this.progBar.setMaximum(n);
        this.progBar.setValue(0);
        this.progDialog.pack();
        this.progDialog.setLocationRelativeTo(this.kMain.getTopWindow());
        this.progDialog.setVisible(true);
    }

    public void updateProgress(long l) {
        this.progBar.setValue((int)l);
    }

    public void loadingException(Throwable throwable) {
        this.progDialog.setVisible(false);
        throwable.printStackTrace(SoftLog.err);
        JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "The file '" + this.fName + "'\ncould not be opened due to an exception:\n" + throwable.getMessage(), "Error", 0);
        this.mergeTarget = null;
    }

    public void loadingComplete(KinfileParser kinfileParser) {
        Iterator<Kinemage> iterator = kinfileParser.getKinemages().iterator();
        while (iterator.hasNext()) {
            iterator.next().initAll();
        }
        if (this.mergeTarget == null) {
            this.kMain.getStable().append(kinfileParser.getKinemages());
        } else {
            iterator = kinfileParser.getKinemages().iterator();
            while (iterator.hasNext()) {
                this.mergeTarget.appendKinemage(iterator.next());
            }
        }
        if (this.kMain.getTextWindow() != null) {
            this.kMain.getTextWindow().appendText(kinfileParser.getText());
        }
        this.mergeTarget = null;
        this.progDialog.setVisible(false);
    }

    public void askSaveFile() {
        this.askSaveFile(this.kMain.getStable().children);
    }

    public void askSaveFile(Kinemage kinemage) {
        this.askSaveFile(Collections.singleton(kinemage));
    }

    public void askSaveFile(Collection collection) {
        File file;
        if (this.fileSaveChooser == null) {
            return;
        }
        this.setMangledName();
        String string = System.getProperty("user.dir");
        if (string != null) {
            this.fileSaveChooser.setCurrentDirectory(new File(string));
        }
        if (!(0 != this.fileSaveChooser.showSaveDialog(this.kMain.getTopWindow()) || (file = this.fileSaveChooser.getSelectedFile()).exists() && JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "This file exists -- do you want to overwrite it?", "Overwrite file?", 0) != 0)) {
            this.saveFile(file, collection);
            System.setProperty("user.dir", file.getAbsolutePath());
        }
    }

    public void saveFile(File file) {
        this.saveFile(file, this.kMain.getStable().children);
    }

    public void saveFile(File file, Collection collection) {
        this.kMain.publish(new KMessage(this, 32L));
        for (Object object : collection) {
            ((Kinemage)object).removeEmptyAGEs();
            ((Kinemage)object).removeUnusedMasters();
        }
        try {
            Object object;
            FileWriter fileWriter = new FileWriter(file);
            object = new KinfileWriter();
            ((KinfileWriter)object).save(fileWriter, this.kMain.getTextWindow().getText(), collection);
            this.lastSavedFile = file;
            ((Writer)fileWriter).close();
            for (Kinemage kinemage : collection) {
                kinemage.setModified(false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An error occurred while saving the file.", "Sorry!", 0);
        }
    }

    void setMangledName() {
        File file;
        if (this.fileSaveChooser == null) {
            return;
        }
        if (this.lastSavedFile != null) {
            file = this.lastSavedFile;
        } else if (this.lastOpenedFile != null) {
            file = this.lastOpenedFile;
        } else {
            return;
        }
        String string = file.getName();
        if (string.endsWith(".gz")) {
            string = string.substring(0, string.length() - 3);
        }
        if (string.endsWith(".kin")) {
            if (string.length() > 6 && string.charAt(string.length() - 6) == '.') {
                String string2 = string.substring(0, string.length() - 6);
                char c = string.charAt(string.length() - 5);
                if ('0' <= c && c < '9') {
                    c = (char)(c + '\u0001');
                    string = string2 + "." + c + ".kin";
                } else if (c == '9') {
                    string = string2 + ".a.kin";
                } else if ('a' <= c && c < 'z') {
                    c = (char)(c + '\u0001');
                    string = string2 + "." + c + ".kin";
                } else {
                    string = string2 + "." + c + ".1.kin";
                }
            } else {
                String string3 = string.substring(0, string.length() - 4);
                string = string3 + ".1.kin";
            }
        }
        file = new File(file.getParent(), string);
        this.fileSaveChooser.setCurrentDirectory(file);
        this.fileSaveChooser.setSelectedFile(file);
    }

    public void askSaveURL() {
        String string = JOptionPane.showInputDialog(this.kMain.getTopWindow(), "Enter a new name for the file (overwrite generally NOT allowed):", "Save file as", -1);
        if (string != null) {
            this.saveURL(string);
        }
    }

    public void saveURL(String string) {
        try {
            JApplet jApplet = this.kMain.getApplet();
            if (jApplet == null) {
                return;
            }
            String string2 = jApplet.getParameter("kinfileSaveHandler");
            if (string2 == null) {
                return;
            }
            URL uRL = new URL(jApplet.getDocumentBase(), string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/4.0");
            httpURLConnection.setRequestMethod("POST");
            URLEncodedOutputStream uRLEncodedOutputStream = new URLEncodedOutputStream(new BufferedOutputStream(httpURLConnection.getOutputStream()));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLEncodedOutputStream);
            uRLEncodedOutputStream.setEncoding(false);
            outputStreamWriter.write("fileName=");
            ((Writer)outputStreamWriter).flush();
            uRLEncodedOutputStream.setEncoding(true);
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).flush();
            uRLEncodedOutputStream.setEncoding(false);
            outputStreamWriter.write("&fileContents=");
            ((Writer)outputStreamWriter).flush();
            uRLEncodedOutputStream.setEncoding(true);
            KinfileWriter kinfileWriter = new KinfileWriter();
            kinfileWriter.save(outputStreamWriter, this.kMain.getTextWindow().getText(), this.kMain.getStable().children);
            ((Writer)outputStreamWriter).close();
            SoftLog.err.println("HTTP response: " + httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
            this.streamcopy(httpURLConnection.getInputStream(), SoftLog.err);
            for (Kinemage kinemage : this.kMain.getStable().getKins()) {
                kinemage.setModified(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(SoftLog.err);
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An error occurred while saving the file.", "Sorry!", 0);
        }
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }
}

