/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.r3.Transform;
import driftwood.util.SoftLog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import king.HTMLHelp;
import king.Plugin;
import king.ToolBox;
import king.core.Engine;
import king.core.KPoint;
import king.core.KView;
import king.core.Painter;
import king.core.Transformable;

public class BasicTool
extends Plugin
implements MouseListener,
MouseMotionListener,
Transformable,
WindowListener {
    static final Object MODE_UNDECIDED = new Object();
    static final Object MODE_VERTICAL = new Object();
    static final Object MODE_HORIZONTAL = new Object();
    protected int lastXCoord = 0;
    protected int lastYCoord = 0;
    protected int pressXCoord = 0;
    protected int pressYCoord = 0;
    protected boolean isNearTop = false;
    protected boolean isNearBottom = false;
    protected Object mouseDragMode = MODE_UNDECIDED;
    protected JDialog dialog = null;
    private boolean hasBeenCentered = false;

    public BasicTool(ToolBox toolBox) {
        super(toolBox);
    }

    public void start() {
        this.show();
    }

    public void stop() {
        this.hide();
    }

    public void reset() {
    }

    protected void initDialog() {
        Container container = this.getToolPanel();
        if (container == null) {
            return;
        }
        this.dialog = new JDialog(this.kMain.getTopWindow(), this.toString(), false);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this);
        this.dialog.setContentPane(container);
        this.dialog.pack();
    }

    protected void show() {
        if (this.dialog == null) {
            this.initDialog();
        }
        if (this.dialog == null) {
            return;
        }
        if (!this.dialog.isVisible()) {
            this.dialog.pack();
            Container container = this.kMain.getContentContainer();
            if (container != null) {
                Point point = container.getLocation();
                Dimension dimension = this.dialog.getSize();
                Dimension dimension2 = container.getSize();
                point.x += dimension2.width - dimension.width / 2;
                point.y += (dimension2.height - dimension.height) / 2;
                this.dialog.setLocation(point);
            }
            this.dialog.setVisible(true);
        } else {
            this.dialog.toFront();
        }
    }

    protected void hide() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public void click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        this.services.pick(kPoint);
        if (kPoint != null && kPoint.getComment() != null) {
            this.clickActionHandler(kPoint.getComment());
        }
    }

    public void s_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        this.services.centerOnPoint(kPoint);
    }

    public void c_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        this.click(n, n2, kPoint, mouseEvent);
    }

    public void sc_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        this.click(n, n2, kPoint, mouseEvent);
    }

    public void drag(int n, int n2, MouseEvent mouseEvent) {
        if (this.services.doFlatland.isSelected()) {
            if (this.isNearTop) {
                this.services.ztranslate(n);
            } else {
                this.services.translate(n, n2);
            }
        } else if (this.isNearTop) {
            this.services.pinwheel(n);
        } else {
            this.services.rotate(n, n2);
        }
    }

    public void s_drag(int n, int n2, MouseEvent mouseEvent) {
        if (this.mouseDragMode == MODE_VERTICAL) {
            this.services.adjustZoom(n2);
        } else if (this.mouseDragMode == MODE_HORIZONTAL) {
            this.services.adjustClipping(n);
        }
    }

    public void c_drag(int n, int n2, MouseEvent mouseEvent) {
        if (this.isNearTop) {
            this.services.ztranslate(n);
        } else {
            this.services.translate(n, n2);
        }
    }

    public void sc_drag(int n, int n2, MouseEvent mouseEvent) {
        if (this.isNearTop) {
            this.services.pinwheel(n);
        } else {
            this.services.rotate(n, 0.0f);
        }
    }

    public void wheel(int n, MouseEvent mouseEvent) {
        this.services.adjustZoom((float)n * 18.0f);
    }

    public void s_wheel(int n, MouseEvent mouseEvent) {
        this.services.adjustClipping((float)(-n) * 18.0f);
    }

    public void c_wheel(int n, MouseEvent mouseEvent) {
        this.wheel(n, mouseEvent);
    }

    public void sc_wheel(int n, MouseEvent mouseEvent) {
        this.s_wheel(n, mouseEvent);
    }

    protected boolean clickActionHandler(String string) {
        if (string.startsWith("http:")) {
            try {
                URL uRL = !string.startsWith("http://") && this.kMain.getApplet() != null ? new URL(this.kMain.getApplet().getDocumentBase(), string.substring(5)) : new URL(string);
                new HTMLHelp(this.kMain, uRL).show();
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                SoftLog.err.println("Bad HTTP URL in point comment: " + string);
                return false;
            }
        }
        return false;
    }

    public void mouseWheelMoved(MouseEvent mouseEvent, int n) {
        boolean bl = mouseEvent.isShiftDown();
        boolean bl2 = mouseEvent.isControlDown();
        if (bl && bl2) {
            this.sc_wheel(n, mouseEvent);
        } else if (bl2) {
            this.c_wheel(n, mouseEvent);
        } else if (bl) {
            this.s_wheel(n, mouseEvent);
        } else {
            this.wheel(n, mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        int n;
        int n2;
        Dimension dimension = this.kCanvas.getCanvasSize();
        Point point = mouseEvent.getPoint();
        int n3 = point.x - this.lastXCoord;
        int n4 = point.y - this.lastYCoord;
        if (this.mouseDragMode == MODE_UNDECIDED) {
            n2 = Math.abs(point.x - this.pressXCoord);
            if (n2 / 2 >= (n = Math.abs(point.y - this.pressYCoord)) + 1) {
                this.mouseDragMode = MODE_HORIZONTAL;
            } else if (n / 2 >= n2 + 1) {
                this.mouseDragMode = MODE_VERTICAL;
            }
        }
        n2 = SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isShiftDown() ? 1 : 0;
        n = SwingUtilities.isMiddleMouseButton(mouseEvent) || mouseEvent.isControlDown() ? 1 : 0;
        boolean bl2 = bl = n2 != 0 && n != 0 || SwingUtilities.isLeftMouseButton(mouseEvent) && SwingUtilities.isRightMouseButton(mouseEvent);
        if (bl) {
            this.sc_drag(n3, n4, mouseEvent);
        } else if (n != 0) {
            this.c_drag(n3, n4, mouseEvent);
        } else if (n2 != 0) {
            this.s_drag(n3, n4, mouseEvent);
        } else {
            this.drag(n3, n4, mouseEvent);
        }
        this.lastXCoord = point.x;
        this.lastYCoord = point.y;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        KPoint kPoint = null;
        if (this.kMain.getKinemage() != null) {
            kPoint = this.kCanvas.getEngine().pickPoint(n, n2, this.services.doSuperpick.isSelected());
        }
        boolean bl2 = SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isShiftDown();
        boolean bl3 = bl = SwingUtilities.isMiddleMouseButton(mouseEvent) || mouseEvent.isControlDown();
        if (this.mouseDragMode.equals(MODE_UNDECIDED)) {
            if (bl2 && bl) {
                this.sc_click(n, n2, kPoint, mouseEvent);
            } else if (bl) {
                this.c_click(n, n2, kPoint, mouseEvent);
            } else if (bl2) {
                this.s_click(n, n2, kPoint, mouseEvent);
            } else {
                this.click(n, n2, kPoint, mouseEvent);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Dimension dimension = this.kCanvas.getCanvasSize();
        this.isNearTop = false;
        this.isNearBottom = false;
        if (mouseEvent.getY() < dimension.height / 6) {
            this.isNearTop = true;
        } else if (mouseEvent.getY() > dimension.height * 5 / 6) {
            this.isNearBottom = true;
        }
        Point point = mouseEvent.getPoint();
        this.pressXCoord = this.lastXCoord = point.x;
        this.pressYCoord = this.lastYCoord = point.y;
        this.mouseDragMode = MODE_UNDECIDED;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.activateDefaultTool();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void onArrowUp(ActionEvent actionEvent) {
        MouseEvent mouseEvent = new MouseEvent(this.kCanvas, 0, 0L, actionEvent.getModifiers(), 0, 0, 0, false);
        this.mouseWheelMoved(mouseEvent, -1);
    }

    public void onArrowDown(ActionEvent actionEvent) {
        MouseEvent mouseEvent = new MouseEvent(this.kCanvas, 0, 0L, actionEvent.getModifiers(), 0, 0, 0, false);
        this.mouseWheelMoved(mouseEvent, 1);
    }

    public void onArrowRight(ActionEvent actionEvent) {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        kView.rotateY((float)Math.PI / 90);
    }

    public void onArrowLeft(ActionEvent actionEvent) {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        kView.rotateY((float)(-Math.PI) / 90);
    }

    public void doTransform(Engine engine, Transform transform) {
    }

    public void overpaintCanvas(Painter painter) {
    }

    public JMenuItem getToolsMenuItem() {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ReflectiveAction(this.toString(), null, this, "onToolActivate"));
        jRadioButtonMenuItem.setSelected(false);
        return jRadioButtonMenuItem;
    }

    public void onToolActivate(ActionEvent actionEvent) {
        this.parent.toolActivated(this);
    }

    protected Container getToolPanel() {
        return null;
    }

    public String getHelpAnchor() {
        return "#navigate-tool";
    }

    public String toString() {
        return "Navigate";
    }
}

