/*
 * Decompiled with CFR 0.152.
 */
package driftwood.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;

public class Props
extends Properties {
    public Props() {
    }

    public Props(Properties properties) {
        super(properties);
    }

    public Properties getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Properties properties) {
        this.defaults = properties;
    }

    public void minimizeDifferences() {
        Properties properties = this.getDefaults();
        if (properties == null) {
            return;
        }
        Iterator<Object> iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            String string3 = this.getProperty(string);
            if ((string3 != null || string2 != null) && (string3 == null || !string3.equals(string2))) continue;
            iterator.remove();
        }
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public String getString(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            string3 = string2;
        } else if (string3.startsWith("\"") && string3.endsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        } else if (string3.startsWith("'") && string3.endsWith("'")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        return string3;
    }

    public String getString(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            throw new NoSuchElementException("Property '" + string + "' could not be found");
        }
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        } else if (string2.startsWith("'") && string2.endsWith("'")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    public int getInt(String string, int n) {
        int n2 = n;
        String string2 = this.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public int getInt(String string) {
        int n = 0;
        String string2 = this.getProperty(string);
        if (string2 == null) {
            throw new NoSuchElementException("Property '" + string + "' could not be found");
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchElementException noSuchElementException = new NoSuchElementException("Property '" + string + "' is not an integer");
            noSuchElementException.initCause(numberFormatException);
            throw noSuchElementException;
        }
        return n;
    }

    public long getLong(String string, long l) {
        long l2 = l;
        String string2 = this.getProperty(string);
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l2;
    }

    public long getLong(String string) {
        long l = 0L;
        String string2 = this.getProperty(string);
        if (string2 == null) {
            throw new NoSuchElementException("Property '" + string + "' could not be found");
        }
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchElementException noSuchElementException = new NoSuchElementException("Property '" + string + "' is not an integer");
            noSuchElementException.initCause(numberFormatException);
            throw noSuchElementException;
        }
        return l;
    }

    public double getDouble(String string, double d) {
        double d2 = d;
        String string2 = this.getProperty(string);
        if (string2 != null) {
            try {
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d2;
    }

    public double getDouble(String string) {
        double d = 0.0;
        String string2 = this.getProperty(string);
        if (string2 == null) {
            throw new NoSuchElementException("Property '" + string + "' could not be found");
        }
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchElementException noSuchElementException = new NoSuchElementException("Property '" + string + "' is not a real number");
            noSuchElementException.initCause(numberFormatException);
            throw noSuchElementException;
        }
        return d;
    }

    public float getFloat(String string, float f) {
        float f2 = f;
        String string2 = this.getProperty(string);
        if (string2 != null) {
            try {
                f2 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f2;
    }

    public float getFloat(String string) {
        float f = 0.0f;
        String string2 = this.getProperty(string);
        if (string2 == null) {
            throw new NoSuchElementException("Property '" + string + "' could not be found");
        }
        try {
            f = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchElementException noSuchElementException = new NoSuchElementException("Property '" + string + "' is not a real number");
            noSuchElementException.initCause(numberFormatException);
            throw noSuchElementException;
        }
        return f;
    }

    public boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = this.getProperty(string);
        if (string2 != null) {
            if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("on") || string2.equals("yes") || string2.equals("1")) {
                bl2 = true;
            } else if (string2.equals("false") || string2.equals("off") || string2.equals("no") || string2.equals("0")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean getBoolean(String string) {
        boolean bl = false;
        String string2 = this.getProperty(string);
        if (string2 == null) {
            throw new NoSuchElementException("Property '" + string + "' could not be found");
        }
        if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("on") || string2.equals("yes") || string2.equals("1")) {
            bl = true;
        } else if (string2.equals("false") || string2.equals("off") || string2.equals("no") || string2.equals("0")) {
            bl = false;
        } else {
            throw new NoSuchElementException("Property '" + string + "' is not a boolean value");
        }
        return bl;
    }
}

