/*
 * Decompiled with CFR 0.152.
 */
package driftwood.r3;

import driftwood.r3.MutableTuple3;
import driftwood.r3.Tuple3;
import java.io.Serializable;
import java.text.DecimalFormat;

public class Triple
implements MutableTuple3,
Serializable {
    public double x;
    public double y;
    public double z;

    public Triple(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Triple(Tuple3 tuple3) {
        this.x = tuple3.getX();
        this.y = tuple3.getY();
        this.z = tuple3.getZ();
    }

    public Triple() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Triple like(Tuple3 tuple3) {
        if (tuple3 != null) {
            this.x = tuple3.getX();
            this.y = tuple3.getY();
            this.z = tuple3.getZ();
        }
        return this;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public void setXYZ(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public double dot(Tuple3 tuple3) {
        return this.x * tuple3.getX() + this.y * tuple3.getY() + this.z * tuple3.getZ();
    }

    public Triple cross(Tuple3 tuple3) {
        double d = this.y * tuple3.getZ() - this.z * tuple3.getY();
        double d2 = this.z * tuple3.getX() - this.x * tuple3.getZ();
        double d3 = this.x * tuple3.getY() - this.y * tuple3.getX();
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Triple likeCross(Tuple3 tuple3, Tuple3 tuple32) {
        double d = tuple3.getY() * tuple32.getZ() - tuple3.getZ() * tuple32.getY();
        double d2 = tuple3.getZ() * tuple32.getX() - tuple3.getX() * tuple32.getZ();
        double d3 = tuple3.getX() * tuple32.getY() - tuple3.getY() * tuple32.getX();
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double mag2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public static double mag(Tuple3 tuple3) {
        double d = tuple3.getX();
        double d2 = tuple3.getY();
        double d3 = tuple3.getZ();
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public Triple unit() {
        double d = this.mag();
        if (d != 0.0) {
            this.x /= d;
            this.y /= d;
            this.z /= d;
        }
        return this;
    }

    public Triple mult(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public Triple div(double d) {
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public Triple likeProd(double d, Tuple3 tuple3) {
        this.x = d * tuple3.getX();
        this.y = d * tuple3.getY();
        this.z = d * tuple3.getZ();
        return this;
    }

    public Triple likeQuot(double d, Tuple3 tuple3) {
        this.x = tuple3.getX() / d;
        this.y = tuple3.getY() / d;
        this.z = tuple3.getZ() / d;
        return this;
    }

    public Triple add(Tuple3 tuple3) {
        this.x += tuple3.getX();
        this.y += tuple3.getY();
        this.z += tuple3.getZ();
        return this;
    }

    public Triple likeSum(Tuple3 tuple3, Tuple3 tuple32) {
        this.x = tuple3.getX() + tuple32.getX();
        this.y = tuple3.getY() + tuple32.getY();
        this.z = tuple3.getZ() + tuple32.getZ();
        return this;
    }

    public Triple sub(Tuple3 tuple3) {
        this.x -= tuple3.getX();
        this.y -= tuple3.getY();
        this.z -= tuple3.getZ();
        return this;
    }

    public Triple likeDiff(Tuple3 tuple3, Tuple3 tuple32) {
        this.x = tuple3.getX() - tuple32.getX();
        this.y = tuple3.getY() - tuple32.getY();
        this.z = tuple3.getZ() - tuple32.getZ();
        return this;
    }

    public Triple neg() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Triple addMult(double d, Tuple3 tuple3) {
        this.x += d * tuple3.getX();
        this.y += d * tuple3.getY();
        this.z += d * tuple3.getZ();
        return this;
    }

    public double distance(Tuple3 tuple3) {
        double d = this.x - tuple3.getX();
        double d2 = this.y - tuple3.getY();
        double d3 = this.z - tuple3.getZ();
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public static double distance(Tuple3 tuple3, Tuple3 tuple32) {
        double d = tuple3.getX() - tuple32.getX();
        double d2 = tuple3.getY() - tuple32.getY();
        double d3 = tuple3.getZ() - tuple32.getZ();
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public double sqDistance(Tuple3 tuple3) {
        double d = this.x - tuple3.getX();
        double d2 = this.y - tuple3.getY();
        double d3 = this.z - tuple3.getZ();
        return d * d + d2 * d2 + d3 * d3;
    }

    public static double sqDistance(Tuple3 tuple3, Tuple3 tuple32) {
        double d = tuple3.getX() - tuple32.getX();
        double d2 = tuple3.getY() - tuple32.getY();
        double d3 = tuple3.getZ() - tuple32.getZ();
        return d * d + d2 * d2 + d3 * d3;
    }

    public Triple likeMidpoint(Tuple3 tuple3, Tuple3 tuple32) {
        this.x = (tuple3.getX() + tuple32.getX()) / 2.0;
        this.y = (tuple3.getY() + tuple32.getY()) / 2.0;
        this.z = (tuple3.getZ() + tuple32.getZ()) / 2.0;
        return this;
    }

    public double angle(Tuple3 tuple3) {
        double d = this.dot(tuple3);
        double d2 = Math.toDegrees(Math.acos(d / (this.mag() * Triple.mag(tuple3))));
        if (Double.isNaN(d2)) {
            d2 = d >= 0.0 ? 0.0 : 180.0;
        }
        return d2;
    }

    public static double angle(Tuple3 tuple3, Tuple3 tuple32, Tuple3 tuple33) {
        double d;
        double d2;
        double d3;
        double d4 = tuple3.getX() - tuple32.getX();
        double d5 = tuple3.getY() - tuple32.getY();
        double d6 = tuple3.getZ() - tuple32.getZ();
        double d7 = tuple33.getX() - tuple32.getX();
        double d8 = d4 * d7 + d5 * (d3 = tuple33.getY() - tuple32.getY()) + d6 * (d2 = tuple33.getZ() - tuple32.getZ());
        double d9 = Math.toDegrees(Math.acos(d8 / (d = Math.sqrt((d4 * d4 + d5 * d5 + d6 * d6) * (d7 * d7 + d3 * d3 + d2 * d2)))));
        if (Double.isNaN(d9)) {
            d9 = d8 >= 0.0 ? 0.0 : 180.0;
        }
        return d9;
    }

    public static double dihedral(Tuple3 tuple3, Tuple3 tuple32, Tuple3 tuple33, Tuple3 tuple34) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = tuple32.getX() - tuple3.getX();
        double d7 = tuple32.getY() - tuple3.getY();
        double d8 = tuple32.getZ() - tuple3.getZ();
        double d9 = tuple33.getX() - tuple32.getX();
        double d10 = tuple33.getY() - tuple32.getY();
        double d11 = tuple33.getZ() - tuple32.getZ();
        double d12 = tuple34.getX() - tuple33.getX();
        double d13 = tuple34.getY() - tuple33.getY();
        double d14 = d7 * d11 - d8 * d10;
        double d15 = tuple34.getZ() - tuple33.getZ();
        double d16 = d10 * d15 - d11 * d13;
        double d17 = d14 * d16 + (d5 = d8 * d9 - d6 * d11) * (d4 = d11 * d12 - d9 * d15) + (d3 = d6 * d10 - d7 * d9) * (d2 = d9 * d13 - d10 * d12);
        double d18 = Math.toDegrees(Math.acos(d17 / (d = Math.sqrt((d14 * d14 + d5 * d5 + d3 * d3) * (d16 * d16 + d4 * d4 + d2 * d2)))));
        if (Double.isNaN(d18)) {
            d18 = d17 >= 0.0 ? 0.0 : 180.0;
        } else {
            d17 = d14 * d12 + d5 * d13 + d3 * d15;
            d = Math.sqrt((d14 * d14 + d5 * d5 + d3 * d3) * (d12 * d12 + d13 * d13 + d15 * d15));
            if (Math.toDegrees(Math.acos(d17 / d)) > 90.0) {
                d18 = -d18;
            }
        }
        return d18;
    }

    public Triple likeVector(Tuple3 tuple3, Tuple3 tuple32) {
        this.x = tuple32.getX() - tuple3.getX();
        this.y = tuple32.getY() - tuple3.getY();
        this.z = tuple32.getZ() - tuple3.getZ();
        return this;
    }

    public Triple likeNormal(Tuple3 tuple3, Tuple3 tuple32, Tuple3 tuple33) {
        double d = tuple3.getX();
        double d2 = tuple3.getY();
        double d3 = tuple3.getZ();
        double d4 = tuple32.getX();
        double d5 = tuple32.getY();
        double d6 = tuple32.getZ();
        double d7 = tuple33.getX();
        double d8 = tuple33.getY();
        double d9 = tuple33.getZ();
        d7 -= d4;
        d8 -= d5;
        d9 -= d6;
        this.x = (d5 -= d2) * d9 - (d6 -= d3) * d8;
        this.y = d6 * d7 - (d4 -= d) * d9;
        this.z = d4 * d8 - d5 * d7;
        this.unit();
        if (Math.abs(this.mag2() - 1.0) > 1.0E-10) {
            this.setXYZ(d4, d5, d6);
            this.likeOrthogonal(this);
        }
        return this;
    }

    public Triple likeOrthogonal(Tuple3 tuple3) {
        double d = tuple3.getX();
        double d2 = tuple3.getY();
        double d3 = tuple3.getZ();
        double d4 = d * d;
        double d5 = d2 * d2;
        double d6 = d3 * d3;
        if (d4 >= d5 && d4 >= d6) {
            if (d5 >= d6) {
                this.z = 0.0;
                this.y = Math.sqrt(1.0 / (1.0 + d5 / d4));
                this.x = -d2 / d * this.y;
            } else {
                this.y = 0.0;
                this.z = Math.sqrt(1.0 / (1.0 + d6 / d4));
                this.x = -d3 / d * this.z;
            }
        } else if (d5 >= d4 && d5 >= d6) {
            if (d4 >= d6) {
                this.z = 0.0;
                this.x = Math.sqrt(1.0 / (1.0 + d4 / d5));
                this.y = -d / d2 * this.x;
            } else {
                this.x = 0.0;
                this.z = Math.sqrt(1.0 / (1.0 + d6 / d5));
                this.y = -d3 / d2 * this.z;
            }
        } else if (d4 >= d5) {
            this.y = 0.0;
            this.x = Math.sqrt(1.0 / (1.0 + d4 / d6));
            this.z = -d / d3 * this.x;
        } else {
            this.x = 0.0;
            this.y = Math.sqrt(1.0 / (1.0 + d5 / d6));
            this.z = -d2 / d3 * this.y;
        }
        return this;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tuple3)) {
            return false;
        }
        Tuple3 tuple3 = (Tuple3)object;
        return this.x == tuple3.getX() && this.y == tuple3.getY() && this.z == tuple3.getZ();
    }

    public int hashCode() {
        int n = Float.floatToIntBits((float)this.x * 6.6360896E8f);
        int n2 = Float.floatToIntBits((float)this.y * 6.6360896E8f);
        int n3 = Float.floatToIntBits((float)this.z * 6.6360896E8f);
        return n ^ (n2 << 11 | n2 >>> 21) ^ (n3 << 22 | n3 >>> 10);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public String format(DecimalFormat decimalFormat, String string) {
        return decimalFormat.format(this.getX()) + string + decimalFormat.format(this.getY()) + string + decimalFormat.format(this.getZ());
    }

    public String format(DecimalFormat decimalFormat) {
        return this.format(decimalFormat, " ");
    }
}

