/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

public class Hy36 {
    private static String digits_base10 = "0123456789";
    private static String digits_upper = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String digits_lower = "0123456789abcdefghijklmnopqrstuvwxyz";
    private static boolean first_call = true;
    private static int[] digits_values_upper = new int[128];
    private static int[] digits_values_lower = new int[128];
    private static String value_out_of_range = "value out of range.";
    private static String invalid_number_literal = "invalid number literal.";
    private static String unsupported_width = "unsupported width.";
    private static int random_seed = 13;

    private static String encode_pure(String string, int n, int n2) {
        int n3;
        boolean bl = false;
        if (n2 < 0) {
            bl = true;
            n2 = -n2;
        }
        String string2 = "";
        while (true) {
            int n4 = n2 / string.length();
            string2 = string2 + string.charAt(n2 - n4 * string.length());
            if (n4 == 0) break;
            n2 = n4;
        }
        if (bl) {
            string2 = string2 + '-';
        }
        String string3 = "";
        for (n3 = string2.length(); n3 < n; ++n3) {
            string3 = string3 + " ";
        }
        for (n3 = string2.length() - 1; n3 >= 0; --n3) {
            string3 = string3 + string2.charAt(n3);
        }
        return string3;
    }

    private static int decode_pure(int[] nArray, int n, String string) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c > '\u007f') {
                throw new Error(invalid_number_literal);
            }
            if (c == ' ') {
                if (!bl2) continue;
                n2 *= n;
                continue;
            }
            if (c == '-') {
                if (bl2) {
                    throw new Error(invalid_number_literal);
                }
                bl2 = true;
                bl = true;
                continue;
            }
            bl2 = true;
            int n3 = nArray[c];
            if (n3 < 0 || n3 >= n) {
                throw new Error(invalid_number_literal);
            }
            n2 *= n;
            n2 += n3;
        }
        if (bl) {
            n2 = -n2;
        }
        return n2;
    }

    public static String encode(int n, int n2) {
        int n3 = n2;
        if (n == 4) {
            if (n3 >= -999) {
                if (n3 < 10000) {
                    return Hy36.encode_pure(digits_base10, 4, n3);
                }
                if ((n3 -= 10000) < 1213056) {
                    return Hy36.encode_pure(digits_upper, 0, n3 += 466560);
                }
                if ((n3 -= 1213056) < 1213056) {
                    return Hy36.encode_pure(digits_lower, 0, n3 += 466560);
                }
            }
        } else if (n == 5) {
            if (n3 >= -9999) {
                if (n3 < 100000) {
                    return Hy36.encode_pure(digits_base10, 5, n3);
                }
                if ((n3 -= 100000) < 43670016) {
                    return Hy36.encode_pure(digits_upper, 0, n3 += 16796160);
                }
                if ((n3 -= 43670016) < 43670016) {
                    return Hy36.encode_pure(digits_lower, 0, n3 += 16796160);
                }
            }
        } else {
            throw new Error(unsupported_width);
        }
        throw new Error(value_out_of_range);
    }

    public static int decode(int n, String string) {
        int n2;
        int n3;
        String string2 = "internal error hy36.decode: integer value out of range.";
        if (first_call) {
            first_call = false;
            for (n3 = 0; n3 < 128; ++n3) {
                Hy36.digits_values_upper[n3] = -1;
            }
            for (n3 = 0; n3 < 128; ++n3) {
                Hy36.digits_values_lower[n3] = -1;
            }
            n3 = 0;
            while (n3 < 36) {
                n2 = digits_upper.charAt(n3);
                if (n2 < 0 || n2 > 127) {
                    throw new Error(string2);
                }
                Hy36.digits_values_upper[n2] = n3++;
            }
            n3 = 0;
            while (n3 < 36) {
                n2 = digits_lower.charAt(n3);
                if (n2 < 0 || n2 > 127) {
                    throw new Error(string2);
                }
                Hy36.digits_values_lower[n2] = n3++;
            }
        }
        if (string.length() == n && (n3 = (int)string.charAt(0)) >= 0 && n3 <= 127) {
            if (digits_values_upper[n3] >= 10) {
                n2 = Hy36.decode_pure(digits_values_upper, 36, string);
                if (n == 4) {
                    n2 -= 456560;
                } else if (n == 5) {
                    n2 -= 16696160;
                } else {
                    throw new Error(unsupported_width);
                }
                return n2;
            }
            if (digits_values_lower[n3] >= 10) {
                n2 = Hy36.decode_pure(digits_values_lower, 36, string);
                if (n == 4) {
                    n2 += 756496;
                } else if (n == 5) {
                    n2 += 26973856;
                } else {
                    throw new Error(unsupported_width);
                }
                return n2;
            }
            n2 = Hy36.decode_pure(digits_values_upper, 10, string);
            if (n != 4 && n != 5) {
                throw new Error(unsupported_width);
            }
            return n2;
        }
        throw new Error(invalid_number_literal);
    }

    private static void check_str(String string, String string2) {
        if (!string.equals(string2)) {
            System.out.println("ERROR: \"" + string + "\" != \"" + string2 + "\"");
        }
    }

    private static void check_int(int n, int n2) {
        if (n != n2) {
            System.out.println("ERROR: " + n + " != " + n2);
        }
    }

    private static void recycle4(int n, String string) {
        String string2 = Hy36.encode(4, n);
        Hy36.check_str(string2, string);
        int n2 = Hy36.decode(4, string2);
        Hy36.check_int(n2, n);
    }

    private static void recycle5(int n, String string) {
        String string2 = Hy36.encode(5, n);
        Hy36.check_str(string2, string);
        int n2 = Hy36.decode(5, string2);
        Hy36.check_int(n2, n);
    }

    private static void check_encode_exception(int n, int n2, String string) {
        String string2 = "";
        try {
            Hy36.encode(n, n2);
        }
        catch (Error error) {
            string2 = error.toString();
        }
        Hy36.check_str(string2, "java.lang.Error: " + string);
    }

    private static void check_decode_exception(int n, String string, String string2) {
        String string3 = "";
        try {
            Hy36.decode(n, string);
        }
        catch (Error error) {
            string3 = error.toString();
        }
        Hy36.check_str(string3, "java.lang.Error: " + string2);
    }

    private static int kernighan_and_ritchie_rand() {
        int n = (random_seed = random_seed * 1103515245 + 12345) / 65536 % 32768;
        if (n < 0) {
            n += 32768;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Hy36.check_int(Hy36.decode(4, "    "), 0);
        Hy36.check_int(Hy36.decode(4, "  -0"), 0);
        Hy36.recycle4(-999, "-999");
        Hy36.recycle4(-78, " -78");
        Hy36.recycle4(-6, "  -6");
        Hy36.recycle4(0, "   0");
        Hy36.recycle4(9999, "9999");
        Hy36.recycle4(10000, "A000");
        Hy36.recycle4(10001, "A001");
        Hy36.recycle4(10002, "A002");
        Hy36.recycle4(10003, "A003");
        Hy36.recycle4(10004, "A004");
        Hy36.recycle4(10005, "A005");
        Hy36.recycle4(10006, "A006");
        Hy36.recycle4(10007, "A007");
        Hy36.recycle4(10008, "A008");
        Hy36.recycle4(10009, "A009");
        Hy36.recycle4(10010, "A00A");
        Hy36.recycle4(10011, "A00B");
        Hy36.recycle4(10012, "A00C");
        Hy36.recycle4(10013, "A00D");
        Hy36.recycle4(10014, "A00E");
        Hy36.recycle4(10015, "A00F");
        Hy36.recycle4(10016, "A00G");
        Hy36.recycle4(10017, "A00H");
        Hy36.recycle4(10018, "A00I");
        Hy36.recycle4(10019, "A00J");
        Hy36.recycle4(10020, "A00K");
        Hy36.recycle4(10021, "A00L");
        Hy36.recycle4(10022, "A00M");
        Hy36.recycle4(10023, "A00N");
        Hy36.recycle4(10024, "A00O");
        Hy36.recycle4(10025, "A00P");
        Hy36.recycle4(10026, "A00Q");
        Hy36.recycle4(10027, "A00R");
        Hy36.recycle4(10028, "A00S");
        Hy36.recycle4(10029, "A00T");
        Hy36.recycle4(10030, "A00U");
        Hy36.recycle4(10031, "A00V");
        Hy36.recycle4(10032, "A00W");
        Hy36.recycle4(10033, "A00X");
        Hy36.recycle4(10034, "A00Y");
        Hy36.recycle4(10035, "A00Z");
        Hy36.recycle4(10036, "A010");
        Hy36.recycle4(10046, "A01A");
        Hy36.recycle4(10071, "A01Z");
        Hy36.recycle4(10072, "A020");
        Hy36.recycle4(11295, "A0ZZ");
        Hy36.recycle4(11296, "A100");
        Hy36.recycle4(56655, "AZZZ");
        Hy36.recycle4(56656, "B000");
        Hy36.recycle4(1223055, "ZZZZ");
        Hy36.recycle4(1223056, "a000");
        Hy36.recycle4(1223091, "a00z");
        Hy36.recycle4(1223092, "a010");
        Hy36.recycle4(1224351, "a0zz");
        Hy36.recycle4(1224352, "a100");
        Hy36.recycle4(1269711, "azzz");
        Hy36.recycle4(1269712, "b000");
        Hy36.recycle4(2436111, "zzzz");
        Hy36.check_int(Hy36.decode(5, "     "), 0);
        Hy36.check_int(Hy36.decode(5, "   -0"), 0);
        Hy36.recycle5(-9999, "-9999");
        Hy36.recycle5(-123, " -123");
        Hy36.recycle5(-45, "  -45");
        Hy36.recycle5(-6, "   -6");
        Hy36.recycle5(0, "    0");
        Hy36.recycle5(12, "   12");
        Hy36.recycle5(345, "  345");
        Hy36.recycle5(6789, " 6789");
        Hy36.recycle5(99999, "99999");
        Hy36.recycle5(100000, "A0000");
        Hy36.recycle5(100010, "A000A");
        Hy36.recycle5(100035, "A000Z");
        Hy36.recycle5(100036, "A0010");
        Hy36.recycle5(100046, "A001A");
        Hy36.recycle5(100071, "A001Z");
        Hy36.recycle5(100072, "A0020");
        Hy36.recycle5(101295, "A00ZZ");
        Hy36.recycle5(101296, "A0100");
        Hy36.recycle5(146655, "A0ZZZ");
        Hy36.recycle5(146656, "A1000");
        Hy36.recycle5(1779615, "AZZZZ");
        Hy36.recycle5(1779616, "B0000");
        Hy36.recycle5(3459232, "C0000");
        Hy36.recycle5(43770015, "ZZZZZ");
        Hy36.recycle5(43770016, "a0000");
        Hy36.recycle5(43770051, "a000z");
        Hy36.recycle5(43770052, "a0010");
        Hy36.recycle5(43771311, "a00zz");
        Hy36.recycle5(43771312, "a0100");
        Hy36.recycle5(43816671, "a0zzz");
        Hy36.recycle5(43816672, "a1000");
        Hy36.recycle5(45449631, "azzzz");
        Hy36.recycle5(45449632, "b0000");
        Hy36.recycle5(87440031, "zzzzz");
        Hy36.check_encode_exception(4, -1000, "value out of range.");
        Hy36.check_encode_exception(4, 2436112, "value out of range.");
        Hy36.check_encode_exception(5, -10000, "value out of range.");
        Hy36.check_encode_exception(5, 87440032, "value out of range.");
        Hy36.check_decode_exception(4, "", "invalid number literal.");
        Hy36.check_decode_exception(4, "    0", "invalid number literal.");
        Hy36.check_decode_exception(4, " abc", "invalid number literal.");
        Hy36.check_decode_exception(4, "abc-", "invalid number literal.");
        Hy36.check_decode_exception(4, "A=BC", "invalid number literal.");
        Hy36.check_decode_exception(4, "40a0", "invalid number literal.");
        Hy36.check_decode_exception(4, "40A0", "invalid number literal.");
        Hy36.check_decode_exception(5, "", "invalid number literal.");
        Hy36.check_decode_exception(5, "     0", "invalid number literal.");
        Hy36.check_decode_exception(5, " abcd", "invalid number literal.");
        Hy36.check_decode_exception(5, "ABCD-", "invalid number literal.");
        Hy36.check_decode_exception(5, "a=bcd", "invalid number literal.");
        Hy36.check_decode_exception(5, "410b0", "invalid number literal.");
        Hy36.check_decode_exception(5, "410B0", "invalid number literal.");
        Hy36.check_encode_exception(3, 0, "unsupported width.");
        Hy36.check_encode_exception(6, 0, "unsupported width.");
        Hy36.check_decode_exception(3, "AAA", "unsupported width.");
        Hy36.check_decode_exception(6, "zzzzzz", "unsupported width.");
        for (int i = -9999; i < 87440032; i += Hy36.kernighan_and_ritchie_rand() % 10000) {
            Hy36.check_int(Hy36.decode(5, Hy36.encode(5, i)), i);
        }
        System.out.println("OK");
    }
}

