/*
 * Decompiled with CFR 0.152.
 */
package driftwood.gui;

import driftwood.util.SoftLog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JPanel;

public class TablePane
extends JPanel {
    TablePane subtable = null;
    GridBagLayout layout = new GridBagLayout();
    GridBagConstraints gbc;
    LinkedList gbcStack;
    int gridx;
    int gridy;
    Map occupants;
    public boolean _debug = false;

    public TablePane() {
        this.setLayout(this.layout);
        this.gbc = new GridBagConstraints();
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.anchor = 17;
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.gbc.ipadx = 0;
        this.gbc.ipady = 0;
        this.gridx = 0;
        this.gridy = 0;
        this.gbcStack = new LinkedList();
        this.occupants = new HashMap();
    }

    public TablePane startSubtable() {
        return this.startSubtable(1, 1);
    }

    public TablePane startSubtable(int n, int n2) {
        if (this.subtable != null) {
            this.subtable.startSubtable(n, n2);
        } else {
            TablePane tablePane = new TablePane();
            this.add((Component)tablePane, n, n2);
            this.subtable = tablePane;
        }
        return this;
    }

    public TablePane endSubtable() {
        if (this.subtable == null) {
            throw new UnsupportedOperationException("No subtable exists");
        }
        if (this.subtable.subtable == null) {
            this.subtable = null;
        } else {
            this.subtable.endSubtable();
        }
        return this;
    }

    public boolean isSubtable() {
        return this.subtable != null;
    }

    public TablePane getCurrent() {
        if (this.subtable != null) {
            return this.subtable.getCurrent();
        }
        return this;
    }

    public TablePane addCell(Component component) {
        this.add(component);
        return this;
    }

    public TablePane addCell(Component component, int n, int n2) {
        this.add(component, n, n2);
        return this;
    }

    public Component add(Component component) {
        return this.add(component, 1, 1);
    }

    public Component add(Component component, int n, int n2) {
        if (this.subtable != null) {
            return this.subtable.add(component, n, n2);
        }
        this.advanceToNextEmptyCell();
        this.gbc.gridx = this.gridx++;
        this.gbc.gridy = this.gridy;
        this.gbc.gridwidth = Math.max(1, n);
        this.gbc.gridheight = Math.max(1, n2);
        Component component2 = this.addWithConstraints(component, this.gbc);
        this.markCellsAsOccupied(component, this.gbc);
        return component2;
    }

    protected Component addWithConstraints(Component component, GridBagConstraints gridBagConstraints) {
        if (this._debug) {
            SoftLog.err.println("Added " + component.getClass() + " at " + gridBagConstraints.gridx + "," + gridBagConstraints.gridy + " measuring " + gridBagConstraints.gridwidth + "x" + gridBagConstraints.gridheight);
        }
        this.layout.setConstraints(component, gridBagConstraints);
        return super.add(component);
    }

    protected void advanceToNextEmptyCell() {
        Point point = new Point(this.gridx, this.gridy);
        while (this.occupants.get(point) != null) {
            ++this.gridx;
            point.setLocation(this.gridx, this.gridy);
        }
    }

    protected void markCellsAsOccupied(Component component, GridBagConstraints gridBagConstraints) {
        for (int i = 0; i < gridBagConstraints.gridheight; ++i) {
            for (int j = 0; j < gridBagConstraints.gridwidth; ++j) {
                Point point = new Point(gridBagConstraints.gridx + j, gridBagConstraints.gridy + i);
                this.occupants.put(point, component);
            }
        }
    }

    public TablePane skip() {
        if (this.subtable != null) {
            this.subtable.skip();
        } else {
            ++this.gridx;
        }
        return this;
    }

    public TablePane newRow() {
        if (this.subtable != null) {
            this.subtable.newRow();
        } else {
            ++this.gridy;
            this.gridx = 0;
        }
        return this;
    }

    public TablePane save() {
        if (this.subtable != null) {
            this.subtable.save();
        } else {
            this.gbcStack.addLast(this.gbc.clone());
        }
        return this;
    }

    public TablePane restore() {
        if (this.subtable != null) {
            this.subtable.restore();
        } else {
            this.gbc = (GridBagConstraints)this.gbcStack.removeLast();
        }
        return this;
    }

    public TablePane weights(double d, double d2) {
        if (this.subtable != null) {
            this.subtable.weights(d, d2);
        } else {
            this.gbc.weightx = d;
            this.gbc.weighty = d2;
        }
        return this;
    }

    public TablePane insets(int n, int n2, int n3, int n4) {
        if (this.subtable != null) {
            this.subtable.insets(n, n2, n3, n4);
        } else {
            this.gbc.insets = new Insets(n, n2, n3, n4);
        }
        return this;
    }

    public TablePane insets(int n) {
        return this.insets(n, n, n, n);
    }

    public TablePane pad(int n, int n2) {
        if (this.subtable != null) {
            this.subtable.pad(n, n2);
        } else {
            this.gbc.ipadx = n;
            this.gbc.ipady = n2;
        }
        return this;
    }

    public TablePane pad(int n) {
        return this.pad(n, n);
    }

    public TablePane hfill(boolean bl) {
        if (this.subtable != null) {
            this.subtable.hfill(bl);
        } else {
            this.fill(bl, this.isVfill());
        }
        return this;
    }

    public TablePane vfill(boolean bl) {
        if (this.subtable != null) {
            this.subtable.vfill(bl);
        } else {
            this.fill(this.isHfill(), bl);
        }
        return this;
    }

    private void fill(boolean bl, boolean bl2) {
        this.gbc.fill = bl ? (bl2 ? 1 : 2) : (bl2 ? 3 : 0);
    }

    private boolean isHfill() {
        return this.gbc.fill == 2 || this.gbc.fill == 1;
    }

    private boolean isVfill() {
        return this.gbc.fill == 3 || this.gbc.fill == 1;
    }

    public TablePane left() {
        if (this.subtable != null) {
            this.subtable.left();
        } else {
            this.align(0, this.getValignment());
        }
        return this;
    }

    public TablePane center() {
        if (this.subtable != null) {
            this.subtable.center();
        } else {
            this.align(1, this.getValignment());
        }
        return this;
    }

    public TablePane right() {
        if (this.subtable != null) {
            this.subtable.right();
        } else {
            this.align(2, this.getValignment());
        }
        return this;
    }

    public TablePane top() {
        if (this.subtable != null) {
            this.subtable.top();
        } else {
            this.align(this.getHalignment(), 0);
        }
        return this;
    }

    public TablePane middle() {
        if (this.subtable != null) {
            this.subtable.middle();
        } else {
            this.align(this.getHalignment(), 1);
        }
        return this;
    }

    public TablePane bottom() {
        if (this.subtable != null) {
            this.subtable.bottom();
        } else {
            this.align(this.getHalignment(), 2);
        }
        return this;
    }

    private void align(int n, int n2) {
        this.gbc.anchor = n == 2 ? (n2 == 2 ? 14 : (n2 == 1 ? 13 : 12)) : (n == 1 ? (n2 == 2 ? 15 : (n2 == 1 ? 10 : 11)) : (n2 == 2 ? 16 : (n2 == 1 ? 17 : 18)));
    }

    private int getHalignment() {
        if (this.gbc.anchor == 14 || this.gbc.anchor == 13 || this.gbc.anchor == 12) {
            return 2;
        }
        if (this.gbc.anchor == 15 || this.gbc.anchor == 10 || this.gbc.anchor == 11) {
            return 1;
        }
        return 0;
    }

    private int getValignment() {
        if (this.gbc.anchor == 16 || this.gbc.anchor == 15 || this.gbc.anchor == 14) {
            return 2;
        }
        if (this.gbc.anchor == 17 || this.gbc.anchor == 10 || this.gbc.anchor == 13) {
            return 1;
        }
        return 0;
    }

    public static Component strut(int n, int n2) {
        return Box.createRigidArea(new Dimension(n, n2));
    }
}

