.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "xpaacl n"
.TH xpaacl n "April 14, 2011" "version 2.1.13" "SAORD Documentation"
.SH "NAME"
\&\fBXPAAcl: Access Control for XPA Messaging\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\s-1XPA\s0 supports host-based access control for each \s-1XPA\s0 access point.  You
can enable/disable access control using the \s-1XPA_ACL\s0 environment
variable. You can specify access to specific \s-1XPA\s0 access points for
specific machines using the \s-1XPA_DEFACL\s0 and \s-1XPA_ACLFILE\s0 environment
variables. By default, an \s-1XPA\s0 access point is accessible only to
processes running on the same machine (same as X Windows).
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
When \s-1INET\s0 sockets are in use (the default, as specified by the
\&\fI\s-1XPA_METHOD\s0\fR environment variable), \s-1XPA\s0 supports a host-based
access control mechanism for individual access points. This mean that
access can be specified for get, set, or info operations for each
access point on a machine by machine basis.  For \s-1LOCAL\s0 sockets, access
is restricted (by definition) to the host machine.
.PP
\&\s-1XPA\s0 access control is enabled by default, but can be turned off by
setting the \fI\s-1XPA_ACL\s0\fR environment variable to \fIfalse\fR.
In this case, any process can access any \s-1XPA\s0 server.
.PP
Assuming that access control is turned on, the \s-1ACL\s0 for an individual
\&\s-1XPA\s0 access point is set up when that access point is registered
(although it can be changed later on; see below). This can be done in
one of two ways:
.PP
Firstly, the \fI\s-1XPA_ACLFILE\s0\fR environment variable can defined to
point to a file of access controls for individual access points. The format
of this file is:
.PP
.Vb 1
\& class:name ip acl
.Ve
.PP
The first argument is a template that specifies the class:name of the
access point covered by this \s-1ACL\s0. See
\&\s-1XPA\s0 Access Points and Templates
for more information about xpa templates.
.PP
The second argument is the \s-1IP\s0 address (in human-readable format) of
the machine which is being given access.  This argument can be
\&\fI*\fR to match all \s-1IP\s0 addresses.  It also can be \fI$host\fR
to match the \s-1IP\s0 address of the current host.
.PP
The third argument is a string combination of \fIs\fR, \fIg\fR,
or \fIi\fR to allow \fIxpaset\fR, \fIxpaget\fR, or
\&\fIxpainfo\fR access respectively.  The \s-1ACL\s0 argument can be
\&\fI+\fR to give \fIsgi\fR access or it can be \fI\-\fR to turn
off all access.
.PP
For example,
.PP
.Vb 3
\&  *:xpa1  somehost sg
\&  *:xpa1  myhost +
\&  * * g
.Ve
.PP
will allow processes on the machine somehost to make xpaget and xpaset calls,
allow processes on myhost to make any call, and allow all other hosts to
make xpaget (but not xpaset) calls.
.PP
Secondly, if the \fI\s-1XPA_ACLFILE\s0\fR does not exist, then a single
default value for all access points can be specified using the
\&\fI\s-1XPA_DEFACL\s0\fR environment variable.  The default value for this
variable is:
.PP
.Vb 1
\&  #define XPA_DEFACL "*:* $host +"
.Ve
.PP
meaning that all access points are fully accessible to all processes
on the current host. Thus, in the absence of any \s-1ACL\s0 environment variables,
processes on the current host have full access to all access points
created on that host. This parallels the X11 xhost mechanism.
.PP
Access to an individual \s-1XPA\s0 access point can be changed using the \-acl
parameter for that access point.  For example:
.PP
.Vb 1
\&  xpaset -p xpa1 -acl "somehost -"
.Ve
.PP
will turn off all access control for somehost to the xpa1 access point, while:
.PP
.Vb 1
\&  xpaset -p XPA:xpa1 -acl "beberly gs"
.Ve
.PP
will give beberly xpaget and xpaset access to the access point whose
class is \s-1XPA\s0 and whose name is xpa1.
.PP
Similarly, the current \s-1ACL\s0 for a given access point can be retrieved using:
.PP
.Vb 1
\&  xpaget xpa1 -acl
.Ve
.PP
Of course, you must have xpaget access to this \s-1XPA\s0 access point to
retrieve its \s-1ACL\s0.
.PP
Note that the \s-1XPA\s0 access points registered in the \fIxpans\fR
program also behave according to the \s-1ACL\s0 rules.  That is, you cannot
use xpaget to view the access points registered with xpans unless
you have the proper \s-1ACL\s0.
.PP
Note also when a client request is made to an \s-1XPA\s0 server, the access
control is checked when the initial connection is established.  This
access in effect at this time remains in effect so long as the client
connection is maintained, regardless of whether the access fro that
\&\s-1XPA\s0 is changed later on.
.PP
We recognize that host-based access control is only relatively secure
and will consider more stringent security (e.g., private key) in the
future if the community requires such support.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See xpa(n) for a list of \s-1XPA\s0 help pages
