# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .entity_health_state_chunk import EntityHealthStateChunk


class NodeHealthStateChunk(EntityHealthStateChunk):
    """Represents the health state chunk of a node, which contains the node name
    and its aggregated health state.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param node_name: The name of a Service Fabric node.
    :type node_name: str
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeHealthStateChunk, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
