# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NextHopParameters(Model):
    """Parameters that define the source and destination endpoint.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The resource identifier of the target
     resource against which the action is to be performed.
    :type target_resource_id: str
    :param source_ip_address: Required. The source IP address.
    :type source_ip_address: str
    :param destination_ip_address: Required. The destination IP address.
    :type destination_ip_address: str
    :param target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP
     forwarding is enabled on any of the nics, then this parameter must be
     specified. Otherwise optional).
    :type target_nic_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'source_ip_address': {'required': True},
        'destination_ip_address': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'source_ip_address': {'key': 'sourceIPAddress', 'type': 'str'},
        'destination_ip_address': {'key': 'destinationIPAddress', 'type': 'str'},
        'target_nic_resource_id': {'key': 'targetNicResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NextHopParameters, self).__init__(**kwargs)
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.source_ip_address = kwargs.get('source_ip_address', None)
        self.destination_ip_address = kwargs.get('destination_ip_address', None)
        self.target_nic_resource_id = kwargs.get('target_nic_resource_id', None)
