# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureFileVolume(Model):
    """The properties of the Azure File volume. Azure File shares are mounted as
    volumes.

    All required parameters must be populated in order to send to Azure.

    :param share_name: Required. The name of the Azure File share to be
     mounted as a volume.
    :type share_name: str
    :param read_only: The flag indicating whether the Azure File shared
     mounted as a volume is read-only.
    :type read_only: bool
    :param storage_account_name: Required. The name of the storage account
     that contains the Azure File share.
    :type storage_account_name: str
    :param storage_account_key: The storage account access key used to access
     the Azure File share.
    :type storage_account_key: str
    """

    _validation = {
        'share_name': {'required': True},
        'storage_account_name': {'required': True},
    }

    _attribute_map = {
        'share_name': {'key': 'shareName', 'type': 'str'},
        'read_only': {'key': 'readOnly', 'type': 'bool'},
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
        'storage_account_key': {'key': 'storageAccountKey', 'type': 'str'},
    }

    def __init__(self, *, share_name: str, storage_account_name: str, read_only: bool=None, storage_account_key: str=None, **kwargs) -> None:
        super(AzureFileVolume, self).__init__(**kwargs)
        self.share_name = share_name
        self.read_only = read_only
        self.storage_account_name = storage_account_name
        self.storage_account_key = storage_account_key
