# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IdentifyRequest(Model):
    """Request body for identify face operation.

    All required parameters must be populated in order to send to Azure.

    :param face_ids: Required. Array of query faces faceIds, created by the
     Face - Detect. Each of the faces are identified independently. The valid
     number of faceIds is between [1, 10].
    :type face_ids: list[str]
    :param person_group_id: PersonGroupId of the target person group, created
     by PersonGroup - Create. Parameter personGroupId and largePersonGroupId
     should not be provided at the same time.
    :type person_group_id: str
    :param large_person_group_id: LargePersonGroupId of the target large
     person group, created by LargePersonGroup - Create. Parameter
     personGroupId and largePersonGroupId should not be provided at the same
     time.
    :type large_person_group_id: str
    :param max_num_of_candidates_returned: The range of
     maxNumOfCandidatesReturned is between 1 and 5 (default is 1). Default
     value: 1 .
    :type max_num_of_candidates_returned: int
    :param confidence_threshold: Confidence threshold of identification, used
     to judge whether one face belong to one person. The range of
     confidenceThreshold is [0, 1] (default specified by algorithm).
    :type confidence_threshold: float
    """

    _validation = {
        'face_ids': {'required': True, 'max_items': 10},
        'person_group_id': {'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'large_person_group_id': {'max_length': 64, 'pattern': r'^[a-z0-9-_]+$'},
        'max_num_of_candidates_returned': {'maximum': 5, 'minimum': 1},
    }

    _attribute_map = {
        'face_ids': {'key': 'faceIds', 'type': '[str]'},
        'person_group_id': {'key': 'personGroupId', 'type': 'str'},
        'large_person_group_id': {'key': 'largePersonGroupId', 'type': 'str'},
        'max_num_of_candidates_returned': {'key': 'maxNumOfCandidatesReturned', 'type': 'int'},
        'confidence_threshold': {'key': 'confidenceThreshold', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(IdentifyRequest, self).__init__(**kwargs)
        self.face_ids = kwargs.get('face_ids', None)
        self.person_group_id = kwargs.get('person_group_id', None)
        self.large_person_group_id = kwargs.get('large_person_group_id', None)
        self.max_num_of_candidates_returned = kwargs.get('max_num_of_candidates_returned', 1)
        self.confidence_threshold = kwargs.get('confidence_threshold', None)
