/*
 * hconsole.c
 *
 * Copyright 1995, 1999 Pete Zaitcev
 */

#define FB_NM_MAX  40

struct hconsole {
	struct raster *r_;		/* Frame to draw into           */
	struct raster *r0_;		/* Master frame, for resets	*/
	struct rfont *f_;		/* Current font			*/
	unsigned xdim_, ydim_;
	unsigned xpos_, ypos_;		/* Emulated cursor is here	*/
	int curson_;			/* Cursor is visible		*/
	int fg_, bg_;			/* Drawing colors		*/
	int color_;			/* RO flag: color is available  */
	char name_[ FB_NM_MAX+1 ];	/* Human-readable name          */
};

#define SM_UP	1
#define SM_DOWN	2

int hcon_init(struct hconsole *t, unsigned int a0);
void hcon_fini(struct hconsole *t);
#define hcon_qcol(t)	((t)->color_)
#define hcon_qxdim(t)	((t)->xdim_)
#define hcon_qydim(t)	((t)->ydim_)
int hcon_clear(struct hconsole *t, int, int,  int, int);
int hcon_putc(struct hconsole *t, int, int, int);
int hcon_putcs(struct hconsole *t, const char *, int, int, int);
int hcon_cursor(struct hconsole *t, int);
int hcon_scroll(struct hconsole *t, int, int, int, int);
