#!/bin/bash

# Copyright(C) 2007 INL
# Written by Romain Bignon <romain AT inl.fr>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: install_defconf.sh 11835 2007-12-27 15:32:25Z romain $

set -e

function input_define()
{
        # $1 -> Message to display
        # $2 -> Default value
        # $3 -> define to put in release.h

        if [ "$2" == "y" ]; then
                PROP="Y/n"
        elif [ "$2" == "n" ]; then
                PROP="y/N"
        else
                PROP=$2
        fi

        echo -n "$1 [$PROP] "
        read ANSWER

        if [ "$ANSWER" == "" ] ; then
                ANSWER=$2
        fi

        if [ "$ANSWER" == "o" ] ; then
                ANSWER="y"
        fi

        export NU_$3="$ANSWER"
}

function check_dir()
{
        if [ "$1" == "" ]; then
                exit 0
        elif [[ "$1" != /* ]]; then
                echo "-Error- Please give an absolute path"
                exit 0
        else
                exit 1
        fi
}

while ( ! check_dir $NU_VARDIR ); do
        input_define "Where do you want to store users' settings?"  "/var/lib/nucentral" VARDIR
done

if [ ! -d $NU_VARDIR ]; then
        input_define "-- $NU_VARDIR doesn't exist. Do you want to create it?" "y" CREATE

        if [ "$NU_CREATE" == "y" ]; then
                mkdir "$NU_VARDIR" || exit
                mkdir "$NU_VARDIR/auth" || exit

                echo "-> Directory $NU_VARDIR created."
        fi
fi

while [ ! -f "$NU_DEFCONF" ]; do
        echo
        echo -e "\t[default.conf]\t\tDefault settings for a NuFW firewall"
        echo -e "\t[no_users.conf]\t\tDefault settings for a standard Netfilter firewall (without user authentification)"
        input_define "What configuration do you want to use?" "default.conf" DEFCONF
done

if [ ! -d "$NU_VARDIR/auth/default" ]; then
        mkdir "$NU_VARDIR/auth/default" || exit 1
        echo "-> Directory \`$NU_VARDIR/auth/default' created."
fi

cp "$NU_DEFCONF" "$NU_VARDIR/auth/default/nulog" || exit
echo "-> File $NU_DEFCONF installed."

echo
echo "Your directory is ready. Please check you have the"
echo "good path in your wrapper.conf configuration file."
echo "Path: $NU_VARDIR"
echo
