/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.claribole.zvtm.lens.Lens;

public abstract class FixedSizeLens
extends Lens {
    protected int LR1 = 100;
    protected int LR2 = 50;
    Color r2Color = null;
    Color r1Color = null;

    public void setOuterRadius(int r) {
        this.LR1 = r;
        this.updateMagBufferWorkingDimensions();
    }

    public void setInnerRadius(int r) {
        this.LR2 = r;
        this.updateMagBufferWorkingDimensions();
    }

    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.updateMagBufferWorkingDimensions();
        if (forceRaster) {
            this.setMagRasterDimensions(this.mbw, this.mbh);
        }
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.updateMagBufferWorkingDimensions();
        if (forceRaster) {
            this.setMagRasterDimensions(this.mbw, this.mbh);
        }
    }

    public int getOuterRadius() {
        return this.LR1;
    }

    public int getRadius() {
        return this.LR1;
    }

    public int getInnerRadius() {
        return this.LR2;
    }

    public synchronized void setLensBuffer(ViewPanel p) {
        this.owningView = p;
        Dimension s = p.getSize();
        this.w = s.width;
        this.h = s.height;
        this.sw = this.w / 2;
        this.sh = this.h / 2;
        this.lurd[0] = this.lx + this.sw - this.getRadius();
        this.lurd[1] = this.ly + this.sh - this.getRadius();
        this.lurd[2] = this.lx + this.sw + this.getRadius();
        this.lurd[3] = this.ly + this.sh + this.getRadius();
        if (this.lurd[0] < 0) {
            this.lurd[0] = 0;
        }
        if (this.lurd[1] < 0) {
            this.lurd[1] = 0;
        }
        if (this.lurd[2] > this.w) {
            this.lurd[2] = this.w;
        }
        if (this.lurd[3] > this.h) {
            this.lurd[3] = this.h;
        }
        this.lensWidth = this.lurd[2] - this.lurd[0];
        this.lensHeight = this.lurd[3] - this.lurd[1];
        BufferedImage tbi = (BufferedImage)p.createImage(1, 1);
        this.imageType = tbi.getType();
        this.transferType = tbi.getRaster().getTransferType();
        this.initBuffers(this.lensWidth * this.lensHeight, this.mbw * this.mbh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void transformI(WritableRaster iwr, WritableRaster ewr) {
        FixedSizeLens fixedSizeLens = this;
        synchronized (fixedSizeLens) {
            iwr.getDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.oPixelsI);
            ewr.getDataElements(0, 0, this.mbw, this.mbh, this.mPixelsI);
            for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
                for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                    this.gf(x, y, this.gain);
                    this.tPixelsI[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.gain[0] > this.mSwitchThreshold || this.gain[1] > this.mSwitchThreshold ? this.mPixelsI[Math.round(((float)(y - this.lurd[1]) * this.MM - (float)this.mbh / 2.0f) / this.gain[1] + (float)this.mbh / 2.0f) * this.mbw + Math.round(((float)(x - this.lurd[0]) * this.MM - (float)this.mbw / 2.0f) / this.gain[0] + (float)this.mbw / 2.0f)] : this.oPixelsI[(Math.round(((float)y - (float)this.sh - (float)this.ly) / this.gain[1] + (float)this.sh + (float)this.ly) - this.lurd[1]) * this.lensWidth + (Math.round(((float)x - (float)this.sw - (float)this.lx) / this.gain[0] + (float)this.sw + (float)this.lx) - this.lurd[0])];
                }
            }
            iwr.setDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.tPixelsI);
        }
    }

    synchronized void transformS(WritableRaster iwr, WritableRaster ewr) {
        iwr.getDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.oPixelsS);
        ewr.getDataElements(0, 0, this.mbw, this.mbh, this.mPixelsS);
        for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
            for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                this.gf(x, y, this.gain);
                this.tPixelsS[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.gain[0] > this.mSwitchThreshold || this.gain[1] > this.mSwitchThreshold ? this.mPixelsS[Math.round(((float)(y - this.lurd[1]) * this.MM - (float)this.mbh / 2.0f) / this.gain[1] + (float)this.mbh / 2.0f) * this.mbw + Math.round(((float)(x - this.lurd[0]) * this.MM - (float)this.mbw / 2.0f) / this.gain[0] + (float)this.mbw / 2.0f)] : this.oPixelsS[(Math.round(((float)y - (float)this.sh - (float)this.ly) / this.gain[1] + (float)this.sh + (float)this.ly) - this.lurd[1]) * this.lensWidth + (Math.round(((float)x - (float)this.sw - (float)this.lx) / this.gain[0] + (float)this.sw + (float)this.lx) - this.lurd[0])];
            }
        }
        iwr.setDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.tPixelsS);
    }

    synchronized void transformB(WritableRaster iwr, WritableRaster ewr) {
        iwr.getDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.oPixelsB);
        ewr.getDataElements(0, 0, this.mbw, this.mbh, this.mPixelsB);
        for (int x = this.lurd[0]; x < this.lurd[2]; ++x) {
            for (int y = this.lurd[1]; y < this.lurd[3]; ++y) {
                this.gf(x, y, this.gain);
                this.tPixelsB[(y - this.lurd[1]) * this.lensWidth + (x - this.lurd[0])] = this.gain[0] > this.mSwitchThreshold || this.gain[1] > this.mSwitchThreshold ? this.mPixelsB[Math.round(((float)(y - this.lurd[1]) * this.MM - (float)this.mbh / 2.0f) / this.gain[1] + (float)this.mbh / 2.0f) * this.mbw + Math.round(((float)(x - this.lurd[0]) * this.MM - (float)this.mbw / 2.0f) / this.gain[0] + (float)this.mbw / 2.0f)] : this.oPixelsB[(Math.round(((float)y - (float)this.sh - (float)this.ly) / this.gain[1] + (float)this.sh + (float)this.ly) - this.lurd[1]) * this.lensWidth + (Math.round(((float)x - (float)this.sw - (float)this.lx) / this.gain[0] + (float)this.sw + (float)this.lx) - this.lurd[0])];
            }
        }
        iwr.setDataElements(this.lurd[0], this.lurd[1], this.lensWidth, this.lensHeight, this.tPixelsB);
    }

    public synchronized void setAbsolutePosition(int ax, int ay) {
        this.lx = ax - this.sw;
        this.ly = ay - this.sh;
        this.lurd[0] = this.lx + this.sw - this.getRadius();
        this.lurd[1] = this.ly + this.sh - this.getRadius();
        this.lurd[2] = this.lx + this.sw + this.getRadius();
        this.lurd[3] = this.ly + this.sh + this.getRadius();
        if (this.lurd[0] < 0) {
            this.lurd[0] = 0;
        }
        if (this.lurd[1] < 0) {
            this.lurd[1] = 0;
        }
        if (this.lurd[2] > this.w) {
            this.lurd[2] = this.w;
        }
        if (this.lurd[3] > this.h) {
            this.lurd[3] = this.h;
        }
        this.lensWidth = this.lurd[2] - this.lurd[0];
        this.lensHeight = this.lurd[3] - this.lurd[1];
    }

    public void setInnerRadiusColor(Color c) {
        this.r2Color = c;
    }

    public void setOuterRadiusColor(Color c) {
        this.r1Color = c;
    }

    public Color getInnerRadiusColor() {
        return this.r2Color;
    }

    public Color getOuterRadiusColor() {
        return this.r1Color;
    }

    public void drawBoundary(Graphics2D g2d) {
        if (this.r1Color != null) {
            g2d.setColor(this.r1Color);
            g2d.drawOval(this.lx + this.w / 2 - this.LR1, this.ly + this.h / 2 - this.LR1, 2 * this.LR1, 2 * this.LR1);
        }
        if (this.r2Color != null) {
            g2d.setColor(this.r2Color);
            g2d.drawOval(this.lx + this.w / 2 - this.LR2, this.ly + this.h / 2 - this.LR2, 2 * this.LR2, 2 * this.LR2);
        }
    }

    public long[] getVisibleRegionInFocus(Camera c, long[] res) {
        float uncoef = (c.focal + c.altitude) / c.focal;
        res[0] = (long)((float)c.posx + ((float)this.lx - (float)this.LR2 / this.MM) * uncoef);
        res[1] = (long)((float)c.posy + ((float)(-this.ly) + (float)this.LR2 / this.MM) * uncoef);
        res[2] = (long)((float)c.posx + ((float)this.lx + (float)this.LR2 / this.MM) * uncoef);
        res[3] = (long)((float)c.posy + ((float)(-this.ly) - (float)this.LR2 / this.MM) * uncoef);
        return res;
    }
}

