!
!  Medians - common methods
!
!  Copyright © 2016 F.Hroch (hroch@physics.muni.cz)
!
!  This file is part of Munipack.
!
!  Munipack is free software: you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation, either version 3 of the License, or
!  (at your option) any later version.
!
!  Munipack is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with Munipack.  If not, see <http://www.gnu.org/licenses/>.
!
!

! Medians:
! * qmed - quick-median
! * xmed - median of sorted array

module medians

  implicit none

  ! numerical precision of real numbers
  integer, parameter, private :: dbl = selected_real_kind(15)

contains

    ! Quick median by Wirth: Algorith + data structures = programs
  ! fastest known median algorithm ~2*n

  function qmed(b,k) result(x)

    integer, intent(in) :: k
    real(dbl),dimension(:),intent(in) :: b
    real(dbl),dimension(:),allocatable :: a
    real(dbl) :: w,x
    integer :: n,l,r,i,j

    n = size(b)
    allocate(a(n))
    a = b

    l = 1
    r = n
    do while( l < r )
       x = a(k)
       i = l
       j = r
       do
          do while( a(i) < x )
             i = i + 1
          enddo
          do while( x < a(j) )
             j = j - 1
          enddo
          if( i <= j ) then
             w = a(i)
             a(i) = a(j)
             a(j) = w
             i = i + 1
             j = j - 1
          endif
          if( i > j ) exit
       enddo
       if( j < k ) l = i
       if( k < i ) r = j
    enddo
    deallocate(a)

  end function qmed


  ! computes median from pre-sorted array
  ! prefered for a few elements ~n*log(n)

  function xmed(b)

    use selectsort

    real(dbl),dimension(:),intent(in) :: b
    real(dbl) :: xmed
    real(dbl),dimension(:),allocatable :: a
    integer :: n

    n = size(b)

    if( n == 0 ) then
       xmed = 0.0_dbl
       return
    end if

    if( n == 1 ) then
       xmed = b(1)
       return
    end if

    allocate(a(n))
    a = b
    call ssort(a)

    xmed = (a((n+1)/2) + a(n/2)) / 2.0_dbl

    deallocate(a)

  end function xmed

end module medians
