/*
 * Author strongly advices against using this code, or a part of it,
 * in an application designed to run on any Microsoft(tm) platform.
 *
 * See doc/README for more information about COPYING terms.
 */
#ifndef _MCDP_H
#define _MCDP_H

#include <time.h>
#include <netdb.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdarg.h>
#include <termios.h>
#include <signal.h>
#include <limits.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <linux/cdrom.h>

#include "params.h"

#define MCDP_VERSION "0.4"

/* METHODS */
#define M_PLAY_CD    0 /* play whole cd and stop */
#define M_REPEAT_CD  1 /* play whole cd in endless-loop */
#define M_REPEAT_TRK 2 /* play current track in endless-loop */
#define M_INTRO      3 /* play first ten seconds of each track and stop */

/* UPDATES */
#define U_STATUS 0 /* only titles are updated */
#define U_METHOD 1 /* status-method is updated */
#define U_VOLUME 2 /* status-volume is updated */
#define U_TRACKS 3 /* all tracks are updated */
#define U_ALL    4 /* really ALL is updated */

#define CDDB_NOENT   0 /* no local cddb, no remote access*/
#define CDDB_LOCAL   1 /* local entry is used */
#define CDDB_REMOTE  2 /* can download from CDDB_SERVER */
#define CDDB_WORKMAN 3 /* local entry .workman format */

/* ***** */
/* mcdp.c */
struct track {
 int audio; /* current track is audio */
 int sec;   /* seconds of current title */
 int min;   /* minutes of current title */
 int cddb;  /* cddb-trackid, 0=discid */
 char name[CDDB_TITLEMAX]; /* name of title, 0=artist/cdname (XXX: is fixed sized okay?) */
};

struct mcdp {
 char *dev;    /* file name of device */
 int fd;       /* file descriptor */
 int method;   /* current playing METHOD (M_*) */
 int status;   /* old status, compared to cds.audiost.. */
 int title[1]; /* current/last title */
 struct track t[MCDP_CDAUDIO_MAX+1]; /* calculated times of all tracks */
 struct cdrom_volctrl vol;          /* current channel0..3 (0..255) */
 struct cdrom_subchnl cds;          /* tmp subchannelinfos */
 struct cdrom_tocentry cdte[MCDP_CDAUDIO_MAX+1]; /* mainly for playmsf */
};

struct he {
 int fd; /* socketfd */
 char *msg; /* some msg */
};

extern short pluskey,updates[4],offset;
extern void mcdp_quit(int);	/* cleanups + quit */

/* ****** */
/* cddb.c */
extern short cddb;
extern char port[6], ip[16];

extern int cddb_getentries(struct mcdp *cd); /* fills cd->t[].name, sets cddb variable */
extern int wmdb_getentries(struct mcdp *cd); /* fills also cd->t[].name */

/* ***** */
/* tty.c */
#define TERM_INIT 0 /* save current value (only one time) */
#define TERM_QUIT 1 /* reset terminal to the old values */
extern void tty_mode(int mode); /* for setting up the terminal */
extern int  tty_getsize(short *x, short *y); /* termsize to x,y */
extern void tty_resize(int i); /* after changes */

/* aliase */
#define show1(m) mesg(1,(char*)m) /* to stdout */
#define show2(m) mesg(2,(char*)m) /* to stderr */
#define gotoxy(x,y) _printf(T_GOTO_XY, y, x)
#define gotoxyw(x,y,t) _printf(T_GOTO_XY "%s", y, x, t)

/* ****** */
/* draw.c */
extern short maxx,maxy;

extern void draw_updatescr(struct mcdp *cd);
extern void draw_status(char *msg, short update);

/* ****** */
/* misc.c */
extern int select_wait(int fd, int sec);
extern void mesg(int fd, char *msg);

/* ******* */
/* cddev.c */
extern int cd_readtracks(struct mcdp *cd);
extern int cd_readsubchannel(struct mcdp *cd);
extern void cd_initdev(const char *cdpath, struct mcdp *cd);
extern void cd_pauseresume(struct mcdp *cd);
extern void cd_skip(struct mcdp *cd, int secs);
extern void cd_start(struct mcdp *cd);
extern void cd_stop(struct mcdp *cd);
extern void cd_eject(int *fd);
extern void cd_close(int *fd);
extern unsigned cd_discid(struct mcdp *cd);

/* ********* */
/* formats.c */
extern int _printf(const char *format, ...);
extern int _sprintf(char *str, const char *format, ...);
extern int _snprintf(char *str, size_t size, const char *format, ...);
extern int _vsnprintf(char *str, size_t size, const char *format, va_list ap);
extern int _ltostr(char *s, int size, unsigned long i, int base, char UpCase);

/* ***** */
/* str.c */
extern size_t str_len(const unsigned char *str);
extern size_t str_ncpy(unsigned char *dst, const unsigned char *src, size_t n);

#endif /* _MCDP_H */
