module Test_libvirtd_lxc =

   let conf = "# Master configuration file for the LXC driver.
# All settings described here are optional - if omitted, sensible
# defaults are used.

# By default, log messages generated by the lxc controller go to the
# container logfile. It is also possible to accumulate log messages
# from all lxc controllers along with libvirtd's log outputs. In this
# case, the lxc controller will honor either LIBVIRT_LOG_OUTPUTS or
# log_outputs from libvirtd.conf.
#
# This is disabled by default, uncomment below to enable it.
#
log_with_libvirtd = 1
security_driver = \"selinux\"
"

   test Libvirtd_lxc.lns get conf =
{ "#comment" = "Master configuration file for the LXC driver." }
{ "#comment" = "All settings described here are optional - if omitted, sensible" }
{ "#comment" = "defaults are used." }
{ "#empty" }
{ "#comment" = "By default, log messages generated by the lxc controller go to the" }
{ "#comment" = "container logfile. It is also possible to accumulate log messages" }
{ "#comment" = "from all lxc controllers along with libvirtd's log outputs. In this" }
{ "#comment" = "case, the lxc controller will honor either LIBVIRT_LOG_OUTPUTS or" }
{ "#comment" = "log_outputs from libvirtd.conf." }
{ "#comment" = "" }
{ "#comment" = "This is disabled by default, uncomment below to enable it." }
{ "#comment" = "" }
{ "log_with_libvirtd" = "1" }
{ "security_driver" = "selinux" }
