/* ***************************************************************************
 *
 * Pico Technology USB Device Driver
 *
 *//**
 * \file      PicoDownloader.cpp 
 * \brief     Background firmware downloader for Pico products.
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: PicoDownloader.cpp,v 1.4 2008/03/04 16:58:42 pei Exp $
 *
 *************************************************************************** */

#include "PicoPortability.h"
#include "PicoDownloader.h"
#if defined(PICO_OS_MACOSX)
	#include "PicoDownloader_MacOSX.h"
#endif
#if defined(PICO_OS_LINUX)
	#include "PicoDownloader_Linux.h"
#endif

PicoDownloader *PicoDownloader::Create(std::vector<DeviceSpec *> devices) {
#if defined(PICO_OS_WIN32)
	#error "Sorry, Windows is not supported."
#elif defined(PICO_OS_MACOSX)
	return (PicoDownloader *)new PicoDownloader_MacOSX(devices);
#elif defined(PICO_OS_SOLARIS)
	#error "Sorry, Solaris is not supported."
#elif defined(PICO_OS_LINUX)
	return (PicoDownloader *)new PicoDownloader_Linux(devices);
#elif defined(PICO_OS_BSD)
	#error "Sorry, BSD is not supported."
#else
	#error "Sorry, the OS you are compiling for does not appear to be supported."
#endif
}

PicoDownloader::~PicoDownloader()
{
	
}
