/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SFX2_MGETEMPL_HXX
#define INCLUDED_SFX2_MGETEMPL_HXX

#include <vcl/edit.hxx>
#include <vcl/fixed.hxx>
#include <vcl/lstbox.hxx>
#include <vcl/vclmedit.hxx>
#include <sfx2/tabdlg.hxx>

/* expected:
    SID_TEMPLATE_NAME   :   In: StringItem, Name of Template
    SID_TEMPLATE_FAMILY :   In: Family of Template
*/

class SfxStyleFamilies;
class SfxStyleFamilyItem;
class SfxStyleSheetBase;

class SfxManageStyleSheetPage : public SfxTabPage
{
    VclMultiLineEdit* m_pNameRo;
    Edit* m_pNameRw;

    CheckBox* m_pAutoCB;

    FixedText* m_pFollowFt;
    ListBox* m_pFollowLb;

    FixedText* m_pBaseFt;
    ListBox* m_pBaseLb;

    FixedText* m_pFilterFt;
    ListBox* m_pFilterLb;

    FixedText *m_pDescFt;

    SfxStyleSheetBase *pStyle;
    SfxStyleFamilies *pFamilies;
    const SfxStyleFamilyItem *pItem;
    OUString aBuf;
    bool bModified;

    // initial data for the style
    OUString aName;
    OUString aFollow;
    OUString aParent;
    sal_uInt16 nFlags;

private:
friend class SfxStyleDialog;

    DECL_LINK( GetFocusHdl, Edit * );
    DECL_LINK( LoseFocusHdl, Edit * );

    void    UpdateName_Impl(ListBox *, const OUString &rNew);
    void    SetDescriptionText_Impl();

    SfxManageStyleSheetPage(Window *pParent, const SfxItemSet &rAttrSet );
    virtual ~SfxManageStyleSheetPage();

    static SfxTabPage*  Create(Window *pParent, const SfxItemSet &rAttrSet );

protected:
    virtual bool        FillItemSet(SfxItemSet &) SAL_OVERRIDE;
    virtual void        Reset(const SfxItemSet &) SAL_OVERRIDE;

    using TabPage::ActivatePage;
        virtual void        ActivatePage(const SfxItemSet &) SAL_OVERRIDE;
        using TabPage::DeactivatePage;
    virtual int     DeactivatePage(SfxItemSet * = 0) SAL_OVERRIDE;
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
