/*
 * $Id: MyCustomCellRendererer.java,v 1.6 2006/11/28 03:36:30 kirillcool Exp $
 * Read the "license.txt" file for licensing information.
 * (C) Antonio Vieiro. All rights reserved.
 */

package test.check.treednd;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

/**
 * MyCustomCellRendererer is a cell renderer that shows some (ugly, sorry) icons
 * 
 * @author Antonio Vieiro (antonio@antonioshome.net), $Author: kirillcool $
 * @version $Revision: 1.6 $
 */
class MyCustomCellRendererer extends DefaultTreeCellRenderer {
	ImageIcon orangeIcon;
	ImageIcon appleIcon;

	public MyCustomCellRendererer() {
		this.orangeIcon = new ImageIcon(this.getClass().getResource(
				"orange.png"));
		this.appleIcon = new ImageIcon(this.getClass().getResource("apple.png"));
	}

	public Component getTreeCellRendererComponent(JTree tree, Object value,
			boolean sel, boolean expanded, boolean leaf, int row,
			boolean hasFocus) {
		super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf,
				row, hasFocus);

		if (value.toString().startsWith("orange"))
			this.setIcon(this.orangeIcon);
		else if (value.toString().startsWith("apple"))
			this.setIcon(this.appleIcon);
		else
			this.setIcon(null);

		return this;
	}

}
