/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.util.ArrayList;

class DerIndefLenConverter {
    private static final int TAG_MASK = 31;
    private static final int FORM_MASK = 32;
    private static final int CLASS_MASK = 192;
    private static final int LEN_LONG = 128;
    private static final int LEN_MASK = 127;
    private static final int SKIP_EOC_BYTES = 2;
    private byte[] data;
    private byte[] newData;
    private int newDataPos;
    private int dataPos;
    private int dataSize;
    private int index;
    private ArrayList ndefsList = new ArrayList();
    private int numOfTotalLenBytes = 0;

    private boolean isEOC(int n) {
        return (n & 0x1F) == 0 && (n & 0x20) == 0 && (n & 0xC0) == 0;
    }

    static boolean isLongForm(int n) {
        return (n & 0x80) == 128;
    }

    DerIndefLenConverter() {
    }

    static boolean isIndefinite(int n) {
        return DerIndefLenConverter.isLongForm(n) && (n & 0x7F) == 0;
    }

    private void parseTag() throws IOException {
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(this.data[this.dataPos]) && this.data[this.dataPos + 1] == 0) {
            int n;
            int n2 = 0;
            Object object = null;
            for (n = this.ndefsList.size() - 1; n >= 0 && !((object = this.ndefsList.get(n)) instanceof Integer); --n) {
                n2 += ((byte[])object).length - 3;
            }
            if (n < 0) {
                throw new IOException("EOC does not have matching indefinite-length tag");
            }
            int n3 = this.dataPos - (Integer)object + n2;
            byte[] byArray = this.getLengthBytes(n3);
            this.ndefsList.set(n, byArray);
            this.numOfTotalLenBytes += byArray.length - 3;
        }
        ++this.dataPos;
    }

    private void writeTag() {
        byte by;
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(by = this.data[this.dataPos++]) && this.data[this.dataPos] == 0) {
            ++this.dataPos;
            this.writeTag();
        } else {
            this.newData[this.newDataPos++] = by;
        }
    }

    private int parseLength() throws IOException {
        int n;
        int n2 = 0;
        if (this.dataPos == this.dataSize) {
            return n2;
        }
        if (DerIndefLenConverter.isIndefinite(n = this.data[this.dataPos++] & 0xFF)) {
            this.ndefsList.add(new Integer(this.dataPos));
            return n2;
        }
        if (DerIndefLenConverter.isLongForm(n)) {
            if ((n &= 0x7F) > 4) {
                throw new IOException("Too much data");
            }
            if (this.dataSize - this.dataPos < n + 1) {
                throw new IOException("Too little data");
            }
            for (int i = 0; i < n; ++i) {
                n2 = (n2 << 8) + (this.data[this.dataPos++] & 0xFF);
            }
        } else {
            n2 = n & 0x7F;
        }
        return n2;
    }

    private void writeLengthAndValue() throws IOException {
        int n;
        if (this.dataPos == this.dataSize) {
            return;
        }
        int n2 = 0;
        if (DerIndefLenConverter.isIndefinite(n = this.data[this.dataPos++] & 0xFF)) {
            byte[] byArray = (byte[])this.ndefsList.get(this.index++);
            System.arraycopy(byArray, 0, this.newData, this.newDataPos, byArray.length);
            this.newDataPos += byArray.length;
            return;
        }
        if (DerIndefLenConverter.isLongForm(n)) {
            n &= 0x7F;
            for (int i = 0; i < n; ++i) {
                n2 = (n2 << 8) + (this.data[this.dataPos++] & 0xFF);
            }
        } else {
            n2 = n & 0x7F;
        }
        this.writeLength(n2);
        this.writeValue(n2);
    }

    private void writeLength(int n) {
        if (n < 128) {
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 256) {
            this.newData[this.newDataPos++] = -127;
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 65536) {
            this.newData[this.newDataPos++] = -126;
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 0x1000000) {
            this.newData[this.newDataPos++] = -125;
            this.newData[this.newDataPos++] = (byte)(n >> 16);
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        } else {
            this.newData[this.newDataPos++] = -124;
            this.newData[this.newDataPos++] = (byte)(n >> 24);
            this.newData[this.newDataPos++] = (byte)(n >> 16);
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        }
    }

    private byte[] getLengthBytes(int n) {
        byte[] byArray;
        int n2 = 0;
        if (n < 128) {
            byArray = new byte[1];
            byArray[n2++] = (byte)n;
        } else if (n < 256) {
            byArray = new byte[2];
            byArray[n2++] = -127;
            byArray[n2++] = (byte)n;
        } else if (n < 65536) {
            byArray = new byte[3];
            byArray[n2++] = -126;
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2++] = (byte)n;
        } else if (n < 0x1000000) {
            byArray = new byte[4];
            byArray[n2++] = -125;
            byArray[n2++] = (byte)(n >> 16);
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2++] = (byte)n;
        } else {
            byArray = new byte[5];
            byArray[n2++] = -124;
            byArray[n2++] = (byte)(n >> 24);
            byArray[n2++] = (byte)(n >> 16);
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2++] = (byte)n;
        }
        return byArray;
    }

    private int getNumOfLenBytes(int n) {
        int n2 = 0;
        n2 = n < 128 ? 1 : (n < 256 ? 2 : (n < 65536 ? 3 : (n < 0x1000000 ? 4 : 5)));
        return n2;
    }

    private void parseValue(int n) {
        this.dataPos += n;
    }

    private void writeValue(int n) {
        for (int i = 0; i < n; ++i) {
            this.newData[this.newDataPos++] = this.data[this.dataPos++];
        }
    }

    byte[] convert(byte[] byArray) throws IOException {
        this.data = byArray;
        this.dataPos = 0;
        this.index = 0;
        this.dataSize = this.data.length;
        int n = 0;
        while (this.dataPos < this.dataSize) {
            this.parseTag();
            n = this.parseLength();
            this.parseValue(n);
        }
        this.newData = new byte[this.dataSize + this.numOfTotalLenBytes];
        this.dataPos = 0;
        this.newDataPos = 0;
        this.index = 0;
        while (this.dataPos < this.dataSize) {
            this.writeTag();
            this.writeLengthAndValue();
        }
        return this.newData;
    }
}

