/*  ctapi-mkt
    Copyright (C) Dr. Claudia Neumann

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this software; see the file COPYING.   If not, write to
  the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
  Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 
   Contact: Dr. Claudia Neumann
                 Herderstr. 7
                 D - 26169 Friesoythe

                 dr. claudia.neumann@gmx.de

   This is a CT API for MKT Version 1.0 for reading the german "Krankenversichertenkarte" 
   (KVK)  und the german "elektronische Gesundheitskarte" (eGK) with card readers on
   the serial port.

   See documentations under http://www.kbv.de/ita/register_G.html and 
   http://www.gematik.de/upload/gematik_Qop_eGK_Spezifikation_Teil1_V1_1_0_Kommentare_4_1652.pdf 

   It works with:
     Kernel > 2.6.0
     tested on various card readers that are certified from the KBV with KVK,
     KVK and eGK tested on Celectronic CardStar medic2, Thales mediCompact.

   Report bugs or comments to:
        dr.claudia.neumann@gmx.de

   Known Bugs:
      none (hopefully) ;-)

*/

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <sys/signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <termios.h>
#include <fcntl.h>
#include <errno.h>

#include "ctapi.h"


unsigned char ask_resync[] = {0x12, 0xC0, 0x00, 0xD2};

int wtx=0,pcb=0;
int maxbytes[255];  

int ctn2fd[255]=
       {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};


unsigned char fxor(const unsigned char *s,int l){
	unsigned char r=0;
	while(l--)r^=s[l];
	return(r);
	}


char CT_init (  unsigned short  ctn, unsigned short  pn ) {
   int port, i, fd, flags, retval, lenc;
   unsigned char nad, pcb, len;
   unsigned char apdu[1250];
   unsigned char device[20];
   struct termios tios;
   
   maxbytes[ctn] = 32;

   switch(ctn) {
 	case '0': strcpy(device,"/dev/ttyS0"); break;
 	case '1': strcpy(device,"/dev/ttyS1"); break;
 	case '2': strcpy(device,"/dev/ttyS2"); break;
 	case '3': strcpy(device,"/dev/ttyS3"); break;
 	case '4': strcpy(device,"/dev/ttyS4"); break;
 	case '5': strcpy(device,"/dev/ttyS5"); break;
 	case '6': strcpy(device,"/dev/ttyS6"); break;
	default:  strcpy(device,"/dev/ttyS0"); break;
   }

   if (ctn2fd[ctn] == 0)
   {
      port = open (device, O_RDWR | O_NOCTTY | O_NONBLOCK);
      if (port < 0) return ERR_INVALID;
      if(tcgetattr(port,&tios)==-1)err(1,NULL);
      tios.c_iflag&=~(IGNBRK|BRKINT|IGNPAR|PARMRK|INPCK|ISTRIP|INLCR|IGNCR|ICRNL|IUCLC|IXON|IXANY|IXOFF|IMAXBEL);
      tios.c_oflag&=~OPOST;
      tios.c_cflag&=~(CSTOPB|PARODD|CRTSCTS);
      tios.c_cflag|=PARENB|CLOCAL;
      tios.c_lflag&=~(ISIG|ICANON|XCASE|ECHO);
      tios.c_cc[VTIME]=0;
      cfsetspeed(&tios,B9600);
      if(tcsetattr(port,TCSANOW,&tios)==-1)err(1,NULL);
      
      if(tcflush(port,TCIOFLUSH)==-1)err(1,NULL);
      flags=fcntl(port,F_GETFL);
      if(flags==-1)err(1,NULL);
      if(fcntl(port,F_SETFL,flags&~O_NONBLOCK)==-1)err(1,NULL);
      if(flags==-1)err(1,NULL);
   }

      lenc=sizeof(ask_resync);;
      
      #ifdef DEBUG
      fprintf(stdout,"CMD: ");
      for (i=0; i <lenc; i++) {
         fprintf(stdout, "%02x ", ask_resync[i]);
      }
      printf("\n");
     #endif
     
     retval = write(port, ask_resync, lenc);
     
     if (retval < 0)return ERR_INVALID;
     if(tcgetattr(port,&tios)==-1)err(1,NULL);
     tios.c_cc[VMIN]=4;
     if(tcsetattr(port,TCSANOW,&tios)==-1)err(1,NULL); /* could miss some errors */
	
     retval=read(port,apdu,4);

     #ifdef DEBUG
     fprintf(stdout,"RSP: ");
     for (i=0; i <4; i++) {
        fprintf(stdout, "%02x ", apdu[i]);
        }
     printf("\n");
     #endif

      if ((apdu[0] != 0x21) || (apdu[1] != 0xe0) || (retval < 0))
      {
         return ERR_INVALID;
      } 

   ctn2fd[ctn] = port;
   return OK;
} 


char CT_data ( unsigned short   ctn,
               unsigned char  * dad,
               unsigned char  * sad,
               unsigned short   lenc,
      	       unsigned char  * command,
               unsigned short * lenr,
               unsigned char  * response )
{

   int port, retval, i, j,lenblock,lenresp;
   unsigned char block[300];
   unsigned char nad, len;
   unsigned char apdu[300];
   int error_status;
   struct termios tios;

   if ((port = ctn2fd[ctn]) < 1){
      *lenr = 0; 
      return ERR_CT;
   }
   len = *lenr;
   lenresp = 0;

   block[0] = (*dad <<4)| *sad;

 if (lenc == 0 ){
    if ( wtx == 0) {
       block[1] = 0x80;
       wtx=1;
      }
   else {
      block[1] = 0x90;
      wtx=0;
    }
    }
  else {
    if (pcb==0) {
      block[1] = 0x00;
      pcb=1;
      wtx=0;
      }
    else{
      block[1] = 0x40;
      pcb=0;
      wtx=0;
     }
     }
      
      block[2] = lenc;
      memcpy(&block[3], command, lenc);

      block[lenc+3]=fxor(block,lenc+3);
      lenc=lenc+4;

      #ifdef DEBUG
      fprintf(stdout,"block[1]=%02x\n",block[1]);
      printf("lenc=%d\n",lenc);
      for (i=0; i <lenc; i++) {
         fprintf(stdout, "%02x ", block[i]);
      }
      printf("\n");
      #endif
      
      j=0;
      while (j<4){

     retval = write(port, block, lenc);
     if (retval < 0)
        return ERR_INVALID;
     if (retval != lenc){
       *lenr = 0;
       return ERR_INVALID;
       }

     if(tcgetattr(port,&tios)==-1)err(1,NULL);
     tios.c_cc[VMIN]=4;
     if(tcsetattr(port,TCSANOW,&tios)==-1)err(1,NULL);
     memset( block, 0x00, 300 );
     memset( apdu, 0x00, 300 );	
     retval=read(port,block,3);
     if(retval==-1)err(1,NULL);
       
     for(i=0;i<3;i++){
     #ifdef DEBUG
     fprintf(stdout," %02x",block[i]);
     #endif
     apdu[i]=block[i];
     }
/*     #ifdef DEBUG
      fprintf(stdout,"\n");
      #endif  */


      if(retval!=3)errx(1,"read() failed 1: %d",retval);
      len=block[2]+1;
/*      if(len>255)errx(1,"transmission error 4: %d",len);  */
      tios.c_cc[VMIN]=len;
      if(tcsetattr(port,TCSANOW,&tios)==-1)err(1,NULL);
        
      retval=read(port,block,len);

      if(retval==-1)err(1,NULL);

      for (i=0; i<retval ; i++) {
        #ifdef DEBUG
        fprintf(stdout, " %02x", block[i]);
        #endif
         apdu[i+3]=block[i];
         response[lenresp+i]=block[i];
         }
        lenblock=len+3;
        lenresp=lenresp+len-1;
       *lenr=lenresp;

	#ifdef DEBUG
        fprintf(stdout,"\n");
 	#endif

        if(apdu[lenblock-1]!=fxor(apdu,lenblock-1))errx(1,"transmission error: fxor"); 

       	if(apdu[1]==0xC3){
       	 #ifdef DEBUG
       	 fprintf(stdout,"WTX-Request\n");
       	 #endif
	 if(j==4)errx(1,"WTX-Fehler\n");
 	 for(i=0;i<lenblock;i++) {
	  block[i]=apdu[i];
	  }
	  block[0]=(*dad <<4)| *sad;
	  block[1]=0xE3;
	  block[lenblock-1]=fxor(block,lenblock-1);
	  lenc=lenblock;
          lenresp=lenresp-1;
	  #ifdef DEBUG
          for (i=0; i<lenc; i++) {
           fprintf(stdout, "%02x ", block[i]);
          }
          fprintf(stdout, "\n");
          #endif
          j++;
	}
	else if(apdu[1]==0x60){
       	 #ifdef DEBUG
       	 fprintf(stdout,"Subsequent block follows\n");
       	 #endif
	 if(j==4)errx(1,"Subsequent block-Fehler\n");
	  block[0]=0x02;
	  block[1]=0x80;
	  block[2]=0x00;
	  lenblock=4;
	  block[lenblock-1]=fxor(block,lenblock-1);
	  lenc=lenblock;
	  #ifdef DEBUG
          for (i=0; i<lenc; i++) {
           fprintf(stdout, "%02x ", block[i]);
          }
          fprintf(stdout, "\n");
          #endif
          j++;
	}
        else {
          break;
          }
        }
   return OK;
}

char CT_close ( unsigned short  ctn )
{
   int port;

   if ((port = ctn2fd[ctn]) < 1)
      return ERR_INVALID;
   close(port);
   ctn2fd[ctn] = 0;
   return OK;
}


   
   



