/*
 * Mailbox folder access
 *
 * Copyright (C) 2004--2008  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <buffy/mailfolder/mailbox.h>
#include <tests/test-utils.h>

namespace tut {
using namespace buffy;
using namespace buffy::mailfolder;
using namespace wibble::tests;

struct buffy_mailfolder_mailbox_shar {
	buffy_mailfolder_mailbox_shar() {
	}
	~buffy_mailfolder_mailbox_shar() {
	}
};
TESTGRP(buffy_mailfolder_mailbox);

class MailFolderCounter : public MailFolderConsumer
{
	size_t m_count;
public:
	MailFolderCounter() : m_count(0) {}
	void consume(MailFolder& f) { ++m_count; }
	size_t count() const { return m_count; }
};

// Check an empty mailbox
template<> template<>
void to::test<1>()
{
	MailFolder test(Mailbox::accessFolder("mbox/empty.mbox"));
	ensure_equals((bool)test, true);
	ensure_equals(test.name(), "empty.mbox");
	ensure_equals(test.path(), "mbox/empty.mbox");
	ensure_equals(test.type(), "Mailbox");

	ensure_equals(test.getMsgTotal(), -1);
	ensure_equals(test.getMsgUnread(), -1);
	ensure_equals(test.getMsgNew(), -1);
	ensure_equals(test.getMsgFlagged(), -1);
	ensure_equals(test.changed(), true);

	test.updateStatistics();
	ensure_equals(test.getMsgTotal(), 0);
	ensure_equals(test.getMsgUnread(), 0);
	ensure_equals(test.getMsgNew(), 0);
	ensure_equals(test.getMsgFlagged(), 0);
	ensure_equals(test.changed(), false);

	MailFolderCounter counter;
	Mailbox::enumerateFolders("mbox/empty.mbox", counter);
	ensure_equals(counter.count(), 1u);
}

// Check a non empty mailbox
template<> template<>
void to::test<2>()
{
	MailFolder test(Mailbox::accessFolder("mbox/test.mbox"));
	ensure_equals((bool)test, true);
	ensure_equals(test.name(), "test.mbox");
	ensure_equals(test.path(), "mbox/test.mbox");
	ensure_equals(test.type(), "Mailbox");

	ensure_equals(test.getMsgTotal(), -1);
	ensure_equals(test.getMsgUnread(), -1);
	ensure_equals(test.getMsgNew(), -1);
	ensure_equals(test.getMsgFlagged(), -1);
	ensure_equals(test.changed(), true);

	test.updateStatistics();
	ensure_equals(test.getMsgTotal(), 3);
	ensure_equals(test.getMsgUnread(), 0);
	ensure_equals(test.getMsgNew(), 0);
	ensure_equals(test.getMsgFlagged(), 1);
	ensure_equals(test.changed(), false);

	MailFolderCounter counter;
	Mailbox::enumerateFolders("mbox/test.mbox", counter);
	ensure_equals(counter.count(), 1u);
}

// Check a mailbox whose root is a broken symlink
template<> template<>
void to::test<3>()
{
	MailFolder test(Mailbox::accessFolder("mbox/broken.mbox"));
	ensure_equals((bool)test, false);

	MailFolderCounter counter;
	Mailbox::enumerateFolders("mbox/broken.mbox", counter);
	ensure_equals(counter.count(), 0u);
}

// Check enumeration of a directory with mailboxes
template<> template<>
void to::test<7>()
{
	MailFolderCounter counter;
	Mailbox::enumerateFolders("mbox", counter);
	ensure_equals(counter.count(), 2u);
}

}

// vim:set ts=4 sw=4:
