/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "displaycertdialog.h"

#include <QtCore/QStringList>

#include <klineedit.h>
#include <klocale.h>

DisplayCertDialog::DisplayCertDialog(QWidget *parent, const char* caption, KVpncConfig *GlobalConfig)
        : KDialog(parent)
{
    Q_UNUSED(caption);

    QWidget *page = new QWidget(this);
    DisplayCertDialogWidget = new Ui_DisplayCertDialogBase();
    DisplayCertDialogWidget->setupUi(page);
    setMainWidget(page);
    this->GlobalConfig = GlobalConfig;
}


DisplayCertDialog::~DisplayCertDialog()
{
}

void DisplayCertDialog::parseCertData()
{
    for (QStringList::Iterator it = CertDataList.begin(); it != CertDataList.end(); ++it) {
        if (GlobalConfig->KvpncDebugLevel > 2)
            GlobalConfig->appendLogEntry("[cert data]: " + *it, KVpncEnum::debug);
        if ((*it).contains("Common Name:"))
            DisplayCertDialogWidget->NameLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("Department:"))
            DisplayCertDialogWidget->DepartmentLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("Company:"))
            DisplayCertDialogWidget->CompanyLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("State:"))
            DisplayCertDialogWidget->StateLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("Country:"))
            DisplayCertDialogWidget->CountryLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("Email:"))
            DisplayCertDialogWidget->EmailLineEdit->setText((*it).section(':', 1, -1).trimmed());
//   else if((*it).contains("Thumb Print:"))
//    DisplayCertDialogWidget->ThumbPrintLineEdit->setText((*it).section(':',1,-1).trimmed());
        else if ((*it).contains("Key Size:"))
            DisplayCertDialogWidget->KeySizeLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("Subject:"))
            DisplayCertDialogWidget->SubjectLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("Serial #:"))
            DisplayCertDialogWidget->SerialLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("Issuer:"))
            DisplayCertDialogWidget->IssuerLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("Not before:"))
            DisplayCertDialogWidget->ValidFromLineEdit->setText((*it).section(':', 1, -1).trimmed());
        else if ((*it).contains("Not after:"))
            DisplayCertDialogWidget->ValidToLineEdit->setText((*it).section(':', 1, -1).trimmed());
    }
}

