/* -*- mode: C; c-basic-offset: 4; indent-tabs-mode: nil; -*- */
/* vim:set et sts=4: */
/* ibus - The Input Bus
 * Copyright (C) 2013-2014 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright (C) 2013-2014 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef __IBUS_COMPOSETABLE_H_
#define __IBUS_COMPOSETABLE_H_

/* The table is generated by ibus/src/gencomposetable
 *
 * if ibus_compose_seqs_a[N - 1] is an outputed compose character,
 * ibus_compose_seqs_a[N * 2 - 1] is also an outputed compose character.
 * and ibus_compose_seqs_a[0] to ibus_compose_seqs_a[0 + N - 3] are the
 * sequences and call ibus_engine_simple_add_table:
 * ibus_engine_simple_add_table(engine, ibus_compose_seqs_a,
 *                              N - 2, G_N_ELEMENTS(ibus_compose_seqs_a) / N)
 * The compose sequences are allowed within G_MAXUINT16 */

typedef struct _IBusComposeTable IBusComposeTable;
struct _IBusComposeTable
{
    const guint16 *data;
    gint max_seq_len;
    gint n_seqs;
};

typedef struct _IBusComposeTableLocaleList IBusComposeTableLocaleList;
struct _IBusComposeTableLocaleList
{
    const gchar *locale;
    const IBusComposeTable *table;
};

static const guint16 ibus_compose_seqs_am_et[] = {
  /* Not sure if am_ET compose file is useful. It uses ASCII key
   * at first but not compose keys.
   * Comment out am_compose_seqs until get the request. */
  0
};

static const IBusComposeTable ibus_compose_table_am_et = {
    ibus_compose_seqs_am_et,
    0,
    0
};

static const guint16 ibus_compose_seqs_el_gr[] = {
  IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FEF, /* U1fef */
  IBUS_KEY_dead_grave, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x0060, /* grave */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_grave, 0, 0, 0,
    0, 0x1FEF, /* U1fef */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_diaeresis, IBUS_KEY_space, 0, 0,
    0, 0x1FED, /* U1fed */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_space, 0, 0,
    0, 0x1FDD, /* U1fdd */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0B, /* U1f0b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1B, /* U1f1b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2B, /* U1f2b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3B, /* U1f3b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4B, /* U1f4b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5B, /* U1f5b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6B, /* U1f6b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F03, /* U1f03 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F13, /* U1f13 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F23, /* U1f23 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F33, /* U1f33 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F43, /* U1f43 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F53, /* U1f53 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F63, /* U1f63 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_space, 0, 0,
    0, 0x1FCD, /* U1fcd */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0A, /* U1f0a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1A, /* U1f1a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2A, /* U1f2a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3A, /* U1f3a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4A, /* U1f4a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6A, /* U1f6a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F02, /* U1f02 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F12, /* U1f12 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F22, /* U1f22 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F32, /* U1f32 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F42, /* U1f42 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F52, /* U1f52 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F62, /* U1f62 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_space, 0, 0,
    0, 0x1FCD, /* U1fcd */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_space, 0, 0,
    0, 0x1FDD, /* U1fdd */
  IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0, 0,
    0, 0x0384, /* U0384 */
  IBUS_KEY_dead_acute, IBUS_KEY_period, 0, 0, 0,
    0, 0x00B7, /* periodcentered */
  IBUS_KEY_dead_acute, IBUS_KEY_less, 0, 0, 0,
    0, 0x00AB, /* guillemotleft */
  IBUS_KEY_dead_acute, IBUS_KEY_greater, 0, 0, 0,
    0, 0x00BB, /* guillemotright */
  IBUS_KEY_dead_acute, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x00B4, /* acute */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_acute, 0, 0, 0,
    0, 0x0384, /* U0384 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_space, 0, 0,
    0, 0x1FDE, /* U1fde */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0D, /* U1f0d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1D, /* U1f1d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2D, /* U1f2d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3D, /* U1f3d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4D, /* U1f4d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5D, /* U1f5d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6D, /* U1f6d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F05, /* U1f05 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F15, /* U1f15 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F25, /* U1f25 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F35, /* U1f35 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F45, /* U1f45 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F55, /* U1f55 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F65, /* U1f65 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_space, 0, 0,
    0, 0x1FCE, /* U1fce */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0C, /* U1f0c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1C, /* U1f1c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2C, /* U1f2c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3C, /* U1f3c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4C, /* U1f4c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6C, /* U1f6c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F04, /* U1f04 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F14, /* U1f14 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F24, /* U1f24 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F34, /* U1f34 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F44, /* U1f44 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F54, /* U1f54 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F64, /* U1f64 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_space, 0, 0,
    0, 0x1FCE, /* U1fce */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_space, 0, 0,
    0, 0x1FDE, /* U1fde */
  IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FC0, /* U1fc0 */
  IBUS_KEY_dead_tilde, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x007E, /* asciitilde */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_tilde, 0, 0, 0,
    0, 0x1FC0, /* U1fc0 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_diaeresis, IBUS_KEY_space, 0, 0,
    0, 0x1FC1, /* U1fc1 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_space, 0, 0,
    0, 0x1FDF, /* U1fdf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0F, /* U1f0f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2F, /* U1f2f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3F, /* U1f3f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5F, /* U1f5f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6F, /* U1f6f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F07, /* U1f07 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F27, /* U1f27 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F37, /* U1f37 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F57, /* U1f57 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F67, /* U1f67 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_space, 0, 0,
    0, 0x1FCF, /* U1fcf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0E, /* U1f0e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2E, /* U1f2e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3E, /* U1f3e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6E, /* U1f6e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F06, /* U1f06 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F26, /* U1f26 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F36, /* U1f36 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F56, /* U1f56 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F66, /* U1f66 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_space, 0, 0,
    0, 0x1FCF, /* U1fcf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_space, 0, 0,
    0, 0x1FDF, /* U1fdf */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_space, 0, 0, 0,
    0, 0x00A8, /* diaeresis */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_period, 0, 0, 0,
    0, 0x00B7, /* periodcentered */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_less, 0, 0, 0,
    0, 0x00AB, /* guillemotleft */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_greater, 0, 0, 0,
    0, 0x00BB, /* guillemotright */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FED, /* U1fed */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FC1, /* U1fc1 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FFE, /* U1ffe */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0, 0,
    0, 0x1F09, /* U1f09 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_EPSILON, 0, 0, 0,
    0, 0x1F19, /* U1f19 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0, 0,
    0, 0x1F29, /* U1f29 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_IOTA, 0, 0, 0,
    0, 0x1F39, /* U1f39 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMICRON, 0, 0, 0,
    0, 0x1F49, /* U1f49 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_RHO, 0, 0, 0,
    0, 0x1FEC, /* U1fec */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_UPSILON, 0, 0, 0,
    0, 0x1F59, /* U1f59 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0, 0,
    0, 0x1F69, /* U1f69 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0, 0,
    0, 0x1F01, /* U1f01 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_epsilon, 0, 0, 0,
    0, 0x1F11, /* U1f11 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0, 0,
    0, 0x1F21, /* U1f21 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_iota, 0, 0, 0,
    0, 0x1F31, /* U1f31 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omicron, 0, 0, 0,
    0, 0x1F41, /* U1f41 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_rho, 0, 0, 0,
    0, 0x1FE5, /* U1fe5 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_upsilon, 0, 0, 0,
    0, 0x1F51, /* U1f51 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0, 0,
    0, 0x1F61, /* U1f61 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FDD, /* U1fdd */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0B, /* U1f0b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1B, /* U1f1b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2B, /* U1f2b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3B, /* U1f3b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4B, /* U1f4b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5B, /* U1f5b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6B, /* U1f6b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F03, /* U1f03 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F13, /* U1f13 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F23, /* U1f23 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F33, /* U1f33 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F43, /* U1f43 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F53, /* U1f53 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F63, /* U1f63 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x1FDE, /* U1fde */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0D, /* U1f0d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1D, /* U1f1d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2D, /* U1f2d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3D, /* U1f3d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4D, /* U1f4d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5D, /* U1f5d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6D, /* U1f6d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F05, /* U1f05 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F15, /* U1f15 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F25, /* U1f25 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F35, /* U1f35 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F45, /* U1f45 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F55, /* U1f55 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F65, /* U1f65 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FDF, /* U1fdf */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0F, /* U1f0f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2F, /* U1f2f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3F, /* U1f3f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5F, /* U1f5f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6F, /* U1f6f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F07, /* U1f07 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F27, /* U1f27 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F37, /* U1f37 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F57, /* U1f57 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F67, /* U1f67 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_ogonek, 0, 0, 0,
    0, 0x1FFE, /* U1ffe */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F89, /* U1f89 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F99, /* U1f99 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FA9, /* U1fa9 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F81, /* U1f81 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F91, /* U1f91 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FA1, /* U1fa1 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_iota, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x1FBE, /* U1fbe */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F89, /* U1f89 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F99, /* U1f99 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FA9, /* U1fa9 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F81, /* U1f81 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F91, /* U1f91 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FA1, /* U1fa1 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F88, /* U1f88 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F98, /* U1f98 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FA8, /* U1fa8 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F80, /* U1f80 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F90, /* U1f90 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FA0, /* U1fa0 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_horn, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FBF, /* U1fbf */
  IBUS_KEY_dead_horn, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x1FBD, /* U1fbd */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0, 0,
    0, 0x1F08, /* U1f08 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_EPSILON, 0, 0, 0,
    0, 0x1F18, /* U1f18 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0, 0,
    0, 0x1F28, /* U1f28 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_IOTA, 0, 0, 0,
    0, 0x1F38, /* U1f38 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMICRON, 0, 0, 0,
    0, 0x1F48, /* U1f48 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0, 0,
    0, 0x1F68, /* U1f68 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0, 0,
    0, 0x1F00, /* U1f00 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_epsilon, 0, 0, 0,
    0, 0x1F10, /* U1f10 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0, 0,
    0, 0x1F20, /* U1f20 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_iota, 0, 0, 0,
    0, 0x1F30, /* U1f30 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_omicron, 0, 0, 0,
    0, 0x1F40, /* U1f40 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_rho, 0, 0, 0,
    0, 0x1FE4, /* U1fe4 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_upsilon, 0, 0, 0,
    0, 0x1F50, /* U1f50 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0, 0,
    0, 0x1F60, /* U1f60 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FCD, /* U1fcd */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0A, /* U1f0a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1A, /* U1f1a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2A, /* U1f2a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3A, /* U1f3a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4A, /* U1f4a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6A, /* U1f6a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F02, /* U1f02 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F12, /* U1f12 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F22, /* U1f22 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F32, /* U1f32 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F42, /* U1f42 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F52, /* U1f52 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F62, /* U1f62 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x1FCE, /* U1fce */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0C, /* U1f0c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1C, /* U1f1c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2C, /* U1f2c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3C, /* U1f3c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4C, /* U1f4c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6C, /* U1f6c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F04, /* U1f04 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F14, /* U1f14 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F24, /* U1f24 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F34, /* U1f34 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F44, /* U1f44 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F54, /* U1f54 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F64, /* U1f64 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FCF, /* U1fcf */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0E, /* U1f0e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2E, /* U1f2e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3E, /* U1f3e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6E, /* U1f6e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F06, /* U1f06 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F26, /* U1f26 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F36, /* U1f36 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F56, /* U1f56 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F66, /* U1f66 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F88, /* U1f88 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F98, /* U1f98 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FA8, /* U1fa8 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F80, /* U1f80 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F90, /* U1f90 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FA0, /* U1fa0 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_horn, 0, 0, 0,
    0, 0x1FBF, /* U1fbf */
  IBUS_KEY_dead_psili, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FBF, /* U1fbf */
  IBUS_KEY_dead_psili, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x1FBD, /* U1fbd */
  IBUS_KEY_dead_psili, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FCD, /* U1fcd */
  IBUS_KEY_dead_psili, IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x1FCE, /* U1fce */
  IBUS_KEY_dead_psili, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FCF, /* U1fcf */
  IBUS_KEY_dead_psili, IBUS_KEY_dead_horn, 0, 0, 0,
    0, 0x1FBF, /* U1fbf */
  IBUS_KEY_dead_dasia, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FFE, /* U1ffe */
  IBUS_KEY_dead_dasia, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FDD, /* U1fdd */
  IBUS_KEY_dead_dasia, IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x1FDE, /* U1fde */
  IBUS_KEY_dead_dasia, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FDF, /* U1fdf */
  IBUS_KEY_dead_dasia, IBUS_KEY_dead_ogonek, 0, 0, 0,
    0, 0x1FFE, /* U1ffe */
  IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_S, 0, 0,
    0, 0x00A7, /* section */
  IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_s, 0, 0,
    0, 0x00A7, /* section */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_grave, IBUS_KEY_Greek_iota, 0,
    0, 0x1FD2, /* U1fd2 */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_grave, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1FE2, /* U1fe2 */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_asciitilde, IBUS_KEY_Greek_iota, 0,
    0, 0x1FD7, /* U1fd7 */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_asciitilde, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1FE7, /* U1fe7 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_space, 0,
    0, 0x2018, /* leftsinglequotemark */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0D, /* U1f0d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1D, /* U1f1d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2D, /* U1f2d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3D, /* U1f3d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4D, /* U1f4d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5D, /* U1f5d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6D, /* U1f6d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F05, /* U1f05 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F15, /* U1f15 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0,
    0, 0x1F25, /* U1f25 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_iota, 0,
    0, 0x1F35, /* U1f35 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F45, /* U1f45 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F55, /* U1f55 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0,
    0, 0x1F65, /* U1f65 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_space, 0,
    0, 0x2019, /* rightsinglequotemark */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0C, /* U1f0c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1C, /* U1f1c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2C, /* U1f2c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3C, /* U1f3c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4C, /* U1f4c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6C, /* U1f6c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F04, /* U1f04 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F14, /* U1f14 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0,
    0, 0x1F24, /* U1f24 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_iota, 0,
    0, 0x1F34, /* U1f34 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F44, /* U1f44 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F54, /* U1f54 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0,
    0, 0x1F64, /* U1f64 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB4, /* U1fb4 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC4, /* U1fc4 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF4, /* U1ff4 */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_minus, 0, 0,
    0, 0x00AD, /* hyphen */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_D, 0, 0,
    0, 0x00D0, /* ETH */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_a, 0, 0,
    0, 0x00E3, /* atilde */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_d, 0, 0,
    0, 0x00F0, /* eth */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_o, 0, 0,
    0, 0x00F5, /* otilde */
  IBUS_KEY_Multi_key, IBUS_KEY_slash, IBUS_KEY_slash, 0, 0,
    0, 0x0374, /* U0374 */
  IBUS_KEY_Multi_key, IBUS_KEY_slash, IBUS_KEY_C, 0, 0,
    0, 0x00A2, /* cent */
  IBUS_KEY_Multi_key, IBUS_KEY_colon, IBUS_KEY_colon, 0, 0,
    0, 0x0387, /* U0387 */
  IBUS_KEY_Multi_key, IBUS_KEY_semicolon, IBUS_KEY_semicolon, 0, 0,
    0, 0x037E, /* U037e */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_space, 0,
    0, 0x2018, /* leftsinglequotemark */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0D, /* U1f0d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1D, /* U1f1d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2D, /* U1f2d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3D, /* U1f3d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4D, /* U1f4d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5D, /* U1f5d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6D, /* U1f6d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F05, /* U1f05 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F15, /* U1f15 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta, 0,
    0, 0x1F25, /* U1f25 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_iota, 0,
    0, 0x1F35, /* U1f35 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F45, /* U1f45 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F55, /* U1f55 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega, 0,
    0, 0x1F65, /* U1f65 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0B, /* U1f0b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1B, /* U1f1b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2B, /* U1f2b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3B, /* U1f3b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4B, /* U1f4b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5B, /* U1f5b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6B, /* U1f6b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F03, /* U1f03 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F13, /* U1f13 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F23, /* U1f23 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_iota, 0,
    0, 0x1F33, /* U1f33 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F43, /* U1f43 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F53, /* U1f53 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1F63, /* U1f63 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F89, /* U1f89 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F99, /* U1f99 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FA9, /* U1fa9 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F81, /* U1f81 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1F91, /* U1f91 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA1, /* U1fa1 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0F, /* U1f0f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2F, /* U1f2f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3F, /* U1f3f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5F, /* U1f5f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6F, /* U1f6f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F07, /* U1f07 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F27, /* U1f27 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_iota, 0,
    0, 0x1F37, /* U1f37 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F57, /* U1f57 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1F67, /* U1f67 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F09, /* U1f09 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F19, /* U1f19 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F29, /* U1f29 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F39, /* U1f39 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F49, /* U1f49 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_RHO, 0, 0,
    0, 0x1FEC, /* U1fec */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F59, /* U1f59 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F69, /* U1f69 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F01, /* U1f01 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F11, /* U1f11 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F21, /* U1f21 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F31, /* U1f31 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F41, /* U1f41 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_rho, 0, 0,
    0, 0x1FE5, /* U1fe5 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F51, /* U1f51 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F61, /* U1f61 */
  IBUS_KEY_Multi_key, IBUS_KEY_equal, IBUS_KEY_L, 0, 0,
    0, 0x00A3, /* sterling */
  IBUS_KEY_Multi_key, IBUS_KEY_equal, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x20AC, /* EuroSign */
  IBUS_KEY_Multi_key, IBUS_KEY_equal, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x20AC, /* EuroSign */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_space, 0,
    0, 0x2019, /* rightsinglequotemark */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0C, /* U1f0c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1C, /* U1f1c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2C, /* U1f2c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3C, /* U1f3c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4C, /* U1f4c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6C, /* U1f6c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F04, /* U1f04 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F14, /* U1f14 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta, 0,
    0, 0x1F24, /* U1f24 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_iota, 0,
    0, 0x1F34, /* U1f34 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F44, /* U1f44 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F54, /* U1f54 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega, 0,
    0, 0x1F64, /* U1f64 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0A, /* U1f0a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1A, /* U1f1a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2A, /* U1f2a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3A, /* U1f3a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4A, /* U1f4a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6A, /* U1f6a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F02, /* U1f02 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F12, /* U1f12 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F22, /* U1f22 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_iota, 0,
    0, 0x1F32, /* U1f32 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F42, /* U1f42 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F52, /* U1f52 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1F62, /* U1f62 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F88, /* U1f88 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F98, /* U1f98 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FA8, /* U1fa8 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F80, /* U1f80 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1F90, /* U1f90 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA0, /* U1fa0 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0E, /* U1f0e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2E, /* U1f2e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3E, /* U1f3e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6E, /* U1f6e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F06, /* U1f06 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F26, /* U1f26 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_iota, 0,
    0, 0x1F36, /* U1f36 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F56, /* U1f56 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1F66, /* U1f66 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F08, /* U1f08 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F18, /* U1f18 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F28, /* U1f28 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F38, /* U1f38 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F48, /* U1f48 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F68, /* U1f68 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F00, /* U1f00 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F10, /* U1f10 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F20, /* U1f20 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F30, /* U1f30 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F40, /* U1f40 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_rho, 0, 0,
    0, 0x1FE4, /* U1fe4 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F50, /* U1f50 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F60, /* U1f60 */
  IBUS_KEY_Multi_key, IBUS_KEY_question, IBUS_KEY_exclam, 0, 0,
    0, 0x203D, /* U203D # INTERROBANG */
  IBUS_KEY_Multi_key, IBUS_KEY_A, IBUS_KEY_O, 0, 0,
    0, 0x00C5, /* Aring */
  IBUS_KEY_Multi_key, IBUS_KEY_B, IBUS_KEY_V, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_C, IBUS_KEY_slash, 0, 0,
    0, 0x00A2, /* cent */
  IBUS_KEY_Multi_key, IBUS_KEY_C, IBUS_KEY_cedilla, 0, 0,
    0, 0x00C7, /* Ccedilla */
  IBUS_KEY_Multi_key, IBUS_KEY_D, IBUS_KEY_minus, 0, 0,
    0, 0x00D0, /* ETH */
  IBUS_KEY_Multi_key, IBUS_KEY_V, IBUS_KEY_B, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_backslash, IBUS_KEY_backslash, 0, 0,
    0, 0x0375, /* U0375 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_exclam, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_0, 0, 0,
    0, 0x00B0, /* degree */
  IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_asciicircum, 0, 0,
    0, 0x02D8, /* breve */
  IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_A, 0, 0,
    0, 0x00AA, /* ordfeminine */
  IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_O, 0, 0,
    0, 0x00BA, /* masculine */
  IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_a, 0, 0,
    0, 0x00AA, /* ordfeminine */
  IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_o, 0, 0,
    0, 0x00BA, /* masculine */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0B, /* U1f0b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1B, /* U1f1b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2B, /* U1f2b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3B, /* U1f3b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4B, /* U1f4b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5B, /* U1f5b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6B, /* U1f6b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F03, /* U1f03 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F13, /* U1f13 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0,
    0, 0x1F23, /* U1f23 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_iota, 0,
    0, 0x1F33, /* U1f33 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F43, /* U1f43 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F53, /* U1f53 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0,
    0, 0x1F63, /* U1f63 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0A, /* U1f0a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1A, /* U1f1a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2A, /* U1f2a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3A, /* U1f3a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4A, /* U1f4a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6A, /* U1f6a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F02, /* U1f02 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F12, /* U1f12 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0,
    0, 0x1F22, /* U1f22 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_iota, 0,
    0, 0x1F32, /* U1f32 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F42, /* U1f42 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F52, /* U1f52 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0,
    0, 0x1F62, /* U1f62 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB2, /* U1fb2 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC2, /* U1fc2 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF2, /* U1ff2 */
  IBUS_KEY_Multi_key, IBUS_KEY_a, IBUS_KEY_minus, 0, 0,
    0, 0x00E3, /* atilde */
  IBUS_KEY_Multi_key, IBUS_KEY_a, IBUS_KEY_o, 0, 0,
    0, 0x00E5, /* aring */
  IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_v, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_c, IBUS_KEY_O, 0, 0,
    0, 0x00A9, /* copyright */
  IBUS_KEY_Multi_key, IBUS_KEY_c, IBUS_KEY_o, 0, 0,
    0, 0x00A9, /* copyright */
  IBUS_KEY_Multi_key, IBUS_KEY_c, IBUS_KEY_cedilla, 0, 0,
    0, 0x00E7, /* ccedilla */
  IBUS_KEY_Multi_key, IBUS_KEY_d, IBUS_KEY_minus, 0, 0,
    0, 0x00F0, /* eth */
  IBUS_KEY_Multi_key, IBUS_KEY_o, IBUS_KEY_minus, 0, 0,
    0, 0x00F5, /* otilde */
  IBUS_KEY_Multi_key, IBUS_KEY_v, IBUS_KEY_b, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB4, /* U1fb4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC4, /* U1fc4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF4, /* U1ff4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F89, /* U1f89 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F99, /* U1f99 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FA9, /* U1fa9 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F81, /* U1f81 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0,
    0, 0x1F91, /* U1f91 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA1, /* U1fa1 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F88, /* U1f88 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F98, /* U1f98 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FA8, /* U1fa8 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F80, /* U1f80 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0,
    0, 0x1F90, /* U1f90 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA0, /* U1fa0 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB2, /* U1fb2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC2, /* U1fc2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF2, /* U1ff2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_bar, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB7, /* U1fb7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC7, /* U1fc7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF7, /* U1ff7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1FBC, /* U1fbc */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1FCC, /* U1fcc */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FFC, /* U1ffc */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1FB3, /* U1fb3 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1FC3, /* U1fc3 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FF3, /* U1ff3 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0F, /* U1f0f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2F, /* U1f2f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3F, /* U1f3f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5F, /* U1f5f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6F, /* U1f6f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F07, /* U1f07 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0,
    0, 0x1F27, /* U1f27 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_iota, 0,
    0, 0x1F37, /* U1f37 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F57, /* U1f57 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0,
    0, 0x1F67, /* U1f67 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0E, /* U1f0e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2E, /* U1f2e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3E, /* U1f3e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6E, /* U1f6e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F06, /* U1f06 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0,
    0, 0x1F26, /* U1f26 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_iota, 0,
    0, 0x1F36, /* U1f36 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F56, /* U1f56 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0,
    0, 0x1F66, /* U1f66 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB7, /* U1fb7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC7, /* U1fc7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF7, /* U1ff7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_asciitilde, 0, 0,
    0, 0x2015, /* Greek_horizbar */
  IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_C, 0, 0,
    0, 0x00C7, /* Ccedilla */
  IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_c, 0, 0,
    0, 0x00E7, /* ccedilla */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_DELTA, IBUS_KEY_Greek_RHO, 0, 0,
    0, 0x20AF, /* U20af */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_DELTA, IBUS_KEY_Greek_rho, 0, 0,
    0, 0x20AF, /* U20af */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_EPSILON, IBUS_KEY_equal, 0, 0,
    0, 0x20AC, /* EuroSign */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_delta, IBUS_KEY_Greek_RHO, 0, 0,
    0, 0x20AF, /* U20af */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_delta, IBUS_KEY_Greek_rho, 0, 0,
    0, 0x20AF, /* U20af */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_epsilon, IBUS_KEY_equal, 0, 0,
    0, 0x20AC  /* EuroSign */
};

static const IBusComposeTable ibus_compose_table_el_gr = {
    ibus_compose_seqs_el_gr,
    5,
    G_N_ELEMENTS (ibus_compose_seqs_el_gr) / (5 + 2)
};

static const guint16 ibus_compose_seqs_fi_fi[] = {
  IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x00B4, /* U00B4  #  ACUTE ACCENT */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_circumflex, IBUS_KEY_E, 0,
    0, 0x1EC6, /* U1EC6  #  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_space, 0, 0,
    0, 0x00A8, /* U00A8  #  DIAERESIS */
  IBUS_KEY_dead_abovering, IBUS_KEY_space, 0, 0,
    0, 0x02DA, /* U02DA  #  RING ABOVE */
  IBUS_KEY_dead_hook, IBUS_KEY_dead_horn, IBUS_KEY_o, 0,
    0, 0x1EDD, /* U1EDD  #  LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE */
  IBUS_KEY_dead_stroke, IBUS_KEY_D, 0, 0,
    0, 0x0110, /* U0110  #  LATIN CAPITAL LETTER D WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_G, 0, 0,
    0, 0x01E4, /* U01E4  #  LATIN CAPITAL LETTER G WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_H, 0, 0,
    0, 0x0126, /* U0126  #  LATIN CAPITAL LETTER H WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_L, 0, 0,
    0, 0x0141, /* U0141  #  LATIN CAPITAL LETTER L WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_O, 0, 0,
    0, 0x00D8, /* U00D8  #  LATIN CAPITAL LETTER O WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_T, 0, 0,
    0, 0x0166, /* U0166  #  LATIN CAPITAL LETTER T WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_d, 0, 0,
    0, 0x0111, /* U0111  #  LATIN SMALL LETTER D WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_g, 0, 0,
    0, 0x01E5, /* U01E5  #  LATIN SMALL LETTER G WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_h, 0, 0,
    0, 0x0127, /* U0127  #  LATIN SMALL LETTER H WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_l, 0, 0,
    0, 0x0142, /* U0142  #  LATIN SMALL LETTER L WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_o, 0, 0,
    0, 0x00F8, /* U00F8  #  LATIN SMALL LETTER O WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_t, 0, 0,
    0, 0x0167, /* U0167  #  LATIN SMALL LETTER T WITH STROKE */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_S, 0, 0,
    0, 0x0218, /* U0218  #  LATIN CAPITAL LETTER S WITH COMMA BELOW */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_T, 0, 0,
    0, 0x021A, /* U021A  #  LATIN CAPITAL LETTER T WITH COMMA BELOW */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_s, 0, 0,
    0, 0x0219, /* U0219  #  LATIN SMALL LETTER S WITH COMMA BELOW */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_t, 0, 0,
    0, 0x021B, /* U021B  #  LATIN SMALL LETTER T WITH COMMA BELOW */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_space, IBUS_KEY_n,
    0, 0x0149  /* U0149  #  LATIN SMALL LETTER N PRECEDED BY APOSTROPHE */
};

static const IBusComposeTable ibus_compose_table_fi_fi = {
    ibus_compose_seqs_fi_fi,
    4,
    G_N_ELEMENTS (ibus_compose_seqs_fi_fi) / (4 + 2)
};

static const guint16 ibus_compose_seqs_pt_br[] = {
  IBUS_KEY_dead_acute, IBUS_KEY_C, 0, 0,
    0, 0x00C7, /* Ccedilla	# LATIN CAPITAL LETTER C WITH CEDILLA */
  IBUS_KEY_dead_acute, IBUS_KEY_c, 0, 0,
    0, 0x00E7, /* ccedilla	# LATIN SMALL LETTER C WITH CEDILLA */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_slash, 0,
    0, 0x301E, /* U301e	# DOUBLE PRIME QUOTATION MARK */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_backslash, 0,
    0, 0x301D, /* U301d	# REVERSED DOUBLE PRIME QUOTATION MARK */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x03D2, 0,
    0, 0x03D3, /* U03D3	# GREEK UPSILON WITH ACUTE AND HOOK SYMBOL */
  IBUS_KEY_Multi_key, IBUS_KEY_comma, IBUS_KEY_E, 0,
    0, 0x0228, /* U0228	# LATIN CAPITAL LETTER E WITH CEDILLA */
  IBUS_KEY_Multi_key, IBUS_KEY_comma, IBUS_KEY_e, 0,
    0, 0x0229, /* U0229	# LATIN SMALL LETTER E WITH CEDILLA */
  IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_comma, IBUS_KEY_E,
    0, 0x1E1C, /* U1E1C	# LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE */
  IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_comma, IBUS_KEY_e,
    0, 0x1E1D, /* U1E1D	# LATIN SMALL LETTER E WITH CEDILLA AND BREVE */
  IBUS_KEY_Multi_key, IBUS_KEY_e, IBUS_KEY_e, 0,
    0, 0x018F, /* U018f */
  IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x03D2, 0,
    0, 0x03D3  /* U03D3	# GREEK UPSILON WITH ACUTE AND HOOK SYMBOL */
};

static const IBusComposeTable ibus_compose_table_pt_br = {
    ibus_compose_seqs_pt_br,
    4,
    G_N_ELEMENTS (ibus_compose_seqs_pt_br) / (4 + 2)
};

static const IBusComposeTableLocaleList ibus_compose_table_locale_list[] = {
    { "el_gr", &ibus_compose_table_el_gr },
    { "fi_fi", &ibus_compose_table_fi_fi },
    { "pt_br", &ibus_compose_table_pt_br },
    { NULL, NULL }
};

#endif
